'\"
'\" Generated from file 'websocket\&.man' by tcllib/doctools with format 'nroff'
'\"
.TH "websocket" n 1\&.4\&.2 tcllib "websocket client and server"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
websocket \- Tcl implementation of the websocket protocol
.SH SYNOPSIS
package require \fBTcl  8\&.4\fR
.sp
package require \fBhttp  2\&.7\fR
.sp
package require \fBlogger \fR
.sp
package require \fBsha1 \fR
.sp
package require \fBbase64 \fR
.sp
package require \fBwebsocket  ?1\&.4\&.2?\fR
.sp
\fB::websocket::open\fR \fIurl\fR \fIhandler\fR ?\fIoptions\fR?
.sp
\fB::websocket::send\fR \fIsock\fR \fItype\fR ?\fImsg\fR? ?\fIfinal\fR?
.sp
\fB::websocket::server\fR \fIsock\fR
.sp
\fB::websocket::live\fR \fIsock\fR \fIpath\fR \fIcb\fR ?\fIproto\fR?
.sp
\fB::websocket::test\fR \fIsrvSock\fR \fIcliSock\fR \fIpath\fR ?\fIhdrs\fR? ?\fIqry\fR?
.sp
\fB::websocket::upgrade\fR \fIsock\fR
.sp
\fB::websocket::takeover\fR \fIsock\fR \fIhandler\fR ?\fIserver\fR?
.sp
\fB::websocket::conninfo\fR \fIsock\fR \fIwhat\fR
.sp
\fB::websocket::find\fR ?\fIhost\fR? ?\fIport\fR?
.sp
\fB::websocket::configure\fR \fIsock\fR \fIargs\fR
.sp
\fB::websocket::loglevel\fR ?\fIloglvl\fR?
.sp
\fB::websocket::close\fR \fIsock\fR ?\fIcode\fR? ?\fIreason\fR?
.sp
.BE
.SH DESCRIPTION
.PP
NOTE: THIS DOCUMENTATION IS WORK IN PROGRESS\&.\&.\&.
.PP
The websocket library is a pure Tcl implementation of the WebSocket
specification covering the needs of both clients and servers\&.
Websockets provide a way to upgrade a regular HTTP connection into a
long-lived and continuous binary or text communication between the
client and the server\&.  The library offers a high-level interface to
receive and send data as specified in RFC 6455 (v\&. 13 of the
protocol), relieving callers from all necessary protocol framing and
reassembly\&.  It implements the ping facility specified by the
standard, together with levers to control it\&.  Pings are server-driven
and ensure the liveness of the connection across home (NAT) networks\&.
The library has a number of introspection facilities to inquire about
the current state of the connection, but also to receive notifications
of incoming pings, if necessary\&.  Finally, the library contains a
number of helper procedures to facilitate the upgrading handshaking in
existing web servers\&.
.PP
Central to the library is the procedure \fBwebsocket::takeover\fR that
will take over a regular socket and treat it as a WebSocket, thus
performing all necessary protocol framing, packetisation and
reassembly in servers and clients\&.  The procedure also takes a
handler, a command that will be called back each time a (possibly
reassembled) packet from the remote end is ready for delivery at the
original caller\&.  While exported by the package, the command
\fBwebsocket::takeover\fR is seldom called in applications, since the
package provides other commands that are specifically tuned for the
needs of clients and servers\&.
.PP
Typically, clients will open a connection to a remote server by
providing a WebSocket URL (\fIws:\fR or \fIwss:\fR schemes) and the
handler described above to the command \fBwebsocket::open\fR\&. The
opening procedure is a wrapper around the latest http::geturl
implementations: it arranges to keep the socket created within the
http library opened for reuse, but confiscates it from its (internal)
map of known sockets for its own use\&.
.PP
Servers will start by registering themselves through the command
\fB::websocket::server\fR and a number of handlers for paths using the
command \fB::websocket::live\fR\&.  Then for each incoming client
connection, they should test the incoming request to detect if it is
an upgrade request using \fB::websocket::test\fR and perform the final
handshake to place the socket connection under the control of the
websocket library and its central procedure using \fB::websocket::upgrade\fR\&.
.PP
Apart from these main commands, the package provides a number of
commands for introspection and basic operations on the websockets that
it has under its control\&.  As WebSockets connections are long-lived,
most remaining communication with the library will be by way of
callbacks, i\&.e\&. commands that are triggered whenever important events
within the library have occur, but mostly whenever data has been
received on a WebSocket\&.
.SH CALLBACKS
A number of commands of the library take a handler handler command as
an argument, a command which will be called back upon reception of
data, but also upon important events within the library or events
resulting from control messages sent by the remote end\&.  For each
callback being performed, the following arguments will be appended:
.TP
\fIsock\fR
The identifier of the WebSocket, as returned for example by
\fB::websocket::open\fR
.TP
\fItype\fR
A textual type describing the event or message content, can be one of
the following
.RS
.TP
\fBtext\fR
Complete text message
.TP
\fBbinary\fR
Complete binary message
.TP
\fBping\fR
Incoming ping message
.TP
\fBconnect\fR
Notification of successful connection to server
.TP
\fBdisconnect\fR
Disconnection from remote end
.TP
\fBclose\fR
Pending closure of connection
.RE
.TP
\fImsg\fR
Will contain the data of the message, whenever this is relevant,
i\&.e\&. when the \fItype\fR is \fBtext\fR, \fBbinary\fR or
\fBping\fR and whenever there is data available\&.
.PP
.SH API
.TP
\fB::websocket::open\fR \fIurl\fR \fIhandler\fR ?\fIoptions\fR?
This command is used in clients to open a WebSocket to a remote
websocket-enabled HTTP server\&.  The URL provided as an argument in
\fIurl\fR should start with ws: or wss:, which are the WebSockets
counterpart of http: and https:\&. The \fIhandler\fR is a command that
will be called back on data reception or whenever important events
occur during the life of the websocket\&.
\fB::websocket::open\fR will return a socket which serves as both the
identifier of the websocket and of the physical low-level socket to
the server\&.  This socket can be used in a number of other commands for
introspection or for controlling the behaviour of the library\&.
Being essentially a wrapper around the \fB::http::geturl\fR command,
this command provides mostly the same set of dash-led options than
\fB::http::geturl\fR\&.  Documented below are the options that differ
from \fB::http::geturl\fR and which are specific to the WebSocket
library\&.
.RS
.TP
-headers
This option is supported, knowing that a number of headers will be
automatically added internally in the library in order to be able to
handshake the upgrading of the socket from a regular HTTP socket to a
WebSocket with the server\&.
.TP
-validate
This option is not supported as it has no real point for WebSockets\&.
.TP
-handler
This option is used internally by the websocket library and cannot be
used\&.
.TP
-command
This option is used internally by the websocket library and cannot be
used\&.
.TP
-protocol
This option specifies a list of application protocols to handshake
with the server\&.  This protocols might help the server triggering
application specific features\&.
.TP
-timeout
This option is supported, but will implemented as part of the library
to enable a number of finalising cleanups\&.
.RE
.TP
\fB::websocket::send\fR \fIsock\fR \fItype\fR ?\fImsg\fR? ?\fIfinal\fR?
This command will send a fragment or a control message to the remote
end of the WebSocket identified by \fIsock\fR\&.  The type of the
message specified in \fItype\fR can either be an integer according to
the specification or (preferrably) one of the following case
insensitive strings: "text", "binary" or "ping"\&.  The content of the
message to send to the remote end is contained in \fImsg\fR and
message fragmentation is made possible by the setting the argument
\fIfinal\fR to non-true, knowing that the type of each fragment has
then to be the same\&.
The command returns the number of bytes that were effectively sent, or
-1 on errors\&.  Serious errors, such as when \fIsock\fR does not
identify a known WebSocket or when the connection is not stable yet
will generate errors that must be catched\&.
.TP
\fB::websocket::server\fR \fIsock\fR
This command registers the (accept) socket \fIsock\fR as the
identifier fo an HTTP server that is capable of doing WebSockets\&.
Paths onto which this server will listen for incoming connections
should be declared using \fB::websocket::live\fR\&.
.TP
\fB::websocket::live\fR \fIsock\fR \fIpath\fR \fIcb\fR ?\fIproto\fR?
This procedure registers callbacks that will be performed on a
WebSocket compliant server registered with \fB::websocket::server\fR
whenever a client connects to a matching path and protocol\&.
\fIsock\fR is the listening socket of the websocket compliant server
declared using \fB::websocket::server\fR\&.  \fIpath\fR is a glob-style
path to match in client request, whenever this will occur\&.  \fIcb\fR
is the command to callback (see Callbacks)\&.  \fIproto\fR is a
glob-style protocol name matcher\&.
.TP
\fB::websocket::test\fR \fIsrvSock\fR \fIcliSock\fR \fIpath\fR ?\fIhdrs\fR? ?\fIqry\fR?
This procedure will test if the connection from an incoming client on
socket \fIcliSock\fR and on the path \fIpath\fR is the opening of a
WebSocket stream within a known server \fIsrvSock\fR\&.  The incoming
request is not upgraded at once, instead a (temporary) context for the
incoming connection is created\&.  This allows server code to perform a
number of actions, if necessary, before the WebSocket stream
connection goes live\&.  The text is made by analysing the content of
the headers \fIhdrs\fR which should contain a dictionary list of the
HTTP headers of the incoming client connection\&.
The command will return \fB1\fR if this is an incoming WebSocket
upgrade request and \fB0\fR otherwise\&.
.TP
\fB::websocket::upgrade\fR \fIsock\fR
Upgrade the socket \fIsock\fR that had been deemed by
\fB::websocket::test\fR to be a WebSocket connection request to a true
WebSocket as recognised by this library\&. As a result, the necessary
connection handshake will be sent to the client, and the command will
arrange for relevant callbacks to be made during the life of the
WebSocket, notably using the specifications described by
\fB::websocket::live\fR\&.
.TP
\fB::websocket::takeover\fR \fIsock\fR \fIhandler\fR ?\fIserver\fR?
Take over the existing opened socket \fIsock\fR to implement sending
and receiving WebSocket framing on top of the socket\&.  The procedure
arranges for \fIhandler\fR to be called back whenever messages,
control messages or other important internal events are received or
occured\&.  \fIserver\fR defaults to \fB0\fR and can be set to
\fB1\fR (or a boolean that evaluates to true) to specify that this is a
WebSocket within a server\&.  Apart from specificities in the protocol,
servers should ping their clients at regular intervals in order to
keep the connection opened at all time\&.  When \fIserver\fR is set to
true, the library will arrange to send these pings automatically\&.
.TP
\fB::websocket::conninfo\fR \fIsock\fR \fIwhat\fR
Provides callers with some introspection facilities in order to get
some semi-internal information about an existing websocket
connection\&. Depending on the value of the \fIwhat\fR argument, the
procedure returns the following piece of information:
.RS
.TP
\fBpeername\fR
Name (preferred) or IP of remote end\&.
.TP
\fBsockname\fR
or \fBname\fR Name or IP of local end\&.
.TP
\fBclosed\fR
\fB1\fR if the connection is closed, \fB0\fR otherwise
.TP
\fBclient\fR
\fB1\fR if the connection is a client websocket, \fB0\fR otherwise
.TP
\fBserver\fR
\fB1\fR if the connection is a server websocket, \fB0\fR otherwise
.TP
\fBtype\fR
\fBserver\fR if the connection is a server websocket, \fBclient\fR otherwise\&.
.TP
\fBhandler\fR
The handler command associated to the websocket
.TP
\fBstate\fR
The state of the websocket, which can be one of:
.RS
.TP
\fBCONNECTING\fR
Connection to remote end is in progress\&.
.TP
\fBCONNECTED\fR
Connection is connected to remote end\&.
.TP
\fBCLOSED\fR
Connection is closed\&.
.RE
.RE
.TP
\fB::websocket::find\fR ?\fIhost\fR? ?\fIport\fR?
Look among existing websocket connections for the ones that match the
hostname and port number filters passed as parameters\&.  This lookup
takes the remote end into account and the \fIhost\fR argument is
matched both against the hostname (whenever available) and the IP
address of the remote end\&.  Both the \fIhost\fR and \fIport\fR
arguments are glob-style string matching filters and default to
\fB*\fR, i\&.e\&. will match any host and/or port number\&.
.TP
\fB::websocket::configure\fR \fIsock\fR \fIargs\fR
This command takes a number of dash-led options (and their values) to
configure the behaviour of an existing websocket connection\&.  The
recognised options are the following (they can be shortened to the
lowest common denominator):
.RS
.TP
\fB-keepalive\fR
is the number of seconds between each
keepalive pings being sent along the connection\&.  A zero or negative
number will effectively turn off the feature\&.  In servers,
\fB-keepalive\fR defaults to 30 seconds, and in clients, no pings
are initiated\&.
.TP
\fB-ping\fR
is the text that is used during the automated
pings\&.  This text defaults to the empty string, leading to an empty ping\&.
.RE
.TP
\fB::websocket::loglevel\fR ?\fIloglvl\fR?
Set or query the log level of the library, which defaults to error\&.
Logging is built on top of the logger module, and the library makes
use of the following levels: \fBdebug\fR, \fBinfo\fR, \fBnotice\fR,
\fBwarn\fR and \fBerror\fR\&.  When called with no argument, this procedure will
simply return the current log level\&.  Otherwise \fIloglvl\fR should contain
the desired log level\&.
.TP
\fB::websocket::close\fR \fIsock\fR ?\fIcode\fR? ?\fIreason\fR?
Gracefully close a websocket that was directly or indirectly passed to
\fB::websocket::takeover\fR\&.  The procedure will optionally send the
\fIcode\fR and describing \fIreason\fR as part of the closure handshake\&.
Good defaults are provided, so that reasons for a number of known codes will
be sent back\&. Only the first 125 characters of a reason string will be kept and
sent as part of the handshake\&. The known codes are:
.RS
.TP
\fB1000\fR
Normal closure (the default \fIcode\fR when none provided)\&.
.TP
\fB1001\fR
Endpoint going away
.TP
\fB1002\fR
Protocol Error
.TP
\fB1003\fR
Received incompatible data type
.TP
\fB1006\fR
Abnormal closure
.TP
\fB1007\fR
Received data not consistent with type
.TP
\fB1008\fR
Policy violation
.TP
\fB1009\fR
Received message too big
.TP
\fB1010\fR
Missing extension
.TP
\fB1011\fR
Unexpected condition
.TP
\fB1015\fR
TLS handshake error
.RE
.PP
.SH EXAMPLES
.PP
The following example opens a websocket connection to the echo
service, waits 400ms to ensure that the connection is really
established and sends a single textual message which should be echoed
back by the echo service\&.  A real example would probably use the
\fBconnect\fR callback to know when connection to the remote
server has been establish and would only send data at that time\&.
.CS


package require websocket
::websocket::loglevel debug

proc handler { sock type msg } {
    switch -glob -nocase -- $type {
	co* {
	    puts "Connected on $sock"
	}
	te* {
	    puts "RECEIVED: $msg"
	}
	cl* -
	dis* {
	}
    }

}

proc test { sock } {
    puts "[::websocket::conninfo $sock type] from [::websocket::conninfo $sock sockname] to [::websocket::conninfo $sock peername]"

    ::websocket::send $sock text "Testing, testing\&.\&.\&."
}

set sock [::websocket::open ws://echo\&.websocket\&.org/ handler]
after 400 test $sock
vwait forever

.CE
.SH "TLS SECURITY CONSIDERATIONS"
.PP
This package uses the \fBTLS\fR package to handle the
security for \fBhttps\fR urls and other socket connections\&.
.PP
Policy decisions like the set of protocols to support and what
ciphers to use are not the responsibility of \fBTLS\fR, nor of
this package itself however\&.
Such decisions are the responsibility of whichever application is
using the package, and are likely influenced by the set of servers
the application will talk to as well\&.
.PP
For example, in light of the recent
\fIPOODLE attack\fR [http://googleonlinesecurity\&.blogspot\&.co\&.uk/2014/10/this-poodle-bites-exploiting-ssl-30\&.html] discovered by Google many servers will disable support
for the SSLv3 protocol\&.
To handle this change the applications using \fBTLS\fR must be
patched, and not this package, nor \fBTLS\fR itself\&.
Such a patch may be as simple as generally activating \fBtls1\fR
support, as shown in the example below\&.
.CS


    package require tls
    tls::init -tls1 1 ;# forcibly activate support for the TLS1 protocol

    \&.\&.\&. your own application code \&.\&.\&.

.CE
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIwebsocket\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH "SEE ALSO"
http
.SH KEYWORDS
http, internet, net, rfc 6455
.SH CATEGORY
Networking
