/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.layout;

import ca.sqlpower.architect.layout.AbstractLayout;
import ca.sqlpower.architect.layout.LayoutEdge;
import ca.sqlpower.architect.layout.LayoutNode;
import ca.sqlpower.architect.swingui.BasicRelationshipUI;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.architect.swingui.TablePane;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import org.apache.log4j.Logger;

public class LineStraightenerLayout
extends AbstractLayout {
    private static Logger logger = Logger.getLogger(LineStraightenerLayout.class);
    private Collection<? extends LayoutEdge> edges;
    private boolean hasRun;

    @Override
    public void setup(Collection<? extends LayoutNode> nodes, Collection<? extends LayoutEdge> edges, Rectangle rect) {
        super.setup(nodes, edges, rect);
        this.edges = edges;
        this.hasRun = false;
    }

    @Override
    public void done() {
    }

    @Override
    public boolean isDone() {
        return this.hasRun;
    }

    @Override
    public void nextFrame() {
        for (LayoutEdge layoutEdge : this.edges) {
            if (!(layoutEdge instanceof Relationship)) continue;
            Relationship r = (Relationship)layoutEdge;
            BasicRelationshipUI.ImmutablePoint[] oldConnectionPoints = new BasicRelationshipUI.ImmutablePoint[]{r.createPkConnectionPoint(), r.createFkConnectionPoint()};
            this.attemptToStraighten(r);
        }
        this.hasRun = true;
    }

    private void attemptToStraighten(Relationship r) {
        TablePane tp1 = r.getPkTable();
        TablePane tp2 = r.getFkTable();
        int orientation = r.getOrientation();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PK Table is at " + tp1.getBounds()));
            logger.debug((Object)("FK Table is at " + tp2.getBounds()));
        }
        if ((orientation & 0x30) != 0 && (orientation & 3) != 0) {
            Interval tp2Vert;
            Interval tp1Vert = new Interval(tp1.getY(), tp1.getHeight());
            Interval vertOverlap = tp1Vert.findOverlap(tp2Vert = new Interval(tp2.getY(), tp2.getHeight()));
            if (vertOverlap != null) {
                int y = vertOverlap.getMidpoint();
                logger.debug((Object)("Found vertical overlap at y = " + y));
                r.setPkConnectionPoint(new Point(r.createPkConnectionPoint().getX(), y - tp1.getY()));
                r.setFkConnectionPoint(new Point(r.createFkConnectionPoint().getX(), y - tp2.getY()));
                ((BasicRelationshipUI)r.getUI()).fixConnectionPoints();
            }
        } else if ((orientation & 0xC0) != 0 && (orientation & 0xC) != 0) {
            Interval tp2Horiz;
            Interval tp1Horiz = new Interval(tp1.getX(), tp1.getWidth());
            Interval horizOverlap = tp1Horiz.findOverlap(tp2Horiz = new Interval(tp2.getX(), tp2.getWidth()));
            if (horizOverlap != null) {
                int x = horizOverlap.getMidpoint();
                logger.debug((Object)("Found horizontal overlap at x = " + x));
                r.setPkConnectionPoint(new Point(x - tp1.getX(), r.createPkConnectionPoint().getY()));
                r.setFkConnectionPoint(new Point(x - tp2.getX(), r.createFkConnectionPoint().getY()));
                ((BasicRelationshipUI)r.getUI()).fixConnectionPoints();
            }
        } else {
            logger.debug((Object)"No facing sides found. Skipping this relationship.");
        }
    }

    private static class Interval {
        final int x1;
        final int x2;

        Interval(int start, int length) {
            if (length >= 0) {
                this.x1 = start;
                this.x2 = start + length;
            } else {
                this.x1 = start + length;
                this.x2 = start;
            }
        }

        public Interval findOverlap(Interval other) {
            int b2;
            int b1;
            int a2;
            int a1;
            if (other.x1 > this.x1) {
                a1 = this.x1;
                a2 = this.x2;
                b1 = other.x1;
                b2 = other.x2;
            } else {
                a1 = other.x1;
                a2 = other.x2;
                b1 = this.x1;
                b2 = this.x2;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Looking for overlap in intervals (" + a1 + "," + a2 + ") and (" + b1 + "," + b2 + ")"));
            }
            if (b1 <= a2) {
                Interval overlap = new Interval(b1, Math.min(a2, b2) - b1);
                logger.debug((Object)("Found overlap: " + overlap));
                return overlap;
            }
            logger.debug((Object)"No overlap found.");
            return null;
        }

        public int getMidpoint() {
            return (this.x1 + this.x2) / 2;
        }

        public String toString() {
            return "(" + this.x1 + "," + this.x2 + ")";
        }
    }
}

