/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.common.model.Direction;

public class ScrollThread
extends Thread {
    private static final Logger logger = Logger.getLogger(ScrollThread.class.getName());
    private static final int SCROLL_DELAY = 100;
    private final FreeColClient freeColClient;
    private volatile Direction direction = null;
    private volatile boolean aborted = false;

    public ScrollThread(FreeColClient freeColClient) {
        super("FreeColClient:Mouse scroller");
        this.freeColClient = freeColClient;
    }

    public void setDirection(Direction d) {
        this.direction = d;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void abort() {
        this.aborted = true;
        this.direction = null;
    }

    @Override
    public void run() {
        GUI gui = this.freeColClient.getGUI();
        while (!this.isAborted()) {
            Direction d = this.direction;
            if (d == null) {
                this.abort();
                return;
            }
            long start = System.currentTimeMillis();
            try {
                SwingUtilities.invokeAndWait(() -> {
                    if (!gui.scrollMap(d)) {
                        this.abort();
                    }
                });
            }
            catch (InterruptedException e) {
                this.abort();
                return;
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Exception while scrolling", ex);
                this.abort();
                return;
            }
            if (this.isAborted()) {
                return;
            }
            try {
                long time = System.currentTimeMillis() - start;
                ScrollThread.sleep(Math.max(5L, 100L - time));
            }
            catch (InterruptedException e) {
                this.abort();
                return;
            }
        }
        return;
    }
}

