/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BaseProduction;
import net.sf.freecol.common.model.Disaster;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.ProductionType;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.RandomChoice;

public final class TileType
extends FreeColSpecObjectType
implements BaseProduction {
    public static final String TAG = "tile-type";
    public static final TileType WATER = new TileType("WATER", true);
    public static final TileType LAND = new TileType("LAND", false);
    private boolean forest;
    private boolean water;
    private boolean canSettle;
    private boolean connected;
    private boolean elevation;
    private int basicMoveCost;
    private int basicWorkTurns;
    private final int[] humidity = new int[2];
    private final int[] temperature = new int[2];
    private final int[] altitude = new int[2];
    private List<RandomChoice<ResourceType>> resourceTypes = null;
    private List<RandomChoice<Disaster>> disasters = null;
    private final List<ProductionType> productionTypes = new ArrayList<ProductionType>();
    private static final String ALTITUDE_MIN_TAG = "altitude-minimum";
    private static final String ALTITUDE_MAX_TAG = "altitude-maximum";
    private static final String BASIC_MOVE_COST_TAG = "basic-move-cost";
    private static final String BASIC_WORK_TURNS_TAG = "basic-work-turns";
    private static final String CAN_SETTLE_TAG = "can-settle";
    private static final String DISASTER_TAG = "disaster";
    private static final String GEN_TAG = "gen";
    private static final String GOODS_TYPE_TAG = "goods-type";
    private static final String HUMIDITY_MIN_TAG = "humidity-minimum";
    private static final String HUMIDITY_MAX_TAG = "humidity-maximum";
    private static final String IS_CONNECTED_TAG = "is-connected";
    private static final String IS_ELEVATION_TAG = "is-elevation";
    private static final String IS_FOREST_TAG = "is-forest";
    private static final String IS_WATER_TAG = "is-water";
    private static final String PROBABILITY_TAG = "probability";
    private static final String PRODUCTION_TAG = "production";
    private static final String RESOURCE_TAG = "resource";
    private static final String TEMPERATURE_MIN_TAG = "temperature-minimum";
    private static final String TEMPERATURE_MAX_TAG = "temperature-maximum";
    private static final String TYPE_TAG = "type";
    private static final String PRIMARY_PRODUCTION_TAG = "primary-production";
    private static final String SECONDARY_PRODUCTION_TAG = "secondary-production";
    private static final String OLD_ALTITUDE_MIN_TAG = "altitudeMin";
    private static final String OLD_ALTITUDE_MAX_TAG = "altitudeMax";
    private static final String OLD_HUMIDITY_MIN_TAG = "humidityMin";
    private static final String OLD_HUMIDITY_MAX_TAG = "humidityMax";
    private static final String OLD_TEMPERATURE_MIN_TAG = "temperatureMin";
    private static final String OLD_TEMPERATURE_MAX_TAG = "temperatureMax";

    public TileType(String id, Specification specification) {
        super(id, specification);
    }

    private TileType(String id, boolean water) {
        super(id, null);
        this.water = water;
    }

    public boolean isForested() {
        return this.forest;
    }

    public boolean isWater() {
        return this.water;
    }

    public boolean canSettle() {
        return this.canSettle;
    }

    public boolean isHighSeasConnected() {
        return this.connected;
    }

    public boolean isDirectlyHighSeasConnected() {
        return this.hasAbility("model.ability.moveToEurope");
    }

    public boolean isElevation() {
        return this.elevation;
    }

    public int getBasicMoveCost() {
        return this.basicMoveCost;
    }

    public int getBasicWorkTurns() {
        return this.basicWorkTurns;
    }

    protected int getHumidity(int i) {
        return this.humidity[i];
    }

    protected void setHumidity(int i, int value) {
        this.humidity[i] = value;
    }

    protected int getTemperature(int i) {
        return this.temperature[i];
    }

    protected void setTemperature(int i, int value) {
        this.temperature[i] = value;
    }

    protected int getAltitude(int i) {
        return this.altitude[i];
    }

    protected void setAltitude(int i, int value) {
        this.altitude[i] = value;
    }

    public boolean withinRange(RangeType rangeType, int value) {
        switch (rangeType) {
            case HUMIDITY: {
                return this.humidity[0] <= value && value <= this.humidity[1];
            }
            case TEMPERATURE: {
                return this.temperature[0] <= value && value <= this.temperature[1];
            }
            case ALTITUDE: {
                return this.altitude[0] <= value && value <= this.altitude[1];
            }
        }
        return false;
    }

    public List<RandomChoice<ResourceType>> getResourceTypes() {
        if (this.resourceTypes == null) {
            this.resourceTypes = new ArrayList<RandomChoice<ResourceType>>();
        }
        return this.resourceTypes;
    }

    protected void setResourceTypes(List<RandomChoice<ResourceType>> resourceTypes) {
        if (this.resourceTypes == null) {
            this.resourceTypes = new ArrayList<RandomChoice<ResourceType>>();
        } else {
            this.resourceTypes.clear();
        }
        this.resourceTypes.addAll(resourceTypes);
    }

    public List<ResourceType> getResourceTypeValues() {
        return CollectionUtils.transform(this.getResourceTypes(), CollectionUtils.alwaysTrue(), RandomChoice::getObject);
    }

    private void addResourceType(ResourceType type, int prob) {
        if (this.resourceTypes == null) {
            this.resourceTypes = new ArrayList<RandomChoice<ResourceType>>();
        }
        this.resourceTypes.add(new RandomChoice<ResourceType>(type, prob));
    }

    public boolean canHaveResourceType(ResourceType resourceType) {
        return this.getResourceTypeValues().contains(resourceType);
    }

    protected List<RandomChoice<Disaster>> getDisasters() {
        return this.disasters;
    }

    protected void setDisasters(List<RandomChoice<Disaster>> disasters) {
        if (this.disasters == null) {
            this.disasters = new ArrayList<RandomChoice<Disaster>>();
        } else {
            this.disasters.clear();
        }
        this.disasters.addAll(disasters);
    }

    public Stream<RandomChoice<Disaster>> getDisasterChoices() {
        return this.disasters == null ? Stream.empty() : this.disasters.stream();
    }

    private void addDisaster(Disaster disaster, int probability) {
        if (this.disasters == null) {
            this.disasters = new ArrayList<RandomChoice<Disaster>>();
        }
        this.disasters.add(new RandomChoice<Disaster>(disaster, probability));
    }

    protected List<ProductionType> getProductionTypes() {
        return this.productionTypes;
    }

    protected void setProductionTypes(List<ProductionType> productionTypes) {
        this.productionTypes.clear();
        this.productionTypes.addAll(productionTypes);
    }

    @Override
    public List<ProductionType> getAvailableProductionTypes(boolean unattended) {
        return this.getAvailableProductionTypes(unattended, this.getSpecification().getString("model.option.tileProduction"));
    }

    public List<ProductionType> getAvailableProductionTypes(boolean unattended, String level) {
        ArrayList<ProductionType> good = new ArrayList<ProductionType>();
        ArrayList<ProductionType> better = new ArrayList<ProductionType>();
        for (ProductionType productionType : CollectionUtils.transform(this.productionTypes, CollectionUtils.matchKey(unattended, ProductionType::getUnattended))) {
            if (productionType.appliesExactly(level)) {
                better.add(productionType);
                continue;
            }
            if (!productionType.appliesTo(level)) continue;
            good.add(productionType);
        }
        return !better.isEmpty() ? better : good;
    }

    public boolean canProduce(GoodsType goodsType, UnitType unitType) {
        return goodsType != null && ProductionType.canProduce(goodsType, this.getAvailableProductionTypes(unitType == null));
    }

    public int getPotentialProduction(GoodsType goodsType, UnitType unitType) {
        if (goodsType == null) {
            return 0;
        }
        int amount = this.getBaseProduction(null, goodsType, unitType);
        amount = unitType != null ? (int)unitType.apply(amount, null, goodsType.getId(), unitType) : (int)this.apply(amount, null, goodsType.getId(), unitType);
        return amount < 0 ? 0 : amount;
    }

    public Stream<AbstractGoods> getPossibleProduction(boolean unattended) {
        return CollectionUtils.flatten(this.getAvailableProductionTypes(unattended), ProductionType::getOutputs);
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        int i;
        TileType o = this.copyInCast(other, TileType.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.forest = o.isForested();
        this.water = o.isWater();
        this.canSettle = o.canSettle();
        this.connected = o.isHighSeasConnected();
        this.elevation = o.isElevation();
        this.basicMoveCost = o.getBasicMoveCost();
        this.basicWorkTurns = o.getBasicWorkTurns();
        for (i = 0; i < this.humidity.length; ++i) {
            this.setHumidity(i, o.getHumidity(i));
        }
        for (i = 0; i < this.temperature.length; ++i) {
            this.setTemperature(i, o.getTemperature(i));
        }
        for (i = 0; i < this.altitude.length; ++i) {
            this.setAltitude(i, o.getAltitude(i));
        }
        this.setResourceTypes(o.getResourceTypes());
        this.setDisasters(o.getDisasters());
        this.setProductionTypes(o.getProductionTypes());
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(BASIC_MOVE_COST_TAG, this.basicMoveCost);
        xw.writeAttribute(BASIC_WORK_TURNS_TAG, this.basicWorkTurns);
        xw.writeAttribute(IS_FOREST_TAG, this.forest);
        xw.writeAttribute(IS_WATER_TAG, this.water);
        xw.writeAttribute(IS_ELEVATION_TAG, this.elevation);
        xw.writeAttribute(IS_CONNECTED_TAG, this.connected);
        xw.writeAttribute(CAN_SETTLE_TAG, this.canSettle);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        xw.writeStartElement(GEN_TAG);
        xw.writeAttribute(HUMIDITY_MIN_TAG, this.humidity[0]);
        xw.writeAttribute(HUMIDITY_MAX_TAG, this.humidity[1]);
        xw.writeAttribute(TEMPERATURE_MIN_TAG, this.temperature[0]);
        xw.writeAttribute(TEMPERATURE_MAX_TAG, this.temperature[1]);
        xw.writeAttribute(ALTITUDE_MIN_TAG, this.altitude[0]);
        xw.writeAttribute(ALTITUDE_MAX_TAG, this.altitude[1]);
        xw.writeEndElement();
        for (ProductionType productionType : this.productionTypes) {
            productionType.toXML(xw);
        }
        if (this.resourceTypes != null) {
            for (RandomChoice randomChoice : this.resourceTypes) {
                xw.writeStartElement(RESOURCE_TAG);
                xw.writeAttribute(TYPE_TAG, (FreeColObject)randomChoice.getObject());
                xw.writeAttribute(PROBABILITY_TAG, randomChoice.getProbability());
                xw.writeEndElement();
            }
        }
        for (RandomChoice randomChoice : CollectionUtils.iterable(this.getDisasterChoices())) {
            xw.writeStartElement(DISASTER_TAG);
            xw.writeAttribute("id", (FreeColObject)randomChoice.getObject());
            xw.writeAttribute(PROBABILITY_TAG, randomChoice.getProbability());
            xw.writeEndElement();
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.basicMoveCost = xr.getAttribute(BASIC_MOVE_COST_TAG, 1);
        this.basicWorkTurns = xr.getAttribute(BASIC_WORK_TURNS_TAG, 1);
        this.forest = xr.getAttribute(IS_FOREST_TAG, false);
        this.water = xr.getAttribute(IS_WATER_TAG, false);
        this.elevation = xr.getAttribute(IS_ELEVATION_TAG, false);
        this.canSettle = xr.getAttribute(CAN_SETTLE_TAG, !this.water);
        this.connected = xr.getAttribute(IS_CONNECTED_TAG, false);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        if (xr.shouldClearContainers()) {
            this.disasters = null;
            this.resourceTypes = null;
            this.productionTypes.clear();
        }
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if (DISASTER_TAG.equals(tag)) {
            Disaster d = xr.getType(spec, "id", Disaster.class, null);
            if (d != null) {
                this.addDisaster(d, xr.getAttribute(PROBABILITY_TAG, 100));
            }
            xr.closeTag(DISASTER_TAG);
        } else if (GEN_TAG.equals(tag)) {
            this.humidity[0] = xr.getAttribute(HUMIDITY_MIN_TAG, 0);
            this.humidity[1] = xr.getAttribute(HUMIDITY_MAX_TAG, 100);
            this.temperature[0] = xr.getAttribute(TEMPERATURE_MIN_TAG, -20);
            this.temperature[1] = xr.getAttribute(TEMPERATURE_MAX_TAG, 40);
            this.altitude[0] = xr.getAttribute(ALTITUDE_MIN_TAG, 0);
            this.altitude[1] = xr.getAttribute(ALTITUDE_MAX_TAG, 0);
            if (xr.hasAttribute(OLD_HUMIDITY_MIN_TAG)) {
                this.humidity[0] = xr.getAttribute(OLD_HUMIDITY_MIN_TAG, 0);
            }
            if (xr.hasAttribute(OLD_HUMIDITY_MAX_TAG)) {
                this.humidity[1] = xr.getAttribute(OLD_HUMIDITY_MAX_TAG, 100);
            }
            if (xr.hasAttribute(OLD_TEMPERATURE_MIN_TAG)) {
                this.temperature[0] = xr.getAttribute(OLD_TEMPERATURE_MIN_TAG, -20);
            }
            if (xr.hasAttribute(OLD_TEMPERATURE_MAX_TAG)) {
                this.temperature[1] = xr.getAttribute(OLD_TEMPERATURE_MAX_TAG, 40);
            }
            if (xr.hasAttribute(OLD_ALTITUDE_MIN_TAG)) {
                this.altitude[0] = xr.getAttribute(OLD_ALTITUDE_MIN_TAG, 0);
            }
            if (xr.hasAttribute(OLD_ALTITUDE_MAX_TAG)) {
                this.altitude[1] = xr.getAttribute(OLD_ALTITUDE_MAX_TAG, 0);
            }
            xr.closeTag(GEN_TAG);
        } else if (PRODUCTION_TAG.equals(tag) && xr.getAttribute("delete", false)) {
            this.productionTypes.clear();
            xr.closeTag(PRODUCTION_TAG);
        } else if (PRODUCTION_TAG.equals(tag)) {
            this.productionTypes.add(new ProductionType(xr, spec));
        } else if (RESOURCE_TAG.equals(tag)) {
            this.addResourceType(xr.getType(spec, TYPE_TAG, ResourceType.class, null), xr.getAttribute(PROBABILITY_TAG, 100));
            xr.closeTag(RESOURCE_TAG);
        } else if (PRIMARY_PRODUCTION_TAG.equals(tag) || SECONDARY_PRODUCTION_TAG.equals(tag)) {
            GoodsType type = xr.getType(spec, GOODS_TYPE_TAG, GoodsType.class, null);
            int amount = xr.getAttribute("value", 0);
            ProductionType pt = new ProductionType(null, type, amount);
            pt.setUnattended(true);
            this.productionTypes.add(pt);
            xr.closeTag(tag);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    public static enum RangeType {
        HUMIDITY,
        TEMPERATURE,
        ALTITUDE;

    }
}

