/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state.configuration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Option;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.AbstractCompleter;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.CommandDomain;
import org.jboss.galleon.cli.cmd.state.AbstractStateCommand;
import org.jboss.galleon.cli.cmd.state.StateActivators;
import org.jboss.galleon.cli.model.ConfigInfo;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.cli.model.state.State;
import org.jboss.galleon.config.ConfigId;

@CommandDefinition(name="define-config", description="Define a new empty configuration", activator=StateActivators.FPDependentCommandActivator.class)
public class StateDefineConfigCommand
extends AbstractStateCommand {
    @Option(required=true, description="Configuration model", completer=ModelCompleter.class)
    private String model;
    @Option(required=true, description="Configuration name")
    private String name;

    @Override
    public CommandDomain getDomain() {
        return CommandDomain.EDITING;
    }

    @Override
    protected void runCommand(PmCommandInvocation invoc, State state) throws IOException, ProvisioningException, CommandExecutionException {
        try {
            state.defineConfiguration(invoc.getPmSession(), new ConfigId(this.model, this.name));
        }
        catch (Exception ex) {
            throw new CommandExecutionException(invoc.getPmSession(), CliErrors.defineConfigFailed(), ex);
        }
    }

    public static class ModelCompleter
    extends AbstractCompleter {
        @Override
        protected List<String> getItems(PmCompleterInvocation completerInvocation) {
            HashSet<String> models = new HashSet<String>();
            for (FeatureContainer fc : completerInvocation.getPmSession().getState().getContainer().getFullDependencies().values()) {
                Map<String, List<ConfigInfo>> configs = fc.getFinalConfigs();
                if (configs == null) continue;
                models.addAll(configs.keySet());
            }
            ArrayList<String> result = new ArrayList<String>(models);
            return result;
        }
    }
}

