This directory contains test files (*.txt) for the comment parser.

The files are in [txtar format](https://pkg.go.dev/golang.org/x/tools/txtar).
Consider this example:

	-- input --
	Hello.
	-- gofmt --
	Hello.
	-- html --
	<p>Hello.
	-- markdown --
	Hello.
	-- text --
	Hello.

Each `-- name --` line introduces a new file with the given name.
The file named “input” must be first and contains the input to
[comment.Parser](https://pkg.go.dev/go/doc/comment/#Parser).

The remaining files contain the expected output for the named format generated by
[comment.Printer](https://pkg.go.dev/go/doc/comment/#Printer):
“gofmt” for Printer.Comment (Go comment format, as used by gofmt),
“html” for Printer.HTML, “markdown” for Printer.Markdown, and “text” for Printer.Text.
The format can also be “dump” for a textual dump of the raw data structures.

The text before the `-- input --` line, if present, is JSON to be unmarshalled
to initialize a comment.Printer. For example, this test case sets the Printer's
TextWidth field to 20:

	{"TextWidth": 20}
	-- input --
	Package gob manages streams of gobs - binary values exchanged between an
	Encoder (transmitter) and a Decoder (receiver).
	-- text --
	Package gob
	manages streams
	of gobs - binary
	values exchanged
	between an Encoder
	(transmitter) and a
	Decoder (receiver).
