/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdBackendAnnotation;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdMemoryBackendFactory;
import org.rrd4j.core.RrdNioBackendFactory;
import org.rrd4j.core.RrdRandomAccessFileBackendFactory;
import org.rrd4j.core.RrdSafeFileBackendFactory;

public abstract class RrdBackendFactory
implements Closeable {
    public static final String DEFAULTFACTORY = "NIO";
    private static final List<RrdBackendFactory> activeFactories = new ArrayList<RrdBackendFactory>();
    private static final Pattern URIPATTERN = Pattern.compile("^(?:(?<scheme>[a-zA-Z][a-zA-Z0-9+-\\.]*):)?(?://(?<authority>[^/\\?#]*))?(?<path>[^\\?#]*)(?:\\?(?<query>[^#]*))?(?:#(?<fragment>.*))?$");
    private final ReferenceQueue<RrdDb> refQueue = new ReferenceQueue();
    protected final String name;
    protected final boolean cachingAllowed;
    protected final String scheme;
    protected final boolean validateHeader;

    @Deprecated
    public static synchronized RrdBackendFactory getFactory(String name) {
        RrdBackendFactory factory = (RrdBackendFactory)Registry.factories.get(name);
        if (factory != null) {
            return factory;
        }
        throw new IllegalArgumentException("No backend factory found with the name specified [" + name + "]");
    }

    @Deprecated
    public static synchronized void registerFactory(RrdBackendFactory factory) {
        String name = factory.getName();
        if (Registry.factories.containsKey(name)) {
            throw new IllegalArgumentException("Backend factory '" + name + "' cannot be registered twice");
        }
        Registry.factories.put(name, factory);
    }

    @Deprecated
    public static synchronized void registerAndSetAsDefaultFactory(RrdBackendFactory factory) {
        RrdBackendFactory.registerFactory(factory);
        RrdBackendFactory.setDefaultFactory(factory.getName());
    }

    public static synchronized RrdBackendFactory getDefaultFactory() {
        if (!activeFactories.isEmpty()) {
            return activeFactories.get(0);
        }
        return Registry.defaultFactory;
    }

    @Deprecated
    public static synchronized void setDefaultFactory(String factoryName) {
        if (RrdBackend.isInstanceCreated()) {
            throw new IllegalStateException("Could not change the default backend factory. This method must be called before the first RRD gets created");
        }
        activeFactories.clear();
        activeFactories.add(RrdBackendFactory.getFactory(factoryName));
    }

    public static synchronized void setActiveFactories(RrdBackendFactory ... newFactories) {
        activeFactories.clear();
        activeFactories.addAll(Arrays.asList(newFactories));
    }

    public static synchronized Stream<RrdBackendFactory> getActiveFactories() {
        return activeFactories.stream();
    }

    @Deprecated
    public static synchronized void addFactories(RrdBackendFactory ... newFactories) {
        RrdBackendFactory.addActiveFactories(newFactories);
    }

    public static synchronized void addActiveFactories(RrdBackendFactory ... newFactories) {
        activeFactories.addAll(Arrays.asList(newFactories));
    }

    public static synchronized RrdBackendFactory findFactory(URI uri) {
        if (activeFactories.isEmpty() && Registry.defaultFactory.canStore(uri)) {
            return Registry.defaultFactory;
        }
        for (RrdBackendFactory tryfactory : activeFactories) {
            if (!tryfactory.canStore(uri)) continue;
            return tryfactory;
        }
        throw new IllegalArgumentException("no matching backend factory for " + uri);
    }

    public static URI buildGenericUri(String rrdpath) {
        Matcher urimatcher = URIPATTERN.matcher(rrdpath);
        if (urimatcher.matches()) {
            String scheme = urimatcher.group("scheme");
            String authority = urimatcher.group("authority");
            String path = urimatcher.group("path");
            String query = urimatcher.group("query");
            String fragment = urimatcher.group("fragment");
            try {
                if (scheme != null && scheme.length() == 1) {
                    return new File(rrdpath).toURI();
                }
                if (scheme != null && path.charAt(0) != '/') {
                    return new URI(scheme, path, query);
                }
                if (File.separatorChar != '/' && scheme == null) {
                    path = path.replace(File.separatorChar, '/');
                }
                return new URI(scheme, authority, path, query, fragment);
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex.getMessage(), ex);
            }
        }
        throw new IllegalArgumentException("Not an URI pattern");
    }

    protected RrdBackendFactory() {
        RrdBackendAnnotation annotation = this.getClass().getAnnotation(RrdBackendAnnotation.class);
        if (annotation != null) {
            this.name = annotation.name();
            this.cachingAllowed = annotation.cachingAllowed();
            this.scheme = annotation.scheme() != null && !annotation.scheme().isEmpty() ? annotation.scheme() : this.name.toLowerCase(Locale.ENGLISH);
            this.validateHeader = annotation.shouldValidateHeader();
        } else {
            this.name = this.getName();
            this.cachingAllowed = true;
            this.scheme = this.getName().toLowerCase(Locale.ENGLISH);
            this.validateHeader = true;
        }
    }

    public void checkClosing() {
        ClosingReference ref;
        while ((ref = (ClosingReference)this.refQueue.poll()) != null) {
            if (ref.backend == null) continue;
            try {
                ref.backend.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String getScheme() {
        return this.scheme;
    }

    protected URI getRootUri() {
        try {
            return new URI(this.getScheme(), null, "/", null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid scheme " + this.getScheme());
        }
    }

    public boolean canStore(URI uri) {
        return false;
    }

    protected URI resolve(URI rootUri, URI uri, boolean relative) {
        String path;
        String authority;
        String scheme = uri.getScheme();
        if (scheme != null && !scheme.equals(rootUri.getScheme())) {
            throw new IllegalArgumentException(String.format("scheme %s not compatible with %s", scheme, rootUri.getScheme()));
        }
        if (scheme == null) {
            scheme = rootUri.getScheme();
        }
        if ((authority = uri.getAuthority()) != null && !authority.equals(rootUri.getAuthority())) {
            throw new IllegalArgumentException("URI credential not compatible");
        }
        if (authority == null) {
            authority = rootUri.getAuthority();
        }
        if (!(path = uri.isOpaque() ? uri.getSchemeSpecificPart() : (!uri.isAbsolute() ? rootUri.resolve(uri).normalize().getPath() : uri.normalize().getPath())).startsWith(rootUri.getPath())) {
            throw new IllegalArgumentException(String.format("URI destination path %s not root with %s", path, rootUri.getPath()));
        }
        String query = uri.getQuery();
        String fragment = uri.getFragment();
        try {
            authority = authority != null ? authority : "";
            query = query != null ? "?" + URLEncoder.encode(query, "UTF-8") : "";
            fragment = fragment != null ? "#" + URLEncoder.encode(fragment, "UTF-8") : "";
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("UTF-8 is missing");
        }
        String newUriString = String.format("%s://%s%s%s%s", scheme, authority, path, query, fragment);
        URI newURI = URI.create(newUriString);
        if (relative) {
            return rootUri.relativize(newURI);
        }
        return newURI;
    }

    public URI getCanonicalUri(URI uri) {
        return this.resolve(this.getRootUri(), uri, false);
    }

    public URI getUri(String path) {
        URI rootUri = this.getRootUri();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        try {
            return new URI(this.getScheme(), rootUri.getAuthority(), rootUri.getPath() + path, null, null);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }

    public String getPath(URI uri) {
        URI rootUri = this.getRootUri();
        uri = this.resolve(rootUri, uri, true);
        if (uri == null) {
            return null;
        }
        return "/" + uri.getPath();
    }

    protected abstract RrdBackend open(String var1, boolean var2) throws IOException;

    RrdBackend getBackend(RrdDb rrdDb, String path, boolean readOnly) throws IOException {
        this.checkClosing();
        RrdBackend backend = this.open(path, readOnly);
        backend.done(this, new ClosingReference(rrdDb, backend, this.refQueue));
        return backend;
    }

    RrdBackend getBackend(RrdDb rrdDb, URI uri, boolean readOnly) throws IOException {
        this.checkClosing();
        RrdBackend backend = this.open(this.getPath(uri), readOnly);
        backend.done(this, new ClosingReference(rrdDb, backend, this.refQueue));
        return backend;
    }

    protected abstract boolean exists(String var1) throws IOException;

    protected boolean exists(URI uri) throws IOException {
        return this.exists(this.getPath(uri));
    }

    protected boolean shouldValidateHeader(String path) throws IOException {
        return this.validateHeader;
    }

    protected boolean shouldValidateHeader(URI uri) throws IOException {
        return this.shouldValidateHeader(this.getPath(uri));
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void close() throws IOException {
    }

    private static class ClosingReference
    extends PhantomReference<RrdDb> {
        private RrdBackend backend;

        public ClosingReference(RrdDb db, RrdBackend backend, ReferenceQueue<? super RrdDb> q) {
            super(db, q);
            this.backend = backend;
        }

        @Override
        public void clear() {
            try {
                this.backend.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.backend = null;
            super.clear();
        }
    }

    private static final class Registry {
        private static final Map<String, RrdBackendFactory> factories = new HashMap<String, RrdBackendFactory>();
        private static RrdBackendFactory defaultFactory;

        private Registry() {
        }

        static {
            RrdRandomAccessFileBackendFactory fileFactory = new RrdRandomAccessFileBackendFactory();
            factories.put(fileFactory.name, fileFactory);
            RrdMemoryBackendFactory memoryFactory = new RrdMemoryBackendFactory();
            factories.put(memoryFactory.name, memoryFactory);
            RrdNioBackendFactory nioFactory = new RrdNioBackendFactory();
            factories.put(nioFactory.name, nioFactory);
            RrdSafeFileBackendFactory safeFactory = new RrdSafeFileBackendFactory();
            factories.put(safeFactory.name, safeFactory);
            defaultFactory = factories.get(RrdBackendFactory.DEFAULTFACTORY);
        }
    }
}

