/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.mappingio;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.format.MappingFormat;
import net.fabricmc.mappingio.format.enigma.EnigmaDirWriter;
import net.fabricmc.mappingio.format.enigma.EnigmaWriter;
import net.fabricmc.mappingio.format.tiny1.Tiny1Writer;
import net.fabricmc.mappingio.format.tiny2.Tiny2Writer;

public interface MappingWriter
extends Closeable,
MappingVisitor {
    public static MappingWriter create(Path file, MappingFormat format) throws IOException {
        if (format.hasSingleFile()) {
            return MappingWriter.create(Files.newBufferedWriter(file, new OpenOption[0]), format);
        }
        switch (format) {
            case ENIGMA_DIR: {
                return new EnigmaDirWriter(file, true);
            }
        }
        throw new UnsupportedOperationException("format " + (Object)((Object)format) + " is not implemented");
    }

    public static MappingWriter create(Writer writer, MappingFormat format) throws IOException {
        if (!format.hasSingleFile()) {
            throw new IllegalArgumentException("format " + (Object)((Object)format) + " is not applicable to a single writer");
        }
        switch (format) {
            case TINY: {
                return new Tiny1Writer(writer);
            }
            case TINY_2: {
                return new Tiny2Writer(writer, false);
            }
            case ENIGMA: {
                return new EnigmaWriter(writer);
            }
        }
        throw new UnsupportedOperationException("format " + (Object)((Object)format) + " is not implemented");
    }
}

