/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.sv;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_sv extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "001", "v\u00e4rlden" },
            { "002", "Afrika" },
            { "003", "Nordamerika" },
            { "005", "Sydamerika" },
            { "009", "Oceanien" },
            { "011", "V\u00e4stafrika" },
            { "013", "Centralamerika" },
            { "014", "\u00d6stafrika" },
            { "015", "Nordafrika" },
            { "017", "Centralafrika" },
            { "018", "s\u00f6dra Afrika" },
            { "019", "Nord- och Sydamerika" },
            { "021", "norra Amerika" },
            { "029", "Karibien" },
            { "030", "\u00d6stasien" },
            { "034", "s\u00f6dra Asien" },
            { "035", "Sydostasien" },
            { "039", "Sydeuropa" },
            { "053", "Australien och Nya Zeeland" },
            { "054", "Melanesien" },
            { "057", "Mikronesiska \u00f6arna" },
            { "061", "Polynesien" },
            { "142", "Asien" },
            { "143", "Centralasien" },
            { "145", "V\u00e4stasien" },
            { "150", "Europa" },
            { "151", "\u00d6steuropa" },
            { "154", "Nordeuropa" },
            { "155", "V\u00e4steuropa" },
            { "419", "Latinamerika" },
            { "AC", "Ascension" },
            { "AD", "Andorra" },
            { "AE", "F\u00f6renade Arabemiraten" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua och Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albanien" },
            { "AM", "Armenien" },
            { "AN", "Nederl\u00e4ndska Antillerna" },
            { "AO", "Angola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentina" },
            { "AS", "Amerikanska Samoa" },
            { "AT", "\u00d6sterrike" },
            { "AU", "Australien" },
            { "AW", "Aruba" },
            { "AX", "\u00c5land" },
            { "AZ", "Azerbajdzjan" },
            { "BA", "Bosnien och Hercegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgien" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarien" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "S:t Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BR", "Brasilien" },
            { "BS", "Bahamas" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet\u00f6n" },
            { "BW", "Botswana" },
            { "BY", "Vitryssland" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Kokos\u00f6arna" },
            { "CD", "Kongo-Kinshasa" },
            { "CF", "Centralafrikanska republiken" },
            { "CG", "Kongo-Brazzaville" },
            { "CH", "Schweiz" },
            { "CI", "Elfenbenskusten" },
            { "CK", "Cook\u00f6arna" },
            { "CL", "Chile" },
            { "CM", "Kamerun" },
            { "CN", "Kina" },
            { "CO", "Colombia" },
            { "CP", "Clipperton\u00f6n" },
            { "CR", "Costa Rica" },
            { "CS", "Serbien och Montenegro" },
            { "CU", "Kuba" },
            { "CV", "Kap Verde" },
            { "CX", "Jul\u00f6n" },
            { "CY", "Cypern" },
            { "CZ", "Tjeckien" },
            { "DE", "Tyskland" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Danmark" },
            { "DM", "Dominica" },
            { "DO", "Dominikanska republiken" },
            { "DZ", "Algeriet" },
            { "EA", "Ceuta och Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estland" },
            { "EG", "Egypten" },
            { "EH", "V\u00e4stsahara" },
            { "ER", "Eritrea" },
            { "ES", "Spanien" },
            { "ET", "Etiopien" },
            { "EU", "Europeiska unionen" },
            { "FI", "Finland" },
            { "FJ", "Fiji" },
            { "FK", "Falklands\u00f6arna" },
            { "FM", "Mikronesien" },
            { "FO", "F\u00e4r\u00f6arna" },
            { "FR", "Frankrike" },
            { "FX", "Europeiska Frankrike" },
            { "GA", "Gabon" },
            { "GB", "Storbritannien" },
            { "GD", "Grenada" },
            { "GE", "Georgien" },
            { "GF", "Franska Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Gr\u00f6nland" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Ekvatorialguinea" },
            { "GR", "Grekland" },
            { "GS", "Sydgeorgien och Sydsandwich\u00f6arna" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hongkong (S.A.R. Kina)" },
            { "HM", "Heard- och McDonald\u00f6arna" },
            { "HN", "Honduras" },
            { "HR", "Kroatien" },
            { "HT", "Haiti" },
            { "HU", "Ungern" },
            { "IC", "Kanarie\u00f6arna" },
            { "ID", "Indonesien" },
            { "IE", "Irland" },
            { "IL", "Israel" },
            { "IM", "Isle of Man" },
            { "IN", "Indien" },
            { "IO", "Brittiska Indiska ocean\u00f6arna" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "IT", "Italien" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Jordanien" },
            { "JP", "Japan" },
            { "KE", "Kenya" },
            { "KG", "Kirgizistan" },
            { "KH", "Kambodja" },
            { "KI", "Kiribati" },
            { "KM", "Komorerna" },
            { "KN", "S:t Kitts och Nevis" },
            { "KP", "Nordkorea" },
            { "KR", "Sydkorea" },
            { "KW", "Kuwait" },
            { "KY", "Cayman\u00f6arna" },
            { "KZ", "Kazakstan" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "S:t Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Litauen" },
            { "LU", "Luxemburg" },
            { "LV", "Lettland" },
            { "LY", "Libyen" },
            { "MA", "Marocko" },
            { "MC", "Monaco" },
            { "MD", "Moldavien" },
            { "ME", "Montenegro" },
            { "MF", "S:t Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Marshall\u00f6arna" },
            { "MK", "Makedonien" },
            { "ML", "Mali" },
            { "MM", "Myanmar" },
            { "MN", "Mongoliet" },
            { "MO", "Macao (S.A.R. Kina)" },
            { "MP", "Nordmarianerna" },
            { "MQ", "Martinique" },
            { "MR", "Mauretanien" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Maldiverna" },
            { "MW", "Malawi" },
            { "MX", "Mexiko" },
            { "MY", "Malaysia" },
            { "MZ", "Mo\u00e7ambique" },
            { "NA", "Namibia" },
            { "NC", "Nya Kaledonien" },
            { "NE", "Niger" },
            { "NF", "Norfolk\u00f6n" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Nederl\u00e4nderna" },
            { "NO", "Norge" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nya Zeeland" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Franska Polynesien" },
            { "PG", "Papua Nya Guinea" },
            { "PH", "Filippinerna" },
            { "PK", "Pakistan" },
            { "PL", "Polen" },
            { "PM", "S:t Pierre och Miquelon" },
            { "PN", "Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestinska territoriet" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "Yttre \u00f6ar i Oceanien" },
            { "RE", "R\u00e9union" },
            { "RO", "Rum\u00e4nien" },
            { "RS", "Serbien" },
            { "RU", "Ryssland" },
            { "RW", "Rwanda" },
            { "SA", "Saudiarabien" },
            { "SB", "Salomon\u00f6arna" },
            { "SC", "Seychellerna" },
            { "SD", "Sudan" },
            { "SE", "Sverige" },
            { "SG", "Singapore" },
            { "SH", "S:t Helena" },
            { "SI", "Slovenien" },
            { "SJ", "Svalbard och Jan Mayen" },
            { "SK", "Slovakien" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Surinam" },
            { "ST", "S\u00e3o Tom\u00e9 och Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SY", "Syrien" },
            { "SZ", "Swaziland" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks- och Caicos\u00f6arna" },
            { "TD", "Tchad" },
            { "TF", "Franska Sydterritorierna" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tadzjikistan" },
            { "TK", "Tokelau" },
            { "TL", "\u00d6sttimor" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisien" },
            { "TO", "Tonga" },
            { "TR", "Turkiet" },
            { "TT", "Trinidad och Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanzania" },
            { "UA", "Ukraina" },
            { "UG", "Uganda" },
            { "UM", "USA:s yttre \u00f6ar" },
            { "US", "USA" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistan" },
            { "VA", "Vatikanstaten" },
            { "VC", "S:t Vincent och Grenadinerna" },
            { "VE", "Venezuela" },
            { "VG", "Brittiska Jungfru\u00f6arna" },
            { "VI", "Amerikanska Jungfru\u00f6arna" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis- och Futuna\u00f6arna" },
            { "WS", "Samoa" },
            { "YE", "Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "Sydafrika" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "ok\u00e4nd eller ogiltig regionkod" },
            { "aa", "afar" },
            { "ab", "abchaziska" },
            { "ae", "avestiska" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amhariska" },
            { "an", "aragonesiska" },
            { "ar", "arabiska" },
            { "as", "assamesiska" },
            { "av", "avariska" },
            { "ay", "aymara" },
            { "az", "azerbajdzjanska" },
            { "ba", "basjkiriska" },
            { "be", "vitryska" },
            { "bg", "bulgariska" },
            { "bh", "bihari" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", "bengali" },
            { "bo", "tibetanska" },
            { "br", "bretonska" },
            { "bs", "bosniska" },
            { "ca", "katalanska" },
            { "ce", "tjetjenska" },
            { "ch", "chamorro" },
            { "co", "korsikanska" },
            { "cr", "cree" },
            { "cs", "tjeckiska" },
            { "cu", "kyrkslaviska" },
            { "cv", "tjuvasjiska" },
            { "cy", "walesiska" },
            { "da", "danska" },
            { "de", "tyska" },
            { "dv", "divehi" },
            { "dz", "bhutanesiska" },
            { "ee", "ewe" },
            { "el", "grekiska" },
            { "en", "engelska" },
            { "eo", "esperanto" },
            { "es", "spanska" },
            { "et", "estniska" },
            { "eu", "baskiska" },
            { "fa", "persiska" },
            { "ff", "fulani" },
            { "fi", "finska" },
            { "fj", "fidjianska" },
            { "fo", "f\u00e4r\u00f6iska" },
            { "fr", "franska" },
            { "fy", "v\u00e4stfrisiska" },
            { "ga", "iriska" },
            { "gd", "h\u00f6glandsskotska" },
            { "gl", "galiciska" },
            { "gn", "guaran\u00ed" },
            { "gu", "gujarati" },
            { "gv", "manx" },
            { "ha", "haussa" },
            { "he", "hebreiska" },
            { "hi", "hindi" },
            { "ho", "hirimotu" },
            { "hr", "kroatiska" },
            { "ht", "haitiska" },
            { "hu", "ungerska" },
            { "hy", "armeniska" },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonesiska" },
            { "ie", "interlingue" },
            { "ig", "ibo" },
            { "ii", "szezuan i" },
            { "ik", "inupiak" },
            { "io", "ido" },
            { "is", "isl\u00e4ndska" },
            { "it", "italienska" },
            { "iu", "inuktitut" },
            { "ja", "japanska" },
            { "jv", "javanesiska" },
            { "ka", "georgiska" },
            { "kg", "kikongo" },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "kazakiska" },
            { "kl", "gr\u00f6nl\u00e4ndska" },
            { "km", "kambodjanska" },
            { "kn", "kannada" },
            { "ko", "koreanska" },
            { "kr", "kanuri" },
            { "ks", "kashmiriska" },
            { "ku", "kurdiska" },
            { "kv", "kome" },
            { "kw", "korniska" },
            { "ky", "kirgisiska" },
            { "la", "latin" },
            { "lb", "luxemburgiska" },
            { "lg", "luganda" },
            { "li", "limburgiska" },
            { "ln", "lingala" },
            { "lo", "laotiska" },
            { "lt", "litauiska" },
            { "lu", "luba-katanga" },
            { "lv", "lettiska" },
            { "mg", "malagassiska" },
            { "mh", "marshalliska" },
            { "mi", "maori" },
            { "mk", "makedonska" },
            { "ml", "malayalam" },
            { "mn", "mongoliska" },
            { "mo", "moldaviska" },
            { "mr", "marathi" },
            { "ms", "malajiska" },
            { "mt", "maltesiska" },
            { "my", "burmesiska" },
            { "na", "nauru" },
            { "nb", "norskt bokm\u00e5l" },
            { "nd", "nordndebele" },
            { "ne", "nepalesiska" },
            { "ng", "ndonga" },
            { "nl", "nederl\u00e4ndska" },
            { "nn", "nynorska" },
            { "no", "norska" },
            { "nr", "sydndebele" },
            { "nv", "navaho" },
            { "ny", "nyanja" },
            { "oc", "occitanska" },
            { "oj", "odjibwa" },
            { "om", "oromo" },
            { "or", "oriya" },
            { "os", "ossetiska" },
            { "pa", "punjabi" },
            { "pi", "pali" },
            { "pl", "polska" },
            { "ps", "afghanska" },
            { "pt", "portugisiska" },
            { "qu", "quechua" },
            { "rm", "r\u00e4toromanska" },
            { "rn", "rundi" },
            { "ro", "rum\u00e4nska" },
            { "ru", "ryska" },
            { "rw", "kinjarwanda" },
            { "sa", "sanskrit" },
            { "sc", "sardiska" },
            { "sd", "sindhi" },
            { "se", "nordsamiska" },
            { "sg", "sango" },
            { "sh", "serbokroatiska" },
            { "si", "singalesiska" },
            { "sk", "slovakiska" },
            { "sl", "slovenska" },
            { "sm", "samoanska" },
            { "sn", "shona" },
            { "so", "somaliska" },
            { "sq", "albanska" },
            { "sr", "serbiska" },
            { "ss", "swati" },
            { "st", "sydsotho" },
            { "su", "sundanesiska" },
            { "sv", "svenska" },
            { "sw", "swahili" },
            { "ta", "tamil" },
            { "te", "telugiska" },
            { "tg", "tadzjikiska" },
            { "th", "thail\u00e4ndska" },
            { "ti", "tigrinja" },
            { "tk", "turkmeniska" },
            { "tl", "tagalog" },
            { "tn", "tswana" },
            { "to", "tonganska" },
            { "tr", "turkiska" },
            { "ts", "tsonga" },
            { "tt", "tatariska" },
            { "tw", "twi" },
            { "ty", "tahitiska" },
            { "ug", "uiguriska" },
            { "uk", "ukrainska" },
            { "ur", "urdu" },
            { "uz", "uzbekiska" },
            { "ve", "venda" },
            { "vi", "vietnamesiska" },
            { "vo", "volap\u00fck" },
            { "wa", "vallonska" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "jiddisch" },
            { "yo", "yoruba" },
            { "za", "zhuang" },
            { "zh", "kinesiska" },
            { "zu", "zulu" },
            { "ace", "acehnesiska" },
            { "ach", "acholi" },
            { "ada", "adangme" },
            { "ady", "adygeiska" },
            { "afa", "afroasiatiskt spr\u00e5k" },
            { "afh", "afrihili" },
            { "agq", "aghem" },
            { "ain", "ainu" },
            { "akk", "akkadiska" },
            { "ale", "aleutiska" },
            { "alg", "algonkinskt spr\u00e5k" },
            { "alt", "sydaltaiska" },
            { "ang", "fornengelska" },
            { "anp", "angika" },
            { "apa", "apachespr\u00e5k" },
            { "arc", "arameiska" },
            { "arn", "araukanska" },
            { "arp", "arapaho" },
            { "art", "konstgjort spr\u00e5k" },
            { "arw", "arawakiska" },
            { "asa", "asu" },
            { "ast", "asturiska" },
            { "ath", "athapaskiskt spr\u00e5k" },
            { "aus", "australiskt spr\u00e5k" },
            { "awa", "awadhi" },
            { "bad", "bandaspr\u00e5k" },
            { "bai", "bamilekespr\u00e5k" },
            { "bal", "baluchiska" },
            { "ban", "balinesiska" },
            { "bas", "basa" },
            { "bat", "baltiskt spr\u00e5k" },
            { "bej", "beyja" },
            { "bem", "bemba" },
            { "ber", "berberspr\u00e5k" },
            { "bez", "bena" },
            { "bho", "bhojpuri" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "bla", "siksika" },
            { "bnt", "bantuspr\u00e5k" },
            { "bra", "braj" },
            { "brx", "bodo" },
            { "btk", "batak" },
            { "bua", "burj\u00e4tiska" },
            { "bug", "buginesiska" },
            { "byn", "blin" },
            { "cad", "caddo" },
            { "cai", "centralamerikanskt indianspr\u00e5k" },
            { "car", "karibiska" },
            { "cau", "kaukasiskt spr\u00e5k" },
            { "cch", "atsam" },
            { "ceb", "cebuano" },
            { "cel", "keltiskt spr\u00e5k" },
            { "chb", "chibcha" },
            { "chg", "chagatai" },
            { "chk", "chuukesiska" },
            { "chm", "mari" },
            { "chn", "chinook" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", "cherokesiska" },
            { "chy", "cheyenne" },
            { "cmc", "chamispr\u00e5k" },
            { "cop", "koptiska" },
            { "cpe", "engelskbaserat kreol- eller pidginspr\u00e5k" },
            { "cpf", "franskbaserat kreol- eller pidginspr\u00e5k" },
            { "cpp", "portugisiskbaserat kreol- eller pidginspr\u00e5k" },
            { "crh", "krimtatariska" },
            { "crp", "kreol- eller pidginspr\u00e5k" },
            { "csb", "kasjubiska" },
            { "cus", "kusjitiskt spr\u00e5k" },
            { "dak", "dakota" },
            { "dar", "darginska" },
            { "day", "dajakiska" },
            { "del", "delaware" },
            { "den", "slavej" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dra", "dravidiskt spr\u00e5k" },
            { "dsb", "l\u00e5gsorbiska" },
            { "dua", "duala" },
            { "dum", "medelnederl\u00e4ndska" },
            { "dyo", "jola-fonyi" },
            { "dyu", "dyula" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "egy", "fornegyptiska" },
            { "eka", "ekajuk" },
            { "elx", "elamitiska" },
            { "enm", "medelengelska" },
            { "ewo", "ewondo" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filippinska" },
            { "fiu", "finskugriskt spr\u00e5k" },
            { "fon", "fonspr\u00e5ket" },
            { "frm", "medelfranska" },
            { "fro", "fornfranska" },
            { "frr", "nordfrisiska" },
            { "frs", "\u00f6stfrisiska" },
            { "fur", "friulianska" },
            { "gaa", "g\u00e3" },
            { "gay", "gayo" },
            { "gba", "gbaya" },
            { "gem", "germanskt spr\u00e5k" },
            { "gez", "etiopiska" },
            { "gil", "gilbertiska" },
            { "gmh", "medelh\u00f6gtyska" },
            { "goh", "fornh\u00f6gtyska" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", "gotiska" },
            { "grb", "grebo" },
            { "grc", "forngrekiska" },
            { "gsw", "schweizertyska" },
            { "gwi", "gwichin" },
            { "hai", "haida" },
            { "haw", "hawaiiska" },
            { "hil", "hiligaynon" },
            { "him", "himachali" },
            { "hit", "hettitiska" },
            { "hmn", "hmongspr\u00e5k" },
            { "hsb", "h\u00f6gsorbiska" },
            { "hup", "hupa" },
            { "iba", "ibanska" },
            { "ijo", "ijospr\u00e5ket" },
            { "ilo", "iloko" },
            { "inc", "indiskt spr\u00e5k" },
            { "ine", "indoeuropeiskt spr\u00e5k" },
            { "inh", "ingusjiska" },
            { "ira", "iranskt spr\u00e5k" },
            { "iro", "irokesiskt spr\u00e5k" },
            { "jbo", "lojban" },
            { "jpr", "judisk persiska" },
            { "jrb", "judisk arabiska" },
            { "kaa", "karakalpakiska" },
            { "kab", "kabyliska" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kar", "karenska" },
            { "kaw", "kawi" },
            { "kbd", "kabardinska" },
            { "kcg", "tyap" },
            { "kea", "kapverdiska" },
            { "kfo", "koro" },
            { "kha", "khasi" },
            { "khi", "khoisanspr\u00e5k" },
            { "kho", "khotanesiska" },
            { "kmb", "kimbundu" },
            { "kok", "konkani" },
            { "kos", "kosreanska" },
            { "kpe", "kpelle" },
            { "krc", "karachay-balkar" },
            { "krl", "karelska" },
            { "kro", "kru" },
            { "kru", "kurukh" },
            { "ksf", "bafia" },
            { "kum", "kumykiska" },
            { "kut", "kutenaj" },
            { "lad", "ladino" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezghien" },
            { "lol", "mongo" },
            { "loz", "lozi" },
            { "lua", "luba-lulua" },
            { "lui", "luise\u00f1o" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "lus", "lushai" },
            { "luy", "luhya" },
            { "mad", "maduresiska" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makasar" },
            { "man", "mande" },
            { "map", "austronesiskt spr\u00e5k" },
            { "mas", "massajiska" },
            { "mdf", "moksja" },
            { "mdr", "mandar" },
            { "men", "mende" },
            { "mga", "medeliriska" },
            { "mgh", "makhuwa-meetto" },
            { "mic", "mic-mac" },
            { "min", "minangkabau" },
            { "mis", "annat spr\u00e5k" },
            { "mkh", "mon-khmeriskt spr\u00e5k" },
            { "mnc", "manchuriska" },
            { "mni", "manipuri" },
            { "mno", "manobospr\u00e5k" },
            { "moh", "mohawk" },
            { "mos", "mossi" },
            { "mua", "mundang" },
            { "mul", "flera spr\u00e5k" },
            { "mun", "mundaspr\u00e5k" },
            { "mus", "muskogee" },
            { "mwl", "mirandesiska" },
            { "mwr", "marwari" },
            { "myn", "mayaspr\u00e5k" },
            { "myv", "erjya" },
            { "nah", "aztekiska" },
            { "nai", "nordamerikanskt indianspr\u00e5k" },
            { "nap", "napolitanska" },
            { "nds", "l\u00e5gtyska" },
            { "new", "newariska" },
            { "nia", "nias" },
            { "nic", "Niger-Kongospr\u00e5k" },
            { "niu", "niueanska" },
            { "nmg", "kwasio" },
            { "nog", "nogai" },
            { "non", "fornnordiska" },
            { "nqo", "n-k\u00e5" },
            { "nso", "nordsotho" },
            { "nub", "nubiskt spr\u00e5k" },
            { "nus", "nuer" },
            { "nwc", "klassisk newariska" },
            { "nym", "nyamwezi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoro" },
            { "nzi", "nzima" },
            { "osa", "osage" },
            { "ota", "ottomanska" },
            { "oto", "otomispr\u00e5k" },
            { "paa", "papuanskt spr\u00e5k" },
            { "pag", "pangasinan" },
            { "pal", "medelpersiska" },
            { "pam", "pampanga" },
            { "pap", "papiamento" },
            { "pau", "palau" },
            { "peo", "fornpersiska" },
            { "phi", "filippinskt spr\u00e5k" },
            { "phn", "feniciska" },
            { "pon", "ponape" },
            { "pra", "prakritspr\u00e5k" },
            { "pro", "fornprovensalska" },
            { "raj", "rajasthani" },
            { "rap", "rapanui" },
            { "rar", "rarotonganska" },
            { "roa", "romanskt spr\u00e5k" },
            { "rof", "rombo" },
            { "rom", "romani" },
            { "rup", "arum\u00e4nska" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "jakutiska" },
            { "sai", "sydamerikanskt indianspr\u00e5k" },
            { "sal", "salikiskt spr\u00e5k" },
            { "sam", "samaritanska" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "sbp", "sangu" },
            { "scn", "sicilianska" },
            { "sco", "skotska" },
            { "sel", "selkup" },
            { "sem", "semitiskt spr\u00e5k" },
            { "sga", "forniriska" },
            { "sgn", "teckenspr\u00e5k" },
            { "shn", "shan" },
            { "sid", "sidamo" },
            { "sio", "siouxspr\u00e5k" },
            { "sit", "sinotibetanskt spr\u00e5k" },
            { "sla", "slaviskt spr\u00e5k" },
            { "sma", "sydsamiska" },
            { "smi", "samiskt spr\u00e5k" },
            { "smj", "lulesamiska" },
            { "smn", "enaresamiska" },
            { "sms", "skoltsamiska" },
            { "snk", "soninke" },
            { "sog", "sogdiska" },
            { "son", "songhai" },
            { "srn", "sranan tongo" },
            { "srr", "serer" },
            { "ssa", "nilosahariskt spr\u00e5k" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumeriska" },
            { "swb", "shimaor\u00e9" },
            { "syc", "klassisk syriska" },
            { "syr", "syriska" },
            { "tai", "thaispr\u00e5k" },
            { "tem", "temne" },
            { "ter", "tereno" },
            { "tet", "tetum" },
            { "tig", "tigr\u00e9" },
            { "tiv", "tivi" },
            { "tkl", "tokelauiska" },
            { "tlh", "klingonska" },
            { "tli", "tlingit" },
            { "tmh", "tamashek" },
            { "tog", "nyasatonganska" },
            { "tpi", "tok pisin" },
            { "tsi", "tsimshian" },
            { "tum", "tumbuka" },
            { "tup", "tup\u00edspr\u00e5k" },
            { "tut", "altaiskt spr\u00e5k" },
            { "tvl", "tuvaluanska" },
            { "twq", "tasawaq" },
            { "tyv", "tuviniska" },
            { "udm", "udmurtiska" },
            { "uga", "ugaritiska" },
            { "umb", "umbundu" },
            { "und", "obest\u00e4mt spr\u00e5k" },
            { "vai", "vaj" },
            { "vot", "votiska" },
            { "wae", "walsertyska" },
            { "wak", "wakusjiskt spr\u00e5k" },
            { "wal", "walamo" },
            { "war", "waray" },
            { "was", "washo" },
            { "wen", "sorbiskt spr\u00e5k" },
            { "xal", "kalmuckiska" },
            { "yao", "kiyao" },
            { "yap", "japetiska" },
            { "yav", "yangben" },
            { "ypk", "eskim\u00e5spr\u00e5k" },
            { "yue", "kantonesiska" },
            { "zap", "zapotek" },
            { "zbl", "blissymboler" },
            { "zen", "zenaga" },
            { "znd", "zand\u00e9" },
            { "zun", "zuni" },
            { "zxx", "inget spr\u00e5kligt inneh\u00e5ll" },
            { "zza", "zazaiska" },
            { "Arab", "arabiska" },
            { "Armi", "imperisk arameiska" },
            { "Armn", "armeniska" },
            { "Avst", "avestiska" },
            { "Bali", "balinesiska" },
            { "Batk", "batak" },
            { "Beng", "bengaliska" },
            { "Blis", "blissymboler" },
            { "Bopo", "bopomofo" },
            { "Brah", "brami" },
            { "Brai", "punktskrift" },
            { "Bugi", "buginesiska" },
            { "Buhd", "buhid" },
            { "Cakm", "chakma" },
            { "Cans", "kanadensiska stavelsetecken" },
            { "Cari", "kariska" },
            { "Cham", "cham" },
            { "Cher", "cherokee" },
            { "Cirt", "cirt" },
            { "Copt", "koptiska" },
            { "Cprt", "cypriotiska" },
            { "Cyrl", "kyrilliska" },
            { "Cyrs", "fornkyrkoslavisk kyrilliska" },
            { "Deva", "devanagari" },
            { "Dsrt", "deseret" },
            { "Egyd", "demotiska" },
            { "Egyh", "hieratiska" },
            { "Egyp", "egyptiska hieroglyfer" },
            { "Ethi", "etiopiska" },
            { "Geok", "kutsuri" },
            { "Geor", "georgiska" },
            { "Glag", "glagolitiska" },
            { "Goth", "gotiska" },
            { "Grek", "grekiska" },
            { "Gujr", "gujarati" },
            { "Guru", "gurmukhi" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanun\u00e5" },
            { "Hans", "f\u00f6renklad han" },
            { "Hant", "traditionell han" },
            { "Hebr", "hebreiska" },
            { "Hira", "hiragana" },
            { "Hmng", "pahaw mong" },
            { "Hrkt", "katakana/hiragana" },
            { "Hung", "fornungerska" },
            { "Inds", "indus" },
            { "Ital", "fornitaliska" },
            { "Java", "javanska" },
            { "Jpan", "japanska" },
            { "Kali", "kaya li" },
            { "Kana", "katakana" },
            { "Khar", "kharoshti" },
            { "Khmr", "khmeriska" },
            { "Knda", "kanaresiska" },
            { "Kore", "koreanska" },
            { "Kthi", "kaithiska" },
            { "Lana", "lanna" },
            { "Laoo", "laotiska" },
            { "Latf", "frakturlatin" },
            { "Latg", "gaeliskt latin" },
            { "Latn", "latinska" },
            { "Lepc", "rong" },
            { "Limb", "limbu" },
            { "Lina", "linj\u00e4r A" },
            { "Linb", "linj\u00e4r B" },
            { "Lyci", "lykiska" },
            { "Lydi", "lydiska" },
            { "Mand", "manda\u00e9iska" },
            { "Mani", "manikeanska" },
            { "Maya", "mayahieroglyfer" },
            { "Mero", "meriotiska" },
            { "Mlym", "malayalam" },
            { "Mong", "mongoliska" },
            { "Moon", "moon" },
            { "Mtei", "meitei-mayek" },
            { "Mymr", "burmesiska" },
            { "Nkoo", "n-k\u00e5" },
            { "Ogam", "ogham" },
            { "Olck", "ol-chiki" },
            { "Orkh", "orkon" },
            { "Orya", "oriya" },
            { "Osma", "osmanja" },
            { "Perm", "fornpermiska" },
            { "Phag", "phags-pa" },
            { "Phli", "tidig pahlavi" },
            { "Phlp", "psaltaren-pahlavi" },
            { "Phlv", "bokpahlavi" },
            { "Phnx", "fenikiska" },
            { "Plrd", "pollardtecken" },
            { "Prti", "tidig parthianska" },
            { "Rjng", "rejang" },
            { "Roro", "rongo-rongo" },
            { "Runr", "runor" },
            { "Samr", "samaritiska" },
            { "Sara", "sarati" },
            { "Saur", "saurashtra" },
            { "Sgnw", "teckningsskrift" },
            { "Shaw", "shawiska" },
            { "Sinh", "singalesiska" },
            { "Sund", "sundanesiska" },
            { "Sylo", "syloti nagri" },
            { "Syrc", "syriska" },
            { "Syre", "estrangelosyriska" },
            { "Syrj", "v\u00e4stsyriska" },
            { "Syrn", "\u00f6stsyriska" },
            { "Tagb", "tagbanwa" },
            { "Tale", "tai le" },
            { "Talu", "tai lue" },
            { "Taml", "tamilska" },
            { "Tavt", "tai viet" },
            { "Telu", "telugu" },
            { "Teng", "tengwar" },
            { "Tfng", "tifinaghiska" },
            { "Tglg", "tagalog" },
            { "Thaa", "taana" },
            { "Thai", "thail\u00e4ndska" },
            { "Tibt", "tibetanska" },
            { "Ugar", "ugaritiska" },
            { "Vaii", "vaj" },
            { "Visp", "synligt tal" },
            { "Xpeo", "fornpersiska" },
            { "Xsux", "sumeo-akkadisk kilskrift" },
            { "Yiii", "yi" },
            { "Zinh", "\u00e4rvda" },
            { "Zmth", "matematisk notation" },
            { "Zsym", "symboler" },
            { "Zxxx", "oskrivet spr\u00e5k" },
            { "Zyyy", "gemensamma" },
            { "Zzzz", "ok\u00e4nt skriftsystem" },
            { "root", "rot" },
            { "de_AT", "\u00f6sterrikisk tyska" },
            { "de_CH", "schweizisk h\u00f6gtyska" },
            { "en_AU", "australisk engelska" },
            { "en_CA", "kanadensisk engelska" },
            { "en_GB", "brittisk engelska" },
            { "en_US", "amerikansk engelska" },
            { "es_ES", "europeisk spanska" },
            { "fr_CA", "kanadensisk franska" },
            { "fr_CH", "schweizisk franska" },
            { "nl_BE", "flaml\u00e4ndska" },
            { "pt_BR", "brasiliansk portugisiska" },
            { "pt_PT", "europeisk portugisiska" },
            { "es_419", "latinamerikansk spanska" },
            { "zh_Hans", "f\u00f6renklad kinesiska" },
            { "zh_Hant", "traditionell kinesiska" },
        };
        return data;
    }
}
