/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_pt_PT extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Hora da \u00c1frica Central",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Hora padr\u00e3o de Moscovo",
               "",
               "Hora de ver\u00e3o de Moscovo",
               "",
               "Hora de Moscovo",
               "",
            };
        final String[] Japan = new String[] {
               "Hora padr\u00e3o do Jap\u00e3o",
               "",
               "Hora de ver\u00e3o do Jap\u00e3o",
               "",
               "Hora do Jap\u00e3o",
               "",
            };
        final String[] Pakistan = new String[] {
               "Hora padr\u00e3o do Paquist\u00e3o",
               "",
               "Hora de ver\u00e3o do Paquist\u00e3o",
               "",
               "Hora do Paquist\u00e3o",
               "",
            };
        final String[] Taipei = new String[] {
               "Hora padr\u00e3o de Taip\u00e9",
               "",
               "Hora de ver\u00e3o de Taip\u00e9",
               "",
               "Hora de Taip\u00e9",
               "",
            };
        final String[] Hovd = new String[] {
               "Hora padr\u00e3o de Hovd",
               "",
               "Hora de ver\u00e3o de Hovd",
               "",
               "Hora de Hovd",
               "",
            };
        final String[] Magadan = new String[] {
               "Hora padr\u00e3o de Magadan",
               "",
               "Hora de ver\u00e3o de Magadan",
               "",
               "Hora de Magadan",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Hora padr\u00e3o da Austr\u00e1lia Central Ocidental",
               "",
               "Hora de ver\u00e3o da Austr\u00e1lia Central Ocidental",
               "",
               "Hora da Austr\u00e1lia Central Ocidental",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Hora padr\u00e3o da Europa Central",
               "CET",
               "Hora de ver\u00e3o da Europa Central",
               "CEST",
               "Hora da Europa Central",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Hora padr\u00e3o de Sacalina",
               "",
               "Hora de ver\u00e3o de Sacalina",
               "",
               "Hora de Sacalina",
               "",
            };
        final String[] Paraguay = new String[] {
               "Hora padr\u00e3o do Paraguai",
               "",
               "Hora de ver\u00e3o do Paraguai",
               "",
               "Hora do Paraguai",
               "",
            };
        final String[] Acre = new String[] {
               "Hora padr\u00e3o do Acre",
               "\u2205\u2205\u2205",
               "Hora de ver\u00e3o do Acre",
               "\u2205\u2205\u2205",
               "Hora do Acre",
               "\u2205\u2205\u2205",
            };
        final String[] Malaysia = new String[] {
               "Hora da Mal\u00e1sia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Hora Coordenada Universal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Eastern = new String[] {
               "Hora padr\u00e3o Oriental",
               "",
               "Hora de ver\u00e3o Oriental",
               "",
               "Hora Oriental",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Hora padr\u00e3o de Lord Howe",
               "",
               "Hora de ver\u00e3o de Lord Howe",
               "",
               "Hora de Lord Howe",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Hora padr\u00e3o da Nova Zel\u00e2ndia",
               "",
               "Hora de ver\u00e3o da Nova Zel\u00e2ndia",
               "",
               "Hora da Nova Zel\u00e2ndia",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Hora do Oceano \u00cdndico",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Hora padr\u00e3o de Yakutsk",
               "",
               "Hora de ver\u00e3o de Yakutsk",
               "",
               "Hora de Yakutsk",
               "",
            };
        final String[] Mauritius = new String[] {
               "Hora padr\u00e3o da Maur\u00edcia",
               "",
               "Hora de ver\u00e3o da Maur\u00edcia",
               "",
               "Hora da Maur\u00edcia",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "Hora da \u00c1frica Oriental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] East_Timor = new String[] {
               "Hora de Timor Leste",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Hora das Ilhas Salom\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kosrae = new String[] {
               "Hora de Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "Hora das Ilhas Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "Hora padr\u00e3o da Europa Oriental",
               "EET",
               "Hora de ver\u00e3o da Europa Oriental",
               "EEST",
               "Hora da Europa Oriental",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Hora padr\u00e3o da Terra Nova",
               "",
               "Hora de ver\u00e3o da Terra Nova",
               "",
               "Hora da Terra Nova",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Hora do Afeganist\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hora padr\u00e3o de Hong Kong",
               "",
               "Hora de ver\u00e3o de Hong Kong",
               "",
               "Hora de Hong Kong",
               "",
            };
        final String[] Argentina_Western = new String[] {
               "Hora padr\u00e3o da Argentina Ocidental",
               "",
               "Hora de ver\u00e3o da Argentina Ocidental",
               "",
               "Hora da Argentina Ocidental",
               "",
            };
        final String[] Atlantic = new String[] {
               "Hora padr\u00e3o do Atl\u00e2ntico",
               "",
               "Hora de ver\u00e3o do Atl\u00e2ntico",
               "",
               "Hora do Atl\u00e2ntico",
               "",
            };
        final String[] Ponape = new String[] {
               "Hora de Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Bolivia = new String[] {
               "Hora da Bol\u00edvia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Hora padr\u00e3o de S\u00e3o Pedro e Miquel\u00e3o",
               "",
               "Hora de ver\u00e3o de S\u00e3o Pedro e Miquel\u00e3o",
               "",
               "Hora de S\u00e3o Pedro e Miquel\u00e3o",
               "",
            };
        final String[] Indochina = new String[] {
               "Hora da Indochina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Hora padr\u00e3o de Ecaterimburgo",
               "",
               "Hora de ver\u00e3o de Ecaterimburgo",
               "",
               "Hora de Ecaterimburgo",
               "",
            };
        final String[] Maldives = new String[] {
               "Hora das Maldivas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Hora do Taiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Hora padr\u00e3o de Israel",
               "",
               "Hora de ver\u00e3o de Israel",
               "",
               "Hora de Israel",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Hora da Indon\u00e9sia Central",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Hora de Wallis e Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "Hora da \u00c1frica do Sul",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Syowa = new String[] {
               "Hora de Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Hora das Ilhas Line",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Hora padr\u00e3o do Uzbequist\u00e3o",
               "",
               "Hora de ver\u00e3o do Uzbequist\u00e3o",
               "",
               "Hora do Uzbequist\u00e3o",
               "",
            };
        final String[] Omsk = new String[] {
               "Hora padr\u00e3o de Omsk",
               "",
               "Hora de ver\u00e3o de Omsk",
               "",
               "Hora de Omsk",
               "",
            };
        final String[] Seychelles = new String[] {
               "Hora das Seicheles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Hora padr\u00e3o do Uruguai",
               "",
               "Hora de ver\u00e3o do Uruguai",
               "",
               "Hora do Uruguai",
               "",
            };
        final String[] Nepal = new String[] {
               "Hora do Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Hora padr\u00e3o de Ulan Bator",
               "",
               "Hora de ver\u00e3o de Ulan Bator",
               "",
               "Hora de Ulan Bator",
               "",
            };
        final String[] America_Central = new String[] {
               "Hora padr\u00e3o Central",
               "",
               "Hora de ver\u00e3o Central",
               "",
               "Hora Central",
               "",
            };
        final String[] Truk = new String[] {
               "Hora de Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Niue = new String[] {
               "Hora de Niu\u00ea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Hora da Ilha Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Falkland = new String[] {
               "Hora padr\u00e3o das Ilhas Falkland",
               "",
               "Hora de ver\u00e3o das Ilhas Falkland",
               "",
               "Hora das Ilhas Falkland",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Hora padr\u00e3o do Vanuatu",
               "",
               "Hora de ver\u00e3o do Vanuatu",
               "",
               "Hora do Vanuatu",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Hora padr\u00e3o de Novosibirsk",
               "",
               "Hora de ver\u00e3o de Novosibirsk",
               "",
               "Hora de Novosibirsk",
               "",
            };
        final String[] Singapore = new String[] {
               "Hora padr\u00e3o de Singapura",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azores = new String[] {
               "Hora padr\u00e3o dos A\u00e7ores",
               "AZOT",
               "Hora de ver\u00e3o dos A\u00e7ores",
               "AZOST",
               "Hora dos A\u00e7ores",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Hora padr\u00e3o de Apia",
               "",
               "Hora de ver\u00e3o de Apia",
               "",
               "Hora de Apia",
               "",
            };
        final String[] Bhutan = new String[] {
               "Hora do But\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "Hora do Suriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nauru = new String[] {
               "Hora de Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Hora padr\u00e3o de Krasnoyarsk",
               "",
               "Hora de ver\u00e3o de Krasnoyarsk",
               "",
               "Hora de Krasnoyarsk",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Hora do Cazaquist\u00e3o Ocidental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Myanmar = new String[] {
               "Hora de Mianmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Christmas = new String[] {
               "Hora da Ilha do Natal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "Hora padr\u00e3o do Amazonas",
               "\u2205\u2205\u2205",
               "Hora de ver\u00e3o do Amazonas",
               "\u2205\u2205\u2205",
               "Hora do Amazonas",
               "\u2205\u2205\u2205",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Hora do Cazaquist\u00e3o Oriental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Fiji = new String[] {
               "Hora padr\u00e3o de Fiji",
               "",
               "Hora de ver\u00e3o de Fiji",
               "",
               "Hora de Fiji",
               "",
            };
        final String[] Reunion = new String[] {
               "Hora de Reuni\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cocos = new String[] {
               "Hora das Ilhas Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Hora padr\u00e3o de Chatham",
               "",
               "Hora de ver\u00e3o de Chatham",
               "",
               "Hora de Chatham",
               "",
            };
        final String[] Vostok = new String[] {
               "Hora de Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Hora padr\u00e3o da Argentina",
               "",
               "Hora de ver\u00e3o da Argentina",
               "",
               "Hora da Argentina",
               "",
            };
        final String[] Gambier = new String[] {
               "Hora de Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Hora padr\u00e3o de Petropavlovsk-Kamchatski",
               "",
               "Hora de ver\u00e3o de Petropavlovsk-Kamchatski",
               "",
               "Hora de Petropavlovsk-Kamchatski",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Hora de Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Hora das Gal\u00e1pagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Macquarie = new String[] {
               "Hora da Ilha Macquarie",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Hora da Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hora padr\u00e3o do Havai e Aleutas",
               "",
               "Hora de ver\u00e3o do Havai e Aleutas",
               "",
               "Hora do Havai e Aleutas",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Hora padr\u00e3o da Austr\u00e1lia Central",
               "",
               "Hora de ver\u00e3o da Austr\u00e1lia Central",
               "",
               "Hora da Austr\u00e1lia Central",
               "",
            };
        final String[] America_Pacific = new String[] {
               "Hora padr\u00e3o do Pac\u00edfico",
               "",
               "Hora de ver\u00e3o do Pac\u00edfico",
               "",
               "Hora do Pac\u00edfico",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "Hora das Ilhas F\u00e9nix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "Hora padr\u00e3o do Turquemenist\u00e3o",
               "",
               "Hora de ver\u00e3o do Turquemenist\u00e3o",
               "",
               "Hora do Turquemenist\u00e3o",
               "",
            };
        final String[] Europe_Western = new String[] {
               "Hora padr\u00e3o da Europa Ocidental",
               "WET",
               "Hora de ver\u00e3o da Europa Ocidental",
               "WEST",
               "Hora da Europa Ocidental",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Hora padr\u00e3o de Cabo Verde",
               "",
               "Hora de ver\u00e3o de Cabo Verde",
               "",
               "Hora de Cabo Verde",
               "",
            };
        final String[] Norfolk = new String[] {
               "Hora da Ilha Norfolk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Guyana = new String[] {
               "Hora da Guiana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Hora de Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Hora de Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Hora padr\u00e3o de Samoa",
               "",
               "Hora de ver\u00e3o de Samoa",
               "",
               "Hora de Samoa",
               "",
            };
        final String[] Palau = new String[] {
               "Hora de Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Hora padr\u00e3o do Azerbaij\u00e3o",
               "",
               "Hora de ver\u00e3o do Azerbaij\u00e3o",
               "",
               "Hora do Azerbaij\u00e3o",
               "",
            };
        final String[] Mawson = new String[] {
               "Hora de Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "Hora padr\u00e3o do Pac\u00edfico Mexicano",
               "",
               "Hora de ver\u00e3o do Pac\u00edfico Mexicano",
               "",
               "Hora do Pac\u00edfico Mexicano",
               "",
            };
        final String[] Davis = new String[] {
               "Hora de Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cuba = new String[] {
               "Hora padr\u00e3o de Cuba",
               "",
               "Hora de ver\u00e3o de Cuba",
               "",
               "Hora de Cuba",
               "",
            };
        final String[] Africa_Western = new String[] {
               "Hora padr\u00e3o da \u00c1frica Ocidental",
               "",
               "Hora de ver\u00e3o da \u00c1frica Ocidental",
               "",
               "Hora da \u00c1frica Ocidental",
               "",
            };
        final String[] GMT = new String[] {
               "Hora de Greenwich",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Philippines = new String[] {
               "Hora padr\u00e3o das Filipinas",
               "",
               "Hora de ver\u00e3o das Filipinas",
               "",
               "Hora das Filipinas",
               "",
            };
        final String[] French_Southern = new String[] {
               "Hora das Terras Austrais e Ant\u00e1rcticas Francesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Hora da Ge\u00f3rgia do Sul",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Hora padr\u00e3o da Nova Caled\u00f3nia",
               "",
               "Hora de ver\u00e3o da Nova Caled\u00f3nia",
               "",
               "Hora da Nova Caled\u00f3nia",
               "",
            };
        final String[] Brunei = new String[] {
               "Hora do Brunei Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "Hora padr\u00e3o do Ir\u00e3o",
               "",
               "Hora de ver\u00e3o do Ir\u00e3o",
               "",
               "Hora do Ir\u00e3o",
               "",
            };
        final String[] Easter = new String[] {
               "Hora padr\u00e3o da Ilha da P\u00e1scoa",
               "",
               "Hora de ver\u00e3o da Ilha da P\u00e1scoa",
               "",
               "Hora da Ilha da P\u00e1scoa",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Hora padr\u00e3o do Noroeste do M\u00e9xico",
               "",
               "Hora de ver\u00e3o do Noroeste do M\u00e9xico",
               "",
               "Hora do Noroeste do M\u00e9xico",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "Hora de Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Hora do Tajiquist\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Hora padr\u00e3o de Tonga",
               "",
               "Hora de ver\u00e3o de Tonga",
               "",
               "Hora de Tonga",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Hora padr\u00e3o do Bangladesh",
               "",
               "Hora de ver\u00e3o do Bangladesh",
               "",
               "Hora do Bangladesh",
               "",
            };
        final String[] Peru = new String[] {
               "Hora padr\u00e3o do Peru",
               "",
               "Hora de ver\u00e3o do Peru",
               "",
               "Hora do Peru",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Hora padr\u00e3o da Gronel\u00e2ndia Ocidental",
               "",
               "Hora de ver\u00e3o da Gronel\u00e2ndia Ocidental",
               "",
               "Hora da Gronel\u00e2ndia Ocidental",
               "",
            };
        final String[] Ecuador = new String[] {
               "Hora do Equador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "Hora padr\u00e3o da Gronel\u00e2ndia Oriental",
               "",
               "Hora de ver\u00e3o da Gronel\u00e2ndia Oriental",
               "",
               "Hora da Gronel\u00e2ndia Oriental",
               "",
            };
        final String[] Gulf = new String[] {
               "Hora padr\u00e3o do Golfo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Hora da Indon\u00e9sia Oriental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Korea = new String[] {
               "Hora padr\u00e3o da Coreia",
               "",
               "Hora de ver\u00e3o da Coreia",
               "",
               "Hora da Coreia",
               "",
            };
        final String[] Australia_Western = new String[] {
               "Hora padr\u00e3o da Austr\u00e1lia Ocidental",
               "",
               "Hora de ver\u00e3o da Austr\u00e1lia Ocidental",
               "",
               "Hora da Austr\u00e1lia Ocidental",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Hora do Quirguist\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "Hora da Indon\u00e9sia Ocidental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "Hora padr\u00e3o da Austr\u00e1lia Oriental",
               "",
               "Hora de ver\u00e3o da Austr\u00e1lia Oriental",
               "",
               "Hora da Austr\u00e1lia Oriental",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Hora da Guiana Francesa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "Hora padr\u00e3o da Col\u00f4mbia",
               "",
               "Hora de ver\u00e3o da Col\u00f4mbia",
               "",
               "Hora da Col\u00f4mbia",
               "",
            };
        final String[] Chile = new String[] {
               "Hora padr\u00e3o do Chile",
               "",
               "Hora de ver\u00e3o do Chile",
               "",
               "Hora do Chile",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Hora das Ilhas Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Hora padr\u00e3o da Montanha",
               "",
               "Hora de ver\u00e3o da Montanha",
               "",
               "Hora de Montanha",
               "",
            };
        final String[] Marquesas = new String[] {
               "Hora das Ilhas Marquesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Hora padr\u00e3o da Ar\u00e1bia",
               "",
               "Hora de ver\u00e3o da Ar\u00e1bia",
               "",
               "Hora da Ar\u00e1bia",
               "",
            };
        final String[] Alaska = new String[] {
               "Hora padr\u00e3o do Alasca",
               "",
               "Hora de ver\u00e3o do Alasca",
               "",
               "Hora do Alasca",
               "",
            };
        final String[] Vladivostok = new String[] {
               "Hora padr\u00e3o de Vladivostok",
               "",
               "Hora de ver\u00e3o de Vladivostok",
               "",
               "Hora de Vladivostok",
               "",
            };
        final String[] Chamorro = new String[] {
               "Hora padr\u00e3o de Chamorro",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Hora padr\u00e3o de Irkutsk",
               "",
               "Hora de ver\u00e3o de Irkutsk",
               "",
               "Hora de Irkutsk",
               "",
            };
        final String[] Georgia = new String[] {
               "Hora padr\u00e3o da Ge\u00f3rgia",
               "",
               "Hora de ver\u00e3o da Ge\u00f3rgia",
               "",
               "Hora da Ge\u00f3rgia",
               "",
            };
        final String[] Tokelau = new String[] {
               "Hora de Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Hora de Papua Nova Guin\u00e9",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "Hora padr\u00e3o de Fernando de Noronha",
               "",
               "Hora de ver\u00e3o de Fernando de Noronha",
               "",
               "Hora de Fernando de Noronha",
               "",
            };
        final String[] Choibalsan = new String[] {
               "Hora padr\u00e3o de Choibalsan",
               "",
               "Hora de ver\u00e3o de Choibalsan",
               "",
               "Hora de Choibalsan",
               "",
            };
        final String[] Brasilia = new String[] {
               "Hora padr\u00e3o de Bras\u00edlia",
               "\u2205\u2205\u2205",
               "Hora de ver\u00e3o de Bras\u00edlia",
               "\u2205\u2205\u2205",
               "Hora de Bras\u00edlia",
               "\u2205\u2205\u2205",
            };
        final String[] China = new String[] {
               "Hora padr\u00e3o da China",
               "",
               "Hora de ver\u00e3o da China",
               "",
               "Hora da China",
               "",
            };
        final String[] Armenia = new String[] {
               "Hora padr\u00e3o da Arm\u00e9nia",
               "",
               "Hora de ver\u00e3o da Arm\u00e9nia",
               "",
               "Hora da Arm\u00e9nia",
               "",
            };
        final String[] Anadyr = new String[] {
               "Hora padr\u00e3o de Anadyr",
               "",
               "Hora de ver\u00e3o de Anadyr",
               "",
               "Hora de Anadyr",
               "",
            };
        final String[] Samara = new String[] {
               "Hora padr\u00e3o de Samara",
               "",
               "Hora de ver\u00e3o de Samara",
               "",
               "Hora de Samara",
               "",
            };
        final String[] Pyongyang = new String[] {
               "Hora de Pyongyang",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Hora padr\u00e3o da \u00cdndia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cook = new String[] {
               "Hora padr\u00e3o das Ilhas Cook",
               "",
               "Hora de ver\u00e3o das Ilhas Cook",
               "",
               "Hora das Ilhas Cook",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "timezone.excity.Europe/San_Marino", "S\u00e3o Marinho" },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Hora de Greenwich",
                    "",
                    "Hora de ver\u00e3o Brit\u00e2nica",
                    "",
                    "",
                    "",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "JST", Japan },
            { "Europe/Warsaw", Europe_Central },
            { "Pacific/Yap", Truk },
            { "timezone.excity.Africa/Djibouti", "Jibuti" },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "America/Eirunepe", Acre },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "timezone.excity.Africa/Porto-Novo", "Porto-Novo" },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "timezone.excity.Africa/Dakar", "Dacar" },
            { "Atlantic/St_Helena", GMT },
            { "timezone.excity.Africa/Addis_Ababa", "Adis-Abeba" },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "timezone.excity.Pacific/Apia", "Apia" },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "BET", Brasilia },
            { "America/Araguaina", Brasilia },
            { "timezone.excity.Pacific/Easter", "Ilha da P\u00e1scoa" },
            { "ACT", Australia_Central },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "timezone.excity.Australia/Lord_Howe", "Ilha de Lord Howe" },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "timezone.excity.Pacific/Pitcairn", "Ilhas Pitcairn" },
            { "Australia/Perth", Australia_Western },
            { "Etc/GMT", GMT },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "timezone.excity.Asia/Yerevan", "Erevan" },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "AET", Australia_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "timezone.excity.Asia/Bangkok", "Banguecoque" },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "timezone.excity.Asia/Baghdad", "Bagdade" },
            { "timezone.excity.America/Montevideo", "Montevideu" },
            { "Africa/Sao_Tome", Africa_Western },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "SystemV/AST4", Atlantic },
            { "timezone.excity.Europe/Madrid", "Madrid" },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "CNT", Newfoundland },
            { "America/Indiana/Vevay", America_Eastern },
            { "timezone.excity.Europe/Monaco", "M\u00f3naco" },
            { "timezone.excity.Asia/Hebron", "Hebron" },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "timezone.excity.Africa/Bamako", "Bamaco" },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "timezone.excity.Africa/Tripoli", "Tripoli" },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "NET", Armenia },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "timezone.excity.America/Montserrat", "Monserrate" },
            { "America/Moncton", Atlantic },
            { "timezone.excity.Europe/Copenhagen", "Copenhaga" },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Pyongyang },
            { "timezone.excity.America/New_York", "Nova Iorque" },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "America/Ciudad_Juarez", America_Mountain },
            { "Europe/Copenhagen", Europe_Central },
            { "timezone.excity.Africa/Lusaka", "Lusaca" },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "SystemV/MST7", America_Mountain },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "timezone.excity.America/Bahia", "Ba\u00eda" },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "timezone.excity.Asia/Tehran", "Teer\u00e3o" },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "timezone.excity.America/Argentina/Tucuman", "Tucum\u00e1n" },
            { "America/Indiana/Knox", America_Central },
            { "timezone.excity.Asia/Saigon", "Cidade de Ho Chi Minh" },
            { "PLT", Pakistan },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "timezone.excity.Africa/Niamey", "Niamei" },
            { "timezone.excity.Asia/Makassar", "Macassar" },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "CST", America_Central },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Hora de Greenwich",
                    "",
                    "Hora de ver\u00e3o da Irlanda",
                    "",
                    "",
                    "",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "SST", Solomon },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "SystemV/CST6", America_Central },
            { "timezone.excity.Asia/Calcutta", "Calcut\u00e1" },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "timezone.excity.Pacific/Efate", "Efate" },
            { "CTT", China },
            { "timezone.excity.Asia/Aqtobe", "Aqtobe" },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "PNT", America_Mountain },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "timezone.excity.Asia/Bahrain", "Bar\u00e9m" },
            { "timezone.excity.Indian/Mahe", "Mahe" },
            { "timezone.excity.America/Port-au-Prince", "Port-au-Prince" },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "BST", Bangladesh },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "SystemV/YST9", Gambier },
            { "timezone.excity.America/Curacao", "Cura\u00e7au" },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", America_Central },
            { "America/Ojinaga", America_Central },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "MIT", Apia },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "ART", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.America/Dominica", "Dom\u00ednica" },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "Asia/Manila", Philippines },
            { "timezone.excity.Africa/Kampala", "Campala" },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "timezone.excity.America/Port_of_Spain", "Porto de Espanha" },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "AST", Alaska },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "timezone.excity.Europe/Helsinki", "Hels\u00ednquia" },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "timezone.excity.America/Araguaina", "Araguaina" },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "PRT", Atlantic },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "timezone.excity.Asia/Qatar", "Catar" },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "timezone.excity.Asia/Kuwait", "Koweit" },
            { "PST", America_Pacific },
            { "SystemV/EST5", America_Eastern },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "timezone.excity.Europe/Moscow", "Moscovo" },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "timezone.excity.Asia/Taipei", "Taip\u00e9" },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "SystemV/PST8", Pitcairn },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "Hora de Greenwich",
                    "",
                    "Hora de ver\u00e3o Brit\u00e2nica",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Indian/Mauritius", "Maur\u00edcia" },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "timezone.excity.Asia/Dhaka", "Daca" },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "timezone.excity.America/St_Johns", "St. John\u2019s" },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "timezone.excity.America/St_Thomas", "St. Thomas" },
            { "timezone.excity.Europe/Busingen", "Busingen" },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Acre },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "timezone.excity.Africa/Ndjamena", "Ndjamena" },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "timezone.excity.Africa/Tunis", "Tunes" },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "NST", New_Zealand },
            { "timezone.excity.Africa/Nairobi", "Nairobi" },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Johannesburg", Africa_Southern },
            { "EAT", Africa_Eastern },
            { "Africa/Bangui", Africa_Western },
            { "timezone.excity.Asia/Singapore", "Singapura" },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "timezone.excity.America/Cayman", "Caim\u00e3o" },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "timezone.excity.Atlantic/Faeroe", "Faro\u00e9" },
            { "Africa/Timbuktu", GMT },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "ECT", Europe_Central },
            { "America/Montreal", America_Eastern },
            { "timezone.excity.America/Anguilla", "Anguila" },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "timezone.excity.Antarctica/Syowa", "Syowa" },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "timezone.excity.Indian/Christmas", "Ilha do Natal" },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "SystemV/YST9YDT", Alaska },
            { "America/Merida", America_Central },
            { "CAT", Africa_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lumpur" },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "SystemV/PST8PDT", America_Pacific },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "timezone.excity.America/Cancun", "Cancun" },
            { "timezone.excity.Europe/Kaliningrad", "Caliningrado" },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Anadyr },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "timezone.excity.Asia/Kabul", "Cabul" },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "timezone.excity.Pacific/Tarawa", "Tarawa" },
            { "timezone.excity.Europe/Amsterdam", "Amesterd\u00e3o" },
            { "Europe/Vatican", Europe_Central },
            { "timezone.excity.Indian/Cocos", "Ilhas Cocos" },
            { "Asia/Amman", Europe_Eastern },
            { "Etc/UTC", ETC_UTC },
            { "SystemV/AST4ADT", Atlantic },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "SystemV/EST5EDT", America_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
