/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.rest;

import java.time.Clock;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.ResourceConfig;
import org.jetbrains.annotations.NotNull;
import org.jitsi.jicofo.auth.ShibbolethAuthAuthority;
import org.jitsi.jicofo.auth.rest.ShibbolethLogin;
import org.jitsi.jicofo.health.JicofoHealthChecker;
import org.jitsi.jicofo.metrics.JicofoMetricsContainer;
import org.jitsi.jicofo.rest.ConferenceRequest;
import org.jitsi.jicofo.rest.RestConfig;
import org.jitsi.rest.Health;
import org.jitsi.rest.Version;
import org.jitsi.rest.prometheus.Prometheus;

public class Application
extends ResourceConfig {
    protected final Clock clock = Clock.systemUTC();

    public Application(ShibbolethAuthAuthority shibbolethAuthAuthority, @NotNull org.jitsi.utils.version.Version version, JicofoHealthChecker healthChecker2, ConferenceRequest conferenceRequest) {
        this.register(new AbstractBinder(){

            @Override
            protected void configure() {
                this.bind(Application.this.clock).to(Clock.class);
            }
        });
        this.packages("org.jitsi.jicofo.rest");
        if (healthChecker2 != null) {
            this.register(new Health(healthChecker2));
        }
        this.register(new Version(version));
        if (shibbolethAuthAuthority != null) {
            this.register(new ShibbolethLogin(shibbolethAuthAuthority));
        }
        if (RestConfig.config.getEnablePrometheus()) {
            this.register(new Prometheus(JicofoMetricsContainer.getInstance()));
        }
        if (conferenceRequest != null) {
            this.register(conferenceRequest);
        }
    }
}

