/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri.json;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.colibri.SourcePacketExtension;
import org.jitsi.xmpp.extensions.colibri.WebSocketPacketExtension;
import org.jitsi.xmpp.extensions.jingle.CandidatePacketExtension;
import org.jitsi.xmpp.extensions.jingle.ContentPacketExtension;
import org.jitsi.xmpp.extensions.jingle.DtlsFingerprintPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.ParameterPacketExtension;
import org.jitsi.xmpp.extensions.jingle.PayloadTypePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RTPHdrExtPacketExtension;
import org.jitsi.xmpp.extensions.jingle.RemoteCandidatePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RtcpFbPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SourceGroupPacketExtension;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public final class JSONSerializer {
    static final String CANDIDATE_LIST = "candidates";
    static final String FINGERPRINTS = "fingerprints";
    static final String PARAMETERS = "parameters";
    static final String RTCP_FBS = "rtcp-fbs";
    static final String SOURCES = "sources";
    static final String WEBSOCKET_LIST = "web-sockets";
    static final String XMLNS = "xmlns";

    public static void serializeAbstractPacketExtensionAttributes(AbstractPacketExtension abstractPacketExtension, JSONObject jsonObject) {
        for (String name : abstractPacketExtension.getAttributeNames()) {
            Object value2 = abstractPacketExtension.getAttribute(name);
            if (value2 instanceof Enum) {
                value2 = value2.toString();
            }
            jsonObject.put(name, value2);
        }
    }

    public static JSONObject serializeCandidate(CandidatePacketExtension candidate) {
        JSONObject candidateJSONObject;
        if (candidate == null) {
            candidateJSONObject = null;
        } else {
            candidateJSONObject = new JSONObject();
            JSONSerializer.serializeAbstractPacketExtensionAttributes(candidate, candidateJSONObject);
        }
        return candidateJSONObject;
    }

    public static JSONArray serializeCandidates(Collection<CandidatePacketExtension> candidates) {
        JSONArray candidatesJSONArray;
        if (candidates == null) {
            candidatesJSONArray = null;
        } else {
            candidatesJSONArray = new JSONArray();
            for (CandidatePacketExtension candidate : candidates) {
                candidatesJSONArray.add(JSONSerializer.serializeCandidate(candidate));
            }
        }
        return candidatesJSONArray;
    }

    public static JSONObject serializeFingerprint(DtlsFingerprintPacketExtension fingerprint) {
        JSONObject fingerprintJSONObject;
        if (fingerprint == null) {
            fingerprintJSONObject = null;
        } else {
            String theFingerprint = fingerprint.getFingerprint();
            fingerprintJSONObject = new JSONObject();
            if (theFingerprint != null) {
                fingerprintJSONObject.put(fingerprint.getElementName(), theFingerprint);
            }
            JSONSerializer.serializeAbstractPacketExtensionAttributes(fingerprint, fingerprintJSONObject);
        }
        return fingerprintJSONObject;
    }

    public static JSONArray serializeFingerprints(Collection<DtlsFingerprintPacketExtension> fingerprints) {
        JSONArray fingerprintsJSONArray;
        if (fingerprints == null) {
            fingerprintsJSONArray = null;
        } else {
            fingerprintsJSONArray = new JSONArray();
            for (DtlsFingerprintPacketExtension fingerprint : fingerprints) {
                fingerprintsJSONArray.add(JSONSerializer.serializeFingerprint(fingerprint));
            }
        }
        return fingerprintsJSONArray;
    }

    public static JSONObject serializeParameters(Collection<ParameterPacketExtension> parameters2) {
        JSONObject parametersJSONObject;
        if (parameters2 == null) {
            parametersJSONObject = null;
        } else {
            parametersJSONObject = new JSONObject();
            for (ParameterPacketExtension parameter : parameters2) {
                String name = parameter.getName();
                String value2 = parameter.getValue();
                if (name == null && value2 == null) continue;
                parametersJSONObject.put(name, value2);
            }
        }
        return parametersJSONObject;
    }

    public static JSONArray serializeRtcpFbs(@NotNull Collection<RtcpFbPacketExtension> rtcpFbs) {
        JSONArray rtcpFbsJSON = new JSONArray();
        for (RtcpFbPacketExtension ext : rtcpFbs) {
            String type2 = ext.getFeedbackType();
            String subtype = ext.getFeedbackSubtype();
            if (type2 == null) continue;
            JSONObject rtcpFbJSON = new JSONObject();
            rtcpFbJSON.put("type", type2);
            if (subtype != null) {
                rtcpFbJSON.put("subtype", subtype);
            }
            rtcpFbsJSON.add(rtcpFbJSON);
        }
        return rtcpFbsJSON;
    }

    public static JSONObject serializePayloadType(PayloadTypePacketExtension payloadType) {
        JSONObject payloadTypeJSONObject;
        if (payloadType == null) {
            payloadTypeJSONObject = null;
        } else {
            List<RtcpFbPacketExtension> rtcpFeedbackTypeList;
            List<ParameterPacketExtension> parameters2 = payloadType.getParameters();
            payloadTypeJSONObject = new JSONObject();
            JSONSerializer.serializeAbstractPacketExtensionAttributes(payloadType, payloadTypeJSONObject);
            if (parameters2 != null && !parameters2.isEmpty()) {
                payloadTypeJSONObject.put(PARAMETERS, JSONSerializer.serializeParameters(parameters2));
            }
            if ((rtcpFeedbackTypeList = payloadType.getRtcpFeedbackTypeList()) != null && !rtcpFeedbackTypeList.isEmpty()) {
                payloadTypeJSONObject.put(RTCP_FBS, JSONSerializer.serializeRtcpFbs(rtcpFeedbackTypeList));
            }
        }
        return payloadTypeJSONObject;
    }

    public static JSONArray serializePayloadTypes(Collection<PayloadTypePacketExtension> payloadTypes) {
        JSONArray payloadTypesJSONArray;
        if (payloadTypes == null) {
            payloadTypesJSONArray = null;
        } else {
            payloadTypesJSONArray = new JSONArray();
            for (PayloadTypePacketExtension payloadType : payloadTypes) {
                payloadTypesJSONArray.add(JSONSerializer.serializePayloadType(payloadType));
            }
        }
        return payloadTypesJSONArray;
    }

    public static JSONObject serializeRtpHdrExt(RTPHdrExtPacketExtension rtpHdrExt) {
        JSONObject rtpHdrExtJSONObject;
        if (rtpHdrExt == null) {
            rtpHdrExtJSONObject = null;
        } else {
            String attributes;
            ContentPacketExtension.SendersEnum senders;
            URI uri;
            rtpHdrExtJSONObject = new JSONObject();
            String id = rtpHdrExt.getID();
            if (id != null) {
                rtpHdrExtJSONObject.put("id", Long.valueOf(id));
            }
            if ((uri = rtpHdrExt.getURI()) != null) {
                rtpHdrExtJSONObject.put("uri", uri.toString());
            }
            if ((senders = rtpHdrExt.getSenders()) != null) {
                rtpHdrExtJSONObject.put("senders", senders.toString());
            }
            if ((attributes = rtpHdrExt.getAttributes()) != null) {
                rtpHdrExtJSONObject.put("attributes", attributes);
            }
        }
        return rtpHdrExtJSONObject;
    }

    public static JSONArray serializeRtpHdrExts(Collection<RTPHdrExtPacketExtension> rtpHdrExts) {
        JSONArray rtpHdrExtsJSONArray;
        if (rtpHdrExts == null) {
            rtpHdrExtsJSONArray = null;
        } else {
            rtpHdrExtsJSONArray = new JSONArray();
            for (RTPHdrExtPacketExtension rtpHdrExt : rtpHdrExts) {
                rtpHdrExtsJSONArray.add(JSONSerializer.serializeRtpHdrExt(rtpHdrExt));
            }
        }
        return rtpHdrExtsJSONArray;
    }

    public static Object serializeSource(SourcePacketExtension source) {
        if (source == null) {
            return null;
        }
        String name = source.getName();
        String videoType = source.getVideoType();
        String rid = source.getRid();
        List<ParameterPacketExtension> parameters2 = source.getParameters();
        if (name == null && rid == null && parameters2.isEmpty()) {
            return source.getSSRC();
        }
        JSONObject sourceJSONObject = new JSONObject();
        sourceJSONObject.put("ssrc", source.getSSRC());
        if (name != null) {
            sourceJSONObject.put("name", name);
        }
        if (videoType != null) {
            sourceJSONObject.put("videoType", videoType);
        }
        if (rid != null) {
            sourceJSONObject.put("rid", rid);
        }
        if (!parameters2.isEmpty()) {
            sourceJSONObject.put(PARAMETERS, JSONSerializer.serializeParameters(parameters2));
        }
        return sourceJSONObject;
    }

    private static Object serializeSourceGroup(SourceGroupPacketExtension sourceGroup) {
        if (sourceGroup.getSemantics() != null && sourceGroup.getSemantics().length() != 0 && sourceGroup.getSources() != null && sourceGroup.getSources().size() != 0) {
            JSONObject sourceGroupJSONObject = new JSONObject();
            sourceGroupJSONObject.put("semantics", JSONValue.escape(sourceGroup.getSemantics()));
            JSONArray ssrcsJSONArray = new JSONArray();
            for (SourcePacketExtension source : sourceGroup.getSources()) {
                ssrcsJSONArray.add(source.getSSRC());
            }
            sourceGroupJSONObject.put(SOURCES, ssrcsJSONArray);
            return sourceGroupJSONObject;
        }
        return null;
    }

    public static JSONArray serializeSourceGroups(Collection<SourceGroupPacketExtension> sourceGroups) {
        JSONArray sourceGroupsJSONArray;
        if (sourceGroups == null || sourceGroups.size() == 0) {
            sourceGroupsJSONArray = null;
        } else {
            sourceGroupsJSONArray = new JSONArray();
            for (SourceGroupPacketExtension sourceGroup : sourceGroups) {
                sourceGroupsJSONArray.add(JSONSerializer.serializeSourceGroup(sourceGroup));
            }
        }
        return sourceGroupsJSONArray;
    }

    public static JSONArray serializeSources(Collection<SourcePacketExtension> sources) {
        JSONArray sourcesJSONArray;
        if (sources == null) {
            sourcesJSONArray = null;
        } else {
            sourcesJSONArray = new JSONArray();
            for (SourcePacketExtension source : sources) {
                sourcesJSONArray.add(JSONSerializer.serializeSource(source));
            }
        }
        return sourcesJSONArray;
    }

    public static JSONObject serializeTransport(IceUdpTransportPacketExtension transport) {
        JSONObject jsonObject;
        if (transport == null) {
            jsonObject = null;
        } else {
            String xmlns = transport.getNamespace();
            List<DtlsFingerprintPacketExtension> fingerprints = transport.getChildExtensionsOfType(DtlsFingerprintPacketExtension.class);
            List<CandidatePacketExtension> candidateList = transport.getCandidateList();
            List<WebSocketPacketExtension> webSocketList = transport.getChildExtensionsOfType(WebSocketPacketExtension.class);
            RemoteCandidatePacketExtension remoteCandidate = transport.getRemoteCandidate();
            boolean rtcpMux = transport.isRtcpMux();
            jsonObject = new JSONObject();
            if (xmlns != null) {
                jsonObject.put(XMLNS, xmlns);
            }
            JSONSerializer.serializeAbstractPacketExtensionAttributes(transport, jsonObject);
            if (fingerprints != null && !fingerprints.isEmpty()) {
                jsonObject.put(FINGERPRINTS, JSONSerializer.serializeFingerprints(fingerprints));
            }
            if (candidateList != null && !candidateList.isEmpty()) {
                jsonObject.put(CANDIDATE_LIST, JSONSerializer.serializeCandidates(candidateList));
            }
            if (remoteCandidate != null) {
                jsonObject.put(remoteCandidate.getElementName(), JSONSerializer.serializeCandidate(remoteCandidate));
            }
            if (webSocketList != null && !webSocketList.isEmpty()) {
                jsonObject.put(WEBSOCKET_LIST, JSONSerializer.serializeWebSockets(webSocketList));
            }
            if (rtcpMux) {
                jsonObject.put("rtcp-mux", Boolean.TRUE);
            }
        }
        return jsonObject;
    }

    private static String serializeWebSocket(WebSocketPacketExtension webSocket) {
        if (webSocket.getActive()) {
            return "active";
        }
        return webSocket.getUrl();
    }

    private static JSONArray serializeWebSockets(List<WebSocketPacketExtension> webSocketList) {
        JSONArray webSocketsJSONArray;
        if (webSocketList == null) {
            webSocketsJSONArray = null;
        } else {
            webSocketsJSONArray = new JSONArray();
            for (WebSocketPacketExtension webSocket : webSocketList) {
                webSocketsJSONArray.add(JSONSerializer.serializeWebSocket(webSocket));
            }
        }
        return webSocketsJSONArray;
    }

    private JSONSerializer() {
    }
}

