/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.config.JitsiConfig;
import org.jitsi.metaconfig.ConfigDelegate;
import org.jitsi.metaconfig.ConfigSource;
import org.jitsi.metaconfig.DeprecationKt;
import org.jitsi.metaconfig.supplier.ConfigSourceSupplier;
import org.jitsi.nlj.AudioLevelListener;
import org.jitsi.nlj.Event;
import org.jitsi.nlj.Features;
import org.jitsi.nlj.PacketHandler;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.RtpReceiver;
import org.jitsi.nlj.RtpReceiverEventHandler;
import org.jitsi.nlj.RtpReceiverImpl;
import org.jitsi.nlj.rtcp.CompoundRtcpParser;
import org.jitsi.nlj.rtcp.RembHandler;
import org.jitsi.nlj.rtcp.RtcpEventNotifier;
import org.jitsi.nlj.rtcp.RtcpRrGenerator;
import org.jitsi.nlj.rtp.AudioRtpPacket;
import org.jitsi.nlj.rtp.LossListener;
import org.jitsi.nlj.rtp.VideoRtpPacket;
import org.jitsi.nlj.rtp.bandwidthestimation.BandwidthEstimator;
import org.jitsi.nlj.srtp.SrtpTransformers;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.stats.RtpReceiverStats;
import org.jitsi.nlj.transform.NodeEventVisitor;
import org.jitsi.nlj.transform.NodeStatsVisitor;
import org.jitsi.nlj.transform.NodeTeardownVisitor;
import org.jitsi.nlj.transform.PipelineBuilder;
import org.jitsi.nlj.transform.PipelineDslKt;
import org.jitsi.nlj.transform.node.ConditionalPacketPath;
import org.jitsi.nlj.transform.node.ConsumerNode;
import org.jitsi.nlj.transform.node.DemuxerNode;
import org.jitsi.nlj.transform.node.Node;
import org.jitsi.nlj.transform.node.PacketLossConfig;
import org.jitsi.nlj.transform.node.PacketLossNode;
import org.jitsi.nlj.transform.node.PacketStreamStatsNode;
import org.jitsi.nlj.transform.node.RtpParser;
import org.jitsi.nlj.transform.node.SrtcpDecryptNode;
import org.jitsi.nlj.transform.node.SrtpDecryptNode;
import org.jitsi.nlj.transform.node.ToggleablePcapWriter;
import org.jitsi.nlj.transform.node.incoming.AudioLevelReader;
import org.jitsi.nlj.transform.node.incoming.BitrateCalculator;
import org.jitsi.nlj.transform.node.incoming.DiscardableDiscarder;
import org.jitsi.nlj.transform.node.incoming.DuplicateTermination;
import org.jitsi.nlj.transform.node.incoming.IncomingStatisticsTracker;
import org.jitsi.nlj.transform.node.incoming.PaddingTermination;
import org.jitsi.nlj.transform.node.incoming.RemoteBandwidthEstimator;
import org.jitsi.nlj.transform.node.incoming.RetransmissionRequesterNode;
import org.jitsi.nlj.transform.node.incoming.RtcpTermination;
import org.jitsi.nlj.transform.node.incoming.RtxHandler;
import org.jitsi.nlj.transform.node.incoming.TccGeneratorNode;
import org.jitsi.nlj.transform.node.incoming.VideoBitrateCalculator;
import org.jitsi.nlj.transform.node.incoming.VideoMuteNode;
import org.jitsi.nlj.transform.node.incoming.VideoParser;
import org.jitsi.nlj.transform.node.incoming.VideoQualityLayerLookup;
import org.jitsi.nlj.util.BufferPool;
import org.jitsi.nlj.util.PacketInfoQueue;
import org.jitsi.nlj.util.ReadOnlyStreamInformationStore;
import org.jitsi.rtp.Packet;
import org.jitsi.rtp.extensions.PacketExtensionsKt;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.RtcpFbRembPacket;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.utils.queue.CountingErrorHandler;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0097\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001)\u0018\u0000 o2\u00020\u0001:\u0001oB_\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010L\u001a\u00020\u00072\u0006\u0010M\u001a\u00020NH\u0016J\u0010\u0010O\u001a\u00020\u00072\u0006\u0010P\u001a\u00020QH\u0014J\u0010\u0010R\u001a\u00020\u00072\u0006\u0010S\u001a\u00020QH\u0016J\u0010\u0010T\u001a\u00020\u00072\u0006\u0010U\u001a\u00020:H\u0016J\u0010\u0010V\u001a\u00020\u00072\u0006\u0010U\u001a\u00020:H\u0016J\b\u0010W\u001a\u00020XH\u0016J\b\u0010Y\u001a\u00020ZH\u0016J\u0010\u0010[\u001a\u00020\u00072\u0006\u0010\\\u001a\u00020]H\u0016J\u0010\u0010^\u001a\u00020:2\u0006\u0010_\u001a\u00020QH\u0002J\u0010\u0010`\u001a\u00020:2\u0006\u0010a\u001a\u00020bH\u0016J\b\u0010c\u001a\u00020:H\u0016J\b\u0010d\u001a\u00020:H\u0016J\u0010\u0010e\u001a\u00020\u00072\u0006\u0010f\u001a\u00020gH\u0016J\u0018\u0010h\u001a\u00020\u00072\u0006\u0010a\u001a\u00020b2\u0006\u0010i\u001a\u00020:H\u0016J\u0010\u0010j\u001a\u00020\u00072\u0006\u0010k\u001a\u00020lH\u0016J\b\u0010m\u001a\u00020\u0007H\u0016J\b\u0010n\u001a\u00020\u0007H\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0010\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010*R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020:X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020=X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020?X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020AX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020CX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020EX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020GX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020IX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020KX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006p"}, d2={"Lorg/jitsi/nlj/RtpReceiverImpl;", "Lorg/jitsi/nlj/RtpReceiver;", "id", "", "rtcpSender", "Lkotlin/Function1;", "Lorg/jitsi/rtp/rtcp/RtcpPacket;", "", "rtcpEventNotifier", "Lorg/jitsi/nlj/rtcp/RtcpEventNotifier;", "executor", "Ljava/util/concurrent/ExecutorService;", "backgroundExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "streamInformationStore", "Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "eventHandler", "Lorg/jitsi/nlj/RtpReceiverEventHandler;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lorg/jitsi/nlj/rtcp/RtcpEventNotifier;Ljava/util/concurrent/ExecutorService;Ljava/util/concurrent/ScheduledExecutorService;Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;Lorg/jitsi/nlj/RtpReceiverEventHandler;Lorg/jitsi/utils/logging2/Logger;Lorg/jitsi/utils/logging/DiagnosticContext;)V", "audioBitrateCalculator", "Lorg/jitsi/nlj/transform/node/incoming/BitrateCalculator;", "audioLevelReader", "Lorg/jitsi/nlj/transform/node/incoming/AudioLevelReader;", "getId", "()Ljava/lang/String;", "incomingPacketQueue", "Lorg/jitsi/nlj/util/PacketInfoQueue;", "inputTreeRoot", "Lorg/jitsi/nlj/transform/node/Node;", "logger", "packetHandler", "Lorg/jitsi/nlj/PacketHandler;", "getPacketHandler", "()Lorg/jitsi/nlj/PacketHandler;", "setPacketHandler", "(Lorg/jitsi/nlj/PacketHandler;)V", "packetHandlerWrapper", "org/jitsi/nlj/RtpReceiverImpl$packetHandlerWrapper$1", "Lorg/jitsi/nlj/RtpReceiverImpl$packetHandlerWrapper$1;", "packetStreamStats", "Lorg/jitsi/nlj/transform/node/PacketStreamStatsNode;", "paddingOnlyDiscarder", "Lorg/jitsi/nlj/transform/node/incoming/DiscardableDiscarder;", "rembHandler", "Lorg/jitsi/nlj/rtcp/RembHandler;", "remoteBandwidthEstimator", "Lorg/jitsi/nlj/transform/node/incoming/RemoteBandwidthEstimator;", "retransmissionRequester", "Lorg/jitsi/nlj/transform/node/incoming/RetransmissionRequesterNode;", "rtcpRrGenerator", "Lorg/jitsi/nlj/rtcp/RtcpRrGenerator;", "rtcpTermination", "Lorg/jitsi/nlj/transform/node/incoming/RtcpTermination;", "running", "", "silenceDiscarder", "srtcpDecryptWrapper", "Lorg/jitsi/nlj/transform/node/SrtcpDecryptNode;", "srtpDecryptWrapper", "Lorg/jitsi/nlj/transform/node/SrtpDecryptNode;", "statsTracker", "Lorg/jitsi/nlj/transform/node/incoming/IncomingStatisticsTracker;", "tccGenerator", "Lorg/jitsi/nlj/transform/node/incoming/TccGeneratorNode;", "toggleablePcapWriter", "Lorg/jitsi/nlj/transform/node/ToggleablePcapWriter;", "videoBitrateCalculator", "Lorg/jitsi/nlj/transform/node/incoming/VideoBitrateCalculator;", "videoMuteNode", "Lorg/jitsi/nlj/transform/node/incoming/VideoMuteNode;", "videoParser", "Lorg/jitsi/nlj/transform/node/incoming/VideoParser;", "addLossListener", "lossListener", "Lorg/jitsi/nlj/rtp/LossListener;", "doProcessPacket", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "enqueuePacket", "p", "forceMuteAudio", "shouldMute", "forceMuteVideo", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "getStats", "Lorg/jitsi/nlj/stats/RtpReceiverStats;", "handleEvent", "event", "Lorg/jitsi/nlj/Event;", "handleIncomingPacket", "packet", "isFeatureEnabled", "feature", "Lorg/jitsi/nlj/Features;", "isReceivingAudio", "isReceivingVideo", "onRttUpdate", "newRttMs", "", "setFeature", "enabled", "setSrtpTransformers", "srtpTransformers", "Lorg/jitsi/nlj/srtp/SrtpTransformers;", "stop", "tearDown", "Companion", "jitsi-media-transform"})
public final class RtpReceiverImpl
extends RtpReceiver {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String id;
    @NotNull
    private final Function1<RtcpPacket, Unit> rtcpSender;
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final ScheduledExecutorService backgroundExecutor;
    @NotNull
    private final RtpReceiverEventHandler eventHandler;
    @NotNull
    private final Logger logger;
    private boolean running;
    @NotNull
    private final Node inputTreeRoot;
    @NotNull
    private final PacketInfoQueue incomingPacketQueue;
    @NotNull
    private final SrtpDecryptNode srtpDecryptWrapper;
    @NotNull
    private final SrtcpDecryptNode srtcpDecryptWrapper;
    @NotNull
    private final TccGeneratorNode tccGenerator;
    @NotNull
    private final RemoteBandwidthEstimator remoteBandwidthEstimator;
    @NotNull
    private final AudioLevelReader audioLevelReader;
    @NotNull
    private final VideoMuteNode videoMuteNode;
    @NotNull
    private final DiscardableDiscarder silenceDiscarder;
    @NotNull
    private final DiscardableDiscarder paddingOnlyDiscarder;
    @NotNull
    private final IncomingStatisticsTracker statsTracker;
    @NotNull
    private final PacketStreamStatsNode packetStreamStats;
    @NotNull
    private final RtcpRrGenerator rtcpRrGenerator;
    @NotNull
    private final RtcpTermination rtcpTermination;
    @NotNull
    private final RetransmissionRequesterNode retransmissionRequester;
    @NotNull
    private final RembHandler rembHandler;
    @NotNull
    private final ToggleablePcapWriter toggleablePcapWriter;
    @NotNull
    private final VideoBitrateCalculator videoBitrateCalculator;
    @NotNull
    private final BitrateCalculator audioBitrateCalculator;
    @NotNull
    private final VideoParser videoParser;
    @Nullable
    private PacketHandler packetHandler;
    @NotNull
    private final packetHandlerWrapper.1 packetHandlerWrapper;
    @NotNull
    private static final CountingErrorHandler queueErrorCounter;
    @NotNull
    private static final String PACKET_QUEUE_ENTRY_EVENT = "Entered RTP receiver incoming queue";
    @NotNull
    private static final String PACKET_QUEUE_EXIT_EVENT = "Exited RTP receiver incoming queue";
    @NotNull
    private static final ConfigDelegate<Integer> queueSize$delegate;
    @NotNull
    private static final PacketLossConfig packetLossConfig;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public RtpReceiverImpl(@NotNull String id, @NotNull Function1<? super RtcpPacket, Unit> rtcpSender, @NotNull RtcpEventNotifier rtcpEventNotifier2, @NotNull ExecutorService executor, @NotNull ScheduledExecutorService backgroundExecutor, final @NotNull ReadOnlyStreamInformationStore streamInformationStore, @NotNull RtpReceiverEventHandler eventHandler, @NotNull Logger parentLogger, @NotNull DiagnosticContext diagnosticContext) {
        void $this$rembHandler_u24lambda_u2d1;
        Object $this$audioLevelReader_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(rtcpSender, "rtcpSender");
        Intrinsics.checkNotNullParameter(rtcpEventNotifier2, "rtcpEventNotifier");
        Intrinsics.checkNotNullParameter(executor, "executor");
        Intrinsics.checkNotNullParameter(backgroundExecutor, "backgroundExecutor");
        Intrinsics.checkNotNullParameter(streamInformationStore, "streamInformationStore");
        Intrinsics.checkNotNullParameter(eventHandler, "eventHandler");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(diagnosticContext, "diagnosticContext");
        this.id = id;
        this.rtcpSender = rtcpSender;
        this.executor = executor;
        this.backgroundExecutor = backgroundExecutor;
        this.eventHandler = eventHandler;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.running = true;
        this.incomingPacketQueue = new PacketInfoQueue("rtp-receiver-incoming-packet-queue", this.executor, (Function1<? super PacketInfo, Boolean>)new Function1<PacketInfo, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull PacketInfo p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return RtpReceiverImpl.access$handleIncomingPacket((RtpReceiverImpl)this.receiver, p0);
            }
        }, RtpReceiverImpl.Companion.getQueueSize());
        this.srtpDecryptWrapper = new SrtpDecryptNode();
        this.srtcpDecryptWrapper = new SrtcpDecryptNode();
        this.tccGenerator = new TccGeneratorNode(this.rtcpSender, streamInformationStore, this.logger, null, 8, null);
        this.remoteBandwidthEstimator = new RemoteBandwidthEstimator(streamInformationStore, this.logger, diagnosticContext, null, 8, null);
        Object object = new AudioLevelReader(streamInformationStore);
        AudioLevelReader audioLevelReader2 = object;
        Object object2 = this;
        boolean bl = false;
        ((AudioLevelReader)$this$audioLevelReader_u24lambda_u2d0).setAudioLevelListener(new AudioLevelListener(this){
            final /* synthetic */ RtpReceiverImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean onLevelReceived(long sourceSsrc, long level) {
                return RtpReceiverImpl.access$getEventHandler$p(this.this$0).audioLevelReceived(sourceSsrc, level);
            }
        });
        ((RtpReceiverImpl)object2).audioLevelReader = object;
        this.videoMuteNode = new VideoMuteNode();
        this.silenceDiscarder = new DiscardableDiscarder("Silence discarder", false);
        this.paddingOnlyDiscarder = new DiscardableDiscarder("Padding-only discarder", true);
        this.statsTracker = new IncomingStatisticsTracker(streamInformationStore);
        this.packetStreamStats = new PacketStreamStatsNode(null, 1, null);
        this.rtcpRrGenerator = new RtcpRrGenerator(this.backgroundExecutor, this.rtcpSender, this.statsTracker, null, new Function0<List<? extends RtcpPacket>>(this){
            final /* synthetic */ RtpReceiverImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<RtcpPacket> invoke() {
                Object object;
                block3: {
                    block2: {
                        object = RtpReceiverImpl.access$getRemoteBandwidthEstimator$p(this.this$0).createRemb();
                        if (object == null) break block2;
                        RtcpFbRembPacket it = object;
                        boolean bl = false;
                        List<RtcpFbRembPacket> list = CollectionsKt.listOf(it);
                        object = list;
                        if (list != null) break block3;
                    }
                    object = CollectionsKt.emptyList();
                }
                return object;
            }
        }, 8, null);
        this.rtcpTermination = new RtcpTermination(rtcpEventNotifier2, this.logger);
        this.retransmissionRequester = new RetransmissionRequesterNode(this.rtcpSender, this.backgroundExecutor, this.logger);
        $this$audioLevelReader_u24lambda_u2d0 = object = new RembHandler(streamInformationStore, this.logger);
        object2 = this;
        boolean bl2 = false;
        $this$rembHandler_u24lambda_u2d1.addListener(new BandwidthEstimator.Listener(this){
            final /* synthetic */ RtpReceiverImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void bandwidthEstimationChanged-_2icLw0(double newValue) {
                RtpReceiverImpl.access$getEventHandler$p(this.this$0).bandwidthEstimationChanged-_2icLw0(newValue);
            }
        });
        ((RtpReceiverImpl)object2).rembHandler = object;
        this.toggleablePcapWriter = new ToggleablePcapWriter(this.logger, this.id + "-rx");
        this.videoBitrateCalculator = new VideoBitrateCalculator(parentLogger, 0, 2, null);
        this.audioBitrateCalculator = new BitrateCalculator("Audio bitrate calculator", 0, null, 6, null);
        this.videoParser = new VideoParser(streamInformationStore, this.logger);
        this.packetHandlerWrapper = new ConsumerNode(this){
            @NotNull
            private final String aggregationKey;
            final /* synthetic */ RtpReceiverImpl this$0;
            {
                this.this$0 = $receiver;
                super("Input pipeline termination node");
                this.aggregationKey = this.getName();
            }

            protected void consume(@NotNull PacketInfo packetInfo) {
                Unit unit;
                Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
                PacketHandler packetHandler = this.this$0.getPacketHandler();
                if (packetHandler != null) {
                    packetHandler.processPacket(packetInfo);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    this.packetDiscarded(packetInfo);
                }
            }

            @NotNull
            protected String getAggregationKey() {
                return this.aggregationKey;
            }

            public void trace(@NotNull Function0<Unit> f) {
                Intrinsics.checkNotNullParameter(f, "f");
                f.invoke();
            }
        };
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            object2 = $this$cdebug$iv;
            boolean bl3 = false;
            object2.debug("using executor " + this.executor.hashCode());
        }
        if (packetLossConfig.getEnabled()) {
            this.logger.warn("Will simulate packet loss: " + packetLossConfig);
        }
        RtcpEventNotifier.addRtcpEventListener$default(rtcpEventNotifier2, this.rtcpRrGenerator, false, 2, null);
        RtcpEventNotifier.addRtcpEventListener$default(rtcpEventNotifier2, this.rembHandler, false, 2, null);
        this.incomingPacketQueue.setErrorHandler(queueErrorCounter);
        this.inputTreeRoot = PipelineDslKt.pipeline((Function1<? super PipelineBuilder, Unit>)new Function1<PipelineBuilder, Unit>(){

            @Override
            public final void invoke(@NotNull PipelineBuilder $this$pipeline) {
                Intrinsics.checkNotNullParameter($this$pipeline, "$this$pipeline");
                PipelineBuilder.node$default($this$pipeline, packetStreamStats, null, 2, null);
                $this$pipeline.demux("SRTP/SRTCP", (Function1<? super DemuxerNode, Unit>)new Function1<DemuxerNode, Unit>(){

                    @Override
                    public final void invoke(@NotNull DemuxerNode $this$demux) {
                        Intrinsics.checkNotNullParameter($this$demux, "$this$demux");
                        PipelineDslKt.packetPath($this$demux, (Function1<? super ConditionalPacketPath, Unit>)new Function1<ConditionalPacketPath, Unit>(){

                            @Override
                            public final void invoke(@NotNull ConditionalPacketPath $this$packetPath) {
                                Intrinsics.checkNotNullParameter($this$packetPath, "$this$packetPath");
                                $this$packetPath.setName("SRTP path");
                                $this$packetPath.setPredicate(PacketExtensionsKt::looksLikeRtp);
                                $this$packetPath.setPath(PipelineDslKt.pipeline((Function1<? super PipelineBuilder, Unit>)new Function1<PipelineBuilder, Unit>(){

                                    @Override
                                    public final void invoke(@NotNull PipelineBuilder $this$pipeline) {
                                        Intrinsics.checkNotNullParameter($this$pipeline, "$this$pipeline");
                                        $this$pipeline.node(new PacketLossNode(packetLossConfig), 1.INSTANCE);
                                        PipelineBuilder.node$default($this$pipeline, new RtpParser(streamInformationStore, logger), null, 2, null);
                                        PipelineBuilder.node$default($this$pipeline, tccGenerator, null, 2, null);
                                        PipelineBuilder.node$default($this$pipeline, remoteBandwidthEstimator, null, 2, null);
                                        PipelineBuilder.node$default($this$pipeline, audioLevelReader, null, 2, null);
                                        PipelineBuilder.node$default($this$pipeline, videoMuteNode, null, 2, null);
                                        PipelineBuilder.node$default($this$pipeline, srtpDecryptWrapper, null, 2, null);
                                        PipelineBuilder.node$default($this$pipeline, toggleablePcapWriter.newObserverNode(), null, 2, null);
                                        PipelineBuilder.node$default($this$pipeline, statsTracker, null, 2, null);
                                        PipelineBuilder.node$default($this$pipeline, new PaddingTermination(logger), null, 2, null);
                                        $this$pipeline.demux("Media Type", (Function1<? super DemuxerNode, Unit>)new Function1<DemuxerNode, Unit>(){

                                            @Override
                                            public final void invoke(@NotNull DemuxerNode $this$demux) {
                                                Intrinsics.checkNotNullParameter($this$demux, "$this$demux");
                                                PipelineDslKt.packetPath($this$demux, (Function1<? super ConditionalPacketPath, Unit>)new Function1<ConditionalPacketPath, Unit>(){

                                                    @Override
                                                    public final void invoke(@NotNull ConditionalPacketPath $this$packetPath) {
                                                        Intrinsics.checkNotNullParameter($this$packetPath, "$this$packetPath");
                                                        $this$packetPath.setName("Audio path");
                                                        $this$packetPath.setPredicate(1::invoke$lambda-0);
                                                        $this$packetPath.setPath(PipelineDslKt.pipeline((Function1<? super PipelineBuilder, Unit>)new Function1<PipelineBuilder, Unit>(){

                                                            @Override
                                                            public final void invoke(@NotNull PipelineBuilder $this$pipeline) {
                                                                Intrinsics.checkNotNullParameter($this$pipeline, "$this$pipeline");
                                                                PipelineBuilder.node$default($this$pipeline, silenceDiscarder, null, 2, null);
                                                                PipelineBuilder.node$default($this$pipeline, audioBitrateCalculator, null, 2, null);
                                                                PipelineBuilder.node$default($this$pipeline, packetHandlerWrapper, null, 2, null);
                                                            }
                                                        }));
                                                    }

                                                    private static final boolean invoke$lambda-0(Packet it) {
                                                        Intrinsics.checkNotNullParameter(it, "it");
                                                        return it instanceof AudioRtpPacket;
                                                    }
                                                });
                                                PipelineDslKt.packetPath($this$demux, (Function1<? super ConditionalPacketPath, Unit>)new Function1<ConditionalPacketPath, Unit>(){

                                                    @Override
                                                    public final void invoke(@NotNull ConditionalPacketPath $this$packetPath) {
                                                        Intrinsics.checkNotNullParameter($this$packetPath, "$this$packetPath");
                                                        $this$packetPath.setName("Video path");
                                                        $this$packetPath.setPredicate(2::invoke$lambda-0);
                                                        $this$packetPath.setPath(PipelineDslKt.pipeline((Function1<? super PipelineBuilder, Unit>)new Function1<PipelineBuilder, Unit>(){

                                                            @Override
                                                            public final void invoke(@NotNull PipelineBuilder $this$pipeline) {
                                                                Intrinsics.checkNotNullParameter($this$pipeline, "$this$pipeline");
                                                                PipelineBuilder.node$default($this$pipeline, new RtxHandler(streamInformationStore, logger), null, 2, null);
                                                                PipelineBuilder.node$default($this$pipeline, new DuplicateTermination(), null, 2, null);
                                                                PipelineBuilder.node$default($this$pipeline, retransmissionRequester, null, 2, null);
                                                                PipelineBuilder.node$default($this$pipeline, paddingOnlyDiscarder, null, 2, null);
                                                                PipelineBuilder.node$default($this$pipeline, videoParser, null, 2, null);
                                                                PipelineBuilder.node$default($this$pipeline, new VideoQualityLayerLookup(logger), null, 2, null);
                                                                PipelineBuilder.node$default($this$pipeline, videoBitrateCalculator, null, 2, null);
                                                                PipelineBuilder.node$default($this$pipeline, packetHandlerWrapper, null, 2, null);
                                                            }
                                                        }));
                                                    }

                                                    private static final boolean invoke$lambda-0(Packet it) {
                                                        Intrinsics.checkNotNullParameter(it, "it");
                                                        return it instanceof VideoRtpPacket;
                                                    }
                                                });
                                            }
                                        });
                                    }
                                }));
                            }
                        });
                        PipelineDslKt.packetPath($this$demux, (Function1<? super ConditionalPacketPath, Unit>)new Function1<ConditionalPacketPath, Unit>(){

                            @Override
                            public final void invoke(@NotNull ConditionalPacketPath $this$packetPath) {
                                Intrinsics.checkNotNullParameter($this$packetPath, "$this$packetPath");
                                $this$packetPath.setName("SRTCP path");
                                $this$packetPath.setPredicate(PacketExtensionsKt::looksLikeRtcp);
                                $this$packetPath.setPath(PipelineDslKt.pipeline((Function1<? super PipelineBuilder, Unit>)new Function1<PipelineBuilder, Unit>(){

                                    @Override
                                    public final void invoke(@NotNull PipelineBuilder $this$pipeline) {
                                        Intrinsics.checkNotNullParameter($this$pipeline, "$this$pipeline");
                                        PipelineBuilder.node$default($this$pipeline, srtcpDecryptWrapper, null, 2, null);
                                        PipelineBuilder.node$default($this$pipeline, toggleablePcapWriter.newObserverNode(), null, 2, null);
                                        PipelineBuilder.node$default($this$pipeline, new CompoundRtcpParser(logger), null, 2, null);
                                        PipelineBuilder.node$default($this$pipeline, rtcpTermination, null, 2, null);
                                        PipelineBuilder.node$default($this$pipeline, packetHandlerWrapper, null, 2, null);
                                    }
                                }));
                            }
                        });
                    }
                });
            }
        });
    }

    public /* synthetic */ RtpReceiverImpl(String string, Function1 function1, RtcpEventNotifier rtcpEventNotifier2, ExecutorService executorService, ScheduledExecutorService scheduledExecutorService, ReadOnlyStreamInformationStore readOnlyStreamInformationStore, RtpReceiverEventHandler rtpReceiverEventHandler, Logger logger, DiagnosticContext diagnosticContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 0x100) != 0) {
            diagnosticContext = new DiagnosticContext();
        }
        this(string, function1, rtcpEventNotifier2, executorService, scheduledExecutorService, readOnlyStreamInformationStore, rtpReceiverEventHandler, logger, diagnosticContext);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @Override
    public boolean isReceivingAudio() {
        return this.audioBitrateCalculator.getActive();
    }

    @Override
    public boolean isReceivingVideo() {
        return this.videoBitrateCalculator.getActive();
    }

    @Override
    public void addLossListener(@NotNull LossListener lossListener) {
        Intrinsics.checkNotNullParameter(lossListener, "lossListener");
        this.tccGenerator.addLossListener(lossListener);
    }

    @Override
    @Nullable
    public PacketHandler getPacketHandler() {
        return this.packetHandler;
    }

    @Override
    public void setPacketHandler(@Nullable PacketHandler packetHandler) {
        this.packetHandler = packetHandler;
    }

    private final boolean handleIncomingPacket(PacketInfo packet) {
        boolean bl;
        if (this.running) {
            packet.addEvent(PACKET_QUEUE_EXIT_EVENT);
            this.processPacket(packet);
            bl = true;
        } else {
            Function1<byte[], Unit> function1 = BufferPool.Companion.getReturnBuffer();
            Intrinsics.checkNotNullExpressionValue(packet.getPacket().buffer, "packet.packet.buffer");
            function1.invoke(packet.getPacket().buffer);
            bl = false;
        }
        return bl;
    }

    @Override
    protected void doProcessPacket(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        this.inputTreeRoot.processPacket(packetInfo);
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u2d3 = nodeStatsBlock = new NodeStatsBlock("RTP receiver " + this.id);
        boolean bl = false;
        $this$getNodeStats_u24lambda_u2d3.addBlock(super.getNodeStats());
        $this$getNodeStats_u24lambda_u2d3.addBoolean("running", this.running);
        new NodeStatsVisitor($this$getNodeStats_u24lambda_u2d3).visit(this.inputTreeRoot);
        return nodeStatsBlock;
    }

    @Override
    public void enqueuePacket(@NotNull PacketInfo p) {
        Intrinsics.checkNotNullParameter(p, "p");
        if (this.running) {
            p.addEvent(PACKET_QUEUE_ENTRY_EVENT);
            this.incomingPacketQueue.add(p);
        } else {
            Function1<byte[], Unit> function1 = BufferPool.Companion.getReturnBuffer();
            Intrinsics.checkNotNullExpressionValue(p.getPacket().buffer, "p.packet.buffer");
            function1.invoke(p.getPacket().buffer);
        }
    }

    @Override
    public void setSrtpTransformers(@NotNull SrtpTransformers srtpTransformers) {
        Intrinsics.checkNotNullParameter(srtpTransformers, "srtpTransformers");
        this.srtpDecryptWrapper.setTransformer(srtpTransformers.getSrtpDecryptTransformer());
        this.srtcpDecryptWrapper.setTransformer(srtpTransformers.getSrtcpDecryptTransformer());
    }

    @Override
    public void handleEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter(event, "event");
        new NodeEventVisitor(event).visit(this.inputTreeRoot);
    }

    @Override
    @NotNull
    public RtpReceiverStats getStats() {
        return new RtpReceiverStats(this.statsTracker.getSnapshot(), this.packetStreamStats.snapshot(), this.videoParser.getStats());
    }

    @Override
    public void forceMuteAudio(boolean shouldMute) {
        this.audioLevelReader.setForceMute(shouldMute);
    }

    @Override
    public void forceMuteVideo(boolean shouldMute) {
        this.videoMuteNode.setForceMute(shouldMute);
    }

    @Override
    public void setFeature(@NotNull Features feature, boolean enabled2) {
        Intrinsics.checkNotNullParameter((Object)feature, "feature");
        if (WhenMappings.$EnumSwitchMapping$0[feature.ordinal()] == 1) {
            if (enabled2) {
                this.toggleablePcapWriter.enable();
            } else {
                this.toggleablePcapWriter.disable();
            }
        }
    }

    @Override
    public boolean isFeatureEnabled(@NotNull Features feature) {
        Intrinsics.checkNotNullParameter((Object)feature, "feature");
        if (WhenMappings.$EnumSwitchMapping$0[feature.ordinal()] != 1) {
            throw new NoWhenBranchMatchedException();
        }
        return this.toggleablePcapWriter.isEnabled();
    }

    @Override
    public void stop() {
        this.running = false;
        this.rtcpRrGenerator.setRunning(false);
        this.retransmissionRequester.stop();
    }

    @Override
    public void tearDown() {
        this.logger.info("Tearing down");
        new NodeTeardownVisitor().visit(this.inputTreeRoot);
        this.incomingPacketQueue.close();
        this.toggleablePcapWriter.disable();
    }

    @Override
    public void onRttUpdate(double newRttMs) {
        this.remoteBandwidthEstimator.onRttUpdate(newRttMs);
    }

    @JvmOverloads
    public RtpReceiverImpl(@NotNull String id, @NotNull Function1<? super RtcpPacket, Unit> rtcpSender, @NotNull RtcpEventNotifier rtcpEventNotifier2, @NotNull ExecutorService executor, @NotNull ScheduledExecutorService backgroundExecutor, @NotNull ReadOnlyStreamInformationStore streamInformationStore, @NotNull RtpReceiverEventHandler eventHandler, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(rtcpSender, "rtcpSender");
        Intrinsics.checkNotNullParameter(rtcpEventNotifier2, "rtcpEventNotifier");
        Intrinsics.checkNotNullParameter(executor, "executor");
        Intrinsics.checkNotNullParameter(backgroundExecutor, "backgroundExecutor");
        Intrinsics.checkNotNullParameter(streamInformationStore, "streamInformationStore");
        Intrinsics.checkNotNullParameter(eventHandler, "eventHandler");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        this(id, rtcpSender, rtcpEventNotifier2, executor, backgroundExecutor, streamInformationStore, eventHandler, parentLogger, null, 256, null);
    }

    @JvmOverloads
    public RtpReceiverImpl(@NotNull String id, @NotNull RtcpEventNotifier rtcpEventNotifier2, @NotNull ExecutorService executor, @NotNull ScheduledExecutorService backgroundExecutor, @NotNull ReadOnlyStreamInformationStore streamInformationStore, @NotNull RtpReceiverEventHandler eventHandler, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(rtcpEventNotifier2, "rtcpEventNotifier");
        Intrinsics.checkNotNullParameter(executor, "executor");
        Intrinsics.checkNotNullParameter(backgroundExecutor, "backgroundExecutor");
        Intrinsics.checkNotNullParameter(streamInformationStore, "streamInformationStore");
        Intrinsics.checkNotNullParameter(eventHandler, "eventHandler");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        this(id, null, rtcpEventNotifier2, executor, backgroundExecutor, streamInformationStore, eventHandler, parentLogger, null, 258, null);
    }

    public static final /* synthetic */ boolean access$handleIncomingPacket(RtpReceiverImpl $this, PacketInfo packet) {
        return $this.handleIncomingPacket(packet);
    }

    public static final /* synthetic */ RtpReceiverEventHandler access$getEventHandler$p(RtpReceiverImpl $this) {
        return $this.eventHandler;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$from$iv;
        Companion = new Companion(null);
        queueErrorCounter = new CountingErrorHandler();
        String string = "jmt.transceiver.recv.queue-size";
        ConfigSource configSource$iv = JitsiConfig.Companion.getNewConfig();
        boolean $i$f$from = false;
        ConfigSourceSupplier supplier$iv = new ConfigSourceSupplier((String)$this$from$iv, configSource$iv, Reflection.typeOf(Integer.TYPE), DeprecationKt.noDeprecation());
        boolean $i$f$config = false;
        queueSize$delegate = new ConfigDelegate(supplier$iv);
        packetLossConfig = new PacketLossConfig("jmt.debug.packet-loss.incoming");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lorg/jitsi/nlj/RtpReceiverImpl$Companion;", "", "()V", "PACKET_QUEUE_ENTRY_EVENT", "", "PACKET_QUEUE_EXIT_EVENT", "packetLossConfig", "Lorg/jitsi/nlj/transform/node/PacketLossConfig;", "queueErrorCounter", "Lorg/jitsi/utils/queue/CountingErrorHandler;", "getQueueErrorCounter", "()Lorg/jitsi/utils/queue/CountingErrorHandler;", "queueSize", "", "getQueueSize", "()I", "queueSize$delegate", "Lorg/jitsi/metaconfig/ConfigDelegate;", "jitsi-media-transform"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final CountingErrorHandler getQueueErrorCounter() {
            return queueErrorCounter;
        }

        private final int getQueueSize() {
            return ((Number)queueSize$delegate.getValue(this, $$delegatedProperties[0])).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Companion.class, "queueSize", "getQueueSize()I", 0))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Features.values().length];
            nArray[Features.TRANSCEIVER_PCAP_DUMP.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

