/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.codec;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.MediaSourceDescKt;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.RtpEncodingDesc;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.nlj.rtp.VideoRtpPacket;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0004J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rH\u0004J\u001e\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\rH\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H&R\"\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\t\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u0016"}, d2={"Lorg/jitsi/nlj/rtp/codec/VideoCodecParser;", "", "sources", "", "Lorg/jitsi/nlj/MediaSourceDesc;", "([Lorg/jitsi/nlj/MediaSourceDesc;)V", "getSources", "()[Lorg/jitsi/nlj/MediaSourceDesc;", "setSources", "[Lorg/jitsi/nlj/MediaSourceDesc;", "findRtpEncodingDesc", "Lorg/jitsi/nlj/RtpEncodingDesc;", "packet", "Lorg/jitsi/nlj/rtp/VideoRtpPacket;", "findRtpLayerDesc", "Lorg/jitsi/nlj/RtpLayerDesc;", "findSourceDescAndRtpEncodingDesc", "Lkotlin/Pair;", "parse", "", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "jitsi-media-transform"})
public abstract class VideoCodecParser {
    @NotNull
    private MediaSourceDesc[] sources;

    public VideoCodecParser(@NotNull MediaSourceDesc[] sources) {
        Intrinsics.checkNotNullParameter(sources, "sources");
        this.sources = sources;
    }

    @NotNull
    public final MediaSourceDesc[] getSources() {
        return this.sources;
    }

    public final void setSources(@NotNull MediaSourceDesc[] mediaSourceDescArray) {
        Intrinsics.checkNotNullParameter(mediaSourceDescArray, "<set-?>");
        this.sources = mediaSourceDescArray;
    }

    public abstract void parse(@NotNull PacketInfo var1);

    @Nullable
    protected final RtpEncodingDesc findRtpEncodingDesc(@NotNull VideoRtpPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        for (MediaSourceDesc source : this.sources) {
            RtpEncodingDesc rtpEncodingDesc = source.findRtpEncodingDesc(packet.getSsrc());
            if (rtpEncodingDesc == null) continue;
            RtpEncodingDesc it = rtpEncodingDesc;
            boolean bl = false;
            return it;
        }
        return null;
    }

    @Nullable
    protected final Pair<MediaSourceDesc, RtpEncodingDesc> findSourceDescAndRtpEncodingDesc(@NotNull VideoRtpPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        for (MediaSourceDesc source : this.sources) {
            RtpEncodingDesc rtpEncodingDesc = source.findRtpEncodingDesc(packet.getSsrc());
            if (rtpEncodingDesc == null) continue;
            RtpEncodingDesc it = rtpEncodingDesc;
            boolean bl = false;
            return new Pair<MediaSourceDesc, RtpEncodingDesc>(source, it);
        }
        return null;
    }

    @Nullable
    protected final RtpLayerDesc findRtpLayerDesc(@NotNull VideoRtpPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        return MediaSourceDescKt.findRtpLayerDesc(this.sources, packet);
    }
}

