/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.config.JitsiConfig;
import org.jitsi.metaconfig.ConfigDelegate;
import org.jitsi.metaconfig.SupplierBuilder;
import org.jitsi.metaconfig.supplier.FallbackSupplier;
import org.jitsi.nlj.Features;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.PacketHandler;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.Transceiver;
import org.jitsi.nlj.TransceiverEventHandler;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.rtp.AudioRtpPacket;
import org.jitsi.nlj.rtp.ParsedVideoPacket;
import org.jitsi.nlj.rtp.RtpExtension;
import org.jitsi.nlj.rtp.SsrcAssociationType;
import org.jitsi.nlj.rtp.VideoRtpPacket;
import org.jitsi.nlj.rtp.bandwidthestimation.BandwidthEstimator;
import org.jitsi.nlj.srtp.TlsRole;
import org.jitsi.nlj.stats.EndpointConnectionStats;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.stats.PacketStreamStats;
import org.jitsi.nlj.stats.TransceiverStats;
import org.jitsi.nlj.transform.node.ConsumerNode;
import org.jitsi.nlj.transform.node.incoming.IncomingSsrcStats;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.ClockUtils;
import org.jitsi.nlj.util.LocalSsrcAssociation;
import org.jitsi.nlj.util.PacketInfoQueue;
import org.jitsi.nlj.util.RemoteSsrcAssociation;
import org.jitsi.rtp.Packet;
import org.jitsi.rtp.UnparsedPacket;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.rtp.rtcp.RtcpSrPacket;
import org.jitsi.rtp.rtcp.rtcpfb.RtcpFbPacket;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.RtcpFbFirPacket;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.RtcpFbPliPacket;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.concurrent.RecurringRunnable;
import org.jitsi.utils.concurrent.RecurringRunnableExecutor;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.queue.CountingErrorHandler;
import org.jitsi.utils.queue.PacketQueue;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.AudioSsrcCache;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.EncodingsManager;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.EndpointMessageTransport;
import org.jitsi.videobridge.PotentialPacketHandler;
import org.jitsi.videobridge.SsrcCache;
import org.jitsi.videobridge.SsrcLimitConfig;
import org.jitsi.videobridge.SsrcRewriter;
import org.jitsi.videobridge.TransportConfig;
import org.jitsi.videobridge.VideoSsrcCache;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.VideobridgeExpireThreadConfig;
import org.jitsi.videobridge.cc.BandwidthProbing;
import org.jitsi.videobridge.cc.allocation.BandwidthAllocation;
import org.jitsi.videobridge.cc.allocation.BitrateController;
import org.jitsi.videobridge.cc.allocation.BitrateControllerStatusSnapshot;
import org.jitsi.videobridge.cc.allocation.VideoConstraints;
import org.jitsi.videobridge.datachannel.DataChannel;
import org.jitsi.videobridge.datachannel.DataChannelStack;
import org.jitsi.videobridge.datachannel.protocol.DataChannelPacket;
import org.jitsi.videobridge.message.BridgeChannelMessage;
import org.jitsi.videobridge.message.ForwardedEndpointsMessage;
import org.jitsi.videobridge.message.ForwardedSourcesMessage;
import org.jitsi.videobridge.message.ReceiverVideoConstraintsMessage;
import org.jitsi.videobridge.message.SenderSourceConstraintsMessage;
import org.jitsi.videobridge.message.SenderVideoConstraintsMessage;
import org.jitsi.videobridge.relay.AudioSourceDesc;
import org.jitsi.videobridge.rest.root.debug.EndpointDebugFeatures;
import org.jitsi.videobridge.sctp.SctpConfig;
import org.jitsi.videobridge.sctp.SctpManager;
import org.jitsi.videobridge.stats.PacketTransitStats;
import org.jitsi.videobridge.transport.dtls.DtlsTransport;
import org.jitsi.videobridge.transport.ice.IceTransport;
import org.jitsi.videobridge.util.ByteBufferPool;
import org.jitsi.videobridge.util.PacketUtils;
import org.jitsi.videobridge.util.TaskPools;
import org.jitsi.videobridge.websocket.ColibriWebSocketService;
import org.jitsi.videobridge.websocket.ColibriWebSocketServiceSupplierKt;
import org.jitsi.xmpp.extensions.colibri.WebSocketPacketExtension;
import org.jitsi.xmpp.extensions.jingle.DtlsFingerprintPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi_modified.sctp4j.SctpServerSocket;
import org.jitsi_modified.sctp4j.SctpSocket;
import org.json.simple.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00fa\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 \u00ca\u00012\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\b\u00ca\u0001\u00cb\u0001\u00cc\u0001\u00cd\u0001BI\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020QJ\u000e\u0010_\u001a\u00020\f2\u0006\u0010`\u001a\u00020\u0006J\u0010\u0010a\u001a\u00020]2\u0006\u0010b\u001a\u00020cH\u0016J\u0016\u0010d\u001a\u00020]2\u0006\u0010e\u001a\u00020G2\u0006\u0010f\u001a\u00020gJ\u0010\u0010h\u001a\u00020]2\u0006\u0010i\u001a\u00020jH\u0016J\u0006\u0010k\u001a\u00020]J\u0006\u0010l\u001a\u00020mJ\u0010\u0010n\u001a\u00020\f2\u0006\u0010o\u001a\u00020pH\u0002J\u0006\u0010q\u001a\u00020\fJ\u001e\u0010r\u001a\u00020]2\u0006\u0010s\u001a\u00020t2\u0006\u0010u\u001a\u00020v2\u0006\u0010w\u001a\u00020vJ8\u0010x\u001a\u00020]2\u0016\u0010y\u001a\u0012\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020{0zj\u0002`|2\u0016\u0010}\u001a\u0012\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020{0zj\u0002`|H\u0002J\u0006\u0010~\u001a\u00020]J\b\u0010\u007f\u001a\u00020]H\u0016J\u0013\u0010\u0080\u0001\u001a\u0004\u0018\u00010!2\u0006\u0010e\u001a\u00020GH\u0016J\u0013\u0010\u0081\u0001\u001a\u0004\u0018\u00010@2\u0006\u0010e\u001a\u00020GH\u0016J\n\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0016J\t\u0010\u0084\u0001\u001a\u00020.H\u0016J\t\u0010\u0085\u0001\u001a\u00020\u0014H\u0016J\t\u0010\u0086\u0001\u001a\u00020GH\u0016J\u000e\u0010\u0087\u0001\u001a\t\u0012\u0004\u0012\u00020\u00010\u0088\u0001J\b\u0010\u0089\u0001\u001a\u00030\u008a\u0001J+\u0010\u008b\u0001\u001a$\u0012\f\u0012\n /*\u0004\u0018\u00010G0G0\u008c\u0001j\u0011\u0012\f\u0012\n /*\u0004\u0018\u00010G0G`\u008d\u0001H\u0016J\u000f\u0010\u008e\u0001\u001a\u00020]2\u0006\u0010o\u001a\u00020pJ\u0007\u0010\u008f\u0001\u001a\u00020\fJ\u0011\u0010\u0090\u0001\u001a\u00020\f2\b\u0010\u0091\u0001\u001a\u00030\u0092\u0001J\u0007\u0010\u0093\u0001\u001a\u00020\fJ\u0007\u0010\u0094\u0001\u001a\u00020\fJ\t\u0010\u0095\u0001\u001a\u00020\fH\u0016J\t\u0010\u0096\u0001\u001a\u00020\fH\u0016J\t\u0010\u0097\u0001\u001a\u00020\fH\u0002J\u0007\u0010\u0098\u0001\u001a\u00020]J\u0007\u0010\u0099\u0001\u001a\u00020vJ.\u0010\u009a\u0001\u001a\u00020]2\u0007\u0010\u009b\u0001\u001a\u00020\u00062\u0007\u0010\u009c\u0001\u001a\u00020G2\u0007\u0010\u009d\u0001\u001a\u00020G2\b\u0010\u009e\u0001\u001a\u00030\u009f\u0001H\u0016J\u0011\u0010\u00a0\u0001\u001a\u00020\f2\u0006\u0010e\u001a\u00020GH\u0016J\t\u0010\u00a1\u0001\u001a\u00020]H\u0016J\u0012\u0010\u00a1\u0001\u001a\u00020]2\u0007\u0010\u00a2\u0001\u001a\u00020GH\u0016J\u0007\u0010\u00a3\u0001\u001a\u00020]J\u0011\u0010\u00a4\u0001\u001a\u00020]2\u0006\u0010o\u001a\u00020pH\u0016J\t\u0010\u00a5\u0001\u001a\u00020]H\u0002J\u0019\u0010\u00a6\u0001\u001a\u00020]2\u000e\u0010\u00a7\u0001\u001a\t\u0012\u0004\u0012\u00020\u00060\u00a8\u0001H\u0007J\u0017\u0010\u00a9\u0001\u001a\u00020]2\u000e\u0010\u00aa\u0001\u001a\t\u0012\u0004\u0012\u00020\u00060\u00a8\u0001J\u0013\u0010\u00ab\u0001\u001a\u00020]2\b\u0010\u00ac\u0001\u001a\u00030\u00ad\u0001H\u0016J\u0012\u0010\u00ae\u0001\u001a\u00020]2\u0007\u0010\u00af\u0001\u001a\u00020{H\u0014J\u001b\u0010\u00b0\u0001\u001a\u00020]2\u0007\u0010\u00b1\u0001\u001a\u00020\u00062\u0007\u0010\u00af\u0001\u001a\u00020{H\u0014J\u0011\u0010\u00b2\u0001\u001a\u00020]2\b\u0010\u00b3\u0001\u001a\u00030\u00b4\u0001J\u0012\u0010\u00b5\u0001\u001a\u00020]2\u0007\u0010\u00b6\u0001\u001a\u00020\fH\u0016J\u001a\u0010\u00b7\u0001\u001a\u00020]2\b\u0010\u0091\u0001\u001a\u00030\u0092\u00012\u0007\u0010\u00b8\u0001\u001a\u00020\fJ\u0010\u0010\u00b9\u0001\u001a\u00020]2\u0007\u0010\u00ba\u0001\u001a\u00020vJ\u0010\u0010\u00bb\u0001\u001a\u00020]2\u0007\u0010\u00bc\u0001\u001a\u00020mJ\t\u0010\u00bd\u0001\u001a\u00020]H\u0002J\t\u0010\u00be\u0001\u001a\u00020]H\u0002J\t\u0010\u00bf\u0001\u001a\u00020\fH\u0016J\u0013\u0010\u00c0\u0001\u001a\u0004\u0018\u00010\u00062\b\u0010\u00c1\u0001\u001a\u00030\u00c2\u0001J\u0019\u0010\u00c3\u0001\u001a\u00020]2\u0007\u0010\u00c4\u0001\u001a\u00020\f2\u0007\u0010\u00c5\u0001\u001a\u00020\fJ\t\u0010\u00c6\u0001\u001a\u00020]H\u0002J\u0011\u0010\u00c7\u0001\u001a\u00020\f2\u0006\u0010o\u001a\u00020pH\u0016J\u0010\u0010\u00c8\u0001\u001a\u00020\f2\u0007\u0010\u00c9\u0001\u001a\u00020\u0001R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020!0 j\b\u0012\u0004\u0012\u00020!`\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00010,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010-\u001a\n /*\u0004\u0018\u00010.0.\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u000e\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00104\u001a\u0004\u0018\u000105X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u00106\u001a\n /*\u0004\u0018\u00010707X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020=X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010A\u001a\b\u0012\u0004\u0012\u00020@0?2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER\u000e\u0010F\u001a\u00020GX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020=X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020JX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010K\u001a\u00020LX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010M\u001a\u0004\u0018\u00010NX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010O\u001a\b\u0012\u0004\u0012\u00020Q0PX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010R\u001a\b\u0012\u0004\u0012\u00020G0SX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010T\u001a\n /*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010U\u001a\u00020V\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010XR\u000e\u0010Y\u001a\u00020ZX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u0010\u0017\u00a8\u0006\u00ce\u0001"}, d2={"Lorg/jitsi/videobridge/Endpoint;", "Lorg/jitsi/videobridge/AbstractEndpoint;", "Lorg/jitsi/videobridge/PotentialPacketHandler;", "Lorg/jitsi/videobridge/EncodingsManager$EncodingsUpdateListener;", "Lorg/jitsi/videobridge/SsrcRewriter;", "id", "", "conference", "Lorg/jitsi/videobridge/Conference;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "iceControlling", "", "isUsingSourceNames", "doSsrcRewriting", "visitor", "clock", "Ljava/time/Clock;", "(Ljava/lang/String;Lorg/jitsi/videobridge/Conference;Lorg/jitsi/utils/logging2/Logger;ZZZZLjava/time/Clock;)V", "_messageTransport", "Lorg/jitsi/videobridge/EndpointMessageTransport;", "acceptAudio", "getAcceptAudio", "()Z", "setAcceptAudio", "(Z)V", "acceptVideo", "getAcceptVideo", "setAcceptVideo", "activeSources", "", "audioSources", "Ljava/util/ArrayList;", "Lorg/jitsi/videobridge/relay/AudioSourceDesc;", "Lkotlin/collections/ArrayList;", "getAudioSources", "()Ljava/util/ArrayList;", "setAudioSources", "(Ljava/util/ArrayList;)V", "audioSsrcs", "Lorg/jitsi/videobridge/AudioSsrcCache;", "bandwidthProbing", "Lorg/jitsi/videobridge/cc/BandwidthProbing;", "bitrateController", "Lorg/jitsi/videobridge/cc/allocation/BitrateController;", "creationTime", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "getCreationTime", "()Ljava/time/Instant;", "dataChannelHandler", "Lorg/jitsi/videobridge/Endpoint$DataChannelHandler;", "dataChannelStack", "Lorg/jitsi/videobridge/datachannel/DataChannelStack;", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "dtlsTransport", "Lorg/jitsi/videobridge/transport/dtls/DtlsTransport;", "iceTransport", "Lorg/jitsi/videobridge/transport/ice/IceTransport;", "incomingDataChannelMessagesQueue", "Lorg/jitsi/nlj/util/PacketInfoQueue;", "value", "", "Lorg/jitsi/nlj/MediaSourceDesc;", "mediaSources", "getMediaSources", "()[Lorg/jitsi/nlj/MediaSourceDesc;", "setMediaSources", "([Lorg/jitsi/nlj/MediaSourceDesc;)V", "nextSendSsrc", "", "outgoingSrtpPacketQueue", "rttListener", "Lorg/jitsi/nlj/stats/EndpointConnectionStats$EndpointConnectionStatsListener;", "sctpHandler", "Lorg/jitsi/videobridge/Endpoint$SctpHandler;", "sctpManager", "Lorg/jitsi/videobridge/sctp/SctpManager;", "sctpSocket", "Ljava/util/Optional;", "Lorg/jitsi_modified/sctp4j/SctpServerSocket;", "sendSsrcs", "", "timelineLogger", "transceiver", "Lorg/jitsi/nlj/Transceiver;", "getTransceiver", "()Lorg/jitsi/nlj/Transceiver;", "videoSsrcs", "Lorg/jitsi/videobridge/VideoSsrcCache;", "getVisitor", "acceptSctpConnection", "", "sctpServerSocket", "acceptWebSocket", "password", "addPayloadType", "payloadType", "Lorg/jitsi/nlj/format/PayloadType;", "addReceiveSsrc", "ssrc", "mediaType", "Lorg/jitsi/utils/MediaType;", "addRtpExtension", "rtpExtension", "Lorg/jitsi/nlj/rtp/RtpExtension;", "createSctpConnection", "describeTransport", "Lorg/jitsi/xmpp/extensions/jingle/IceUdpTransportPacketExtension;", "doSendSrtp", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "doesSsrcRewriting", "dtlsAppPacketReceived", "data", "", "off", "", "len", "effectiveVideoConstraintsChanged", "oldEffectiveConstraints", "", "Lorg/jitsi/videobridge/cc/allocation/VideoConstraints;", "Lorg/jitsi/videobridge/cc/allocation/EffectiveConstraintsMap;", "newEffectiveConstraints", "endpointMessageTransportConnected", "expire", "findAudioSourceProps", "findVideoSourceProps", "getDebugState", "Lorg/json/simple/JSONObject;", "getLastIncomingActivity", "getMessageTransport", "getNextSendSsrc", "getOrderedEndpoints", "", "getRtt", "", "getSsrcs", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "handleIncomingPacket", "hasSuspendedSources", "isFeatureEnabled", "feature", "Lorg/jitsi/videobridge/rest/root/debug/EndpointDebugFeatures;", "isInStageView", "isOversending", "isSendingAudio", "isSendingVideo", "isTransportConnected", "lastNEndpointsChanged", "numForwardedEndpoints", "onNewSsrcAssociation", "endpointId", "primarySsrc", "secondarySsrc", "type", "Lorg/jitsi/nlj/rtp/SsrcAssociationType;", "receivesSsrc", "requestKeyframe", "mediaSsrc", "scheduleEndpointMessageTransportTimeout", "send", "sendAllVideoConstraints", "sendForwardedEndpointsMessage", "forwardedEndpoints", "", "sendForwardedSourcesMessage", "forwardedSources", "sendMessage", "msg", "Lorg/jitsi/videobridge/message/BridgeChannelMessage;", "sendVideoConstraints", "maxVideoConstraints", "sendVideoConstraintsV2", "sourceName", "setBandwidthAllocationSettings", "message", "Lorg/jitsi/videobridge/message/ReceiverVideoConstraintsMessage;", "setExtmapAllowMixed", "allow", "setFeature", "enabled", "setLastN", "lastN", "setTransportInfo", "transportInfo", "setupDtlsTransport", "setupIceTransport", "shouldExpire", "unmapRtcpFbSsrc", "packet", "Lorg/jitsi/rtp/rtcp/rtcpfb/RtcpFbPacket;", "updateForceMute", "audioForceMuted", "videoForceMuted", "updateStatsOnExpire", "wants", "wantsStatsFrom", "ep", "Companion", "DataChannelHandler", "SctpHandler", "TransceiverEventHandlerImpl", "jitsi-videobridge"})
public final class Endpoint
extends AbstractEndpoint
implements PotentialPacketHandler,
EncodingsManager.EncodingsUpdateListener,
SsrcRewriter {
    @NotNull
    public static final Companion Companion;
    private final boolean isUsingSourceNames;
    private final boolean doSsrcRewriting;
    private final boolean visitor;
    @NotNull
    private final Clock clock;
    private final Instant creationTime;
    @NotNull
    private final SctpHandler sctpHandler;
    @NotNull
    private final DataChannelHandler dataChannelHandler;
    @NotNull
    private final IceTransport iceTransport;
    @NotNull
    private final DtlsTransport dtlsTransport;
    private final DiagnosticContext diagnosticContext;
    private final Logger timelineLogger;
    @Nullable
    private SctpManager sctpManager;
    @Nullable
    private DataChannelStack dataChannelStack;
    @NotNull
    private Optional<SctpServerSocket> sctpSocket;
    private boolean acceptAudio;
    private boolean acceptVideo;
    @NotNull
    private final PacketInfoQueue outgoingSrtpPacketQueue;
    @NotNull
    private final PacketInfoQueue incomingDataChannelMessagesQueue;
    @NotNull
    private final BitrateController<AbstractEndpoint> bitrateController;
    @NotNull
    private final EndpointMessageTransport _messageTransport;
    @NotNull
    private final EndpointConnectionStats.EndpointConnectionStatsListener rttListener;
    @NotNull
    private final Transceiver transceiver;
    @NotNull
    private final BandwidthProbing bandwidthProbing;
    @NotNull
    private final VideoSsrcCache videoSsrcs;
    @NotNull
    private final AudioSsrcCache audioSsrcs;
    @NotNull
    private Set<String> activeSources;
    @NotNull
    private final Set<Long> sendSsrcs;
    private long nextSendSsrc;
    @NotNull
    private ArrayList<AudioSourceDesc> audioSources;
    private static final boolean openDataChannelLocally = false;
    @JvmField
    @NotNull
    public static final CountingErrorHandler queueErrorCounter;
    @NotNull
    private static final RecurringRunnableExecutor recurringRunnableExecutor;
    @NotNull
    private static final Duration epTimeout;
    @NotNull
    private static final AtomicLong timelineCounter;
    private static final long TIMELINE_FRACTION;
    @NotNull
    private static final String SRTP_QUEUE_ENTRY_EVENT = "Entered Endpoint SRTP sender outgoing queue";
    @NotNull
    private static final String SRTP_QUEUE_EXIT_EVENT = "Exited Endpoint SRTP sender outgoing queue";
    @NotNull
    private static final ConfigDelegate<Integer> statsFilterThreshold$delegate;
    private static final boolean useRandomSendSsrcs;
    @NotNull
    private static final SecureRandom random;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public Endpoint(@NotNull String id, @NotNull Conference conference, @NotNull Logger parentLogger, boolean iceControlling, boolean isUsingSourceNames, boolean doSsrcRewriting, boolean visitor2, @NotNull Clock clock) {
        void it;
        Object $this$bandwidthProbing_u24lambda_u2d7;
        Object $this$transceiver_u24lambda_u2d5;
        Object $this$outgoingSrtpPacketQueue_u24lambda_u2d1;
        Object $this$diagnosticContext_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(conference, "conference");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(clock, "clock");
        super(conference, id, parentLogger);
        this.isUsingSourceNames = isUsingSourceNames;
        this.doSsrcRewriting = doSsrcRewriting;
        this.visitor = visitor2;
        this.clock = clock;
        this.creationTime = this.clock.instant();
        this.sctpHandler = new SctpHandler();
        this.dataChannelHandler = new DataChannelHandler();
        Logger logger = this.logger;
        Intrinsics.checkNotNullExpressionValue(logger, "logger");
        this.iceTransport = new IceTransport(id, iceControlling, false, logger, null, 16, null);
        Logger logger2 = this.logger;
        Intrinsics.checkNotNullExpressionValue(logger2, "logger");
        this.dtlsTransport = new DtlsTransport(logger2);
        Object object = conference.newDiagnosticContext();
        DiagnosticContext diagnosticContext = object;
        Endpoint endpoint = this;
        boolean bl = false;
        ((ConcurrentHashMap)$this$diagnosticContext_u24lambda_u2d0).put("endpoint_id", id);
        endpoint.diagnosticContext = object;
        this.timelineLogger = this.logger.createChildLogger("timeline." + this.getClass().getName());
        Optional optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, "empty()");
        this.sctpSocket = optional;
        String string = this.getClass().getSimpleName() + "-outgoing-packet-queue";
        ExecutorService executorService = TaskPools.IO_POOL;
        Intrinsics.checkNotNullExpressionValue(executorService, "IO_POOL");
        $this$diagnosticContext_u24lambda_u2d0 = object = new PacketInfoQueue(string, executorService, (Function1<? super PacketInfo, Boolean>)new Function1<PacketInfo, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull PacketInfo p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return Endpoint.access$doSendSrtp((Endpoint)this.receiver, p0);
            }
        }, TransportConfig.Companion.getQueueSize());
        endpoint = this;
        boolean bl2 = false;
        ((PacketQueue)$this$outgoingSrtpPacketQueue_u24lambda_u2d1).setErrorHandler(queueErrorCounter);
        endpoint.outgoingSrtpPacketQueue = object;
        String string2 = this.getClass().getSimpleName() + "-incoming-data-channel-queue";
        ExecutorService executorService2 = TaskPools.IO_POOL;
        Intrinsics.checkNotNullExpressionValue(executorService2, "IO_POOL");
        this.incomingDataChannelMessagesQueue = new PacketInfoQueue(string2, executorService2, (Function1<? super PacketInfo, Boolean>)new Function1<PacketInfo, Boolean>(this){
            final /* synthetic */ Endpoint this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull PacketInfo packetInfo) {
                Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
                Endpoint.access$getDataChannelHandler$p(this.this$0).consume(packetInfo);
                return true;
            }
        }, TransportConfig.Companion.getQueueSize());
        BitrateController.EventHandler eventHandler = new BitrateController.EventHandler(this, conference){
            final /* synthetic */ Endpoint this$0;
            final /* synthetic */ Conference $conference;
            {
                this.this$0 = $receiver;
                this.$conference = $conference;
            }

            public void allocationChanged(@NotNull BandwidthAllocation allocation) {
                Intrinsics.checkNotNullParameter(allocation, "allocation");
            }

            public void forwardedEndpointsChanged(@NotNull Set<String> forwardedEndpoints) {
                Intrinsics.checkNotNullParameter(forwardedEndpoints, "forwardedEndpoints");
                this.this$0.sendForwardedEndpointsMessage((Collection<String>)forwardedEndpoints);
            }

            public void forwardedSourcesChanged(@NotNull Set<String> forwardedSources) {
                Intrinsics.checkNotNullParameter(forwardedSources, "forwardedSources");
                this.this$0.sendForwardedSourcesMessage((Collection<String>)forwardedSources);
            }

            public void effectiveVideoConstraintsChanged(@NotNull Map<MediaSourceDesc, VideoConstraints> oldEffectiveConstraints, @NotNull Map<MediaSourceDesc, VideoConstraints> newEffectiveConstraints) {
                Intrinsics.checkNotNullParameter(oldEffectiveConstraints, "oldEffectiveConstraints");
                Intrinsics.checkNotNullParameter(newEffectiveConstraints, "newEffectiveConstraints");
                Endpoint.access$effectiveVideoConstraintsChanged(this.this$0, oldEffectiveConstraints, newEffectiveConstraints);
            }

            public void keyframeNeeded(@Nullable String endpointId, long ssrc2) {
                this.$conference.requestKeyframe(endpointId, ssrc2);
            }
        };
        Supplier<List> supplier = () -> Endpoint.bitrateController$lambda-2(this);
        DiagnosticContext diagnosticContext2 = this.diagnosticContext;
        Intrinsics.checkNotNullExpressionValue(diagnosticContext2, "diagnosticContext");
        Logger logger3 = this.logger;
        Intrinsics.checkNotNullExpressionValue(logger3, "logger");
        this.bitrateController = new BitrateController(eventHandler, supplier, diagnosticContext2, logger3, this.isUsingSourceNames, null, 32, null);
        this._messageTransport = new EndpointMessageTransport(this, () -> Endpoint._messageTransport$lambda-3(conference), conference, this.logger);
        this.rttListener = new EndpointConnectionStats.EndpointConnectionStatsListener(this){
            final /* synthetic */ Endpoint this$0;
            {
                this.this$0 = $receiver;
            }

            public void onRttUpdate(double newRttMs) {
                if (newRttMs > 0.0) {
                    this.this$0.getTransceiver().removeEndpointConnectionStatsListener(this);
                    Endpoint.access$getIceTransport$p(this.this$0).updateStatsOnInitialRtt(newRttMs);
                }
            }
        };
        ExecutorService executorService3 = TaskPools.CPU_POOL;
        Intrinsics.checkNotNullExpressionValue(executorService3, "CPU_POOL");
        ExecutorService executorService4 = TaskPools.CPU_POOL;
        Intrinsics.checkNotNullExpressionValue(executorService4, "CPU_POOL");
        ScheduledExecutorService scheduledExecutorService = TaskPools.SCHEDULED_POOL;
        Intrinsics.checkNotNullExpressionValue(scheduledExecutorService, "SCHEDULED_POOL");
        DiagnosticContext diagnosticContext3 = this.diagnosticContext;
        Intrinsics.checkNotNullExpressionValue(diagnosticContext3, "diagnosticContext");
        Logger logger4 = this.logger;
        Intrinsics.checkNotNullExpressionValue(logger4, "logger");
        $this$outgoingSrtpPacketQueue_u24lambda_u2d1 = object = new Transceiver(id, executorService3, executorService4, scheduledExecutorService, diagnosticContext3, logger4, new TransceiverEventHandlerImpl(), this.clock);
        endpoint = this;
        boolean bl3 = false;
        ((Transceiver)$this$transceiver_u24lambda_u2d5).setIncomingPacketHandler(new ConsumerNode(this){
            final /* synthetic */ Endpoint this$0;
            {
                this.this$0 = $receiver;
                super("receiver chain handler");
            }

            protected void consume(@NotNull PacketInfo packetInfo) {
                Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
                this.this$0.handleIncomingPacket(packetInfo);
            }

            public void trace(@NotNull Function0<Unit> f) {
                Intrinsics.checkNotNullParameter(f, "f");
                f.invoke();
            }
        });
        ((Transceiver)$this$transceiver_u24lambda_u2d5).addEndpointConnectionStatsListener(this.rttListener);
        ((Transceiver)$this$transceiver_u24lambda_u2d5).setLocalSsrc(MediaType.AUDIO, conference.getLocalAudioSsrc());
        ((Transceiver)$this$transceiver_u24lambda_u2d5).setLocalSsrc(MediaType.VIDEO, conference.getLocalVideoSsrc());
        endpoint.transceiver = object;
        $this$transceiver_u24lambda_u2d5 = object = new BandwidthProbing(new BandwidthProbing.ProbingDataSender(this){
            final /* synthetic */ Endpoint this$0;
            {
                this.this$0 = $receiver;
            }

            public int sendProbing(@NotNull Collection<Long> mediaSsrcs, int numBytes) {
                Intrinsics.checkNotNullParameter(mediaSsrcs, "mediaSsrcs");
                return this.this$0.getTransceiver().sendProbing(mediaSsrcs, numBytes);
            }
        }, () -> Endpoint.bandwidthProbing$lambda-6(this));
        endpoint = this;
        boolean bl4 = false;
        ((BandwidthProbing)$this$bandwidthProbing_u24lambda_u2d7).setDiagnosticsContext(this.diagnosticContext);
        ((BandwidthProbing)$this$bandwidthProbing_u24lambda_u2d7).setEnabled(true);
        $this$bandwidthProbing_u24lambda_u2d7 = object;
        boolean bl5 = false;
        recurringRunnableExecutor.registerRecurringRunnable((RecurringRunnable)it);
        endpoint.bandwidthProbing = object;
        int n = SsrcLimitConfig.config.getMaxVideoSsrcs();
        SsrcRewriter ssrcRewriter = this;
        Logger logger5 = this.logger;
        Intrinsics.checkNotNullExpressionValue(logger5, "logger");
        this.videoSsrcs = new VideoSsrcCache(n, ssrcRewriter, logger5);
        int n2 = SsrcLimitConfig.config.getMaxAudioSsrcs();
        SsrcRewriter ssrcRewriter2 = this;
        Logger logger6 = this.logger;
        Intrinsics.checkNotNullExpressionValue(logger6, "logger");
        this.audioSsrcs = new AudioSsrcCache(n2, ssrcRewriter2, logger6);
        this.activeSources = SetsKt.emptySet();
        this.sendSsrcs = new LinkedHashSet();
        this.nextSendSsrc = 777000001L;
        conference.getEncodingsManager().subscribe(this);
        this.setupIceTransport();
        this.setupDtlsTransport();
        conference.getVideobridge().getStatistics().totalEndpoints.inc();
        if (this.visitor) {
            conference.getVideobridge().getStatistics().totalVisitors.inc();
        }
        this.logger.info("Created new endpoint isUsingSourceNames=" + this.isUsingSourceNames + ", iceControlling=" + iceControlling);
        this.audioSources = new ArrayList();
    }

    public /* synthetic */ Endpoint(String string, Conference conference, Logger logger, boolean bl, boolean bl2, boolean bl3, boolean bl4, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue(clock2, "systemUTC()");
            clock = clock2;
        }
        this(string, conference, logger, bl, bl2, bl3, bl4, clock);
    }

    public final boolean getVisitor() {
        return this.visitor;
    }

    public final Instant getCreationTime() {
        return this.creationTime;
    }

    public final boolean getAcceptAudio() {
        return this.acceptAudio;
    }

    public final void setAcceptAudio(boolean bl) {
        this.acceptAudio = bl;
    }

    public final boolean getAcceptVideo() {
        return this.acceptVideo;
    }

    public final void setAcceptVideo(boolean bl) {
        this.acceptVideo = bl;
    }

    public final boolean hasSuspendedSources() {
        return this.bitrateController.hasSuspendedSources();
    }

    @Override
    @NotNull
    public EndpointMessageTransport getMessageTransport() {
        return this._messageTransport;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AbstractEndpoint> getOrderedEndpoints() {
        void $this$filterNotTo$iv$iv;
        List<AbstractEndpoint> list = this.getConference().getOrderedEndpoints();
        Intrinsics.checkNotNullExpressionValue(list, "conference.orderedEndpoints");
        Iterable $this$filterNot$iv = list;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            AbstractEndpoint it = (AbstractEndpoint)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(it, this)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Transceiver getTransceiver() {
        return this.transceiver;
    }

    @Override
    @NotNull
    public MediaSourceDesc[] getMediaSources() {
        return this.transceiver.getMediaSources();
    }

    public void setMediaSources(@NotNull MediaSourceDesc[] value2) {
        boolean wasEmpty;
        Intrinsics.checkNotNullParameter(value2, "value");
        this.applyVideoTypeCache(value2);
        boolean bl = wasEmpty = this.transceiver.getMediaSources().length == 0;
        if (this.transceiver.setMediaSources(value2)) {
            this.eventEmitter.fireEvent(mediaSources.1.INSTANCE);
        }
        if (wasEmpty) {
            this.sendAllVideoConstraints();
        }
    }

    @NotNull
    public final ArrayList<AudioSourceDesc> getAudioSources() {
        return this.audioSources;
    }

    public final void setAudioSources(@NotNull ArrayList<AudioSourceDesc> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.audioSources = arrayList;
    }

    private final void setupIceTransport() {
        this.iceTransport.incomingDataHandler = new IceTransport.IncomingDataHandler(this){
            final /* synthetic */ Endpoint this$0;
            {
                this.this$0 = $receiver;
            }

            public void dataReceived(@NotNull byte[] data2, int offset, int length, @NotNull Instant receivedTime) {
                Intrinsics.checkNotNullParameter(data2, "data");
                Intrinsics.checkNotNullParameter(receivedTime, "receivedTime");
                if (PacketUtils.looksLikeDtls(data2, offset, length)) {
                    Endpoint.access$getDtlsTransport$p(this.this$0).dtlsDataReceived(data2, offset, length);
                } else {
                    PacketInfo packetInfo;
                    byte[] copy2 = ByteBufferPool.getBuffer(length + 10 + 20);
                    System.arraycopy(data2, offset, copy2, 10, length);
                    Intrinsics.checkNotNullExpressionValue(copy2, "copy");
                    PacketInfo $this$dataReceived_u24lambda_u2d0 = packetInfo = new PacketInfo(new UnparsedPacket(copy2, 10, length), null, 2, null);
                    boolean bl = false;
                    $this$dataReceived_u24lambda_u2d0.setReceivedTime(receivedTime);
                    PacketInfo pktInfo = packetInfo;
                    this.this$0.getTransceiver().handleIncomingPacket(pktInfo);
                }
            }
        };
        this.iceTransport.eventHandler = new IceTransport.EventHandler(this){
            final /* synthetic */ Endpoint this$0;
            {
                this.this$0 = $receiver;
            }

            public void connected() {
                this.this$0.logger.info("ICE connected");
                this.this$0.eventEmitter.fireEvent(setupIceTransport.connected.1.INSTANCE);
                this.this$0.getTransceiver().setOutgoingPacketHandler(new PacketHandler(this.this$0){
                    final /* synthetic */ Endpoint this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void processPacket(@NotNull PacketInfo packetInfo) {
                        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
                        packetInfo.addEvent("Entered Endpoint SRTP sender outgoing queue");
                        Endpoint.access$getOutgoingSrtpPacketQueue$p(this.this$0).add(packetInfo);
                    }
                });
                TaskPools.IO_POOL.execute(Endpoint.access$getIceTransport$p(this.this$0)::startReadingData);
                TaskPools.IO_POOL.execute(Endpoint.access$getDtlsTransport$p(this.this$0)::startDtlsHandshake);
            }

            public void failed() {
                this.this$0.eventEmitter.fireEvent(setupIceTransport.failed.1.INSTANCE);
            }

            public void consentUpdated(@NotNull Instant time) {
                Intrinsics.checkNotNullParameter(time, "time");
                this.this$0.getTransceiver().getPacketIOActivity().setLastIceActivityInstant(time);
            }
        };
    }

    public final boolean isInStageView() {
        return !((Collection)this.bitrateController.getAllocationSettings().getOnStageEndpoints()).isEmpty();
    }

    private final void setupDtlsTransport() {
        this.dtlsTransport.incomingDataHandler = new DtlsTransport.IncomingDataHandler(this){
            final /* synthetic */ Endpoint this$0;
            {
                this.this$0 = $receiver;
            }

            public void dtlsAppDataReceived(@NotNull byte[] buf, int off, int len) {
                Intrinsics.checkNotNullParameter(buf, "buf");
                this.this$0.dtlsAppPacketReceived(buf, off, len);
            }
        };
        this.dtlsTransport.outgoingDataHandler = new DtlsTransport.OutgoingDataHandler(this){
            final /* synthetic */ Endpoint this$0;
            {
                this.this$0 = $receiver;
            }

            public void sendData(@NotNull byte[] buf, int off, int len) {
                Intrinsics.checkNotNullParameter(buf, "buf");
                Endpoint.access$getIceTransport$p(this.this$0).send(buf, off, len);
            }
        };
        this.dtlsTransport.eventHandler = new DtlsTransport.EventHandler(this){
            final /* synthetic */ Endpoint this$0;
            {
                this.this$0 = $receiver;
            }

            public void handshakeComplete(int chosenSrtpProtectionProfile, @NotNull TlsRole tlsRole, @NotNull byte[] keyingMaterial) {
                Intrinsics.checkNotNullParameter((Object)((Object)tlsRole), "tlsRole");
                Intrinsics.checkNotNullParameter(keyingMaterial, "keyingMaterial");
                this.this$0.logger.info("DTLS handshake complete");
                this.this$0.getTransceiver().setSrtpInformation(chosenSrtpProtectionProfile, tlsRole, keyingMaterial);
                Endpoint.access$getSctpSocket$p(this.this$0).ifPresent(this.this$0::acceptSctpConnection);
                this.this$0.scheduleEndpointMessageTransportTimeout();
            }
        };
    }

    public final void updateForceMute(boolean audioForceMuted, boolean videoForceMuted) {
        this.transceiver.forceMuteAudio(audioForceMuted);
        this.transceiver.forceMuteVideo(videoForceMuted);
    }

    @Override
    public void addPayloadType(@NotNull PayloadType payloadType) {
        Intrinsics.checkNotNullParameter(payloadType, "payloadType");
        this.transceiver.addPayloadType(payloadType);
        this.bitrateController.addPayloadType(payloadType);
    }

    @Override
    public void addRtpExtension(@NotNull RtpExtension rtpExtension) {
        Intrinsics.checkNotNullParameter(rtpExtension, "rtpExtension");
        this.transceiver.addRtpExtension(rtpExtension);
    }

    public void setExtmapAllowMixed(boolean allow) {
        this.transceiver.setExtmapAllowMixed(allow);
    }

    public final void addReceiveSsrc(long ssrc2, @NotNull MediaType mediaType) {
        Intrinsics.checkNotNullParameter((Object)mediaType, "mediaType");
        Logger logger = this.logger;
        Intrinsics.checkNotNullExpressionValue(logger, "logger");
        Logger $this$cdebug$iv = logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger2 = $this$cdebug$iv;
            boolean bl = false;
            logger2.debug("Adding receive ssrc " + ssrc2 + " of type " + mediaType);
        }
        this.transceiver.addReceiveSsrc(ssrc2, mediaType);
        this.getConference().addEndpointSsrc(this, ssrc2);
    }

    @Override
    public void onNewSsrcAssociation(@NotNull String endpointId, long primarySsrc, long secondarySsrc, @NotNull SsrcAssociationType type2) {
        Intrinsics.checkNotNullParameter(endpointId, "endpointId");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        if (StringsKt.equals(endpointId, this.getId(), true)) {
            this.transceiver.addSsrcAssociation(new LocalSsrcAssociation(primarySsrc, secondarySsrc, type2));
        } else {
            this.transceiver.addSsrcAssociation(new RemoteSsrcAssociation(primarySsrc, secondarySsrc, type2));
        }
    }

    public final void setFeature(@NotNull EndpointDebugFeatures feature, boolean enabled2) {
        Intrinsics.checkNotNullParameter((Object)feature, "feature");
        if (WhenMappings.$EnumSwitchMapping$0[feature.ordinal()] == 1) {
            this.transceiver.setFeature(Features.TRANSCEIVER_PCAP_DUMP, enabled2);
        }
    }

    public final boolean isFeatureEnabled(@NotNull EndpointDebugFeatures feature) {
        Intrinsics.checkNotNullParameter((Object)feature, "feature");
        if (WhenMappings.$EnumSwitchMapping$0[feature.ordinal()] != 1) {
            throw new NoWhenBranchMatchedException();
        }
        return this.transceiver.isFeatureEnabled(Features.TRANSCEIVER_PCAP_DUMP);
    }

    @Override
    public boolean isSendingAudio() {
        return this.transceiver.isReceivingAudio();
    }

    @Override
    public boolean isSendingVideo() {
        return this.transceiver.isReceivingVideo();
    }

    private final boolean doSendSrtp(PacketInfo packetInfo) {
        packetInfo.addEvent(SRTP_QUEUE_EXIT_EVENT);
        PacketTransitStats.packetSent(packetInfo);
        packetInfo.sent();
        if (this.timelineLogger.isTraceEnabled() && Companion.logTimeline()) {
            this.timelineLogger.trace(() -> Endpoint.doSendSrtp$lambda-10(packetInfo));
        }
        Intrinsics.checkNotNullExpressionValue(packetInfo.getPacket().buffer, "packetInfo.packet.buffer");
        this.iceTransport.send(packetInfo.getPacket().buffer, packetInfo.getPacket().offset, packetInfo.getPacket().length);
        ByteBufferPool.returnBuffer(packetInfo.getPacket().buffer);
        return true;
    }

    public final void lastNEndpointsChanged() {
        this.bitrateController.endpointOrderingChanged();
    }

    @Override
    public void sendMessage(@NotNull BridgeChannelMessage msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        this.getMessageTransport().sendMessage(msg);
    }

    public final void endpointMessageTransportConnected() {
        this.sendAllVideoConstraints();
        this.videoSsrcs.sendAllMappings();
        this.audioSsrcs.sendAllMappings();
    }

    private final void sendAllVideoConstraints() {
        Map map = this.maxReceiverVideoConstraintsMap;
        Intrinsics.checkNotNullExpressionValue(map, "maxReceiverVideoConstraintsMap");
        Map $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            String sourceName = (String)entry.getKey();
            VideoConstraints constraints = (VideoConstraints)entry.getValue();
            Intrinsics.checkNotNullExpressionValue(sourceName, "sourceName");
            Intrinsics.checkNotNullExpressionValue(constraints, "constraints");
            this.sendVideoConstraintsV2(sourceName, constraints);
        }
    }

    public final void dtlsAppPacketReceived(@NotNull byte[] data2, int off, int len) {
        Intrinsics.checkNotNullParameter(data2, "data");
        this.sctpHandler.processPacket(new PacketInfo(new UnparsedPacket(data2, off, len), null, 2, null));
    }

    /*
     * WARNING - void declaration
     */
    private final void effectiveVideoConstraintsChanged(Map<MediaSourceDesc, VideoConstraints> oldEffectiveConstraints, Map<MediaSourceDesc, VideoConstraints> newEffectiveConstraints) {
        Object element$iv;
        Map<MediaSourceDesc, VideoConstraints> $this$forEach$iv;
        Collection collection;
        Iterator<Object> $this$mapTo$iv$iv;
        MediaSourceDesc it;
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = oldEffectiveConstraints.keySet();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (MediaSourceDesc)element$iv$iv;
            boolean bl = false;
            if (newEffectiveConstraints.keySet().contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List removedSources = (List)destination$iv$iv;
        Iterable $this$map$iv = removedSources;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object item$iv$iv = iterator2.next();
            it = (MediaSourceDesc)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSourceName());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        $this$mapTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$mapTo$iv$iv.hasNext()) {
            element$iv = $this$mapTo$iv$iv.next();
            String removedSourceName = (String)element$iv;
            boolean bl = false;
            AbstractEndpoint abstractEndpoint = this.getConference().findSourceOwner(removedSourceName);
            if (abstractEndpoint == null) continue;
            abstractEndpoint.removeSourceReceiver(removedSourceName, this.getId());
        }
        $this$forEach$iv = newEffectiveConstraints;
        $i$f$forEach = false;
        $this$mapTo$iv$iv = $this$forEach$iv.entrySet().iterator();
        while ($this$mapTo$iv$iv.hasNext()) {
            Object removedSourceName = element$iv = (Map.Entry)$this$mapTo$iv$iv.next();
            boolean bl = false;
            Iterator source = (MediaSourceDesc)removedSourceName.getKey();
            VideoConstraints effectiveConstraints = (VideoConstraints)removedSourceName.getValue();
            AbstractEndpoint abstractEndpoint = this.getConference().findSourceOwner(((MediaSourceDesc)((Object)source)).getSourceName());
            if (abstractEndpoint == null) continue;
            abstractEndpoint.addReceiver(this.getId(), ((MediaSourceDesc)((Object)source)).getSourceName(), effectiveConstraints);
        }
        if (this.doSsrcRewriting) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = newEffectiveConstraints.entrySet();
            boolean $i$f$filter = false;
            element$iv = $this$filter$iv;
            Iterable destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Map.Entry it2 = (Map.Entry)element$iv$iv;
                boolean bl = false;
                if (!(!((VideoConstraints)it2.getValue()).isDisabled())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                Map.Entry it2 = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add((MediaSourceDesc)it2.getKey());
            }
            List<MediaSourceDesc> newActiveSources = CollectionsKt.toList((List)destination$iv$iv2);
            Iterable $this$mapNotNull$iv = newActiveSources;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv2 = $this$mapNotNull$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl = false;
                MediaSourceDesc it3 = (MediaSourceDesc)element$iv$iv;
                boolean bl2 = false;
                if (it3.getSourceName() == null) continue;
                boolean bl3 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            Set newActiveSourceNames = CollectionsKt.toSet((List)destination$iv$iv3);
            if (!Intrinsics.areEqual(this.activeSources, newActiveSourceNames)) {
                this.activeSources = newActiveSourceNames;
                this.videoSsrcs.activate(newActiveSources);
            }
        }
    }

    @Override
    protected void sendVideoConstraints(@NotNull VideoConstraints maxVideoConstraints) {
        Intrinsics.checkNotNullParameter(maxVideoConstraints, "maxVideoConstraints");
        if (this.getMediaSources().length == 0) {
            Logger logger = this.logger;
            Intrinsics.checkNotNullExpressionValue(logger, "logger");
            Logger $this$cdebug$iv = logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger2 = $this$cdebug$iv;
                boolean bl = false;
                logger2.debug("Suppressing sending a SenderVideoConstraints message, endpoint has no streams.");
            }
        } else {
            SenderVideoConstraintsMessage senderVideoConstraintsMessage = new SenderVideoConstraintsMessage(maxVideoConstraints.getMaxHeight());
            Logger logger = this.logger;
            Intrinsics.checkNotNullExpressionValue(logger, "logger");
            Logger $this$cdebug$iv = logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger3 = $this$cdebug$iv;
                boolean bl = false;
                logger3.debug("Sender constraints changed: " + senderVideoConstraintsMessage.toJson());
            }
            this.sendMessage(senderVideoConstraintsMessage);
        }
    }

    @Override
    protected void sendVideoConstraintsV2(@NotNull String sourceName, @NotNull VideoConstraints maxVideoConstraints) {
        block4: {
            Unit unit;
            block5: {
                block3: {
                    Intrinsics.checkNotNullParameter(sourceName, "sourceName");
                    Intrinsics.checkNotNullParameter(maxVideoConstraints, "maxVideoConstraints");
                    if (this.findMediaSourceDesc(sourceName) != null) break block3;
                    this.logger.warn(() -> Endpoint.sendVideoConstraintsV2$lambda-21(sourceName));
                    break block4;
                }
                if (!this.isUsingSourceNames) break block5;
                SenderSourceConstraintsMessage senderSourceConstraintsMessage = new SenderSourceConstraintsMessage(sourceName, maxVideoConstraints.getMaxHeight());
                Logger logger = this.logger;
                Intrinsics.checkNotNullExpressionValue(logger, "logger");
                Logger $this$cdebug$iv = logger;
                boolean $i$f$cdebug = false;
                if ($this$cdebug$iv.isDebugEnabled()) {
                    Logger logger2 = $this$cdebug$iv;
                    boolean bl = false;
                    logger2.debug("Sender constraints changed: " + senderSourceConstraintsMessage.toJson());
                }
                this.sendMessage(senderSourceConstraintsMessage);
                break block4;
            }
            VideoConstraints videoConstraints = (VideoConstraints)this.maxReceiverVideoConstraintsMap.get(sourceName);
            if (videoConstraints != null) {
                VideoConstraints it = videoConstraints;
                boolean bl = false;
                this.sendVideoConstraints(it);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block4;
            this.logger.error("No max receiver constraints mapping found for: " + sourceName);
        }
    }

    public final void createSctpConnection() {
        Logger logger = this.logger;
        Intrinsics.checkNotNullExpressionValue(logger, "logger");
        Logger $this$cdebug$iv = logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger2 = $this$cdebug$iv;
            boolean bl = false;
            logger2.debug("Creating SCTP manager");
        }
        SctpManager sctpManager = this.sctpManager = new SctpManager((arg_0, arg_1, arg_2) -> Endpoint.createSctpConnection$lambda-25(this, arg_0, arg_1, arg_2), this.logger);
        Intrinsics.checkNotNull(sctpManager);
        this.sctpHandler.setSctpManager(sctpManager);
        SctpManager sctpManager2 = this.sctpManager;
        Intrinsics.checkNotNull(sctpManager2);
        SctpServerSocket socket = sctpManager2.createServerSocket();
        socket.eventHandler = new SctpSocket.SctpSocketEventHandler(this, socket){
            final /* synthetic */ Endpoint this$0;
            final /* synthetic */ SctpServerSocket $socket;
            {
                this.this$0 = $receiver;
                this.$socket = $socket;
            }

            public void onReady() {
                this.this$0.logger.info("SCTP connection is ready, creating the Data channel stack");
                Endpoint.access$setDataChannelStack$p(this.this$0, new DataChannelStack((arg_0, arg_1, arg_2) -> createSctpConnection.3.onReady$lambda-0(this.$socket, arg_0, arg_1, arg_2), this.this$0.logger));
                DataChannelStack dataChannelStack = Endpoint.access$getDataChannelStack$p(this.this$0);
                Intrinsics.checkNotNull(dataChannelStack);
                dataChannelStack.onDataChannelStackEvents(arg_0 -> createSctpConnection.3.onReady$lambda-1(this.this$0, arg_0));
                DataChannelHandler dataChannelHandler = Endpoint.access$getDataChannelHandler$p(this.this$0);
                DataChannelStack dataChannelStack2 = Endpoint.access$getDataChannelStack$p(this.this$0);
                Intrinsics.checkNotNull(dataChannelStack2);
                dataChannelHandler.setDataChannelStack(dataChannelStack2);
                this.this$0.logger.info("Will wait for the remote side to open the data channel.");
            }

            public void onDisconnected() {
                this.this$0.logger.info("SCTP connection is disconnected");
            }

            private static final int onReady$lambda-0(SctpServerSocket $socket, ByteBuffer data2, int sid, int ppid) {
                return $socket.send(data2, true, sid, ppid);
            }

            private static final void onReady$lambda-1(Endpoint this$0, DataChannel dataChannel) {
                Intrinsics.checkNotNullParameter(this$0, "this$0");
                this$0.logger.info("Remote side opened a data channel.");
                Endpoint.access$get_messageTransport$p(this$0).setDataChannel(dataChannel);
            }
        };
        socket.dataCallback = (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> Endpoint.createSctpConnection$lambda-26(this, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6);
        socket.listen();
        Optional<SctpServerSocket> optional = Optional.of(socket);
        Intrinsics.checkNotNullExpressionValue(optional, "of(socket)");
        this.sctpSocket = optional;
    }

    public final void acceptSctpConnection(@NotNull SctpServerSocket sctpServerSocket) {
        Intrinsics.checkNotNullParameter(sctpServerSocket, "sctpServerSocket");
        TaskPools.IO_POOL.execute(() -> Endpoint.acceptSctpConnection$lambda-28(this, sctpServerSocket));
    }

    public final void scheduleEndpointMessageTransportTimeout() {
        TaskPools.SCHEDULED_POOL.schedule(() -> Endpoint.scheduleEndpointMessageTransportTimeout$lambda-29(this), 30L, TimeUnit.SECONDS);
    }

    public final boolean acceptWebSocket(@NotNull String password) {
        Intrinsics.checkNotNullParameter(password, "password");
        if (!Intrinsics.areEqual(this.iceTransport.getIcePassword(), password)) {
            this.logger.warn("Incoming web socket request with an invalid password. Expected: " + this.iceTransport.getIcePassword() + " received " + password);
            return false;
        }
        return true;
    }

    @Deprecated(message="", replaceWith=@ReplaceWith(expression="sendForwardedSourcesMessage", imports={}), level=DeprecationLevel.WARNING)
    public final void sendForwardedEndpointsMessage(@NotNull Collection<String> forwardedEndpoints) {
        Intrinsics.checkNotNullParameter(forwardedEndpoints, "forwardedEndpoints");
        if (this.isUsingSourceNames) {
            return;
        }
        ForwardedEndpointsMessage msg = new ForwardedEndpointsMessage(forwardedEndpoints);
        TaskPools.IO_POOL.execute(() -> Endpoint.sendForwardedEndpointsMessage$lambda-30(this, msg));
    }

    public final void sendForwardedSourcesMessage(@NotNull Collection<String> forwardedSources) {
        Intrinsics.checkNotNullParameter(forwardedSources, "forwardedSources");
        if (!this.isUsingSourceNames) {
            return;
        }
        ForwardedSourcesMessage msg = new ForwardedSourcesMessage(forwardedSources);
        TaskPools.IO_POOL.execute(() -> Endpoint.sendForwardedSourcesMessage$lambda-31(this, msg));
    }

    public final void setTransportInfo(@NotNull IceUdpTransportPacketExtension transportInfo) {
        Intrinsics.checkNotNullParameter(transportInfo, "transportInfo");
        Map remoteFingerprints = new LinkedHashMap();
        List<DtlsFingerprintPacketExtension> fingerprintExtensions = transportInfo.getChildExtensionsOfType(DtlsFingerprintPacketExtension.class);
        Intrinsics.checkNotNullExpressionValue(fingerprintExtensions, "fingerprintExtensions");
        Iterable $this$forEach$iv = fingerprintExtensions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DtlsFingerprintPacketExtension fingerprintExtension = (DtlsFingerprintPacketExtension)element$iv;
            boolean bl = false;
            if (fingerprintExtension.getHash() != null && fingerprintExtension.getFingerprint() != null) {
                String string;
                String string2;
                Map map = remoteFingerprints;
                Intrinsics.checkNotNullExpressionValue(fingerprintExtension.getHash(), "fingerprintExtension.hash");
                Intrinsics.checkNotNullExpressionValue(fingerprintExtension.getFingerprint(), "fingerprintExtension.fingerprint");
                map.put(string2, string);
                continue;
            }
            this.logger.info("Ignoring empty DtlsFingerprint extension: " + transportInfo.toXML());
        }
        this.dtlsTransport.setRemoteFingerprints(remoteFingerprints);
        if (!((Collection)fingerprintExtensions).isEmpty()) {
            String setup = CollectionsKt.first(fingerprintExtensions).getSetup();
            this.dtlsTransport.setSetupAttribute(setup);
        }
        this.iceTransport.startConnectivityEstablishment(transportInfo);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IceUdpTransportPacketExtension describeTransport() {
        IceUdpTransportPacketExtension iceUdpTransportPacketExtension = new IceUdpTransportPacketExtension();
        this.iceTransport.describe(iceUdpTransportPacketExtension);
        this.dtlsTransport.describe(iceUdpTransportPacketExtension);
        ColibriWebSocketService colibriWebSocketService = ColibriWebSocketServiceSupplierKt.getColibriWebSocketServiceSupplier().get();
        if (colibriWebSocketService != null) {
            void $this$forEach$iv;
            ColibriWebSocketService colibriWebsocketService = colibriWebSocketService;
            boolean bl = false;
            String string = this.getConference().getID();
            Intrinsics.checkNotNullExpressionValue(string, "conference.id");
            String string2 = this.getId();
            Intrinsics.checkNotNullExpressionValue(string2, "id");
            Iterable iterable = colibriWebsocketService.getColibriWebSocketUrls(string, string2, this.iceTransport.getIcePassword());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String wsUrl = (String)element$iv;
                boolean bl2 = false;
                WebSocketPacketExtension wsPacketExtension = new WebSocketPacketExtension(wsUrl);
                iceUdpTransportPacketExtension.addChildExtension(wsPacketExtension);
            }
        }
        Logger logger = this.logger;
        Intrinsics.checkNotNullExpressionValue(logger, "logger");
        Logger $this$cdebug$iv = logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger2 = $this$cdebug$iv;
            boolean bl = false;
            logger2.debug("Transport description:\n" + iceUdpTransportPacketExtension.toXML());
        }
        return iceUdpTransportPacketExtension;
    }

    public final void handleIncomingPacket(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        if (this.visitor) {
            ByteBufferPool.returnBuffer(packetInfo.getPacket().buffer);
            return;
        }
        packetInfo.setEndpointId(this.getId());
        this.getConference().handleIncomingPacket(packetInfo);
    }

    @Override
    public boolean receivesSsrc(long ssrc2) {
        return this.transceiver.receivesSsrc(ssrc2);
    }

    public final boolean doesSsrcRewriting() {
        return this.doSsrcRewriting;
    }

    @Nullable
    public final String unmapRtcpFbSsrc(@NotNull RtcpFbPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        return this.videoSsrcs.unmapRtcpFbSsrc(packet);
    }

    @NotNull
    public HashSet<Long> getSsrcs() {
        return new HashSet<Long>((Collection)this.transceiver.getReceiveSsrcs());
    }

    @Override
    @NotNull
    public Instant getLastIncomingActivity() {
        return this.transceiver.getPacketIOActivity().getLastIncomingActivityInstant();
    }

    @Override
    public void requestKeyframe() {
        Transceiver.requestKeyFrame$default(this.transceiver, null, 1, null);
    }

    @Override
    public void requestKeyframe(long mediaSsrc) {
        this.transceiver.requestKeyFrame(mediaSsrc);
    }

    public final boolean isOversending() {
        return this.bitrateController.isOversending();
    }

    public final int numForwardedEndpoints() {
        return this.bitrateController.numForwardedEndpoints();
    }

    public final void setBandwidthAllocationSettings(@NotNull ReceiverVideoConstraintsMessage message) {
        Intrinsics.checkNotNullParameter(message, "message");
        this.bitrateController.setBandwidthAllocationSettings(message);
    }

    @Override
    @Nullable
    public MediaSourceDesc findVideoSourceProps(long ssrc2) {
        AbstractEndpoint abstractEndpoint = this.getConference().getEndpointBySsrc(ssrc2);
        if (abstractEndpoint != null) {
            AbstractEndpoint ep = abstractEndpoint;
            boolean bl = false;
            MediaSourceDesc[] $this$forEach$iv = ep.getMediaSources();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                MediaSourceDesc element$iv;
                MediaSourceDesc s2 = element$iv = $this$forEach$iv[i];
                boolean bl2 = false;
                if (s2.findRtpEncodingDesc(ssrc2) == null) continue;
                return s2;
            }
        }
        this.logger.error(() -> Endpoint.findVideoSourceProps$lambda-38(ssrc2));
        return null;
    }

    @Override
    @Nullable
    public AudioSourceDesc findAudioSourceProps(long ssrc2) {
        AbstractEndpoint abstractEndpoint = this.getConference().getEndpointBySsrc(ssrc2);
        if (abstractEndpoint != null) {
            Object v0;
            block3: {
                AbstractEndpoint ep = abstractEndpoint;
                boolean bl = false;
                if (!(ep instanceof Endpoint)) {
                    return null;
                }
                Iterable iterable = ((Endpoint)ep).audioSources;
                for (Object t : iterable) {
                    AudioSourceDesc s2 = (AudioSourceDesc)t;
                    boolean bl2 = false;
                    if (!(s2.getSsrc() == ssrc2)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            return v0;
        }
        this.logger.error(() -> Endpoint.findAudioSourceProps$lambda-41(ssrc2));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNextSendSsrc() {
        Set<Long> set = this.sendSsrcs;
        synchronized (set) {
            long l;
            long ssrc2;
            boolean bl = false;
            do {
                if (useRandomSendSsrcs) {
                    l = random.nextLong() & 0xFFFFFFFFL;
                    continue;
                }
                long l2 = this.nextSendSsrc;
                this.nextSendSsrc = l2 + 1L;
                l = l2;
            } while (!this.sendSsrcs.add(ssrc2 = l));
            long l3 = ssrc2;
            return l3;
        }
    }

    @Override
    public void send(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        Packet packet = packetInfo.getPacket();
        if (packet instanceof VideoRtpPacket) {
            if (this.bitrateController.transformRtp(packetInfo)) {
                if (this.doSsrcRewriting) {
                    boolean start;
                    boolean bl = start = !(packet instanceof ParsedVideoPacket) || ((ParsedVideoPacket)packet).isKeyframe() && ((ParsedVideoPacket)packet).isStartOfFrame();
                    if (!this.videoSsrcs.rewriteRtp((RtpPacket)packet, start)) {
                        return;
                    }
                }
                this.transceiver.sendPacket(packetInfo);
            } else {
                this.logger.warn("Dropping a packet which was supposed to be accepted:" + packet);
            }
            return;
        }
        if (packet instanceof AudioRtpPacket) {
            if (this.doSsrcRewriting) {
                SsrcCache.rewriteRtp$default(this.audioSsrcs, (RtpPacket)packet, false, 2, null);
            }
        } else if (packet instanceof RtcpSrPacket) {
            this.bitrateController.transformRtcp((RtcpSrPacket)packet);
            if (this.doSsrcRewriting && !this.videoSsrcs.rewriteRtcp((RtcpPacket)packet) && !this.audioSsrcs.rewriteRtcp((RtcpPacket)packet)) {
                return;
            }
            this.logger.trace(() -> Endpoint.send$lambda-43(packet));
        }
        this.transceiver.sendPacket(packetInfo);
    }

    @Override
    public boolean shouldExpire() {
        if (this.iceTransport.hasFailed()) {
            this.logger.warn("Allowing to expire because ICE failed.");
            return true;
        }
        Instant lastActivity = this.getLastIncomingActivity();
        Instant now = this.clock.instant();
        if (Intrinsics.areEqual(lastActivity, ClockUtils.NEVER)) {
            Duration timeSinceCreation = Duration.between(this.creationTime, now);
            if (timeSinceCreation.compareTo(epTimeout) > 0) {
                this.logger.info("Endpoint's ICE connection has neither failed nor connected after " + timeSinceCreation + " expiring");
                return true;
            }
            return false;
        }
        Duration expireTimeout = VideobridgeExpireThreadConfig.config.getInactivityTimeout();
        if (Duration.between(lastActivity, now).compareTo(expireTimeout) > 0) {
            this.logger.info("Allowing to expire because of no activity in over " + expireTimeout);
            return true;
        }
        return false;
    }

    public final void setLastN(int lastN) {
        this.bitrateController.setLastN(lastN);
    }

    private final boolean isTransportConnected() {
        return this.iceTransport.isConnected() && this.dtlsTransport.isConnected();
    }

    public final double getRtt() {
        return this.transceiver.getTransceiverStats().getEndpointConnectionStats().getRtt();
    }

    @Override
    public boolean wants(@NotNull PacketInfo packetInfo) {
        boolean bl;
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        if (!this.isTransportConnected()) {
            return false;
        }
        Packet packet = packetInfo.getPacket();
        if (packet instanceof VideoRtpPacket) {
            bl = this.acceptVideo && this.bitrateController.accept(packetInfo);
        } else if (packet instanceof AudioRtpPacket) {
            bl = this.acceptAudio;
        } else if (packet instanceof RtcpSrPacket) {
            bl = this.bitrateController.accept((RtcpSrPacket)packet);
        } else if (packet instanceof RtcpFbPliPacket ? true : packet instanceof RtcpFbFirPacket) {
            bl = true;
        } else {
            this.logger.warn("Ignoring an unknown packet type:" + packet.getClass().getSimpleName());
            bl = false;
        }
        return bl;
    }

    public final boolean wantsStatsFrom(@NotNull AbstractEndpoint ep) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(ep, "ep");
            if (this.getConference().getEndpointCount() <= Endpoint.Companion.getStatsFilterThreshold()) {
                return true;
            }
            this.logger.debug(() -> Endpoint.wantsStatsFrom$lambda-46(ep, this));
            if (this.getConference().getSpeechActivity().isRecentSpeaker(ep) || this.getConference().isRankedSpeaker(ep)) {
                return true;
            }
            MediaSourceDesc[] $this$any$iv = ep.getMediaSources();
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                MediaSourceDesc element$iv;
                MediaSourceDesc source = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                boolean bl3 = this.bitrateController.isOnStageOrSelected(source) || this.bitrateController.hasNonZeroEffectiveConstraints(source);
                if (!bl3) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateStatsOnExpire() {
        void $this$filterTo$iv$iv;
        Conference.Statistics conferenceStats = this.getConference().getStatistics();
        TransceiverStats transceiverStats = this.transceiver.getTransceiverStats();
        Object object = conferenceStats;
        Conference.Statistics $this$updateStatsOnExpire_u24lambda_u2d48 = object;
        boolean bl = false;
        PacketStreamStats.Snapshot incomingStats = transceiverStats.getRtpReceiverStats().getPacketStreamStats();
        PacketStreamStats.Snapshot outgoingStats = transceiverStats.getOutgoingPacketStreamStats();
        $this$updateStatsOnExpire_u24lambda_u2d48.totalBytesReceived.addAndGet(incomingStats.getBytes());
        $this$updateStatsOnExpire_u24lambda_u2d48.totalPacketsReceived.addAndGet(incomingStats.getPackets());
        $this$updateStatsOnExpire_u24lambda_u2d48.totalBytesSent.addAndGet(outgoingStats.getBytes());
        $this$updateStatsOnExpire_u24lambda_u2d48.totalPacketsSent.addAndGet(outgoingStats.getPackets());
        Object $this$updateStatsOnExpire_u24lambda_u2d51 = object = this.getConference().getVideobridge().getStatistics();
        boolean bl2 = false;
        BandwidthEstimator.StatisticsSnapshot bweStats = transceiverStats.getBandwidthEstimatorStats();
        Number number = bweStats.getNumber("incomingEstimateExpirations");
        if (number != null) {
            long it = number.longValue();
            boolean bl3 = false;
            ((Videobridge.Statistics)$this$updateStatsOnExpire_u24lambda_u2d51).incomingBitrateExpirations.addAndGet(it);
        }
        ((Videobridge.Statistics)$this$updateStatsOnExpire_u24lambda_u2d51).keyframesReceived.addAndGet(transceiverStats.getRtpReceiverStats().getVideoParserStats().getNumKeyframes());
        ((Videobridge.Statistics)$this$updateStatsOnExpire_u24lambda_u2d51).layeringChangesReceived.addAndGet(transceiverStats.getRtpReceiverStats().getVideoParserStats().getNumLayeringChanges());
        Iterable $this$filter$iv = transceiverStats.getRtpReceiverStats().getIncomingStats().getSsrcStats().values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IncomingSsrcStats.Snapshot it = (IncomingSsrcStats.Snapshot)element$iv$iv;
            boolean bl4 = false;
            if (!(it.getMediaType() == MediaType.VIDEO)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Duration durationActiveVideo2 = ClockUtils.sumOf((List)destination$iv$iv, updateStatsOnExpire.2.durationActiveVideo.2.INSTANCE);
        ((Videobridge.Statistics)$this$updateStatsOnExpire_u24lambda_u2d51).totalVideoStreamMillisecondsReceived.addAndGet(durationActiveVideo2.toMillis());
        Endpoint $this$updateStatsOnExpire_u24lambda_u2d53 = this;
        boolean bl5 = false;
        bweStats = transceiverStats.getBandwidthEstimatorStats();
        Number number2 = bweStats.getNumber("lossLimitedMs");
        if (number2 == null) {
        } else {
            long lossLimitedMs = number2.longValue();
            Number number3 = bweStats.getNumber("lossDegradedMs");
            if (number3 == null) {
            } else {
                long lossDegradedMs = number3.longValue();
                Number number4 = bweStats.getNumber("lossFreeMs");
                if (number4 == null) {
                } else {
                    Videobridge.Statistics statistics;
                    long lossFreeMs = number4.longValue();
                    long participantMs = lossFreeMs + lossDegradedMs + lossLimitedMs;
                    Videobridge.Statistics $this$updateStatsOnExpire_u24lambda_u2d53_u24lambda_u2d52 = statistics = $this$updateStatsOnExpire_u24lambda_u2d53.getConference().getVideobridge().getStatistics();
                    boolean bl6 = false;
                    $this$updateStatsOnExpire_u24lambda_u2d53_u24lambda_u2d52.totalLossControlledParticipantMs.addAndGet(participantMs);
                    $this$updateStatsOnExpire_u24lambda_u2d53_u24lambda_u2d52.totalLossLimitedParticipantMs.addAndGet(lossLimitedMs);
                    $this$updateStatsOnExpire_u24lambda_u2d53_u24lambda_u2d52.totalLossDegradedParticipantMs.addAndGet(lossDegradedMs);
                }
            }
        }
        if (this.iceTransport.isConnected() && !this.dtlsTransport.isConnected()) {
            this.logger.info("Expiring an endpoint with ICE connected, but not DTLS.");
            conferenceStats.dtlsFailedEndpoints.incrementAndGet();
        }
    }

    @Override
    @NotNull
    public JSONObject getDebugState() {
        JSONObject jSONObject;
        JSONObject $this$getDebugState_u24lambda_u2d54 = jSONObject = super.getDebugState();
        boolean bl = false;
        $this$getDebugState_u24lambda_u2d54.put("bitrateController", this.bitrateController.getDebugState());
        $this$getDebugState_u24lambda_u2d54.put("bandwidthProbing", this.bandwidthProbing.getDebugState());
        $this$getDebugState_u24lambda_u2d54.put("iceTransport", this.iceTransport.getDebugState());
        $this$getDebugState_u24lambda_u2d54.put("dtlsTransport", this.dtlsTransport.getDebugState());
        $this$getDebugState_u24lambda_u2d54.put("transceiver", this.transceiver.getNodeStats().toJson());
        $this$getDebugState_u24lambda_u2d54.put("acceptAudio", this.acceptAudio);
        $this$getDebugState_u24lambda_u2d54.put("acceptVideo", this.acceptVideo);
        $this$getDebugState_u24lambda_u2d54.put("visitor", this.visitor);
        $this$getDebugState_u24lambda_u2d54.put("messageTransport", this.getMessageTransport().getDebugState());
        if (this.doSsrcRewriting) {
            $this$getDebugState_u24lambda_u2d54.put("audioSsrcs", this.audioSsrcs.getDebugState());
            $this$getDebugState_u24lambda_u2d54.put("videoSsrcs", this.videoSsrcs.getDebugState());
        }
        JSONObject jSONObject2 = jSONObject;
        Intrinsics.checkNotNullExpressionValue(jSONObject2, "super.getDebugState().ap\u2026)\n            }\n        }");
        return jSONObject2;
    }

    @Override
    public void expire() {
        if (super.isExpired()) {
            return;
        }
        super.expire();
        try {
            Logger logger;
            this.bitrateController.expire();
            this.updateStatsOnExpire();
            this.transceiver.stop();
            Logger logger2 = this.logger;
            Intrinsics.checkNotNullExpressionValue(logger2, "logger");
            Logger $this$cdebug$iv = logger2;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug(this.transceiver.getNodeStats().prettyPrint(0));
            }
            Logger logger3 = this.logger;
            Intrinsics.checkNotNullExpressionValue(logger3, "logger");
            $this$cdebug$iv = logger3;
            $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                logger = $this$cdebug$iv;
                boolean bl = false;
                String string = this.bitrateController.getDebugState().toJSONString();
                Intrinsics.checkNotNullExpressionValue(string, "bitrateController.debugState.toJSONString()");
                logger.debug(string);
            }
            Logger logger4 = this.logger;
            Intrinsics.checkNotNullExpressionValue(logger4, "logger");
            $this$cdebug$iv = logger4;
            $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug(this.iceTransport.getDebugState().toJSONString());
            }
            Logger logger5 = this.logger;
            Intrinsics.checkNotNullExpressionValue(logger5, "logger");
            $this$cdebug$iv = logger5;
            $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug(this.dtlsTransport.getDebugState().toJSONString());
            }
            this.logger.info("Spent " + this.bitrateController.getTotalOversendingTime().getSeconds() + " seconds oversending");
            this.transceiver.teardown();
            this._messageTransport.close();
            this.sctpHandler.stop();
            SctpManager sctpManager = this.sctpManager;
            if (sctpManager != null) {
                sctpManager.closeConnection();
            }
        }
        catch (Throwable t) {
            this.logger.error("Exception while expiring: ", t);
        }
        this.bandwidthProbing.setEnabled(false);
        recurringRunnableExecutor.deRegisterRecurringRunnable(this.bandwidthProbing);
        this.getConference().getEncodingsManager().unsubscribe(this);
        this.dtlsTransport.stop();
        this.iceTransport.stop();
        this.outgoingSrtpPacketQueue.close();
        this.logger.info("Expired.");
    }

    @JvmOverloads
    public Endpoint(@NotNull String id, @NotNull Conference conference, @NotNull Logger parentLogger, boolean iceControlling, boolean isUsingSourceNames, boolean doSsrcRewriting, boolean visitor2) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(conference, "conference");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        this(id, conference, parentLogger, iceControlling, isUsingSourceNames, doSsrcRewriting, visitor2, null, 128, null);
    }

    private static final List bitrateController$lambda-2(Endpoint this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return this$0.getOrderedEndpoints();
    }

    private static final Videobridge.Statistics _messageTransport$lambda-3(Conference $conference) {
        Intrinsics.checkNotNullParameter($conference, "$conference");
        return $conference.getVideobridge().getStatistics();
    }

    private static final BitrateControllerStatusSnapshot bandwidthProbing$lambda-6(Endpoint this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return this$0.bitrateController.getStatusSnapshot();
    }

    private static final String doSendSrtp$lambda-10(PacketInfo $packetInfo) {
        Intrinsics.checkNotNullParameter($packetInfo, "$packetInfo");
        return $packetInfo.getTimeline().toString();
    }

    private static final String sendVideoConstraintsV2$lambda-21(String $sourceName) {
        Intrinsics.checkNotNullParameter($sourceName, "$sourceName");
        return "Suppressing sending a SenderVideoConstraints message, endpoint has no such source: " + $sourceName;
    }

    private static final int createSctpConnection$lambda-25(Endpoint this$0, byte[] data2, int offset, int length) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        DtlsTransport dtlsTransport = this$0.dtlsTransport;
        Intrinsics.checkNotNullExpressionValue(data2, "data");
        dtlsTransport.sendDtlsData(data2, offset, length);
        return 0;
    }

    private static final void createSctpConnection$lambda-26(Endpoint this$0, byte[] data2, int sid, int ssn, int tsn, long ppid, int context, int flags) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        DataChannelPacket dataChannelPacket = new DataChannelPacket(data2, 0, data2.length, sid, (int)ppid);
        this$0.incomingDataChannelMessagesQueue.add(new PacketInfo(dataChannelPacket, null, 2, null));
    }

    private static final void acceptSctpConnection$lambda-28(Endpoint this$0, SctpServerSocket $sctpServerSocket) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($sctpServerSocket, "$sctpServerSocket");
        this$0.logger.info("Attempting to establish SCTP socket connection");
        int attempts = 0;
        while (!$sctpServerSocket.accept()) {
            ++attempts;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                break;
            }
            if (attempts <= 100) continue;
            this$0.logger.error("Timed out waiting for SCTP connection from remote side");
            break;
        }
        Logger logger = this$0.logger;
        Intrinsics.checkNotNullExpressionValue(logger, "logger");
        Logger $this$cdebug$iv = logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger2 = $this$cdebug$iv;
            boolean bl = false;
            logger2.debug("SCTP socket " + $sctpServerSocket.hashCode() + " accepted connection");
        }
    }

    private static final void scheduleEndpointMessageTransportTimeout$lambda-29(Endpoint this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        if (!this$0.isExpired() && !this$0.getMessageTransport().isConnected()) {
            this$0.logger.error("EndpointMessageTransport still not connected.");
            this$0.getConference().getVideobridge().getStatistics().numEndpointsNoMessageTransportAfterDelay.inc();
        }
    }

    private static final void sendForwardedEndpointsMessage$lambda-30(Endpoint this$0, ForwardedEndpointsMessage $msg) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($msg, "$msg");
        try {
            this$0.sendMessage($msg);
        }
        catch (Throwable t) {
            this$0.logger.warn("Failed to send message:", t);
        }
    }

    private static final void sendForwardedSourcesMessage$lambda-31(Endpoint this$0, ForwardedSourcesMessage $msg) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($msg, "$msg");
        try {
            this$0.sendMessage($msg);
        }
        catch (Throwable t) {
            this$0.logger.warn("Failed to send message:", t);
        }
    }

    private static final String findVideoSourceProps$lambda-38(long $ssrc) {
        return "No properties found for SSRC " + $ssrc + ".";
    }

    private static final String findAudioSourceProps$lambda-41(long $ssrc) {
        return "No properties found for SSRC " + $ssrc + ".";
    }

    private static final String send$lambda-43(Packet $packet) {
        Intrinsics.checkNotNullParameter($packet, "$packet");
        return "relaying an sr from ssrc=" + ((RtcpSrPacket)$packet).getSenderSsrc() + ", timestamp=" + ((RtcpSrPacket)$packet).getSenderInfo().getRtpTimestamp();
    }

    private static final String wantsStatsFrom$lambda-46(AbstractEndpoint $ep, Endpoint this$0) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($ep, "$ep");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        StringBuilder $this$wantsStatsFrom_u24lambda_u2d46_u24lambda_u2d45 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$wantsStatsFrom_u24lambda_u2d46_u24lambda_u2d45.append("wantsStatsFrom(" + $ep.getId() + "): isRecentSpeaker=" + this$0.getConference().getSpeechActivity().isRecentSpeaker($ep) + " ");
        $this$wantsStatsFrom_u24lambda_u2d46_u24lambda_u2d45.append("isRankedSpeaker=" + this$0.getConference().isRankedSpeaker($ep) + " ");
        if ($ep.getMediaSources().length == 0) {
            $this$wantsStatsFrom_u24lambda_u2d46_u24lambda_u2d45.append("(no media sources)");
        }
        MediaSourceDesc[] $this$forEach$iv = $ep.getMediaSources();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            MediaSourceDesc element$iv;
            MediaSourceDesc source = element$iv = $this$forEach$iv[i];
            boolean bl2 = false;
            String name = source.getSourceName();
            $this$wantsStatsFrom_u24lambda_u2d46_u24lambda_u2d45.append("isOnStageOrSelected(" + name + ")=" + this$0.bitrateController.isOnStageOrSelected(source) + " ");
            $this$wantsStatsFrom_u24lambda_u2d46_u24lambda_u2d45.append("hasNonZeroEffectiveConstraints(" + name + ")=");
            $this$wantsStatsFrom_u24lambda_u2d46_u24lambda_u2d45.append(this$0.bitrateController.hasNonZeroEffectiveConstraints(source) + " ");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public static final /* synthetic */ DtlsTransport access$getDtlsTransport$p(Endpoint $this) {
        return $this.dtlsTransport;
    }

    public static final /* synthetic */ PacketInfoQueue access$getOutgoingSrtpPacketQueue$p(Endpoint $this) {
        return $this.outgoingSrtpPacketQueue;
    }

    public static final /* synthetic */ IceTransport access$getIceTransport$p(Endpoint $this) {
        return $this.iceTransport;
    }

    public static final /* synthetic */ Optional access$getSctpSocket$p(Endpoint $this) {
        return $this.sctpSocket;
    }

    public static final /* synthetic */ void access$setDataChannelStack$p(Endpoint $this, DataChannelStack dataChannelStack) {
        $this.dataChannelStack = dataChannelStack;
    }

    public static final /* synthetic */ DataChannelStack access$getDataChannelStack$p(Endpoint $this) {
        return $this.dataChannelStack;
    }

    public static final /* synthetic */ DataChannelHandler access$getDataChannelHandler$p(Endpoint $this) {
        return $this.dataChannelHandler;
    }

    public static final /* synthetic */ EndpointMessageTransport access$get_messageTransport$p(Endpoint $this) {
        return $this._messageTransport;
    }

    public static final /* synthetic */ boolean access$doSendSrtp(Endpoint $this, PacketInfo packetInfo) {
        return $this.doSendSrtp(packetInfo);
    }

    public static final /* synthetic */ void access$effectiveVideoConstraintsChanged(Endpoint $this, Map oldEffectiveConstraints, Map newEffectiveConstraints) {
        $this.effectiveVideoConstraintsChanged(oldEffectiveConstraints, newEffectiveConstraints);
    }

    static {
        SupplierBuilder supplierBuilder;
        Companion = new Companion(null);
        queueErrorCounter = new CountingErrorHandler();
        recurringRunnableExecutor = new RecurringRunnableExecutor(Endpoint.class.getSimpleName());
        epTimeout = DurationKt.getMins(2);
        timelineCounter = new AtomicLong();
        TIMELINE_FRACTION = 10000L;
        boolean $i$f$config = false;
        SupplierBuilder $this$statsFilterThreshold_delegate_u24lambda_u2d59 = supplierBuilder = new SupplierBuilder(Reflection.typeOf(Integer.TYPE));
        boolean bl = false;
        $this$statsFilterThreshold_delegate_u24lambda_u2d59.from("videobridge.stats-filter-threshold", JitsiConfig.Companion.getNewConfig());
        SupplierBuilder supplierBuilder$iv = supplierBuilder;
        statsFilterThreshold$delegate = supplierBuilder$iv.getSuppliers().size() == 1 ? new ConfigDelegate(CollectionsKt.first(supplierBuilder$iv.getSuppliers())) : new ConfigDelegate(new FallbackSupplier(supplierBuilder$iv.getSuppliers()));
        useRandomSendSsrcs = true;
        random = new SecureRandom();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001b\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jitsi/videobridge/Endpoint$Companion;", "", "()V", "SRTP_QUEUE_ENTRY_EVENT", "", "SRTP_QUEUE_EXIT_EVENT", "TIMELINE_FRACTION", "", "epTimeout", "Ljava/time/Duration;", "openDataChannelLocally", "", "queueErrorCounter", "Lorg/jitsi/utils/queue/CountingErrorHandler;", "random", "Ljava/security/SecureRandom;", "recurringRunnableExecutor", "Lorg/jitsi/utils/concurrent/RecurringRunnableExecutor;", "statsFilterThreshold", "", "getStatsFilterThreshold", "()I", "statsFilterThreshold$delegate", "Lorg/jitsi/metaconfig/ConfigDelegate;", "timelineCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "useRandomSendSsrcs", "logTimeline", "jitsi-videobridge"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        public final boolean logTimeline() {
            return timelineCounter.getAndIncrement() % TIMELINE_FRACTION == 0L;
        }

        private final int getStatsFilterThreshold() {
            return ((Number)statsFilterThreshold$delegate.getValue(this, $$delegatedProperties[0])).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Companion.class, "statsFilterThreshold", "getStatsFilterThreshold()I", 0))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u001d\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\f\u0010\r\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u000e"}, d2={"Lorg/jitsi/videobridge/Endpoint$TransceiverEventHandlerImpl;", "Lorg/jitsi/nlj/TransceiverEventHandler;", "(Lorg/jitsi/videobridge/Endpoint;)V", "audioLevelReceived", "", "sourceSsrc", "", "level", "bandwidthEstimationChanged", "", "newValue", "Lorg/jitsi/nlj/util/Bandwidth;", "bandwidthEstimationChanged-_2icLw0", "(D)V", "jitsi-videobridge"})
    private final class TransceiverEventHandlerImpl
    implements TransceiverEventHandler {
        @Override
        public boolean audioLevelReceived(long sourceSsrc, long level) {
            return Endpoint.this.getConference().levelChanged(Endpoint.this, level);
        }

        @Override
        public void bandwidthEstimationChanged-_2icLw0(double newValue) {
            Logger logger = Endpoint.this.logger;
            Intrinsics.checkNotNullExpressionValue(logger, "logger");
            Logger $this$cdebug$iv = logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger2 = $this$cdebug$iv;
                boolean bl = false;
                logger2.debug("Estimated bandwidth is now " + Bandwidth.toString-impl(newValue));
            }
            Endpoint.this.bitrateController.bandwidthChanged((long)newValue);
            Endpoint.this.bandwidthProbing.bandwidthEstimationChanged-_2icLw0(newValue);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u000e\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jitsi/videobridge/Endpoint$DataChannelHandler;", "Lorg/jitsi/nlj/transform/node/ConsumerNode;", "()V", "cachedDataChannelPackets", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lorg/jitsi/nlj/PacketInfo;", "dataChannelStack", "Lorg/jitsi/videobridge/datachannel/DataChannelStack;", "dataChannelStackLock", "", "consume", "", "packetInfo", "setDataChannelStack", "trace", "f", "Lkotlin/Function0;", "jitsi-videobridge"})
    private static final class DataChannelHandler
    extends ConsumerNode {
        @NotNull
        private final Object dataChannelStackLock = new Object();
        @Nullable
        private DataChannelStack dataChannelStack;
        @NotNull
        private final LinkedBlockingQueue<PacketInfo> cachedDataChannelPackets = new LinkedBlockingQueue();

        public DataChannelHandler() {
            super("Data channel handler");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void consume(@NotNull PacketInfo packetInfo) {
            Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
            Object object = this.dataChannelStackLock;
            synchronized (object) {
                Object object2;
                boolean bl = false;
                Packet packet = packetInfo.getPacket();
                if (packet instanceof DataChannelPacket) {
                    DataChannelStack dataChannelStack = this.dataChannelStack;
                    if (dataChannelStack != null) {
                        dataChannelStack.onIncomingDataChannelPacket(ByteBuffer.wrap(packet.buffer), ((DataChannelPacket)packet).sid, ((DataChannelPacket)packet).ppid);
                        object2 = Unit.INSTANCE;
                    } else {
                        DataChannelHandler $this$consume_u24lambda_u2d1_u24lambda_u2d0 = this;
                        boolean bl2 = false;
                        object2 = $this$consume_u24lambda_u2d1_u24lambda_u2d0.cachedDataChannelPackets.add(packetInfo);
                    }
                } else {
                    object2 = Unit.INSTANCE;
                }
                Unit unit = object2;
            }
        }

        public final void setDataChannelStack(@NotNull DataChannelStack dataChannelStack) {
            Intrinsics.checkNotNullParameter(dataChannelStack, "dataChannelStack");
            TaskPools.IO_POOL.execute(() -> DataChannelHandler.setDataChannelStack$lambda-4(this, dataChannelStack));
        }

        @Override
        public void trace(@NotNull Function0<Unit> f) {
            Intrinsics.checkNotNullParameter(f, "f");
            f.invoke();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void setDataChannelStack$lambda-4(DataChannelHandler this$0, DataChannelStack $dataChannelStack) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            Intrinsics.checkNotNullParameter($dataChannelStack, "$dataChannelStack");
            Object object = this$0.dataChannelStackLock;
            synchronized (object) {
                boolean bl = false;
                this$0.dataChannelStack = $dataChannelStack;
                Iterable $this$forEach$iv = this$0.cachedDataChannelPackets;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PacketInfo it = (PacketInfo)element$iv;
                    boolean bl2 = false;
                    DataChannelPacket dcp = (DataChannelPacket)it.getPacket();
                    $dataChannelStack.onIncomingDataChannelPacket(ByteBuffer.wrap(dcp.buffer), dcp.sid, dcp.ppid);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0012\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0014H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jitsi/videobridge/Endpoint$SctpHandler;", "Lorg/jitsi/nlj/transform/node/ConsumerNode;", "()V", "cachedSctpPackets", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lorg/jitsi/nlj/PacketInfo;", "numCachedSctpPackets", "Ljava/util/concurrent/atomic/AtomicLong;", "sctpManager", "Lorg/jitsi/videobridge/sctp/SctpManager;", "sctpManagerLock", "", "consume", "", "packetInfo", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "setSctpManager", "trace", "f", "Lkotlin/Function0;", "jitsi-videobridge"})
    private static final class SctpHandler
    extends ConsumerNode {
        @NotNull
        private final Object sctpManagerLock = new Object();
        @Nullable
        private SctpManager sctpManager;
        @NotNull
        private final AtomicLong numCachedSctpPackets = new AtomicLong(0L);
        @NotNull
        private final LinkedBlockingQueue<PacketInfo> cachedSctpPackets = new LinkedBlockingQueue(100);

        public SctpHandler() {
            super("SCTP handler");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void consume(@NotNull PacketInfo packetInfo) {
            Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
            Object object = this.sctpManagerLock;
            synchronized (object) {
                boolean bl = false;
                if (SctpConfig.config.getEnabled()) {
                    SctpManager sctpManager = this.sctpManager;
                    if (sctpManager != null) {
                        sctpManager.handleIncomingSctp(packetInfo);
                    } else {
                        SctpHandler $this$consume_u24lambda_u2d1_u24lambda_u2d0 = this;
                        boolean bl2 = false;
                        $this$consume_u24lambda_u2d1_u24lambda_u2d0.numCachedSctpPackets.incrementAndGet();
                        $this$consume_u24lambda_u2d1_u24lambda_u2d0.cachedSctpPackets.add(packetInfo);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        @Override
        @NotNull
        public NodeStatsBlock getNodeStats() {
            NodeStatsBlock nodeStatsBlock;
            NodeStatsBlock $this$getNodeStats_u24lambda_u2d2 = nodeStatsBlock = super.getNodeStats();
            boolean bl = false;
            $this$getNodeStats_u24lambda_u2d2.addNumber("num_cached_packets", this.numCachedSctpPackets.get());
            return nodeStatsBlock;
        }

        public final void setSctpManager(@NotNull SctpManager sctpManager) {
            Intrinsics.checkNotNullParameter(sctpManager, "sctpManager");
            TaskPools.IO_POOL.execute(() -> SctpHandler.setSctpManager$lambda-5(this, sctpManager));
        }

        @Override
        public void trace(@NotNull Function0<Unit> f) {
            Intrinsics.checkNotNullParameter(f, "f");
            f.invoke();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void setSctpManager$lambda-5(SctpHandler this$0, SctpManager $sctpManager) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            Intrinsics.checkNotNullParameter($sctpManager, "$sctpManager");
            Object object = this$0.sctpManagerLock;
            synchronized (object) {
                boolean bl = false;
                this$0.sctpManager = $sctpManager;
                Iterable $this$forEach$iv = this$0.cachedSctpPackets;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PacketInfo it = (PacketInfo)element$iv;
                    boolean bl2 = false;
                    $sctpManager.handleIncomingSctp(it);
                }
                this$0.cachedSctpPackets.clear();
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EndpointDebugFeatures.values().length];
            nArray[EndpointDebugFeatures.PCAP_DUMP.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

