/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.vp9;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.codec.vpx.PictureIdIndexTracker;
import org.jitsi.nlj.rtp.codec.vp9.Vp9Packet;
import org.jitsi.nlj.util.ArrayCache;
import org.jitsi.videobridge.cc.vp9.Vp9Frame;
import org.jitsi.videobridge.cc.vp9.Vp9Picture;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0014J>\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004H\u0002J$\u0010\"\u001a\u0004\u0018\u00010\u001a2\u0006\u0010#\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001d0\u001cJ$\u0010$\u001a\u0004\u0018\u00010\u001a2\u0006\u0010#\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001d0\u001cJ\u0013\u0010%\u001a\u0004\u0018\u00010\u00022\u0006\u0010&\u001a\u00020\u0004H\u0086\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010\u00022\u0006\u0010(\u001a\u00020\u0004H\u0002J\u0010\u0010)\u001a\u0004\u0018\u00010\u00022\u0006\u0010*\u001a\u00020+R\u001a\u0010\u0006\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0005R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\b\"\u0004\b\u0015\u0010\u0005\u00a8\u0006,"}, d2={"Lorg/jitsi/videobridge/cc/vp9/PictureHistory;", "Lorg/jitsi/nlj/util/ArrayCache;", "Lorg/jitsi/videobridge/cc/vp9/Vp9Picture;", "size", "", "(I)V", "firstIndex", "getFirstIndex", "()I", "setFirstIndex", "indexTracker", "Lorg/jitsi/nlj/codec/vpx/PictureIdIndexTracker;", "getIndexTracker", "()Lorg/jitsi/nlj/codec/vpx/PictureIdIndexTracker;", "setIndexTracker", "(Lorg/jitsi/nlj/codec/vpx/PictureIdIndexTracker;)V", "latestPicture", "getLatestPicture", "()Lorg/jitsi/videobridge/cc/vp9/Vp9Picture;", "numCached", "getNumCached", "setNumCached", "discardItem", "", "item", "doFind", "Lorg/jitsi/videobridge/cc/vp9/Vp9Frame;", "pred", "Lkotlin/Function1;", "", "startIndex", "endIndex", "startLayer", "increment", "findAfter", "frame", "findBefore", "get", "pictureId", "getIndex", "index", "insert", "packet", "Lorg/jitsi/nlj/rtp/codec/vp9/Vp9Packet;", "jitsi-videobridge"})
public final class PictureHistory
extends ArrayCache<Vp9Picture> {
    private int numCached;
    private int firstIndex = -1;
    @NotNull
    private PictureIdIndexTracker indexTracker = new PictureIdIndexTracker();

    public PictureHistory(int size) {
        super(size, 1.INSTANCE, false, null, 8, null);
    }

    public final int getNumCached() {
        return this.numCached;
    }

    public final void setNumCached(int n) {
        this.numCached = n;
    }

    public final int getFirstIndex() {
        return this.firstIndex;
    }

    public final void setFirstIndex(int n) {
        this.firstIndex = n;
    }

    @NotNull
    public final PictureIdIndexTracker getIndexTracker() {
        return this.indexTracker;
    }

    public final void setIndexTracker(@NotNull PictureIdIndexTracker pictureIdIndexTracker) {
        Intrinsics.checkNotNullParameter(pictureIdIndexTracker, "<set-?>");
        this.indexTracker = pictureIdIndexTracker;
    }

    @Nullable
    public final Vp9Picture get(int pictureId) {
        int index = this.indexTracker.interpret(pictureId);
        return this.getIndex(index);
    }

    private final Vp9Picture getIndex(int index) {
        if (index <= this.getLastIndex() - this.getSize()) {
            return null;
        }
        ArrayCache.Container container = ArrayCache.getContainer$default(this, index, false, 2, null);
        if (container == null) {
            return null;
        }
        ArrayCache.Container c = container;
        return (Vp9Picture)c.getItem();
    }

    @Nullable
    public final Vp9Picture getLatestPicture() {
        return this.getIndex(this.getLastIndex());
    }

    @Nullable
    public final Vp9Picture insert(@NotNull Vp9Packet packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        int pictureId = packet.getPictureId();
        int index = this.indexTracker.update(pictureId);
        Vp9Picture picture = new Vp9Picture(packet, index);
        boolean inserted = super.insertItem(picture, index);
        if (inserted) {
            int n = this.numCached;
            this.numCached = n + 1;
            if (this.firstIndex == -1 || index < this.firstIndex) {
                this.firstIndex = index;
            }
            return picture;
        }
        return null;
    }

    @Override
    protected void discardItem(@NotNull Vp9Picture item) {
        Intrinsics.checkNotNullParameter(item, "item");
        int n = this.numCached;
        this.numCached = n + -1;
    }

    @Nullable
    public final Vp9Frame findBefore(@NotNull Vp9Frame frame, @NotNull Function1<? super Vp9Frame, Boolean> pred) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        Intrinsics.checkNotNullParameter(pred, "pred");
        int lastIndex = this.getLastIndex();
        if (lastIndex == -1) {
            return null;
        }
        int index = this.indexTracker.interpret(frame.getPictureId());
        int searchStartIndex = Integer.min(index, lastIndex);
        int searchEndIndex = Integer.max(lastIndex - this.getSize(), this.firstIndex - 1);
        return this.doFind(pred, searchStartIndex, searchEndIndex, frame.getEffectiveSpatialLayer() - 1, -1);
    }

    @Nullable
    public final Vp9Frame findAfter(@NotNull Vp9Frame frame, @NotNull Function1<? super Vp9Frame, Boolean> pred) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        Intrinsics.checkNotNullParameter(pred, "pred");
        int lastIndex = this.getLastIndex();
        if (lastIndex == -1) {
            return null;
        }
        int index = this.indexTracker.interpret(frame.getPictureId());
        if (index > lastIndex) {
            return null;
        }
        int searchStartIndex = Integer.max(index, Integer.max(lastIndex - this.getSize() + 1, this.firstIndex));
        return this.doFind(pred, searchStartIndex, lastIndex + 1, frame.getEffectiveSpatialLayer() + 1, 1);
    }

    private final Vp9Frame doFind(Function1<? super Vp9Frame, Boolean> pred, int startIndex, int endIndex, int startLayer, int increment) {
        int layer = startLayer;
        boolean firstPicture = true;
        for (int index = startIndex; index != endIndex; index += increment) {
            Vp9Picture picture = this.getIndex(index);
            if (picture != null) {
                if (!firstPicture) {
                    int n = layer = increment < 0 ? picture.getFrames().size() - 1 : 0;
                }
                while (true) {
                    boolean bl = 0 <= layer ? layer < picture.getFrames().size() : false;
                    if (!bl) break;
                    Vp9Frame frame = picture.getFrames().get(layer);
                    if (frame != null && pred.invoke(frame).booleanValue()) {
                        return frame;
                    }
                    layer += increment;
                }
            }
            firstPicture = false;
        }
        return null;
    }
}

