/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.vp9;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.codec.vpx.VpxUtils;
import org.jitsi.nlj.rtp.VideoRtpPacket;
import org.jitsi.nlj.rtp.codec.vp9.Vp9Packet;
import org.jitsi.nlj.util.UtilKt;
import org.jitsi.videobridge.cc.vp9.PacketInsertionResult;
import org.jitsi.videobridge.cc.vp9.Vp9Frame;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010!\u001a\u00020\fH\u0002J\u0010\u0010\"\u001a\u0004\u0018\u00010\f2\u0006\u0010#\u001a\u00020\u0005J\u0010\u0010\"\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0000J\b\u0010'\u001a\u00020\fH\u0002J\u000e\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020\u0003J\u0010\u0010*\u001a\u00020%2\u0006\u0010)\u001a\u00020+H\u0002J\u0018\u0010,\u001a\u00020-2\u0006\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u0005H\u0002J\u000e\u0010.\u001a\u00020-2\u0006\u0010)\u001a\u00020\u0003R\u0011\u0010\u0007\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR%\u0010\n\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bj\n\u0012\u0006\u0012\u0004\u0018\u00010\f`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\tR\u0011\u0010\u0011\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\tR\u0011\u0010\u0013\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\tR\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\tR\u0011\u0010\u001b\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0018R\u0011\u0010\u001d\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\t\u00a8\u0006/"}, d2={"Lorg/jitsi/videobridge/cc/vp9/Vp9Picture;", "", "packet", "Lorg/jitsi/nlj/rtp/codec/vp9/Vp9Packet;", "index", "", "(Lorg/jitsi/nlj/rtp/codec/vp9/Vp9Packet;I)V", "earliestKnownSequenceNumber", "getEarliestKnownSequenceNumber", "()I", "frames", "Ljava/util/ArrayList;", "Lorg/jitsi/videobridge/cc/vp9/Vp9Frame;", "Lkotlin/collections/ArrayList;", "getFrames", "()Ljava/util/ArrayList;", "getIndex", "latestKnownSequenceNumber", "getLatestKnownSequenceNumber", "pictureId", "getPictureId", "ssrc", "", "getSsrc", "()J", "temporalLayer", "getTemporalLayer", "timestamp", "getTimestamp", "tl0PICIDX", "getTl0PICIDX", "addPacket", "Lorg/jitsi/videobridge/cc/vp9/PacketInsertionResult;", "firstFrame", "frame", "sid", "isImmediatelyAfter", "", "otherPicture", "lastFrame", "matchesPicture", "pkt", "matchesSSRC", "Lorg/jitsi/nlj/rtp/VideoRtpPacket;", "setFrameAtSid", "", "validateConsistency", "jitsi-videobridge"})
public final class Vp9Picture {
    @NotNull
    private final ArrayList<Vp9Frame> frames;

    public Vp9Picture(@NotNull Vp9Packet packet, int index) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        this.frames = new ArrayList();
        int sid = packet.getEffectiveSpatialLayerIndex();
        this.setFrameAtSid(new Vp9Frame(packet, index), sid);
    }

    @NotNull
    public final ArrayList<Vp9Frame> getFrames() {
        return this.frames;
    }

    @Nullable
    public final Vp9Frame frame(int sid) {
        return (Vp9Frame)CollectionsKt.getOrNull((List)this.frames, sid);
    }

    @Nullable
    public final Vp9Frame frame(@NotNull Vp9Packet packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        return this.frame(packet.getEffectiveSpatialLayerIndex());
    }

    private final void setFrameAtSid(Vp9Frame frame, int sid) {
        UtilKt.setAndExtend((List)this.frames, sid, frame, null);
    }

    private final Vp9Frame firstFrame() {
        Object v0;
        block2: {
            Iterable iterable = this.frames;
            for (Object t : iterable) {
                Vp9Frame f = (Vp9Frame)t;
                boolean bl = false;
                if (!(f != null)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Vp9Frame f = v0;
        if (!(f != null)) {
            boolean bl = false;
            String string = "Picture must have at least one frame";
            throw new IllegalStateException(string.toString());
        }
        return f;
    }

    private final Vp9Frame lastFrame() {
        Object v0;
        block2: {
            List list = this.frames;
            ListIterator listIterator = list.listIterator(list.size());
            while (listIterator.hasPrevious()) {
                Object e = listIterator.previous();
                Vp9Frame f = (Vp9Frame)e;
                boolean bl = false;
                if (!(f != null)) continue;
                v0 = e;
                break block2;
            }
            v0 = null;
        }
        Vp9Frame f = v0;
        if (!(f != null)) {
            boolean bl = false;
            String string = "Picture must have at least one frame";
            throw new IllegalStateException(string.toString());
        }
        return f;
    }

    public final long getSsrc() {
        return this.firstFrame().getSsrc();
    }

    public final long getTimestamp() {
        return this.firstFrame().getTimestamp();
    }

    public final int getTemporalLayer() {
        return this.firstFrame().getTemporalLayer();
    }

    public final int getEarliestKnownSequenceNumber() {
        return this.firstFrame().getEarliestKnownSequenceNumber();
    }

    public final int getLatestKnownSequenceNumber() {
        return this.lastFrame().getLatestKnownSequenceNumber();
    }

    public final int getPictureId() {
        return this.firstFrame().getPictureId();
    }

    public final int getIndex() {
        return this.firstFrame().getIndex();
    }

    public final int getTl0PICIDX() {
        return this.firstFrame().getTl0PICIDX();
    }

    @NotNull
    public final PacketInsertionResult addPacket(@NotNull Vp9Packet packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        if (!this.matchesPicture(packet)) {
            boolean $i$a$-require-Vp9Picture$addPacket$22 = false;
            String $i$a$-require-Vp9Picture$addPacket$22 = "Non-matching packet added to picture";
            throw new IllegalArgumentException($i$a$-require-Vp9Picture$addPacket$22.toString());
        }
        int sid = packet.getEffectiveSpatialLayerIndex();
        Vp9Frame f = this.frame(packet);
        if (f != null) {
            f.addPacket(packet);
            return new PacketInsertionResult(f, this, false, false, 8, null);
        }
        Vp9Frame newF = new Vp9Frame(packet, this.getIndex());
        this.setFrameAtSid(newF, sid);
        return new PacketInsertionResult(newF, this, true, false, 8, null);
    }

    private final boolean matchesSSRC(VideoRtpPacket pkt) {
        return this.getSsrc() == pkt.getSsrc();
    }

    public final boolean matchesPicture(@NotNull Vp9Packet pkt) {
        Intrinsics.checkNotNullParameter(pkt, "pkt");
        return this.matchesSSRC(pkt) && this.getTimestamp() == pkt.getTimestamp();
    }

    public final void validateConsistency(@NotNull Vp9Packet pkt) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(pkt, "pkt");
        Vp9Frame f = this.frame(pkt);
        if (f != null) {
            f.validateConsistency(pkt);
            return;
        }
        if (this.getTemporalLayer() == pkt.getTemporalLayerIndex() && this.getTl0PICIDX() == pkt.getTL0PICIDX() && this.getPictureId() == pkt.getPictureId()) {
            return;
        }
        StringBuilder $this$validateConsistency_u24lambda_u2d6 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Vp9Packet $this$validateConsistency_u24lambda_u2d6_u24lambda_u2d5 = pkt;
        boolean bl2 = false;
        $this$validateConsistency_u24lambda_u2d6.append("Packet ssrc " + $this$validateConsistency_u24lambda_u2d6_u24lambda_u2d5.getSsrc() + ", seq " + $this$validateConsistency_u24lambda_u2d6_u24lambda_u2d5.getSequenceNumber() + ", picture id " + $this$validateConsistency_u24lambda_u2d6_u24lambda_u2d5.getPictureId() + ", timestamp " + $this$validateConsistency_u24lambda_u2d6_u24lambda_u2d5.getTimestamp() + " ");
        $this$validateConsistency_u24lambda_u2d6.append("is not consistent with picture " + this.getSsrc() + ", ");
        $this$validateConsistency_u24lambda_u2d6.append("seq " + this.getEarliestKnownSequenceNumber() + "-" + this.getLatestKnownSequenceNumber() + " ");
        $this$validateConsistency_u24lambda_u2d6.append("picture id " + this.getPictureId() + ", timestamp " + this.getTimestamp() + ": ");
        boolean complained = false;
        if (this.getTemporalLayer() != pkt.getTemporalLayerIndex()) {
            $this$validateConsistency_u24lambda_u2d6.append("packet temporal layer " + pkt.getTemporalLayerIndex() + " != frame temporal layer " + this.getTemporalLayer());
            complained = true;
        }
        if (this.getTl0PICIDX() != pkt.getTL0PICIDX()) {
            if (complained) {
                $this$validateConsistency_u24lambda_u2d6.append("; ");
            }
            $this$validateConsistency_u24lambda_u2d6.append("packet TL0PICIDX " + pkt.getTL0PICIDX() + " != frame TL0PICIDX " + this.getTl0PICIDX());
            complained = true;
        }
        if (this.getPictureId() != pkt.getPictureId()) {
            if (complained) {
                $this$validateConsistency_u24lambda_u2d6.append("; ");
            }
            $this$validateConsistency_u24lambda_u2d6.append("packet PictureID " + pkt.getPictureId() + " != frame PictureID " + this.getPictureId());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        String string2 = string;
        throw new RuntimeException(string2);
    }

    public final boolean isImmediatelyAfter(@NotNull Vp9Picture otherPicture) {
        Intrinsics.checkNotNullParameter(otherPicture, "otherPicture");
        return this.getPictureId() == VpxUtils.Companion.applyExtendedPictureIdDelta(otherPicture.getPictureId(), 1);
    }
}

