/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.locking;

import java.time.Instant;

public final class LockAcquiringTimeoutException
extends RuntimeException {
    private final String lockName;
    private final String keycloakInstanceIdentifier;
    private final Instant timeWhenAcquired;

    public LockAcquiringTimeoutException(String lockName, String keycloakInstanceIdentifier, Instant timeWhenAcquired) {
        super(String.format("Lock [%s] already acquired by keycloak instance [%s] at the time [%s]", lockName, keycloakInstanceIdentifier, timeWhenAcquired));
        this.lockName = lockName;
        this.keycloakInstanceIdentifier = keycloakInstanceIdentifier;
        this.timeWhenAcquired = timeWhenAcquired;
    }

    public LockAcquiringTimeoutException(String lockName, String keycloakInstanceIdentifier, Instant timeWhenAcquired, Throwable cause) {
        super(String.format("Lock [%s] already acquired by keycloak instance [%s] at the time [%s]", lockName, keycloakInstanceIdentifier, timeWhenAcquired), cause);
        this.lockName = lockName;
        this.keycloakInstanceIdentifier = keycloakInstanceIdentifier;
        this.timeWhenAcquired = timeWhenAcquired;
    }

    public String getLockName() {
        return this.lockName;
    }

    public String getKeycloakInstanceIdentifier() {
        return this.keycloakInstanceIdentifier;
    }

    public Instant getTimeWhenAcquired() {
        return this.timeWhenAcquired;
    }
}

