/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.anchor;

import com.webauthn4j.anchor.CachingTrustAnchorsProviderBase;
import com.webauthn4j.anchor.KeyStoreException;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.CertificateUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Deprecated
public class KeyStoreFileTrustAnchorsProvider
extends CachingTrustAnchorsProviderBase {
    private Path keyStore;
    private String password;

    private void checkConfig() {
        AssertUtil.notNull((Object)this.keyStore, (String)"keyStore must not be null");
        AssertUtil.notNull((Object)this.password, (String)"password must not be null");
    }

    @Override
    protected @NonNull Map<AAGUID, Set<TrustAnchor>> loadTrustAnchors() {
        Map map;
        block9: {
            this.checkConfig();
            Path keystore = this.getKeyStore();
            InputStream inputStream = Files.newInputStream(keystore, new OpenOption[0]);
            try {
                KeyStore keyStoreObject = this.loadKeyStoreFromStream(inputStream, this.getPassword());
                ArrayList<String> aliases = Collections.list(keyStoreObject.aliases());
                HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
                for (String alias : aliases) {
                    X509Certificate certificate = (X509Certificate)keyStoreObject.getCertificate(alias);
                    trustAnchors.add(new TrustAnchor(certificate, null));
                }
                map = Collections.singletonMap(AAGUID.NULL, trustAnchors);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | java.security.KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    throw new KeyStoreException("Failed to load TrustAnchor from keystore", e);
                }
            }
            inputStream.close();
        }
        return map;
    }

    private @NonNull KeyStore loadKeyStoreFromStream(@NonNull InputStream inputStream, @NonNull String password) throws CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore keyStoreObject = CertificateUtil.createKeyStore();
        keyStoreObject.load(inputStream, password.toCharArray());
        return keyStoreObject;
    }

    public @Nullable Path getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(@Nullable Path keyStore) {
        this.keyStore = keyStore;
    }

    public @Nullable String getPassword() {
        return this.password;
    }

    public void setPassword(@Nullable String password) {
        this.password = password;
    }
}

