/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.internal.AbstractSqmPathInterpretation;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddedValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.SqlTupleContainer;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.update.Assignable;

public class EmbeddableValuedPathInterpretation<T>
extends AbstractSqmPathInterpretation<T>
implements Assignable,
SqlTupleContainer {
    private final SqlTuple sqlExpression;

    public static <T> Expression from(SqmEmbeddedValuedSimplePath<T> sqmPath, SqmToSqlAstConverter sqlAstCreationState, boolean jpaQueryComplianceEnabled) {
        ModelPartContainer modelPartContainer;
        JpaPath lhs = sqmPath.getLhs();
        TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().getTableGroup(lhs.getNavigablePath());
        EntityPersister treatTarget = null;
        if (jpaQueryComplianceEnabled) {
            MappingMetamodelImplementor mappingMetamodel = sqlAstCreationState.getCreationContext().getSessionFactory().getRuntimeMetamodels().getMappingMetamodel();
            if (lhs instanceof SqmTreatedPath) {
                EntityDomainType treatTargetDomainType = ((SqmTreatedPath)lhs).getTreatTarget();
                treatTarget = mappingMetamodel.findEntityDescriptor(treatTargetDomainType.getHibernateEntityName());
            } else if (lhs.getNodeType() instanceof EntityDomainType) {
                EntityDomainType entityDomainType = (EntityDomainType)lhs.getNodeType();
                treatTarget = mappingMetamodel.findEntityDescriptor(entityDomainType.getHibernateEntityName());
            }
        }
        EmbeddableValuedModelPart mapping = SqmUtil.needsTargetTableMapping(sqmPath, modelPartContainer = tableGroup.getModelPart(), sqlAstCreationState) ? (EmbeddableValuedModelPart)((ManagedMappingType)modelPartContainer.getPartMappingType()).findSubPart(sqmPath.getReferencedPathSource().getPathName(), treatTarget) : (EmbeddableValuedModelPart)modelPartContainer.findSubPart(sqmPath.getReferencedPathSource().getPathName(), treatTarget);
        return new EmbeddableValuedPathInterpretation<T>(mapping.toSqlExpression(tableGroup, sqlAstCreationState.getCurrentClauseStack().getCurrent(), sqlAstCreationState, sqlAstCreationState), sqmPath.getNavigablePath(), mapping, tableGroup);
    }

    public EmbeddableValuedPathInterpretation(SqlTuple sqlExpression, NavigablePath navigablePath, EmbeddableValuedModelPart mapping, TableGroup tableGroup) {
        super(navigablePath, mapping, tableGroup);
        this.sqlExpression = sqlExpression;
    }

    @Override
    public SqlTuple getSqlExpression() {
        return this.sqlExpression;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        this.sqlExpression.accept(sqlTreeWalker);
    }

    public String toString() {
        return "EmbeddableValuedPathInterpretation(" + this.getNavigablePath() + ")";
    }

    @Override
    public void visitColumnReferences(Consumer<ColumnReference> columnReferenceConsumer) {
        for (Expression expression : this.sqlExpression.getExpressions()) {
            if (!(expression instanceof ColumnReference)) {
                throw new IllegalArgumentException("Expecting ColumnReference, found : " + expression);
            }
            columnReferenceConsumer.accept((ColumnReference)expression);
        }
    }

    @Override
    public List<ColumnReference> getColumnReferences() {
        ArrayList<ColumnReference> results = new ArrayList<ColumnReference>();
        this.visitColumnReferences(results::add);
        return results;
    }

    @Override
    public SqlTuple getSqlTuple() {
        return this.sqlExpression;
    }
}

