/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli;

import java.util.Collection;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.keycloak.utils.StringUtil;
import picocli.CommandLine;

public final class PropertyMapperParameterConsumer
implements CommandLine.IParameterConsumer {
    static final CommandLine.IParameterConsumer INSTANCE = new PropertyMapperParameterConsumer();

    private PropertyMapperParameterConsumer() {
    }

    public void consumeParameters(Stack<String> args, CommandLine.Model.ArgSpec argSpec, CommandLine.Model.CommandSpec commandSpec) {
        if (argSpec instanceof CommandLine.Model.OptionSpec) {
            this.validateOption(args, argSpec, commandSpec);
        }
    }

    private void validateOption(Stack<String> args, CommandLine.Model.ArgSpec argSpec, CommandLine.Model.CommandSpec commandSpec) {
        CommandLine.Model.OptionSpec option = (CommandLine.Model.OptionSpec)argSpec;
        String name = String.join((CharSequence)", ", option.names());
        CommandLine commandLine = commandSpec.commandLine();
        if (args.isEmpty() || !this.isOptionValue(args.peek())) {
            throw new CommandLine.ParameterException(commandLine, "Missing required value for option '" + name + "' (" + argSpec.paramLabel() + ")." + PropertyMapperParameterConsumer.getExpectedValuesMessage(argSpec.completionCandidates(), option.completionCandidates()));
        }
        String value = args.pop();
        if (!args.isEmpty() && this.isOptionValue(args.peek())) {
            throw new CommandLine.ParameterException(commandLine, "Option '" + name + "' expects a single value (" + argSpec.paramLabel() + ")" + PropertyMapperParameterConsumer.getExpectedValuesMessage(argSpec.completionCandidates(), option.completionCandidates()));
        }
        if (PropertyMapperParameterConsumer.isExpectedValue(StreamSupport.stream(option.completionCandidates().spliterator(), false).collect(Collectors.toList()), value)) {
            return;
        }
        throw new CommandLine.ParameterException(commandLine, PropertyMapperParameterConsumer.getErrorMessage(name, value, argSpec.completionCandidates(), option.completionCandidates()));
    }

    static String getErrorMessage(String name, String value, Iterable<String> specCandidates, Iterable<String> optionCandidates) {
        return "Invalid value for option '" + name + "': " + value + "." + PropertyMapperParameterConsumer.getExpectedValuesMessage(specCandidates, optionCandidates);
    }

    private boolean isOptionValue(String arg) {
        return !arg.startsWith("--") && !arg.startsWith("-");
    }

    static String getExpectedValuesMessage(Iterable<String> specCandidates, Iterable<String> optionCandidates) {
        return optionCandidates.iterator().hasNext() ? " Expected values are: " + String.join((CharSequence)", ", specCandidates) : "";
    }

    static boolean isExpectedValue(Collection<String> expectedValues, String value) {
        if (expectedValues.isEmpty()) {
            return true;
        }
        if (StringUtil.isBlank((String)value)) {
            return false;
        }
        for (String v : value.split(",")) {
            if (expectedValues.contains(v)) continue;
            return false;
        }
        return true;
    }
}

