/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import java.util.HashSet;
import java.util.Set;
import org.keycloak.common.Profile;
import org.keycloak.quarkus.runtime.Environment;

public class IgnoredArtifacts {
    public static final Set<String> FIPS_ENABLED = Set.of("org.bouncycastle:bcprov-jdk18on", "org.bouncycastle:bcpkix-jdk18on", "org.bouncycastle:bcutil-jdk18on", "org.keycloak:keycloak-crypto-default");
    public static final Set<String> FIPS_DISABLED = Set.of("org.keycloak:keycloak-crypto-fips1402", "org.bouncycastle:bc-fips", "org.bouncycastle:bctls-fips", "org.bouncycastle:bcpkix-fips");

    public static Set<String> getDefaultIgnoredArtifacts() {
        return new Builder().append(IgnoredArtifacts.fips()).build();
    }

    private static Set<String> fips() {
        Profile profile = Environment.getCurrentOrCreateFeatureProfile();
        boolean isFipsEnabled = (Boolean)profile.getFeatures().get(Profile.Feature.FIPS);
        return isFipsEnabled ? FIPS_ENABLED : FIPS_DISABLED;
    }

    private static final class Builder {
        private final Set<String> finalIgnoredArtifacts = new HashSet<String>();

        public Builder append(Set<String> ignoredArtifacts) {
            this.finalIgnoredArtifacts.addAll(ignoredArtifacts);
            return this;
        }

        public Set<String> build() {
            return this.finalIgnoredArtifacts;
        }
    }
}

