<?php

/**
 * ⚠️ Editing not allowed except for 'en' language.
 *
 * @see https://github.com/monicahq/monica/blob/main/docs/contribute/translate.md for translations.
 */

return [
    'sidebar_settings' => 'Pengaturan akun',
    'sidebar_personalization' => 'Personalisasi',
    'sidebar_settings_storage' => 'Ruang Peyimpanan',
    'sidebar_settings_export' => 'Ekspor data',
    'sidebar_settings_users' => 'Pengguna',
    'sidebar_settings_subscriptions' => 'Berlangganan',
    'sidebar_settings_import' => 'Impor data',
    'sidebar_settings_tags' => 'Pengelolaan tag',
    'sidebar_settings_api' => 'API',
    'sidebar_settings_dav' => 'Sumberdaya DAV',
    'sidebar_settings_security' => 'Keamanan',
    'sidebar_settings_auditlogs' => 'Catatan audit',

    'title_general' => 'Informasi Umum',
    'title_i18n' => 'Pengaturan internasional',
    'title_layout' => 'Tata letak',

    'me_title' => 'Saya sebagai sebuah kontak',
    'me_help' => 'Ini adalah kontak yang mewakili <em>Anda</em> dalam Monica',
    'me_select' => 'Pilih sebuah kontak',
    'me_no_contact' => 'Belum ada kontak yang dipilih.',
    'me_select_click' => 'Klik di sini untuk memilih sebuah kontak.',
    'me_remove_contact' => 'Hapus pengkaitan',
    'me_choose' => 'Pilih diri Anda sendiri',
    'me_choose_placeholder' => 'Pilih diri Anda sendiri',

    'export_title' => 'Ekspor data akun Anda',
    'export_be_patient' => 'Click the button to start the export. It might take several minutes to process the export – please be patient and do not spam the button.',
    'export_title_sql' => 'Export to SQL',
    'export_sql_explanation' => 'Exporting your data in SQL format allows you to take your data and import it to your own Monica instance. This is only valuable if you do have your own server.',
    'export_sql_cta' => 'Export to SQL',
    'export_sql_link_instructions' => 'Note: <a href=":url">read the instructions</a> to learn more about importing this file to your instance.',
    'export_title_json' => 'Export to Json',
    'export_submitted' => 'Your export has been submitted, it will be available in a few moment…',
    'export_json_explanation' => 'Exporting your data in Json format for backup.',
    'export_json_beta' => 'Json export is in preview mode. Tell us what you think about it:',
    'export_json_cta' => 'Export to Json',
    'export_header_type' => 'Type',
    'export_header_timestamp' => 'Creation date',
    'export_header_status' => 'Status',
    'export_header_actions' => 'Actions',
    'export_last_title' => 'Last exports',
    'export_empty_title' => 'No exports yet',
    'export_type_json' => 'Json export',
    'export_type_sql' => 'SQL export',
    'export_status_todo' => 'Submitted',
    'export_status_doing' => 'Doing',
    'export_status_done' => 'Done',
    'export_status_failed' => 'Failed',
    'export_not_done' => 'Download impossible, this export is not done yet.',

    'firstname' => 'Nama depan',
    'lastname' => 'Nama belakang',
    'name_order' => 'Urutan nama',
    'name_order_firstname_lastname' => '<First name> <Last name> – Asep Surasep',
    'name_order_lastname_firstname' => '<Last name> <First name> – Surasep Asep',
    'name_order_firstname_lastname_nickname' => '<First name> <Last name> (<Nickname>) – Asep Surasep (Kabayan)',
    'name_order_firstname_nickname_lastname' => '<First name> (<Nickname>) <Last name> – Asep (Kabayan) Surasep',
    'name_order_lastname_firstname_nickname' => '<Last name> <First name> (<Nickname>) – Surasep Asep (Kabayan)',
    'name_order_lastname_nickname_firstname' => '<Last name> (<Nickname>) <First name> – Surasep (Kabayan) Asep',
    'name_order_nickname_firstname_lastname' => '<Nickname> (<First name> <Last name>) – Kabayan (Asep Surasep)',
    'name_order_nickname_lastname_firstname' => '<Nickname> (<Last name> <First name>) – Kabayan (Surasep Asep)',
    'name_order_nickname' => '<Nickname> - Kabayan',
    'currency' => 'Mata uang',
    'name' => 'Nama Anda: :name',
    'email' => 'Alamat email',
    'email_placeholder' => 'Masukkan email',
    'email_help' => 'Ini adalah email yang digunakan untuk masuk, dan di alamat inilah Monica akan mengirim pengingat Anda.',
    'timezone' => 'Zona waktu',
    'temperature_scale' => 'Skala suhu',
    'temperature_scale_fahrenheit' => 'Fahrenheit (°F)',
    'temperature_scale_celsius' => 'Celsius (°C)',
    'layout' => 'Tata letak',
    'layout_small' => 'Maksimal lebar 1200 piksel',
    'layout_big' => 'Lebar penuh dari peramban web',
    'save' => 'Perbarui preferensi',
    'delete_title' => 'Hapus akun Anda',
    'delete_desc' => 'Apakah Anda ingin menghapus akun Anda? Penghapusan bersifat permanen dan semua data Anda akan dihapus secara permanen. Jika Anda berlangganan, itu akan segera dibatalkan.',
    'delete_other_desc' => 'Your data in the main database will be deleted immediately. As described in our privacy policy, we carry out securely encrypted backups of the database every day.  These backups are kept for 30 days after which they are completely deleted. We cannot delete specific data from the backups we hold any earlier than this.  All of your data will be completely deleted no later than 31 days after your account’s deletion.',
    'reset_desc' => 'Apakah Anda ingin mengatur ulang akun Anda? Ini akan menghapus semua kontak Anda, dan semua data yang terkait dengannya. Akun Anda tidak akan dihapus.',
    'reset_title' => 'Atur ulang akun Anda',
    'reset_cta' => 'Atur ulang akun',
    'reset_notice' => 'Apakah Anda yakin untuk mengatur ulang akun Anda? Ini bersifat permanen dan tidak dapat dibatalkan.',
    'reset_success' => 'Akun Anda telah berhasil diatur ulang.',
    'delete_notice' => 'Apakah Anda yakin ingin menghapus akun Anda? Ini bersifat permanen dan tidak bisa dibatalkan. Semua data Anda akan dihapus dan tidak akan dapat dipulihkan.',
    'delete_cta' => 'Hapus akun',
    'settings_success' => 'Preferensi diperbarui!',
    'locale' => 'Bahasa yang digunakan dalam aplikasi',
    'locale_help' => 'Apakah Anda ingin membantu menerjemahkan Monica atau menambahkan bahasa baru? Silakan ikuti <a href=":url" target="_blank" lang="en">tautan ini untuk informasi lebih lanjut</a>.',
    'locale_ar' => 'Arab',
    'locale_cs' => 'Ceko',
    'locale_de' => 'Jerman',
    'locale_el' => 'Greek',
    'locale_en' => 'Inggris',
    'locale_en-GB' => 'Inggris (Britania Raya)',
    'locale_es' => 'Spanyol',
    'locale_fr' => 'Perancis',
    'locale_he' => 'Ibrani',
    'locale_hr' => 'Kroasia',
    'locale_id' => 'Indonesia',
    'locale_it' => 'Italia',
    'locale_ja' => 'Jepang',
    'locale_nl' => 'Belanda',
    'locale_pt' => 'Portugis',
    'locale_pt-BR' => 'Portuguese, Brazil',
    'locale_ru' => 'Rusia',
    'locale_sv' => 'Swedia',
    'locale_vi' => 'Vietnam',
    'locale_zh' => 'Cina Sederhana',
    'locale_zh-TW' => 'Cina Tradisional',
    'locale_tr' => 'Turki',

    'security_title' => 'Keamanan',
    'security_help' => 'Ubah hal tentang keamanan untuk akun Anda.',
    'password_change' => 'Ganti kata sandi Anda',
    'password_current' => 'Kata sandi saat ini',
    'password_current_placeholder' => 'Masukkan kata sandi Anda',
    'password_new1' => 'Kata sandi baru',
    'password_new1_placeholder' => 'Masukkan kata sandi baru Anda',
    'password_new2' => 'Konfirmasi kata sandi baru Anda',
    'password_new2_placeholder' => 'Ketik ulang kata sandi baru Anda',
    'password_btn' => 'Ganti kata sandi',
    '2fa_title' => 'Otentikasi Dua Faktor',
    '2fa_otp_title' => 'Aplikasi seluler Otentikasi Dua Faktor',
    '2fa_enable_title' => 'Aktifkan Otentikasi Dua Faktor',
    '2fa_enable_description' => 'Aktifkan Otentikasi Dua Faktor untuk meningkatkan keamanan akun Anda.',
    '2fa_enable_otp' => 'Buka aplikasi seluler Otentikasi Dua Faktor Anda dan pindai barcode QR berikut:',
    '2fa_enable_otp_help' => 'Jika aplikasi seluler Otentikasi Dua Faktor Anda tidak mendukung barcode QR, masukkan kode berikut:',
    '2fa_enable_otp_validate' => 'Silakan validasi perangkat baru yang baru saja Anda atur:',
    '2fa_enable_success' => 'Otentikasi Dua Faktor diaktifkan',
    '2fa_enable_error' => 'Kesalahan saat mencoba mengaktifkan Otentikasi Dua Faktor',
    '2fa_enable_error_already_set' => 'Otentikasi Dua Faktor telah diaktifkan sebelumnya',
    '2fa_disable_title' => 'Nonaktifkan Otentikasi Dua Faktor',
    '2fa_disable_description' => 'Nonaktifkan Otentikasi Dua Faktor untuk akun Anda. Harap berhati-hati, akun Anda akan jauh lebih kurang aman!',
    '2fa_disable_success' => 'Otentikasi Dua Faktor dinonaktifkan',
    '2fa_disable_error' => 'Kesalahan saat mencoba menonaktifkan Otentikasi Dua Faktor',

    'webauthn_title' => 'Kunci keamanan - protokol WebAuthn',
    'webauthn_enable_description' => 'Tambahkan sebuah kunci keamanan baru',
    'webauthn_key_name_help' => 'Berikan sebuah nama ke kunci Anda.',
    'webauthn_key_name' => 'Nama kunci:',
    'webauthn_success' => 'Kunci Anda terdeteksi dan telah divalidasi.',
    'webauthn_last_use' => 'Penggunaan terakhir: {timestamp}',
    'webauthn_delete_confirmation' => 'Apakah Anda yakin ingin menghapus kunci ini?',
    'webauthn_delete_success' => 'Kunci dihapus',
    'webauthn_insertKey' => 'Masukkan kunci keamanan Anda.',
    'webauthn_buttonAdvise' => 'Jika kunci keamanan Anda memiliki sebuah tombol, tekan tombol itu.',
    'webauthn_noButtonAdvise' => 'Jika tidak, hapus dan masukkan lagi kunci tersebut.',
    'webauthn_not_supported' => 'Peramban web Anda saat ini tidak mendukung WebAuthn.',
    'webauthn_not_secured' => 'WebAuthn hanya mendukung koneksi yang aman. Silakan muat halaman ini dengan skema https.',
    'webauthn_error_already_used' => 'Kunci ini telah didaftarkan sebelumnya. Tidak diperlukan untuk didaftarkannya lagi.',
    'webauthn_error_not_allowed' => 'Operasi tersebut habis waktu atau tidak diizinkan.',

    'recovery_title' => 'Kode pemulihan',
    'recovery_show' => 'Dapatkan kode pemulihan',
    'recovery_copy_help' => 'Salin kode di papanklip Anda',
    'recovery_help_intro' => 'Ini adalah kode pemulihan Anda:',
    'recovery_help_information' => 'Anda dapat menggunakan setiap kode pemulihan hanya sekali.',
    'recovery_clipboard' => 'Kode disalin ke papanklip.',
    'recovery_generate' => 'Hasilkan kode baru…',
    'recovery_generate_help' => 'Menghasilkan kode baru akan membatalkan kode yang dihasilkan sebelumnya/tidak valid.',
    'recovery_already_used_help' => 'Kode ini telah digunakan sebelumnya.',

    'users_list_title' => 'Pengguna dengan akses ke akun Anda',
    'users_list_add_user' => 'Undang seorang pengguna baru',
    'users_list_you' => 'Itu Anda',
    'users_list_invitations_title' => 'Undangan yang tertunda',
    'users_list_invitations_explanation' => 'Di bawah ini adalah orang yang telah Anda undang untuk bergabung dengan Monica sebagai kolaborator.',
    'users_list_invitations_invited_by' => 'diundang oleh :name',
    'users_list_invitations_sent_date' => 'dikirim pada :date',
    'users_blank_title' => 'Anda adalah satu-satunya yang memiliki akses ke akun ini.',
    'users_blank_add_title' => 'Apakah Anda ingin mengundang orang lain?',
    'users_blank_description' => 'Orang ini akan memiliki akses yang sama yang Anda miliki, dan akan dapat menambah, mengedit, atau menghapus informasi kontak.',
    'users_blank_cta' => 'Undang seseorang',
    'users_add_title' => 'Undang seorang pengguna baru ke akun Anda melalui email',
    'users_add_description' => 'Orang ini akan memiliki akses yang sama seperti yang Anda punya, termasuk mengundang atau menghapus pengguna lain, termasuk Anda. Pastikan Anda mempercayai orang ini sebelum memberi mereka akses.',
    'users_add_email_field' => 'Masukkan alamat email orang yang ingin Anda undang',
    'users_add_confirmation' => 'Saya mengkonfirmasi bahwa saya ingin mengundang pengguna ini ke akun saya. Saya mengerti bahwa orang ini akan memiliki akses ke semua data saya dan melihat apa yang saya lihat dengan sama.',
    'users_add_cta' => 'Undang pengguna melalui email',
    'users_accept_title' => 'Terima undangan dan buat sebuah akun baru',
    'users_error_please_confirm' => 'Harap konfirmasi bahwa Anda ingin mengundang pengguna ini sebelum melanjutkan dengan undangan tersebut',
    'users_error_email_already_taken' => 'Email ini telah dipakai. Silakan pilih yang lain',
    'users_error_already_invited' => 'Anda telah mengundang pengguna ini sebelumnya. Silakan pilih alamat email lain.',
    'users_error_email_not_similar' => 'Ini bukan alamat email dari orang yang telah mengundang Anda.',
    'users_invitation_deleted_confirmation_message' => 'Undangan telah berhasil dihapus',
    'users_invitations_delete_confirmation' => 'Apakah Anda yakin ingin menghapus undangan ini?',
    'users_list_delete_confirmation' => 'Apakah Anda yakin ingin menghapus pengguna ini dari akun Anda?',
    'users_invitation_need_subscription' => 'Menambahkan lebih banyak pengguna membutuhkan sebuah langganan.',

    'subscriptions_account_current_plan' => 'Paket rencana Anda saat ini',
    'subscriptions_account_current_legacy' => 'Current plan, not selectable anymore:',
    'subscriptions_account_current_paid_plan' => 'Anda berada di paket rencana :name. Terima kasih banyak telah menjadi seorang pelanggan.',

    'subscriptions_account_next_billing_title' => 'Next bill',
    'subscriptions_account_next_billing' => 'Langganan Anda akan diperbarui secara otomatis pada <strong>:date</strong>.',
    'subscriptions_account_bill_monthly' => 'We’ll bill you <strong>:price</strong> for another <strong>month</strong>.',
    'subscriptions_account_bill_annual' => 'We’ll bill you <strong>:price</strong> for another <strong>year</strong>.',
    'subscriptions_account_change' => 'Change plan',

    'subscriptions_account_cancel_title' => 'Cancel subscription',
    'subscriptions_account_cancel_action' => 'Cancel subscription',
    'subscriptions_account_cancel' => 'Anda dapat <a href=":url">membatalkan langganan</a> kapan saja.',
    'subscriptions_account_free_plan' => 'Anda berada dalam paket rencana gratis.',
    'subscriptions_account_free_plan_upgrade' => 'Anda dapat meningkatkan akun Anda ke paket rencana :name, dengan biaya $:price per bulan. Berikut ini adalah kelebihannya:',
    'subscriptions_account_free_plan_benefits_users' => 'Jumlah pengguna yang tidak terbatas',
    'subscriptions_account_free_plan_benefits_reminders' => 'Pengingat melalui email',
    'subscriptions_account_free_plan_benefits_import_data_vcard' => 'Impor kontak Anda dengan vCard',
    'subscriptions_account_free_plan_benefits_support' => 'Mendukung proyek dalam jangka panjang, sehingga kami dapat memperkenalkan lebih banyak lagi fitur hebat.',
    'subscriptions_account_upgrade' => 'Tingkatkan akun Anda',
    'subscriptions_account_upgrade_title' => 'Tingkatkan Monica hari ini dan memiliki hubungan yang lebih bermakna.',
    'subscriptions_account_upgrade_choice' => 'Pilih sebuah paket rencana di bawah ini dan bergabunglah dengan :customers pelanggan yang meningkatkan aplikasi Monica mereka.',
    'subscriptions_account_update_title' => 'Update Monica subscription',
    'subscriptions_account_update_description' => 'You can change your subscription’s frequency here.',
    'subscriptions_account_update_information' => 'You will be billed immediately for the new amount. Your subscription will extend to the new period, depending on your choice.',
    'subscriptions_account_invoices' => 'Faktur',
    'subscriptions_account_invoices_download' => 'Unduh',
    'subscriptions_account_invoices_subscription' => 'Berlangganan dari :startDate ke sampai :endDate',
    'subscriptions_account_payment' => 'Opsi pembayaran mana yang paling cocok untuk Anda?',
    'subscriptions_account_confirm_payment' => 'Pembayaran Anda saat ini tidak lengkap, silakan <a href=":url">Konfirmasi pembayaran Anda</a>.',
    'subscriptions_downgrade_title' => 'Turunkan akun Anda ke paket rencana gratis',
    'subscriptions_downgrade_limitations' => 'Paket rencana gratis memiliki keterbatasan. Untuk dapat menurunkan versi, Anda harus lulus daftar periksa di bawah ini:',
    'subscriptions_downgrade_rule_users' => 'Anda harus memiliki hanya 1 pengguna di akun Anda',
    'subscriptions_downgrade_rule_users_constraint' => 'Anda saat ini memiliki <a href=":url">:count pengguna</a> pada akun Anda.',
    'subscriptions_downgrade_rule_invitations' => 'Anda tidak boleh memiliki undangan yang tertunda',
    'subscriptions_downgrade_rule_invitations_constraint' => 'Anda saat ini memiliki <a href=":url">:count undangan tertunda</a>.',
    'subscriptions_downgrade_rule_contacts' => 'Anda tidak boleh memiliki lebih dari :number kontak aktif',
    'subscriptions_downgrade_rule_contacts_constraint' => 'Saat ini Anda memiliki <a href=":url">:count kontak</a>.',
    'subscriptions_downgrade_rule_contacts_archive' => 'We can also <a href=":url">archive all your contacts for you</a> – that would clear this rule and let you proceed with your account’s downgrade process.',
    'subscriptions_downgrade_cta' => 'Turun tingkat',
    'subscriptions_downgrade_success' => 'Anda kembali ke paket rencana Gratis!',
    'subscriptions_downgrade_thanks' => 'Terima kasih banyak telah mencoba paket rencana berbayar. Kami terus menambahkan fitur baru di Monica sepanjang waktu - sehingga Anda mungkin ingin kembali pada kesempatan mendatang untuk melihat apakah Anda mungkin tertarik untuk berlangganan lagi.',
    'subscriptions_back' => 'Kembali ke pengaturan',
    'subscriptions_upgrade_title' => 'Tingkatkan akun Anda',
    'subscriptions_upgrade_choose' => 'Kamu memilih paket rencana :plan.',
    'subscriptions_upgrade_infos' => 'Kami tidak bisa lebih bahagia. Masukkan informasi pembayaran Anda di bawah ini.',
    'subscriptions_upgrade_name' => 'Nama di kartu',
    'subscriptions_upgrade_zip' => 'ZIP atau kode pos',
    'subscriptions_upgrade_credit' => 'Kartu kredit atau debit',
    'subscriptions_upgrade_submit' => 'Bayar {amount}',
    'subscriptions_upgrade_charge' => 'Kami akan menagih kartu Anda :price sekarang. Tagihan berikutnya akan dibebankan pada :date. Jika Anda berubah pikiran, Anda dapat membatalkannya kapan saja, tanpa pertanyaan.',
    'subscriptions_upgrade_charge_handled' => 'Pembayaran ditangani oleh <a href=":url">Stripe</a>. Tidak ada informasi kartu yang melalui server kami.',
    'subscriptions_upgrade_success' => 'Terima kasih Kakak! Anda sekarang berlangganan.',
    'subscriptions_upgrade_thanks' => 'Wilujeng sumping ke komunitas kumpulan orang yang berusaha menjadikan dunia tempat yang lebih baik.',

    'subscriptions_payment_confirm_title' => 'Konfirmasi pembayaran :amount Anda',
    'subscriptions_payment_confirm_information' => 'Konfirmasi tambahan diperlukan untuk memproses pembayaran Anda. Silahkan konfirmasi pembayaran Anda dengan mengisi rincian pembayaran Anda di bawah ini.',
    'subscriptions_payment_succeeded_title' => 'Pembayaran berhasil',
    'subscriptions_payment_succeeded' => 'Pembayaran ini sudah berhasil dikonfirmasi sebelumnya.',
    'subscriptions_payment_cancelled_title' => 'Pembayaran Dibatalkan',
    'subscriptions_payment_cancelled' => 'Pembayaran ini dibatalkan.',
    'subscriptions_payment_error_name' => 'Tolong sediakan nama Anda.',
    'subscriptions_payment_success' => 'Pembayaran berhasil.',

    'subscriptions_pdf_title' => 'Langganan bulanan :name Anda',
    'subscriptions_plan_frequency_year' => ':amount / year',
    'subscriptions_plan_frequency_month' => ':amount / month',
    'subscriptions_plan_choose' => 'Pilih paket rencana ini',
    'subscriptions_plan_year_title' => 'Bayar pertahun',
    'subscriptions_plan_year_bonus' => 'Ketenangan pikiran untuk setahun penuh',
    'subscriptions_plan_month_title' => 'Bayar perbulan',
    'subscriptions_plan_month_bonus' => 'Batalkan kapan saja',
    'subscriptions_plan_include1' => 'Termasuk dalam peningkatan Anda:',
    'subscriptions_plan_include2' => 'Jumlah kontak yang tidak terbatas • Jumlah pengguna yang tidak terbatas • Pengingat melalui email • Impor dengan vCard • Personalisasi lembar kontak',
    'subscriptions_plan_include3' => '100% dari keuntungan digunakan untuk pengembangan proyek sumber terbuka yang hebat ini.',
    'subscriptions_help_title' => 'Rincian tambahan yang mungkin Anda ingin tau',
    'subscriptions_help_opensource_title' => 'Apa itu proyek sumber terbuka?',
    'subscriptions_help_opensource_desc' => 'Monica adalah proyek sumber terbuka.  Ini berarti dibangun oleh sebuah komunitas yang ingin membuat alat yang hebat untuk kebaikan yang lebih besar. Menjadi sumber terbuka berarti kode aplikasi ini tersedia untuk umum di GitHub, dan semua orang dapat memeriksa, memodifikasi, atau meningkatkannya. Semua dana yang kami kumpulkan didedikasikan untuk membangun fitur yang lebih baik, membayar untuk server yang lebih kuat, dan membayar biaya lainnnya. Terima kasih atas bantuan Anda. Kami tidak bisa melakukannya tanpa Anda.',
    'subscriptions_help_limits_title' => 'Apakah ada sebuah batasan jumlah kontak yang bisa dimiliki pada paket rencana gratis?',
    'subscriptions_help_limits_plan' => 'Ya. Paket rencana gratis mengizinkan Anda mengelola :number kontak.',
    'subscriptions_help_discounts_title' => 'Apakah Anda memiliki diskon untuk organisasi non-profit dan edukasi?',
    'subscriptions_help_discounts_desc' => 'Kami punya! Monica gratis untuk siswa, dan gratis untuk organisasi non-profit dan amal. Cukup hubungi<a href=":support">dukungan</a> dengan bukti status Anda dan kami akan terapkan status khusus ini pada akun Anda.',
    'subscriptions_help_change_title' => 'Bagaimana jika saya berubah pikiran?',
    'subscriptions_help_change_desc' => 'Anda dapat membatalkannya kapan saja, tanpa pertanyaan, dan semua oleh Anda sendiri - tidak perlu menghubungi dukungan. Namun, dana Anda tidak akan dikembalikan untuk periode tersebut.',

    'stripe_error_card' => 'Kartu Anda ditolak. Pesan penolakan: :message',
    'stripe_error_api_connection' => 'Komunikasi jaringan dengan Stripe gagal. Coba lagi nanti.',
    'stripe_error_rate_limit' => 'Terlalu banyak permintaan dengan Stripe saat ini. Coba lagi nanti.',
    'stripe_error_invalid_request' => 'Parameter tidak valid. Coba lagi nanti.',
    'stripe_error_authentication' => 'Otentikasi salah dengan Stripe',

    'import_title' => 'Impor kontak di akun Anda',
    'import_cta' => 'Unggah kontak',
    'import_stat' => 'Anda sudah mengimpor :number berkas sejauh ini.',
    'import_result_stat' => 'Unggahan vCard dengan :total_contacts kontak (:total_imported yang diimpor, :total_skipped dilewatkan)',
    'import_view_report' => 'Lihat laporan',
    'import_in_progress' => 'Impor sedang berlangsung. Muat ulang halaman dalam satu menit.',
    'import_upload_title' => 'Impor kontak Anda dari sebuah berkas vCard',
    'import_upload_rules_desc' => 'Kami tetapi memiliki beberapa aturan:',
    'import_upload_rule_format' => 'Kami mendukung berkas <code>.vcard</code> dan <code>.vcf</code>.',
    'import_upload_rule_vcard' => 'Kami mendukung format vCard 3.0, yang merupakan format standar untuk Contacts.app MacOS dan Google Contacts.',
    'import_upload_rule_instructions' => 'Petunjuk ekspor untuk <a href=":url1" target="_blank" rel="noopener noreferrer">Contacts.app macOS</a> dan <a href=":url2" target="_blank" rel="noopener noreferrer">Google Contacts</a>.',
    'import_upload_rule_multiple' => 'Jika kontak Anda memiliki beberapa alamat email atau nomor telepon, hanya entri pertama yang akan disimpan.',
    'import_upload_rule_limit' => 'Berkas dibatasi hingga 10 MB.',
    'import_upload_rule_time' => 'Mungkin membutuhkan waktu hingga satu menit untuk mengunggah kontak dan memprosesnya. Harap bersabar.',
    'import_upload_rule_cant_revert' => 'Pastikan data dalam vCard tersebut akurat sebelum mengunggah, karena Anda tidak dapat membatalkan unggahan.',
    'import_upload_form_file' => 'Berkas <code>.vcf</code> atau <code>.vCard</code> Anda:',
    'import_upload_behaviour' => 'Perilaku impor:',
    'import_upload_behaviour_add' => 'Tambahkan kontak baru dan lewati yang telah tersedia',
    'import_upload_behaviour_replace' => 'Ganti kontak yang telah tersedia',
    'import_upload_behaviour_help' => 'Mengganti akan mengganti semua data yang ditemukan di vCard, tetapi akan menyimpan kontak yang telah tersedia.',
    'import_report_title' => 'Mengimpor laporan',
    'import_report_date' => 'Tanggal impor',
    'import_report_type' => 'Jenis impor',
    'import_report_number_contacts' => 'Jumlah kontak dalam berkas',
    'import_report_number_contacts_imported' => 'Jumlah kontak yang telah diimpor',
    'import_report_number_contacts_skipped' => 'Jumlah kontak yang dilewati',
    'import_report_status_imported' => 'Diimpor',
    'import_report_status_skipped' => 'Dilewati',
    'import_vcard_parse_error' => 'Kesalahan saat menguraikan entri vCard',
    'import_vcard_contact_exist' => 'Kontak telah tersedia',
    'import_vcard_contact_no_firstname' => 'Tanpa nama depan (wajib)',
    'import_vcard_file_not_found' => 'Berkas tidak ditemukan',
    'import_vcard_unknown_entry' => 'Nama kontak tidak diketahui',
    'import_vcard_file_no_entries' => 'Berkas tidak memiliki entri',
    'import_blank_title' => 'Anda belum mengimpor kontak apapun.',
    'import_blank_question' => 'Apakah Ànda ingin mengimpor kontak sekarang?',
    'import_blank_description' => 'Kami dapat mengimpor berks vCard yang bisa Anda dapatkan dari Google Contacts atau pengelola Kontak Anda.',
    'import_blank_cta' => 'Impor vCard',
    'import_need_subscription' => 'Mengimpor data memerlukan sebuah langganan.',

    'tags_list_title' => 'Tag',
    'tags_list_description' => 'Anda dapat mengkategorikan kontak Anda dengan mengatur tag. Tag berfungsi seperti folder, tetapi Anda dapat menambahkan lebih dari satu tag ke kontak. Untuk menambahkan sebuah tag baru, tambahkan tag pada kontak tersebut.',
    'tags_list_contact_number' => ':count kontak',
    'tags_list_delete_success' => 'Tag telah berhasil dihapus',
    'tags_list_delete_confirmation' => 'Apakah Anda yakin ingin menghapus tag? Tidak ada kontak yang akan dihapus, hanya tag saja.',
    'tags_blank_title' => 'Tag adalah sebuah cara yang bagus untuk mengkategorikan kontak Anda.',
    'tags_blank_description' => 'Tag bekerja seperti folder, tetapi Anda dapat menambahkan lebih dari satu tag ke kontak. Cari sebuah kontak dan tag seorang teman, tepat di bawah namanya. Setelah sebuah kontak ditambhkan tag, kembali ke sini untuk mengelola semua tag di akun Anda.',

    'api_title' => 'Akses API',
    'api_description' => 'API dapat digunakan untuk memanipulasi data Monica dari aplikasi eksternal, seperti aplikasi seluler misalnya.',
    'api_help' => 'Untuk menggunakan API, sebuah token bersifat wajib. Anda dapat membuat token akses pribadi (Bearer authentication), atau mengotorisasi sebuah klien OAuth untuk membuatnya untuk Anda. Lihat <a href=":url">Dokumentasi API</a>.',
    'api_endpoint' => 'Endpoint API untuk contoh pemasangan Monica ini adalah:',

    'api_personal_access_tokens' => 'Token akses pribadi',
    'api_pao_description' => 'Pastikan Anda memberikan token ini kepada sebuah sumber yang Anda percayai - karena token tersebut mengizinkan Anda untuk mengakses semua data Anda.',
    'api_token_title' => 'Token Akses Pribadi',
    'api_token_create_new' => 'Buat Token Baru',
    'api_token_not_created' => 'Anda belum membuat token akses pribadi apapun.',
    'api_token_name' => 'Nama token',
    'api_token_expire' => 'Kadaluarsa pada {date}',
    'api_token_delete' => 'Hapus',
    'api_token_create' => 'Buat Token',
    'api_token_scopes' => 'Lingkup',
    'api_token_help' => 'Ini adalah token akses pribadi baru Anda. Ditampilkan hanya sekali ini saja, jadi jangan hilangkan token tersebut! Anda sekarang dapat menggunakan token ini untuk membuat permintaan API.',

    'api_oauth_clients' => 'Klien OAuth Anda',
    'api_oauth_clients_desc' => 'Bagian ini memungkinkan Anda mendaftarkan klien OAuth Anda sendiri.',
    'api_oauth_clients_desc2' => 'Gunakan ID klien ini untuk meminta sebuah token baru, dan mengkonversi kode otorisasi untuk mengakses token. Lihat <a href="{url}">Dokumentasi Passport Laravel</a> untuk informasi lebih lanjut.',
    'api_oauth_title' => 'Klien OAuth',
    'api_oauth_create_new' => 'Buat Klien Baru',
    'api_oauth_edit' => 'Sunting Klien',
    'api_oauth_not_created' => 'Anda belum membuat klien OAuth apapun.',
    'api_oauth_clientid' => 'ID Klien',
    'api_oauth_name' => 'Nama',
    'api_oauth_name_help' => 'Sesuatu yang akan dikenali dan dipercaya oleh pengguna Anda.',
    'api_oauth_secret' => 'Kunci Rahasia',
    'api_oauth_create' => 'Buat Klien',
    'api_oauth_redirecturl' => 'URL Pengalihan',
    'api_oauth_redirecturl_help' => 'URL panggilan balik otorisasi aplikasi Anda.',

    'api_authorized_clients' => 'Daftar klien resmi',
    'api_authorized_clients_desc' => 'Bagian ini mencantumkan semua klien yang telah Anda otorisasi untuk mengakses data aplikasi Anda. Anda dapat mencabut otorisasi ini kapan saja.',
    'api_authorized_clients_title' => 'Aplikasi Resmi',
    'api_authorized_clients_none' => 'Belum ada klien resmi.',
    'api_authorized_clients_name' => 'Nama',
    'api_authorized_clients_scopes' => 'Lingkup',

    'personalization_tab_title' => 'Personalisasi akun Anda',

    'personalization_title' => 'Di sini Anda akan menemukan pengaturan yang berbeda untuk mengkonfigurasi akun Anda. Fitur ini ditujukan untuk "pengguna super" yang menginginkan kontrol maksimum atas Monica.',
    'personalization_contact_field_type_title' => 'Jenis baris kontak',
    'personalization_contact_field_type_add' => 'Tambah jenis baris baru',
    'personalization_contact_field_type_description' => 'Anda dapat mengkonfigurasi semua jenis baris kontak yang berbeda yang dapat Anda kaitkan ke semua kontak Anda. Misalnya, jika sebuah jejaring sosial baru muncul di masa mendatang, Anda akan dapat menambahkan cara baru berkomunikasi ini dengan kontak Anda di sini.',
    'personalization_contact_field_type_table_name' => 'Nama',
    'personalization_contact_field_type_table_protocol' => 'Protokol',
    'personalization_contact_field_type_table_actions' => 'Tindakan',
    'personalization_contact_field_type_modal_title' => 'Tambah jenis baris kontak baru',
    'personalization_contact_field_type_modal_edit_title' => 'Sunting jenis bidang kontak yang telah tersedia',
    'personalization_contact_field_type_modal_delete_title' => 'Hapus jenis bidang kontak yang telah tersedia',
    'personalization_contact_field_type_modal_delete_description' => 'Apakah Anda yakin ingin menghapus jenis baris kontak ini? Menghapus jenis baris kontak ini akan menghapus SEMUA data dengan jenis ini untuk semua kontak Anda.',
    'personalization_contact_field_type_modal_name' => 'Nama',
    'personalization_contact_field_type_modal_protocol' => 'Protokol (opsional)',
    'personalization_contact_field_type_modal_protocol_help' => 'Setiap jenis baris kontak yang baru dapat diklik. Jika sebuah protokol diatur, kami akan menggunakannya untuk memicu tindakan yang diatur.',
    'personalization_contact_field_type_modal_icon' => 'Ikon (opsional)',
    'personalization_contact_field_type_modal_icon_help' => 'Anda dapat mengaitkan sebuah ikon dengan jenis baris kontak ini. Anda perlu menambahkan sebuah referensi ke sebuah ikon Font Awesome.',
    'personalization_contact_field_type_delete_success' => 'Jenis baris kontak telah berhasil dihapus.',
    'personalization_contact_field_type_add_success' => 'Jenis baris kontak telah berhasil ditambahkan.',
    'personalization_contact_field_type_edit_success' => 'Jenis baris kontak telah berhasil diperbarui.',

    'personalization_genders_title' => 'Jenis Kelamin',
    'personalization_genders_add' => 'Tambahkan jenis kelamin baru',
    'personalization_genders_desc' => 'Anda dapat mendefinisikan jenis kelamin yang Anda butuhkan sebanyak mungkin. Anda memerlukan setidaknya satu jenis kelamin di akun Anda.',
    'personalization_genders_modal_add' => 'Tambah jenis kelamin',
    'personalization_genders_modal_edit' => 'Perbarui jenis kelamin',
    'personalization_genders_modal_name' => 'Nama',
    'personalization_genders_modal_name_help' => 'Nama yang digunakan untuk menampilkan jenis kelamin pada sebuah halaman kontak.',
    'personalization_genders_modal_sex' => 'Jenis Kelamin',
    'personalization_genders_modal_sex_help' => 'Digunakan untuk mendefinisikan hubungan relasi, dan selama proses impor/ekspor vCard.',
    'personalization_genders_modal_default' => 'Pilih jenis kelamin standar untuk kontak baru',
    'personalization_genders_modal_delete' => 'Hapus jenis kelamin',
    'personalization_genders_modal_delete_desc' => 'Apakah Anda yakin ingin menghapus jenis kelamin "{name}"?',
    'personalization_genders_modal_delete_question' => 'Anda saat ini memiliki {count} kontak dengan jenis kelamin ini. Jika Anda menghapus jenis kelamin ini, jenis kelamin apa yang harus dimiliki kontak tersebut?',
    'personalization_genders_modal_delete_question_default' => 'Jenis kelamin ini adalah yang standar. Jika Anda menghapus jenis kelamin ini, yang mana yang akan menjadi standar yang baru?',
    'personalization_genders_modal_error' => 'Silakan pilih sebuah jenis kelamin dari daftar.',
    'personalization_genders_list_contact_number' => '{count} kontak',
    'personalization_genders_table_name' => 'Nama',
    'personalization_genders_table_sex' => 'Jenis Kelamin',
    'personalization_genders_table_default' => 'Standar',
    'personalization_genders_default' => 'Jenis kelamin standar',
    'personalization_genders_make_default' => 'Ubah jenis kelamin standar',
    'personalization_genders_select_default' => 'Pilih jenis kelamin standar',
    'personalization_genders_m' => 'Pria',
    'personalization_genders_f' => 'Wanita',
    'personalization_genders_o' => 'Lainnya',
    'personalization_genders_u' => 'Tidak Diketahui',
    'personalization_genders_n' => 'Tidak ada atau tidak berlaku',

    'personalization_reminder_rule_save' => 'Perubahan telah disimpan',
    'personalization_reminder_rule_title' => 'Aturan pengingat',
    'personalization_reminder_rule_line' => '{count} hari sebelumnya',
    'personalization_reminder_rule_desc' => 'Untuk setiap pengingat yang Anda telah atur, Monica dapat mengirimkan email kepada Anda beberapa hari sebelum peristiwa terjadi.  Anda dapat menyesuaikan pengaturan pemberitahuan ini di sini. Pemberitahuan ini hanya berlaku untuk pengingat bulanan dan tahunan.',

    'personalization_module_save' => 'Perubahan telah disimpan',
    'personalization_module_title' => 'Fitur',
    'personalization_module_desc' => 'Anda mungkin tidak memerlukan semua fitur Monica. Di bawah ini Anda dapat mengaktifkan fitur spesifik yang digunakan pada sebuah lembar kontak. Perubahan ini akan memengaruhi SEMUA kontak Anda. Menonaktifkan sebuah fitur tidak akan menghapus data apapun, hanya menyembunyikan fitur tersebut.',

    'personalisation_paid_upgrade' => 'Ini adalah fitur premium yang memerlukan langganan Berbayar untuk dapat diaktifkan. Tingkatkan akun Anda dengan mengunjungi <a href=":url">Pengaturan > Berlangganan</a>.',
    'personalisation_paid_upgrade_vue' => 'Ini adalah fitur premium yang memerlukan sebuah langganan Berbayar untuk dapat diaktifkan. Tingkatkan akun Anda dengan mengunjungi <a href="{url}">Pengaturan > Berlangganan</a>.',

    'reminder_time_to_send' => 'Pengingat waktu dalam hari akan dikirim',
    'reminder_time_to_send_help' => 'Pengingat Anda berikutnya dijadwalkan untuk dikirimkan pada <span title="{dateTimeUtc}" class="reminder-info">{dateTime}</span>.',

    'personalization_activity_type_category_title' => 'Kategori jenis aktifitas',
    'personalization_activity_type_category_add' => 'Tambahkan sebuah kategori jenis aktifitas baru',
    'personalization_activity_type_category_table_name' => 'Nama',
    'personalization_activity_type_category_description' => 'Sebuah aktifitas dengan salah satu kontak Anda dapat memiliki sebuah jenis dan sebuah jenis kategori. Akun Anda dilengkapi dengan satu set jenis kategori yang telah ditentukan secara standar, tetapi Anda dapat menyesuaikan ini di sini.',
    'personalization_activity_type_category_table_actions' => 'Tindakan',
    'personalization_activity_type_category_modal_add' => 'Tambahkan sebuah kategori jenis aktifitas baru',
    'personalization_activity_type_category_modal_edit' => 'Sunting sebuah kategori jenis aktifitas',
    'personalization_activity_type_category_modal_question' => 'Harus kita namakan apa kategori baru ini?',
    'personalization_activity_type_add_button' => 'Tambahkan sebuah jenis aktifitas baru',
    'personalization_activity_type_modal_add' => 'Tambahkan sebuah jenis aktifitas baru',
    'personalization_activity_type_modal_question' => 'Harus kita namakan apa aktifitas baru ini?',
    'personalization_activity_type_modal_edit' => 'Sunting sebuah jenis aktifitas',
    'personalization_activity_type_category_modal_delete' => 'Hapus sebuah kategori jenis aktifitas',
    'personalization_activity_type_category_modal_delete_desc' => 'Apakah Anda yakin ingin menghapus kategori ini? Menghapusnya akan menghapus semua jenis aktifitas terkait. Aktifitas yang termasuk kedalam kategori ini tidak akan terpengaruh oleh penghapusan ini.',
    'personalization_activity_type_modal_delete' => 'Hapus sebuah jenis aktifitas',
    'personalization_activity_type_modal_delete_desc' => 'Apakah Anda yakin ingin menghapus jenis aktifitas ini? Aktifitas yang termasuk kedalam kategori ini tidak akan terpengaruh oleh penghapusan ini.',
    'personalization_activity_type_modal_delete_error' => 'Kami tidak dapat menemukan jenis aktifitas ini.',
    'personalization_activity_type_category_modal_delete_error' => 'Kami tidak dapat menemukan kategori jenis aktifitas ini.',

    'personalization_life_event_category_title' => 'Kategori peristiwa Kehidupan',
    'personalization_live_event_category_table_name' => 'Nama',
    'personalization_life_event_category_description' => 'Sebuah peristiwa kehidupan dapat memiliki sebuah jenis dan kategori. Akun Anda dilengkapi dengan serangkaian kategori dan jenis yang telah ditentukan secara standar, tetapi Anda dapat menyesuaikan jenis peritiswa kehidupan di sini.',
    'personalization_live_event_category_table_actions' => 'Tindakan',
    'personalization_life_event_type_add_button' => 'Tambahkan sebuah jenis peristiwa kehidupan baru',
    'personalization_life_event_type_modal_add' => 'Tambahkan sebuah jenis peristiwa kehidupan baru',
    'personalization_life_event_type_modal_question' => 'Harus kita namakan apa jenis peristiwa kehidupan baru ini?',
    'personalization_life_event_type_modal_edit' => 'Sunting sebuah jenis peristiwa kehidupan',
    'personalization_life_event_type_modal_delete' => 'Hapus sebuah jenis peristiwa kehidupan',
    'personalization_life_event_type_modal_delete_desc' => 'Apakah Anda yakin ingin menghapus jenis peristiwa kehidupan ini? Peristiwa kehidupan yang termasuk dalam jenis ini akan dihapus dengan melakukan tindakan ini.',
    'personalization_life_event_type_modal_delete_error' => 'Kami tidak dapat menemukan jenis peristiwa kehidupan ini.',

    'personalization_life_event_category_work_education' => 'Pekerjaan & edukasi',
    'personalization_life_event_category_family_relationships' => 'Keluarga & hubungan relasi',
    'personalization_life_event_category_home_living' => 'Rumah & kehidupan',
    'personalization_life_event_category_travel_experiences' => 'Wisata & pengalaman',
    'personalization_life_event_category_health_wellness' => 'Kesehatan & kebugaran',

    'personalization_life_event_type_new_job' => 'Pekerjaan baru',
    'personalization_life_event_type_retirement' => 'Pensiunan',
    'personalization_life_event_type_new_school' => 'Sekolah baru',
    'personalization_life_event_type_study_abroad' => 'Belajar diluar negeri',
    'personalization_life_event_type_volunteer_work' => 'Pekerjaan sukarela',
    'personalization_life_event_type_published_book_or_paper' => 'Menerbitkan sebuah buku atau makalah',
    'personalization_life_event_type_military_service' => 'Pelayanan militer',
    'personalization_life_event_type_first_met' => 'Pertama kali bertemu',
    'personalization_life_event_type_new_relationship' => 'Hubungan baru',
    'personalization_life_event_type_engagement' => 'Bertunangan',
    'personalization_life_event_type_marriage' => 'Pernikahan',
    'personalization_life_event_type_anniversary' => 'Perayaan Hari Pernikahan',
    'personalization_life_event_type_expecting_a_baby' => 'Mengharapkan seorang bayi',
    'personalization_life_event_type_new_child' => 'Anak baru',
    'personalization_life_event_type_new_family_member' => 'Anggota keluarga baru',
    'personalization_life_event_type_new_pet' => 'Hewan peliharan baru',
    'personalization_life_event_type_end_of_relationship' => 'Akhir dari hubungan',
    'personalization_life_event_type_loss_of_a_loved_one' => 'Kehilangan orang yang dicintai',
    'personalization_life_event_type_moved' => 'Pindah',
    'personalization_life_event_type_bought_a_home' => 'Membeli sebuah rumah',
    'personalization_life_event_type_home_improvement' => 'Perbaikan rumah',
    'personalization_life_event_type_holidays' => 'Liburan',
    'personalization_life_event_type_new_vehicle' => 'Kendaraan baru',
    'personalization_life_event_type_new_roommate' => 'Teman sekamar baru',
    'personalization_life_event_type_overcame_an_illness' => 'Sembuh dari sebuah penyakit',
    'personalization_life_event_type_quit_a_habit' => 'Berhenti dari kebiasaan',
    'personalization_life_event_type_new_eating_habits' => 'Kebiasaan makan baru',
    'personalization_life_event_type_weight_loss' => 'Turun berat badan',
    'personalization_life_event_type_wear_glass_or_contact' => 'Mulai mengenakan kacamata atau kontak',
    'personalization_life_event_type_broken_bone' => 'Patah tulang',
    'personalization_life_event_type_removed_braces' => 'Melepaskan kawat gigi',
    'personalization_life_event_type_surgery' => 'Menjalani operasi',
    'personalization_life_event_type_dentist' => 'Melakukan perawatan gigi',
    'personalization_life_event_type_new_sport' => 'Memulai memainkan sebuah olahraga baru',
    'personalization_life_event_type_new_hobby' => 'Mengambil sebuah hobi baru',
    'personalization_life_event_type_new_instrument' => 'Memulai belajar sebuah instrumen baru',
    'personalization_life_event_type_new_language' => 'Memulai belajar sebuah bahasa baru',
    'personalization_life_event_type_tattoo_or_piercing' => 'Tato atau tindik',
    'personalization_life_event_type_new_license' => 'SIM baru',
    'personalization_life_event_type_travel' => 'Wisata',
    'personalization_life_event_type_achievement_or_award' => 'Prestasi atau penghargaan',
    'personalization_life_event_type_changed_beliefs' => 'Berubah keyakinan',
    'personalization_life_event_type_first_word' => 'Kata pertama',
    'personalization_life_event_type_first_kiss' => 'Ciuman pertama',

    'storage_title' => 'Ruang Peyimpanan',
    'storage_account_info' => 'Batas akun Anda adalah :accountLimit MB. Penggunaan Anda saat ini adalah :currentAccountSize MB (sekitar :percentUsage%).',
    'storage_upgrade_notice' => 'Tingkatkan akun Anda àgar dapat mengunggah dokumen dan foto.',
    'storage_description' => 'Di sini Anda dapat melihat semua dokumen dan foto yang telah diunggah tentang kontak Anda.',

    'dav_title' => 'WebDAV',
    'dav_description' => 'Di sini Anda dapat menemukan semua pengaturan untuk menggunakan sumber daya WebDAV untuk ekspor CardDAV dan CalDAV.',
    'dav_copy_help' => 'Salin ke papanklip Anda',
    'dav_clipboard_copied' => 'Nilai disalin ke dalam papanklip Anda',
    'dav_url_base' => 'Url Dasar untuk semua sumber daya CardDAV dan CalDAV:',
    'dav_connect_help' => 'Anda dapat menghubungkan kontak dan/atau kalender Anda dengan url dasar ini pada ponsel atau komputer Anda.',
    'dav_connect_help2' => 'Gunakan login Anda (email) dan buat sebuah token API sebagai kata sandi untuk mengotentikasi.',
    'dav_url_carddav' => 'Url CardDAV untuk sumber daya Kontak:',
    'dav_url_caldav_birthdays' => 'Url CalDAV untuk sumber daya Ulang Tahun:',
    'dav_url_caldav_tasks' => 'Url CalDAV untuk sumber daya Tugas:',
    'dav_title_carddav' => 'CardDAV',
    'dav_title_caldav' => 'CalDAV',
    'dav_carddav_export' => 'Ekspor semua kontak dalam satu berkas',
    'dav_caldav_birthdays_export' => 'Ekspor semua ulang tahun dalam satu berkas',
    'dav_caldav_tasks_export' => 'Ekspor semua tugas dalam satu berkas',

    'archive_title' => 'Arsipkan semua kontak di akun Anda',
    'archive_desc' => 'Ini akan mengarsipkan semua kontak di akun Anda.',
    'archive_cta' => 'Arsipkan semua kontak Anda',

    'logs_title' => 'Segala sesuatu yang telah terjadi pada akun ini',
    'logs_actor' => 'Aktor',
    'logs_timestamp' => 'Timestamp',
    'logs_description' => 'Deskripsi',
    'logs_subject' => 'Subyek',
    'logs_size' => 'Ukuran (Kb)',
    'logs_object' => 'Obyek',
];
