"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DSLFacet = void 0;

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class DSLFacet {
  constructor(client) {
    this.client = client;

    _defineProperty(this, "fetch", async (request, format, responseFormat) => {
      const res = {
        success: false,
        data: {}
      };

      try {
        const params = {
          query: JSON.stringify(request.body)
        };
        const queryRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        const dslDataSource = queryRes;
        res.success = true;
        res.data = dslDataSource;
      } catch (err) {
        console.error(err);
        res.data = err.body;
      }

      return res;
    });

    _defineProperty(this, "describeQuery", async request => {
      return this.fetch(request, 'dsl.dslQuery', 'json');
    });

    this.client = client;
  }

}

exports.DSLFacet = DSLFacet;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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