/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.AbstractList;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidatorException;
import org.apache.calcite.util.NlsString;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class SqlOperatorBinding {
    protected final RelDataTypeFactory typeFactory;
    private final SqlOperator sqlOperator;

    protected SqlOperatorBinding(RelDataTypeFactory typeFactory, SqlOperator sqlOperator) {
        this.typeFactory = typeFactory;
        this.sqlOperator = sqlOperator;
    }

    public int getGroupCount() {
        return -1;
    }

    public boolean hasFilter() {
        return false;
    }

    public SqlOperator getOperator() {
        return this.sqlOperator;
    }

    public RelDataTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Deprecated
    public @Nullable String getStringLiteralOperand(int ordinal) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public int getIntLiteralOperand(int ordinal) {
        throw new UnsupportedOperationException();
    }

    public <T> @Nullable T getOperandLiteralValue(int ordinal, Class<T> clazz) {
        throw new UnsupportedOperationException();
    }

    public @Nullable Object getOperandLiteralValue(int ordinal, RelDataType type) {
        if (!(type instanceof RelDataTypeFactoryImpl.JavaType)) {
            return null;
        }
        Class clazz = ((RelDataTypeFactoryImpl.JavaType)type).getJavaClass();
        Object o = this.getOperandLiteralValue(ordinal, Object.class);
        if (o == null) {
            return null;
        }
        if (clazz.isInstance(o)) {
            return clazz.cast(o);
        }
        Object o2 = o instanceof NlsString ? ((NlsString)o).getValue() : o;
        return EnumUtils.evaluate(o2, clazz);
    }

    @Deprecated
    public @Nullable Comparable getOperandLiteralValue(int ordinal) {
        return this.getOperandLiteralValue(ordinal, Comparable.class);
    }

    public boolean isOperandNull(int ordinal, boolean allowCast) {
        throw new UnsupportedOperationException();
    }

    public boolean isOperandLiteral(int ordinal, boolean allowCast) {
        throw new UnsupportedOperationException();
    }

    public boolean isOperandTimeFrame(int ordinal) {
        return this.getOperandCount() > 0 && SqlTypeName.TIME_FRAME_TYPES.contains((Object)this.getOperandType(ordinal).getSqlTypeName());
    }

    public abstract int getOperandCount();

    public abstract RelDataType getOperandType(int var1);

    public SqlMonotonicity getOperandMonotonicity(int ordinal) {
        return SqlMonotonicity.NOT_MONOTONIC;
    }

    public RelDataType getCollationType() {
        throw new UnsupportedOperationException();
    }

    public List<RelDataType> collectOperandTypes() {
        return new AbstractList<RelDataType>(){

            @Override
            public RelDataType get(int index) {
                return SqlOperatorBinding.this.getOperandType(index);
            }

            @Override
            public int size() {
                return SqlOperatorBinding.this.getOperandCount();
            }
        };
    }

    public @Nullable RelDataType getCursorOperand(int ordinal) {
        throw new UnsupportedOperationException();
    }

    public @Nullable String getColumnListParamInfo(int ordinal, String paramName, List<String> columnList) {
        throw new UnsupportedOperationException();
    }

    public abstract CalciteException newError(Resources.ExInst<SqlValidatorException> var1);
}

