/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutorServiceUtils {
    public static ExecutorService createExecutorService(int maxConcurrentThreads, Class<?> clazz) {
        String baseName = clazz.getSimpleName();
        ClassLoader classLoader = clazz.getClassLoader();
        AccountingThreadFactory threadFactory = new AccountingThreadFactory(classLoader, baseName);
        return new AccountingExecutorService(maxConcurrentThreads, threadFactory);
    }

    static final class AccountingExecutorService
    implements ExecutorService {
        private final ExecutorService delegate;
        private final AccountingThreadFactory threadFactory;

        public AccountingExecutorService(int maxConcurrentThreads, AccountingThreadFactory threadFactory) {
            this.delegate = Executors.newFixedThreadPool(maxConcurrentThreads, threadFactory);
            this.threadFactory = threadFactory;
        }

        @Override
        public void shutdown() {
            this.delegate.shutdown();
            this.threadFactory.join();
        }

        @Override
        public List<Runnable> shutdownNow() {
            List<Runnable> result = this.delegate.shutdownNow();
            this.threadFactory.join();
            return result;
        }

        @Override
        public boolean isShutdown() {
            return this.delegate.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.delegate.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.awaitTermination(timeout, unit);
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return this.delegate.submit(task);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return this.delegate.submit(task, result);
        }

        @Override
        public Future<?> submit(Runnable task) {
            return this.delegate.submit(task);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return this.delegate.invokeAll(tasks);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.invokeAll(tasks, timeout, unit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return this.delegate.invokeAny(tasks);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.delegate.invokeAny(tasks, timeout, unit);
        }

        @Override
        public void execute(Runnable command) {
            this.delegate.execute(command);
        }
    }

    static final class AccountingThreadFactory
    implements ThreadFactory {
        private final ClassLoader classLoader;
        private final String baseName;
        private final AtomicInteger counter = new AtomicInteger();
        private final List<WeakReference<Thread>> threads = Collections.synchronizedList(new ArrayList());

        public AccountingThreadFactory(ClassLoader classLoader, String baseName) {
            this.classLoader = classLoader;
            this.baseName = baseName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "SharedExecutor-" + this.baseName + "-" + this.counter.getAndIncrement());
            t.setDaemon(true);
            t.setContextClassLoader(this.classLoader);
            this.threads.add(new WeakReference<Thread>(t));
            return t;
        }

        void join() {
            for (WeakReference<Thread> r : this.threads) {
                Thread t = (Thread)r.get();
                if (t == null) continue;
                try {
                    t.join();
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }
}

