/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.placement.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.solr.cluster.Node;
import org.apache.solr.cluster.Replica;
import org.apache.solr.cluster.Shard;
import org.apache.solr.cluster.SolrCollection;
import org.apache.solr.cluster.placement.PlacementContext;
import org.apache.solr.cluster.placement.PlacementException;
import org.apache.solr.cluster.placement.PlacementPlan;
import org.apache.solr.cluster.placement.PlacementPlugin;
import org.apache.solr.cluster.placement.PlacementPluginFactory;
import org.apache.solr.cluster.placement.PlacementRequest;
import org.apache.solr.cluster.placement.ReplicaPlacement;

public class SimplePlacementFactory
implements PlacementPluginFactory<PlacementPluginFactory.NoConfig> {
    @Override
    public PlacementPlugin createPluginInstance() {
        return new SimplePlacementPlugin();
    }

    static class ReplicaCount {
        public final Node node;
        public Map<String, Integer> collectionReplicas;
        public int totalReplicas = 0;

        ReplicaCount(Node node) {
            this.node = node;
            this.collectionReplicas = new HashMap<String, Integer>();
        }

        public int weight(String collection) {
            return this.collectionReplicas.getOrDefault(collection, 0) * 5 + this.totalReplicas;
        }

        public void addReplica(String collection, String shard) {
            this.collectionReplicas.merge(collection, 1, Integer::sum);
        }

        public Node node() {
            return this.node;
        }

        public String nodeName() {
            return this.node.getName();
        }
    }

    public static class SimplePlacementPlugin
    implements PlacementPlugin {
        @Override
        public List<PlacementPlan> computePlacements(Collection<PlacementRequest> requests, PlacementContext placementContext) throws PlacementException {
            ArrayList<PlacementPlan> placementPlans = new ArrayList<PlacementPlan>(requests.size());
            Map<Node, ReplicaCount> nodeVsShardCount = this.getNodeVsShardCount(placementContext);
            for (PlacementRequest request : requests) {
                int totalReplicasPerShard = 0;
                for (Replica.ReplicaType rt : Replica.ReplicaType.values()) {
                    totalReplicasPerShard += request.getCountReplicasToCreate(rt);
                }
                HashSet<ReplicaPlacement> replicaPlacements = new HashSet<ReplicaPlacement>(totalReplicasPerShard * request.getShardNames().size());
                Collection replicaCounts = nodeVsShardCount.values();
                if (request.getTargetNodes().size() < replicaCounts.size()) {
                    replicaCounts = replicaCounts.stream().filter(rc -> request.getTargetNodes().contains(rc.node())).collect(Collectors.toList());
                }
                for (String shard : request.getShardNames()) {
                    List nodeList = replicaCounts.stream().sorted(Comparator.comparingInt(rc -> rc.weight(request.getCollection().getName())).thenComparing(ReplicaCount::nodeName)).map(ReplicaCount::node).collect(Collectors.toList());
                    int replicaNumOfShard = 0;
                    for (Replica.ReplicaType replicaType : Replica.ReplicaType.values()) {
                        for (int i = 0; i < request.getCountReplicasToCreate(replicaType); ++i) {
                            Node assignedNode = (Node)nodeList.get(replicaNumOfShard++ % nodeList.size());
                            replicaPlacements.add(placementContext.getPlacementPlanFactory().createReplicaPlacement(request.getCollection(), shard, assignedNode, replicaType));
                            ReplicaCount replicaCount = nodeVsShardCount.computeIfAbsent(assignedNode, ReplicaCount::new);
                            ++replicaCount.totalReplicas;
                            replicaCount.collectionReplicas.merge(request.getCollection().getName(), 1, Integer::sum);
                        }
                    }
                }
                placementPlans.add(placementContext.getPlacementPlanFactory().createPlacementPlan(request, replicaPlacements));
            }
            return placementPlans;
        }

        private Map<Node, ReplicaCount> getNodeVsShardCount(PlacementContext placementContext) {
            HashMap<Node, ReplicaCount> nodeVsShardCount = new HashMap<Node, ReplicaCount>();
            for (Node s : placementContext.getCluster().getLiveDataNodes()) {
                nodeVsShardCount.computeIfAbsent(s, ReplicaCount::new);
            }
            for (SolrCollection collection : placementContext.getCluster().collections()) {
                for (Shard shard : collection.shards()) {
                    for (Replica replica : shard.replicas()) {
                        ReplicaCount count = nodeVsShardCount.get(replica.getNode());
                        if (count == null) continue;
                        count.addReplica(collection.getName(), shard.getShardName());
                    }
                }
            }
            return nodeVsShardCount;
        }
    }
}

