/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.solr.api.AnnotatedApi;
import org.apache.solr.api.Api;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.AdminHandlersProxy;
import org.apache.solr.handler.admin.api.NodeLoggingAPI;
import org.apache.solr.logging.LogWatcher;
import org.apache.solr.logging.LoggerInfo;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingHandler
extends RequestHandlerBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final LogWatcher<?> watcher;
    private final CoreContainer cc;

    public LoggingHandler(CoreContainer cc) {
        this.cc = cc;
        this.watcher = cc.getLogging();
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        String since;
        String[] set;
        if (this.watcher == null) {
            rsp.add("error", "Logging Not Initialized");
            return;
        }
        rsp.add("watcher", this.watcher.getName());
        SolrParams params = req.getParams();
        if (params.get("threshold") != null) {
            this.watcher.setThreshold(params.get("threshold"));
        }
        if (params.get("test") != null) {
            log.trace("trace message");
            log.debug("debug message");
            RuntimeException exc = new RuntimeException("test");
            log.info("info (with exception) INFO", (Throwable)exc);
            log.warn("warn (with exception) WARN", (Throwable)exc);
            log.error("error (with exception) ERROR", (Throwable)exc);
        }
        if ((set = params.getParams("set")) != null) {
            for (String pair : set) {
                String[] split = pair.split(":");
                if (split.length != 2) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid format, expected level:value, got " + pair);
                }
                String category = split[0];
                String level = split[1];
                this.watcher.setLogLevel(category, level);
            }
        }
        if ((since = req.getParams().get("since")) != null) {
            long time = -1L;
            try {
                time = Long.parseLong(since);
            }
            catch (Exception ex) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "invalid timestamp: " + since);
            }
            AtomicBoolean found = new AtomicBoolean(false);
            SolrDocumentList docs = this.watcher.getHistory(time, found);
            if (docs == null) {
                rsp.add("error", "History not enabled");
                return;
            }
            SimpleOrderedMap info = new SimpleOrderedMap();
            if (time > 0L) {
                info.add("since", (Object)time);
                info.add("found", (Object)found.get());
            } else {
                info.add("levels", this.watcher.getAllLevels());
            }
            info.add("last", (Object)this.watcher.getLastEvent());
            info.add("buffer", (Object)this.watcher.getHistorySize());
            info.add("threshold", (Object)this.watcher.getThreshold());
            rsp.add("info", info);
            rsp.add("history", docs);
        } else {
            rsp.add("levels", this.watcher.getAllLevels());
            ArrayList<LoggerInfo> loggers = new ArrayList<LoggerInfo>(this.watcher.getAllLoggers());
            Collections.sort(loggers);
            ArrayList info = new ArrayList();
            for (LoggerInfo wrap : loggers) {
                info.add(wrap.getInfo());
            }
            rsp.add("loggers", info);
        }
        rsp.setHttpCaching(false);
        if (this.cc != null && AdminHandlersProxy.maybeProxyToNodes(req, rsp, this.cc)) {
            return;
        }
    }

    @Override
    public String getDescription() {
        return "Logging Handler";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    @Override
    public Collection<Api> getApis() {
        return AnnotatedApi.getApis(new NodeLoggingAPI(this));
    }

    @Override
    public Boolean registerV2() {
        return Boolean.TRUE;
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        if (request.getParams().get("set") != null) {
            return PermissionNameProvider.Name.CONFIG_EDIT_PERM;
        }
        return PermissionNameProvider.Name.CONFIG_READ_PERM;
    }
}

