/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.component.ActiveTasksListComponent;
import org.apache.solr.handler.component.QueryCancellationComponent;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.plugin.SolrCoreAware;

public abstract class TaskManagementHandler
extends RequestHandlerBase
implements SolrCoreAware,
PermissionNameProvider {
    private ShardHandlerFactory shardHandlerFactory;

    @Override
    public void inform(SolrCore core) {
        this.shardHandlerFactory = core.getCoreContainer().getShardHandlerFactory();
    }

    protected void processRequest(SolrQueryRequest req, ResponseBuilder rb, Map<String, String> extraParams) throws IOException {
        ShardHandler shardHandler = this.shardHandlerFactory.getShardHandler();
        List<SearchComponent> components = rb.components;
        shardHandler.prepDistributed(rb);
        for (SearchComponent searchComponent : components) {
            searchComponent.prepare(rb);
        }
        if (!rb.isDistrib) {
            for (SearchComponent searchComponent : components) {
                searchComponent.process(rb);
            }
        } else {
            ShardRequest sreq = new ShardRequest();
            sreq.shards = rb.shards;
            sreq.actualShards = sreq.shards;
            sreq.responses = new ArrayList<ShardResponse>(sreq.actualShards.length);
            rb.finished = new ArrayList<ShardRequest>();
            for (String shard : sreq.actualShards) {
                ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)sreq.params);
                String reqPath = (String)req.getContext().get("path");
                params.set("qt", new String[]{reqPath});
                params.remove("shards");
                params.set("distrib", new String[]{"false"});
                params.remove("indent");
                params.remove("echoParams");
                params.set("isShard", true);
                params.set("shards.purpose", sreq.purpose);
                params.set("shard.url", new String[]{shard});
                params.set("omitHeader", false);
                if (extraParams != null) {
                    for (Map.Entry<String, String> entry : extraParams.entrySet()) {
                        params.set(entry.getKey(), new String[]{entry.getValue()});
                    }
                }
                shardHandler.submit(sreq, shard, params);
            }
            ShardResponse shardResponse = shardHandler.takeCompletedOrError();
            if (shardResponse.getException() != null) {
                shardHandler.cancelAll();
                if (shardResponse.getException() instanceof SolrException) {
                    throw (SolrException)shardResponse.getException();
                }
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, shardResponse.getException());
            }
            rb.finished.add(shardResponse.getShardRequest());
            for (SearchComponent c : components) {
                c.handleResponses(rb, shardResponse.getShardRequest());
            }
        }
    }

    public static List<SearchComponent> buildComponentsList() {
        ArrayList<SearchComponent> components = new ArrayList<SearchComponent>(2);
        QueryCancellationComponent component = new QueryCancellationComponent();
        components.add(component);
        ActiveTasksListComponent activeTasksListComponent = new ActiveTasksListComponent();
        components.add(activeTasksListComponent);
        return components;
    }

    public static ResponseBuilder buildResponseBuilder(SolrQueryRequest req, SolrQueryResponse rsp, List<SearchComponent> components) {
        CoreContainer cc = req.getCoreContainer();
        boolean isZkAware = cc.isZooKeeperAware();
        ResponseBuilder rb = new ResponseBuilder(req, rsp, components);
        rb.isDistrib = req.getParams().getBool("distrib", isZkAware);
        return rb;
    }
}

