/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.configsets;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.jersey.SolrJerseyResponse;
import org.apache.solr.security.PermissionNameProvider;

@Path(value="/cluster/configs")
public class ListConfigSetsAPI
extends JerseyResource {
    @Context
    public HttpHeaders headers;
    private final CoreContainer coreContainer;

    @Inject
    public ListConfigSetsAPI(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
    }

    @GET
    @Produces(value={"application/json", "application/javabin"})
    @Operation(summary="List the configsets available to Solr.", tags={"configset"})
    @PermissionName(value=PermissionNameProvider.Name.CONFIG_READ_PERM)
    public ListConfigsetsResponse listConfigSet() throws Exception {
        ListConfigsetsResponse response = this.instantiateJerseyResponse(ListConfigsetsResponse.class);
        response.configSets = this.coreContainer.getConfigSetService().listConfigs();
        return response;
    }

    public static class ListConfigsetsResponse
    extends SolrJerseyResponse {
        @JsonProperty(value="configSets")
        public List<String> configSets;
    }
}

