/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.facet.AggValueSource;
import org.apache.solr.search.facet.FacetField;
import org.apache.solr.search.facet.FacetHeatmap;
import org.apache.solr.search.facet.FacetQuery;
import org.apache.solr.search.facet.FacetRangeParser;
import org.apache.solr.search.facet.FacetRequest;

abstract class FacetParser<T extends FacetRequest> {
    protected T facet;
    protected FacetParser<?> parent;
    protected String key;

    public FacetParser(FacetParser<?> parent, String key) {
        this.parent = parent;
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public String getPathStr() {
        if (this.parent == null) {
            return "/" + this.key;
        }
        return this.parent.getKey() + "/" + this.key;
    }

    protected RuntimeException err(String msg) {
        return new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg + " , path=" + this.getPathStr());
    }

    public abstract FacetRequest parse(Object var1) throws SyntaxError;

    public void parseSubs(Object o) throws SyntaxError {
        if (o == null) {
            return;
        }
        if (o instanceof Map) {
            Map m = (Map)o;
            for (Map.Entry entry : m.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if ("processEmpty".equals(key)) {
                    ((FacetRequest)this.facet).processEmpty = this.getBoolean(m, "processEmpty", false);
                    continue;
                }
                Object parsedValue = this.parseFacetOrStat(key, value);
                if (parsedValue instanceof FacetRequest) {
                    ((FacetRequest)this.facet).addSubFacet(key, (FacetRequest)parsedValue);
                    continue;
                }
                if (parsedValue instanceof AggValueSource) {
                    ((FacetRequest)this.facet).addStat(key, (AggValueSource)((Object)parsedValue));
                    continue;
                }
                throw this.err("Unknown facet type key=" + key + " class=" + (parsedValue == null ? "null" : parsedValue.getClass().getName()));
            }
        } else {
            throw this.err("Expected map for facet/stat");
        }
    }

    public Object parseFacetOrStat(String key, Object o) throws SyntaxError {
        Map args;
        String type;
        if (o instanceof String) {
            return this.parseStringFacetOrStat(key, (String)o);
        }
        if (!(o instanceof Map)) {
            throw this.err("expected Map but got " + o);
        }
        Map m = (Map)o;
        if (m.size() == 1) {
            Map.Entry entry = m.entrySet().iterator().next();
            type = (String)entry.getKey();
            args = entry.getValue();
        } else {
            Object typeObj = m.get("type");
            if (!(typeObj instanceof String)) {
                throw this.err("expected facet/stat type name, like {type:range, field:price, ...} but got " + typeObj);
            }
            type = (String)typeObj;
            args = m;
        }
        return this.parseFacetOrStat(key, type, args);
    }

    public Object parseFacetOrStat(String key, String type, Object args) throws SyntaxError {
        switch (type) {
            case "field": 
            case "terms": {
                return new FacetFieldParser(this, key).parse(args);
            }
            case "query": {
                return new FacetQueryParser(this, key).parse(args);
            }
            case "range": {
                return new FacetRangeParser(this, key).parse(args);
            }
            case "heatmap": {
                return new FacetHeatmap.Parser(this, key).parse(args);
            }
            case "func": {
                return this.parseStat(key, args);
            }
        }
        throw this.err("Unknown facet or stat. key=" + key + " type=" + type + " args=" + args);
    }

    public Object parseStringFacetOrStat(String key, String s) throws SyntaxError {
        return this.parseStat(key, s);
    }

    private AggValueSource parseStatWithParams(String key, SolrParams localparams, String stat) throws SyntaxError {
        SolrQueryRequest req = this.getSolrRequest();
        FunctionQParser parser = new FunctionQParser(stat, localparams, req.getParams(), req);
        AggValueSource agg = parser.parseAgg(1);
        return agg;
    }

    private AggValueSource parseStat(String key, Object args) throws SyntaxError {
        assert (null != args);
        if (args instanceof CharSequence) {
            return this.parseStatWithParams(key, null, args.toString());
        }
        if (args instanceof Map) {
            Map statMap = (Map)args;
            return this.parseStatWithParams(key, FacetParser.jsonToSolrParams(statMap), statMap.get("func").toString());
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Stats must be specified as either a simple string, or a json Map");
    }

    private FacetRequest.Domain getDomain() {
        if (((FacetRequest)this.facet).domain == null) {
            ((FacetRequest)this.facet).domain = new FacetRequest.Domain();
        }
        return ((FacetRequest)this.facet).domain;
    }

    protected void parseCommonParams(Object o) {
        if (o instanceof Map) {
            Object domainObj;
            Map m = (Map)o;
            List<String> excludeTags = this.getStringList(m, "excludeTags");
            if (excludeTags != null) {
                this.getDomain().excludeTags = excludeTags;
            }
            if ((domainObj = m.get("domain")) instanceof Map) {
                Map domainMap = (Map)domainObj;
                FacetRequest.Domain domain = this.getDomain();
                excludeTags = this.getStringList(domainMap, "excludeTags");
                if (excludeTags != null) {
                    domain.excludeTags = excludeTags;
                }
                if (domainMap.containsKey("query")) {
                    domain.explicitQueries = this.parseJSONQueryStruct(domainMap.get("query"));
                    if (null == domain.explicitQueries) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'query' domain can not be null or empty");
                    }
                    if (null != domain.excludeTags) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'query' domain can not be combined with 'excludeTags'");
                    }
                }
                String blockParent = this.getString(domainMap, "blockParent", null);
                String blockChildren = this.getString(domainMap, "blockChildren", null);
                if (blockParent != null) {
                    domain.toParent = true;
                    domain.parents = blockParent;
                } else if (blockChildren != null) {
                    domain.toChildren = true;
                    domain.parents = blockChildren;
                }
                FacetRequest.Domain.JoinField.createJoinField(domain, domainMap);
                FacetRequest.Domain.GraphField.createGraphField(domain, domainMap);
                Object filterOrList = domainMap.get("filter");
                if (filterOrList != null) {
                    assert (domain.filters == null);
                    domain.filters = this.parseJSONQueryStruct(filterOrList);
                }
            } else if (domainObj != null) {
                throw this.err("Expected Map for 'domain', received " + domainObj.getClass().getSimpleName() + "=" + domainObj);
            }
        }
    }

    private List<Object> parseJSONQueryStruct(Object raw) {
        ArrayList<Object> result = null;
        if (null == raw) {
            return result;
        }
        if (raw instanceof List) {
            result = (ArrayList<Object>)raw;
        } else {
            result = new ArrayList<Object>(1);
            result.add(raw);
        }
        return result;
    }

    public String getField(Map<String, Object> args) {
        Object fieldName = args.get("field");
        if (fieldName == null) {
            fieldName = args.get("f");
        }
        if (fieldName == null) {
            throw this.err("Missing 'field'");
        }
        if (!(fieldName instanceof String)) {
            throw this.err("Expected string for 'field', got" + fieldName);
        }
        return (String)fieldName;
    }

    public Long getLongOrNull(Map<String, Object> args, String paramName, boolean required) {
        Object o = args.get(paramName);
        if (o == null) {
            if (required) {
                throw this.err("Missing required parameter '" + paramName + "'");
            }
            return null;
        }
        if (!(o instanceof Long || o instanceof Integer || o instanceof Short || o instanceof Byte)) {
            throw this.err("Expected integer type for param '" + paramName + "' but got " + o);
        }
        return ((Number)o).longValue();
    }

    public long getLong(Map<String, Object> args, String paramName, long defVal) {
        Object o = args.get(paramName);
        if (o == null) {
            return defVal;
        }
        if (!(o instanceof Long || o instanceof Integer || o instanceof Short || o instanceof Byte)) {
            throw this.err("Expected integer type for param '" + paramName + "' but got " + o.getClass().getSimpleName() + " = " + o);
        }
        return ((Number)o).longValue();
    }

    public Double getDoubleOrNull(Map<String, Object> args, String paramName, boolean required) {
        Object o = args.get(paramName);
        if (o == null) {
            if (required) {
                throw this.err("Missing required parameter '" + paramName + "'");
            }
            return null;
        }
        if (!(o instanceof Number)) {
            throw this.err("Expected double type for param '" + paramName + "' but got " + o);
        }
        return ((Number)o).doubleValue();
    }

    public boolean getBoolean(Map<String, Object> args, String paramName, boolean defVal) {
        Object o = args.get(paramName);
        if (o == null) {
            return defVal;
        }
        if (!(o instanceof Boolean)) {
            throw this.err("Expected boolean type for param '" + paramName + "' but got " + o.getClass().getSimpleName() + " = " + o);
        }
        return (Boolean)o;
    }

    public Boolean getBooleanOrNull(Map<String, Object> args, String paramName) {
        Object o = args.get(paramName);
        if (o != null && !(o instanceof Boolean)) {
            throw this.err("Expected boolean type for param '" + paramName + "' but got " + o.getClass().getSimpleName() + " = " + o);
        }
        return (Boolean)o;
    }

    public String getString(Map<String, Object> args, String paramName, String defVal) {
        Object o = args.get(paramName);
        if (o == null) {
            return defVal;
        }
        if (!(o instanceof String)) {
            throw this.err("Expected string type for param '" + paramName + "' but got " + o.getClass().getSimpleName() + " = " + o);
        }
        return (String)o;
    }

    public Object getVal(Map<String, Object> args, String paramName, boolean required) {
        Object o = args.get(paramName);
        if (o == null && required) {
            throw this.err("Missing required parameter: '" + paramName + "'");
        }
        return o;
    }

    public List<String> getStringList(Map<String, Object> args, String paramName) {
        return this.getStringList(args, paramName, true);
    }

    public List<String> getStringList(Map<String, Object> args, String paramName, boolean decode) {
        Object o = args.get(paramName);
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            return (List)o;
        }
        if (o instanceof String) {
            return StrUtils.splitSmart((String)((String)o), (String)",", (boolean)decode).stream().map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        }
        throw this.err("Expected list of string or comma separated string values for '" + paramName + "', received " + o.getClass().getSimpleName() + "=" + o);
    }

    public IndexSchema getSchema() {
        return this.parent.getSchema();
    }

    public SolrQueryRequest getSolrRequest() {
        return this.parent.getSolrRequest();
    }

    public static SolrParams jsonToSolrParams(Map jsonObject) {
        NamedList nl = new NamedList();
        nl.addAll(jsonObject);
        return SolrParams.toSolrParams((NamedList)nl);
    }

    static class FacetFieldParser
    extends FacetParser<FacetField> {
        public FacetFieldParser(FacetParser<?> parent, String key) {
            super(parent, key);
            this.facet = new FacetField();
        }

        @Override
        public FacetField parse(Object arg) throws SyntaxError {
            this.parseCommonParams(arg);
            if (arg instanceof String) {
                ((FacetField)this.facet).field = (String)arg;
            } else if (arg instanceof Map) {
                Map m = (Map)arg;
                ((FacetField)this.facet).field = this.getField(m);
                ((FacetField)this.facet).offset = this.getLong(m, "offset", ((FacetField)this.facet).offset);
                ((FacetField)this.facet).limit = this.getLong(m, "limit", ((FacetField)this.facet).limit);
                ((FacetField)this.facet).overrequest = (int)this.getLong(m, "overrequest", ((FacetField)this.facet).overrequest);
                ((FacetField)this.facet).overrefine = (int)this.getLong(m, "overrefine", ((FacetField)this.facet).overrefine);
                if (((FacetField)this.facet).limit == 0L) {
                    ((FacetField)this.facet).offset = 0L;
                }
                ((FacetField)this.facet).mincount = this.getLong(m, "mincount", ((FacetField)this.facet).mincount);
                ((FacetField)this.facet).missing = this.getBoolean(m, "missing", ((FacetField)this.facet).missing);
                ((FacetField)this.facet).numBuckets = this.getBoolean(m, "numBuckets", ((FacetField)this.facet).numBuckets);
                ((FacetField)this.facet).prefix = this.getString(m, "prefix", ((FacetField)this.facet).prefix);
                ((FacetField)this.facet).allBuckets = this.getBoolean(m, "allBuckets", ((FacetField)this.facet).allBuckets);
                ((FacetField)this.facet).method = FacetField.FacetMethod.fromString(this.getString(m, "method", null));
                ((FacetField)this.facet).cacheDf = (int)this.getLong(m, "cacheDf", ((FacetField)this.facet).cacheDf);
                ((FacetField)this.facet).refine = FacetRequest.RefineMethod.fromObj(m.get("refine"));
                ((FacetField)this.facet).perSeg = this.getBooleanOrNull(m, "perSeg");
                Object o = m.get("facet");
                this.parseSubs(o);
                ((FacetField)this.facet).sort = FacetFieldParser.parseAndValidateSort((FacetField)this.facet, m, "sort");
                ((FacetField)this.facet).prelim_sort = FacetFieldParser.parseAndValidateSort((FacetField)this.facet, m, "prelim_sort");
            } else if (arg != null) {
                throw this.err("Expected string/map for facet field, received " + arg.getClass().getSimpleName() + "=" + arg);
            }
            if (null == ((FacetField)this.facet).sort) {
                ((FacetField)this.facet).sort = FacetRequest.FacetSort.COUNT_DESC;
            }
            return (FacetField)this.facet;
        }

        private static FacetRequest.FacetSort parseAndValidateSort(FacetField facet, Map<String, Object> args, String sortParam) {
            boolean isValidSort;
            Object sort = args.get(sortParam);
            if (sort == null) {
                return null;
            }
            FacetRequest.FacetSort facetSort = null;
            if (sort instanceof String) {
                String sortStr = (String)sort;
                facetSort = sortStr.endsWith(" asc") ? new FacetRequest.FacetSort(sortStr.substring(0, sortStr.length() - " asc".length()), FacetRequest.SortDirection.asc) : (sortStr.endsWith(" desc") ? new FacetRequest.FacetSort(sortStr.substring(0, sortStr.length() - " desc".length()), FacetRequest.SortDirection.desc) : new FacetRequest.FacetSort(sortStr, "index".equals(sortStr) ? FacetRequest.SortDirection.asc : FacetRequest.SortDirection.desc));
            } else if (sort instanceof Map) {
                Optional optional = ((Map)sort).entrySet().stream().findFirst();
                if (optional.isPresent()) {
                    Map.Entry entry = (Map.Entry)optional.get();
                    facetSort = new FacetRequest.FacetSort((String)entry.getKey(), FacetRequest.SortDirection.fromObj(entry.getValue()));
                }
            } else {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Expected string/map for '" + sortParam + "', received " + sort.getClass().getSimpleName() + "=" + sort);
            }
            Map facetStats = facet.facetStats;
            boolean bl = isValidSort = facetSort == null || "index".equals(facetSort.sortVariable) || "count".equals(facetSort.sortVariable) || facetStats != null && facetStats.containsKey(facetSort.sortVariable);
            if (!isValidSort) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid " + sortParam + " option '" + sort + "' for field '" + facet.field + "'");
            }
            return facetSort;
        }
    }

    static class FacetQueryParser
    extends FacetParser<FacetQuery> {
        public FacetQueryParser(FacetParser<?> parent, String key) {
            super(parent, key);
            this.facet = new FacetQuery();
        }

        @Override
        public FacetQuery parse(Object arg) throws SyntaxError {
            this.parseCommonParams(arg);
            String qstring = null;
            if (arg instanceof String) {
                qstring = (String)arg;
            } else if (arg instanceof Map) {
                Map m = (Map)arg;
                qstring = this.getString(m, "q", null);
                if (qstring == null) {
                    qstring = this.getString(m, "query", null);
                }
                this.parseSubs(m.get("facet"));
            } else if (arg != null) {
                throw this.err("Expected string/map for facet query, received " + arg.getClass().getSimpleName() + "=" + arg);
            }
            if (qstring != null) {
                QParser parser = QParser.getParser(qstring, this.getSolrRequest());
                parser.setIsFilter(true);
                ((FacetQuery)this.facet).q = parser.getQuery();
            }
            return (FacetQuery)this.facet;
        }
    }

    static class FacetTopParser
    extends FacetParser<FacetQuery> {
        private SolrQueryRequest req;

        public FacetTopParser(SolrQueryRequest req) {
            super(null, "facet");
            this.facet = new FacetQuery();
            this.req = req;
        }

        @Override
        public FacetQuery parse(Object args) throws SyntaxError {
            this.parseSubs(args);
            return (FacetQuery)this.facet;
        }

        @Override
        public SolrQueryRequest getSolrRequest() {
            return this.req;
        }

        @Override
        public IndexSchema getSchema() {
            return this.req.getSchema();
        }
    }
}

