/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.api.collections.RoutedAlias;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.SolrCmdDistributor;
import org.apache.solr.update.processor.DistributedUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutedAliasUpdateProcessor
extends UpdateRequestProcessor {
    private static final String ALIAS_DISTRIB_UPDATE_PARAM = "alias.update.distrib";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int CACHE_FOR_MILLIS = 60000;
    private final SolrQueryRequest req;
    private final SolrCmdDistributor cmdDistrib;
    private final ZkController zkController;
    private final String thisCollection;
    private final RoutedAlias routedAlias;
    private final SolrParams outParamsToLeader;

    public static UpdateRequestProcessor wrap(SolrQueryRequest req, UpdateRequestProcessor next) {
        String aliasName = null;
        SolrCore core = req.getCore();
        CoreDescriptor coreDescriptor = core.getCoreDescriptor();
        CloudDescriptor cloudDescriptor = coreDescriptor.getCloudDescriptor();
        if (cloudDescriptor != null) {
            String collectionName = cloudDescriptor.getCollectionName();
            CoreContainer coreContainer = core.getCoreContainer();
            ZkController zkController = coreContainer.getZkController();
            ZkStateReader zkStateReader = zkController.getZkStateReader();
            Map collectionProperties = zkStateReader.getCollectionProperties(collectionName, 60000L);
            aliasName = (String)collectionProperties.get("routedAliasName");
        }
        if (StringUtils.isBlank(aliasName)) {
            aliasName = coreDescriptor.getCoreProperty("routedAliasName", null);
        }
        DistributedUpdateProcessor.DistribPhase shardDistribPhase = DistributedUpdateProcessor.DistribPhase.parseParam(req.getParams().get("update.distrib"));
        DistributedUpdateProcessor.DistribPhase aliasDistribPhase = DistributedUpdateProcessor.DistribPhase.parseParam(req.getParams().get(ALIAS_DISTRIB_UPDATE_PARAM));
        if (aliasName == null || aliasDistribPhase != DistributedUpdateProcessor.DistribPhase.NONE || shardDistribPhase != DistributedUpdateProcessor.DistribPhase.NONE) {
            return next;
        }
        try {
            RoutedAlias alias = RoutedAlias.fromProps(aliasName, RoutedAliasUpdateProcessor.getAliasProps(req, aliasName));
            return new RoutedAliasUpdateProcessor(req, next, aliasDistribPhase, alias);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Routed alias has invalid properties: " + e, (Throwable)e);
        }
    }

    private static Map<String, String> getAliasProps(SolrQueryRequest req, String aliasName) {
        ZkController zkController = req.getCoreContainer().getZkController();
        Map aliasProperties = zkController.getZkStateReader().getAliases().getCollectionAliasProperties(aliasName);
        if (aliasProperties.isEmpty()) {
            throw RoutedAlias.newAliasMustExistException(aliasName);
        }
        return aliasProperties;
    }

    private RoutedAliasUpdateProcessor(SolrQueryRequest req, UpdateRequestProcessor next, DistributedUpdateProcessor.DistribPhase aliasDistribPhase, RoutedAlias routedAlias) {
        super(next);
        this.routedAlias = routedAlias;
        assert (aliasDistribPhase == DistributedUpdateProcessor.DistribPhase.NONE);
        SolrCore core = req.getCore();
        CoreContainer cc = core.getCoreContainer();
        this.thisCollection = core.getCoreDescriptor().getCloudDescriptor().getCollectionName();
        this.req = req;
        this.zkController = cc.getZkController();
        this.cmdDistrib = new SolrCmdDistributor(cc.getUpdateShardHandler());
        ModifiableSolrParams outParams = new ModifiableSolrParams(req.getParams());
        outParams.remove("optimize");
        outParams.remove("commit");
        outParams.remove("softCommit");
        outParams.remove("prepareCommit");
        outParams.remove("rollback");
        outParams.set("update.distrib", new String[]{DistributedUpdateProcessor.DistribPhase.NONE.toString()});
        outParams.set(ALIAS_DISTRIB_UPDATE_PARAM, new String[]{DistributedUpdateProcessor.DistribPhase.TOLEADER.toString()});
        outParams.set("distrib.from", new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)core.getName())});
        this.outParamsToLeader = outParams;
    }

    private String getAliasName() {
        return this.routedAlias.getAliasName();
    }

    @Override
    public void processAdd(AddUpdateCommand cmd) throws IOException {
        this.routedAlias.validateRouteValue(cmd);
        this.routedAlias.updateParsedCollectionAliases(this.zkController.zkStateReader, false);
        String targetCollection = this.routedAlias.createCollectionsIfRequired(cmd);
        if (this.thisCollection.equals(targetCollection)) {
            super.processAdd(cmd);
        } else {
            SolrCmdDistributor.Node targetLeaderNode = this.routeDocToSlice(targetCollection, cmd.getSolrInputDocument());
            this.cmdDistrib.distribAdd(cmd, Collections.singletonList(targetLeaderNode), new ModifiableSolrParams(this.outParamsToLeader));
        }
    }

    @Override
    public void processDelete(DeleteUpdateCommand cmd) throws IOException {
        List<SolrCmdDistributor.Node> nodes = this.lookupShardLeadersOfCollections();
        this.cmdDistrib.distribDelete(cmd, nodes, new ModifiableSolrParams(this.outParamsToLeader));
    }

    @Override
    public void processCommit(CommitUpdateCommand cmd) throws IOException {
        List<SolrCmdDistributor.Node> nodes = this.lookupShardLeadersOfCollections();
        this.cmdDistrib.distribCommit(cmd, nodes, new ModifiableSolrParams(this.outParamsToLeader));
        this.cmdDistrib.blockAndDoRetries();
    }

    @Override
    public void finish() throws IOException {
        try {
            this.cmdDistrib.finish();
            List<SolrCmdDistributor.SolrError> errors = this.cmdDistrib.getErrors();
            if (!errors.isEmpty()) {
                throw new DistributedUpdateProcessor.DistributedUpdatesAsyncException(errors);
            }
        }
        finally {
            super.finish();
        }
    }

    @Override
    protected void doClose() {
        try {
            this.cmdDistrib.close();
        }
        finally {
            super.doClose();
        }
    }

    private SolrCmdDistributor.Node routeDocToSlice(String collection, SolrInputDocument doc) {
        SchemaField uniqueKeyField = this.req.getSchema().getUniqueKeyField();
        String idFieldName = uniqueKeyField == null ? null : uniqueKeyField.getName();
        String idValue = uniqueKeyField == null ? null : doc.getFieldValue(idFieldName).toString();
        DocCollection coll = this.zkController.getClusterState().getCollection(collection);
        Slice slice = coll.getRouter().getTargetSlice(idValue, doc, null, this.req.getParams(), coll);
        return this.getLeaderNode(collection, slice);
    }

    private List<SolrCmdDistributor.Node> lookupShardLeadersOfCollections() {
        Aliases aliases = this.zkController.getZkStateReader().getAliases();
        List collections = (List)aliases.getCollectionAliasListMap().get(this.getAliasName());
        if (collections == null) {
            throw RoutedAlias.newAliasMustExistException(this.getAliasName());
        }
        return collections.stream().map(this::lookupShardLeaderOfCollection).collect(Collectors.toList());
    }

    private SolrCmdDistributor.Node lookupShardLeaderOfCollection(String collection) {
        Slice[] activeSlices = this.zkController.getClusterState().getCollection(collection).getActiveSlicesArr();
        if (activeSlices.length == 0) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Cannot route to collection " + collection);
        }
        Slice slice = activeSlices[0];
        return this.getLeaderNode(collection, slice);
    }

    private SolrCmdDistributor.Node getLeaderNode(String collection, Slice slice) {
        Replica leader = slice.getLeader();
        if (leader == null) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "No 'leader' replica available for shard " + slice.getName() + " of collection " + collection);
        }
        return new SolrCmdDistributor.ForwardNode(new ZkCoreNodeProps((ZkNodeProps)leader), this.zkController.getZkStateReader(), collection, slice.getName(), DistributedUpdateProcessor.MAX_RETRIES_ON_FORWARD_DEAULT);
    }
}

