/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import net.jcip.annotations.NotThreadSafe;
import org.apache.solr.common.SolrException;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class UpdateRequestProcessor
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final UpdateRequestProcessor next;

    public UpdateRequestProcessor(UpdateRequestProcessor next) {
        this.next = next;
    }

    public void processAdd(AddUpdateCommand cmd) throws IOException {
        if (this.next != null) {
            this.next.processAdd(cmd);
        }
    }

    public void processDelete(DeleteUpdateCommand cmd) throws IOException {
        if (this.next != null) {
            this.next.processDelete(cmd);
        }
    }

    public void processMergeIndexes(MergeIndexesCommand cmd) throws IOException {
        if (this.next != null) {
            this.next.processMergeIndexes(cmd);
        }
    }

    public void processCommit(CommitUpdateCommand cmd) throws IOException {
        if (this.next != null) {
            this.next.processCommit(cmd);
        }
    }

    public void processRollback(RollbackUpdateCommand cmd) throws IOException {
        if (this.next != null) {
            this.next.processRollback(cmd);
        }
    }

    public void finish() throws IOException {
        if (this.next != null) {
            this.next.finish();
        }
    }

    @Override
    public final void close() throws IOException {
        UpdateRequestProcessor p = this;
        while (p != null) {
            try {
                p.doClose();
            }
            catch (Exception e) {
                SolrException.log((Logger)log, (String)"Exception closing processor", (Throwable)e);
            }
            p = p.next;
        }
    }

    protected void doClose() {
    }
}

