/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.tracing;

import io.opentracing.Span;
import io.opentracing.noop.NoopSpan;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.util.function.Consumer;
import org.apache.solr.request.SolrQueryRequest;

public class TraceUtils {
    public static void setDbInstance(SolrQueryRequest req, String coreOrColl) {
        if (coreOrColl != null) {
            TraceUtils.ifNotNoop(req.getSpan(), span -> span.setTag((Tag)Tags.DB_INSTANCE, (Object)coreOrColl));
        }
    }

    public static void ifNotNoop(Span span, Consumer<Span> consumer) {
        if (span != null && !(span instanceof NoopSpan)) {
            consumer.accept(span);
        }
    }
}

