/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.KeyExchangeAlgorithm;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.ECDHEServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.ServerKeyExchangeParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ECDHEServerKeyExchangeParser<T extends ECDHEServerKeyExchangeMessage>
extends ServerKeyExchangeParser<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ProtocolVersion version;
    private final KeyExchangeAlgorithm keyExchangeAlgorithm;

    public ECDHEServerKeyExchangeParser(int pointer, byte[] array, ProtocolVersion version, Config config) {
        this(pointer, array, version, null, config);
    }

    public ECDHEServerKeyExchangeParser(int pointer, byte[] array, ProtocolVersion version, KeyExchangeAlgorithm keyExchangeAlgorithm, Config config) {
        super(pointer, array, HandshakeMessageType.SERVER_KEY_EXCHANGE, version, config);
        this.version = version;
        this.keyExchangeAlgorithm = keyExchangeAlgorithm;
    }

    @Override
    protected void parseHandshakeMessageContent(ECDHEServerKeyExchangeMessage msg) {
        LOGGER.debug("Parsing ECDHEServerKeyExchangeMessage");
        this.parseCurveType(msg);
        this.parseNamedGroup(msg);
        this.parseSerializedPublicKeyLength(msg);
        this.parseSerializedPublicKey(msg);
        if (this.keyExchangeAlgorithm == null || !this.keyExchangeAlgorithm.isAnon()) {
            if (this.isTLS12() || this.isDTLS12()) {
                this.parseSignatureAndHashAlgorithm(msg);
            }
            this.parseSignatureLength(msg);
            this.parseSignature(msg);
        }
    }

    protected void parseEcDheParams(T msg) {
        this.parseCurveType((ECDHEServerKeyExchangeMessage)msg);
        this.parseNamedGroup((ECDHEServerKeyExchangeMessage)msg);
        this.parseSerializedPublicKeyLength((ECDHEServerKeyExchangeMessage)msg);
        this.parseSerializedPublicKey((ECDHEServerKeyExchangeMessage)msg);
    }

    @Override
    protected T createHandshakeMessage() {
        return (T)new ECDHEServerKeyExchangeMessage();
    }

    private void parseCurveType(ECDHEServerKeyExchangeMessage msg) {
        msg.setCurveType(this.parseByteField(1));
        LOGGER.debug("CurveType: " + msg.getGroupType().getValue());
    }

    private void parseNamedGroup(ECDHEServerKeyExchangeMessage msg) {
        msg.setNamedGroup(this.parseByteArrayField(2));
        LOGGER.debug("NamedGroup: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getNamedGroup().getValue())));
    }

    private void parseSerializedPublicKeyLength(ECDHEServerKeyExchangeMessage msg) {
        msg.setPublicKeyLength(this.parseIntField(1));
        LOGGER.debug("SerializedPublicKeyLength: " + msg.getPublicKeyLength().getValue());
    }

    private void parseSerializedPublicKey(ECDHEServerKeyExchangeMessage msg) {
        msg.setPublicKey(this.parseByteArrayField((Integer)msg.getPublicKeyLength().getValue()));
        LOGGER.debug("SerializedPublicKey: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getPublicKey().getValue())));
    }

    private boolean isTLS12() {
        return this.version == ProtocolVersion.TLS12;
    }

    private boolean isDTLS12() {
        return this.version == ProtocolVersion.DTLS12;
    }

    private void parseSignatureAndHashAlgorithm(ECDHEServerKeyExchangeMessage msg) {
        msg.setSignatureAndHashAlgorithm(this.parseByteArrayField(2));
        LOGGER.debug("SignatureAndHashAlgorithm: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getSignatureAndHashAlgorithm().getValue())));
    }

    private void parseSignatureLength(ECDHEServerKeyExchangeMessage msg) {
        msg.setSignatureLength(this.parseIntField(2));
        LOGGER.debug("SignatureLength: " + msg.getSignatureLength().getValue());
    }

    private void parseSignature(ECDHEServerKeyExchangeMessage msg) {
        msg.setSignature(this.parseByteArrayField((Integer)msg.getSignatureLength().getValue()));
        LOGGER.debug("Signature: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getSignature().getValue())));
    }
}

