/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import com.google.inject.Injector;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.BaseProtocol;
import org.traccar.GlobalTimer;
import org.traccar.LifecycleObject;
import org.traccar.TrackerConnector;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.helper.ClassScanner;

@Singleton
public class ServerManager
implements LifecycleObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerManager.class);
    private final List<TrackerConnector> connectorList = new LinkedList<TrackerConnector>();
    private final Map<String, BaseProtocol> protocolList = new ConcurrentHashMap<String, BaseProtocol>();

    @Inject
    public ServerManager(Injector injector, Config config) throws IOException, URISyntaxException, ReflectiveOperationException {
        HashSet<String> enabledProtocols = null;
        if (config.hasKey(Keys.PROTOCOLS_ENABLE)) {
            enabledProtocols = new HashSet<String>(Arrays.asList(config.getString(Keys.PROTOCOLS_ENABLE).split("[, ]")));
        }
        for (Class<?> protocolClass : ClassScanner.findSubclasses(BaseProtocol.class, "org.traccar.protocol")) {
            String protocolName = BaseProtocol.nameFromClass(protocolClass);
            if (enabledProtocols != null && !enabledProtocols.contains(protocolName) || !config.hasKey(Keys.PROTOCOL_PORT.withPrefix(protocolName))) continue;
            BaseProtocol protocol = (BaseProtocol)injector.getInstance(protocolClass);
            this.connectorList.addAll(protocol.getConnectorList());
            this.protocolList.put(protocol.getName(), protocol);
        }
    }

    public BaseProtocol getProtocol(String name) {
        return this.protocolList.get(name);
    }

    @Override
    public void start() throws Exception {
        for (TrackerConnector connector : this.connectorList) {
            try {
                connector.start();
            }
            catch (BindException e) {
                LOGGER.warn("Port disabled due to conflict", (Throwable)e);
            }
            catch (ConnectException e) {
                LOGGER.warn("Connection failed", (Throwable)e);
            }
        }
    }

    @Override
    public void stop() throws Exception {
        try {
            for (TrackerConnector connector : this.connectorList) {
                connector.stop();
            }
        }
        finally {
            GlobalTimer.release();
        }
    }
}

