{application, tsung_controller,
      [{description,  "tsung, a bench tool for TCP/UDP servers"},
       {vsn,          "1.8.0"},
       {modules,      [
                       ts_api,
                       ts_config_amqp,
                       ts_config,
                       ts_config_fs,
                       ts_config_http,
                       ts_config_jabber,
                       ts_config_job,
                       ts_config_ldap,
                       ts_config_mqtt,
                       ts_config_mysql,
                       ts_config_pgsql,
                       ts_config_raw,
                       ts_config_server,
                       ts_config_shell,
                       ts_config_websocket,
                       ts_controller_sup,
                       ts_file_server,
                       ts_interaction_server,
                       ts_job_notify,
                       ts_match_logger,
                       ts_mon,
                       ts_msg_server,
                       ts_os_mon,
                       ts_os_mon_erlang,
                       ts_os_mon_munin,
                       ts_os_mon_snmp,
                       ts_os_mon_sup,
                       ts_stats_mon,
                       ts_timer,
                       tsung_controller,
                       ts_user_server,
                       ts_user_server_sup,
                       ts_web
                      ]},
       {registered,   [
                       ts_config_server,
                       ts_file_server,
                       ts_interaction_server,
                       ts_job_notify,
                       ts_match_logger,
                       ts_mon,
                       ts_msg_server,
                       ts_os_mon,
                       ts_os_mon_erlang,
                       ts_os_mon_snmp,
                       ts_os_mon_munin,
                       ts_stats_mon,
                       ts_stats,
                       ts_timer,
                       ts_user_server
                      ]},
       {env,        [
                     {debug_level, 6},
                     {smp_disable, true}, % disable smp on clients
                     {ts_cookie, "humhum"},
                     {clients_timeout, 60000},    % timeout for global synchro
                     {file_server_timeout, 30000},% timeout for reading file
                     {warm_time, 1}, % (seconds) initial waiting time when launching clients

                     {thinktime_value, "5"}, % default value = 5sec
                     {thinktime_override, "false"},
                     {thinktime_random, "false"},

                     {global_number, 100},
                     {global_ack_timeout, 3600000}, %in msec

                     {munin_port, 4949},

                     {snmp_port, 161},
                     {snmp_version, v2},
                     {snmp_community, "public"},

                     {mysql_port, 3306},
                     {mysql_user, "root"},
                     {mysql_password, false},

                     {dumpstats_interval, 10000},
                     {dump, none},          %% full or light or none
                     {stats_backend, none}, %% text|rrdtool

                     {nclients, 10},        %% number of clients
                     {nclients_deb, 1},     %% beginning of interval
                     {nclients_fin, 2000},     %% end of interval
                     {config_file, "./tsung.xml"},
                     {log_file, "./tsung.log"},
                     {match_log_file, "./match.log"},
                     {exclude_tag, ""},
                     {template_path, beam_relative}
                    ]},
       {applications, [ kernel,stdlib,asn1,crypto,public_key,ssl,crypto ]},
       {start_phases, [{load_config, []},{start_os_monitoring,[{timeout,30000}]},
                       {start_clients,[]}]},
       {mod,          {tsung_controller, []}}
      ]}.
