#pragma once

#include <cstdint>

namespace exmdbpp::constants
{

namespace ResponseCode
{
static const uint8_t SUCCESS = 0x00;
static const uint8_t ACCESS_DENY = 0x01;
static const uint8_t MAX_REACHED = 0x02;
static const uint8_t LACK_MEMORY = 0x03;
static const uint8_t MISCONFIG_PREFIX = 0x04;
static const uint8_t MISCONFIG_MODE = 0x05;
static const uint8_t CONNECT_INCOMPLETE = 0x06;
static const uint8_t PULL_ERROR = 0x07;
static const uint8_t DISPATCH_ERROR = 0x08;
static const uint8_t PUSH_ERROR = 0x09;
}

namespace CallId
{
static const uint8_t CONNECT = 0x00;
static const uint8_t GET_NAMED_PROPIDS = 0x04;
static const uint8_t GET_STORE_ALL_PROPTAGS = 0x08;
static const uint8_t GET_STORE_PROPERTIES = 0x09;
static const uint8_t SET_STORE_PROPERTIES = 0x0a;
static const uint8_t REMOVE_STORE_PROPERTIES = 0x0b;
static const uint8_t QUERY_FOLDER_MESSAGES = 0x11;
static const uint8_t GET_FOLDER_BY_NAME = 0x13;
static const uint8_t CREATE_FOLDER_BY_PROPERTIES = 0x15;
static const uint8_t GET_FOLDER_ALL_PROPTAGS = 0x16;
static const uint8_t GET_FOLDER_PROPERTIES = 0x17;
static const uint8_t SET_FOLDER_PROPERTIES = 0x18;
static const uint8_t DELETE_FOLDER = 0x1a;
static const uint8_t EMPTY_FOLDER = 0x1b;
static const uint8_t DELETE_MESSAGES = 0x23;
static const uint8_t LOAD_HIERARCHY_TABLE = 0x26;
static const uint8_t LOAD_CONTENT_TABLE = 0x28;
static const uint8_t UNLOAD_TABLE = 0x2b;
static const uint8_t QUERY_TABLE = 0x2d;
static const uint8_t LOAD_MESSAGE_INSTANCE = 0x39;
static const uint8_t READ_MESSAGE_INSTANCE = 0x3e;
static const uint8_t UNLOAD_INSTANCE = 0x46;
static const uint8_t GET_INSTANCE_PROPERTIES = 0x48;
static const uint8_t GET_MESSAGE_INSTANCE_RCPTS = 0x4f;
static const uint8_t QUERY_MESSAGE_INSTANCE_ATTACHMENT_TABLE = 0x54;
static const uint8_t GET_MESSAGE_PROPERTIES = 0x57;
static const uint8_t ALLOCATE_CN = 0x5c;
static const uint8_t UPDATE_FOLDER_PERMISSION = 0x6a;
static const uint8_t READ_MESSAGE = 0x6f;
static const uint8_t LOAD_PERMISSION_TABLE = 0x7d; //was 0x29, changed table_flags from uint8_t to uint32_t
static const uint8_t UNLOAD_STORE = 0x80;
}

namespace PublicFid
{
static const uint64_t ROOT = 0x01;
static const uint64_t IPMSUBTREE = 0x02;
static const uint64_t NONIPMSUBTREE = 0x03;
static const uint64_t EFORMSREGISTRY = 0x04;
static const uint64_t CUSTOM = 0x05;
}

namespace PrivateFid
{
static const uint64_t ROOT = 0x01;
static const uint64_t DEFERRED_ACTION = 0x02;
static const uint64_t SPOOLER_QUEUE = 0x03;
static const uint64_t SHORTCUTS = 0x04;
static const uint64_t FINDER = 0x05;
static const uint64_t VIEWS = 0x06;
static const uint64_t COMMON_VIEWS = 0x07;
static const uint64_t SCHEDULE = 0x08;
static const uint64_t IPMSUBTREE = 0x09;
static const uint64_t SENT_ITEMS = 0x0a;
static const uint64_t DELETED_ITEMS = 0x0b;
static const uint64_t OUTBOX = 0x0c;
static const uint64_t INBOX = 0x0d;
static const uint64_t DRAFT = 0x0e;
static const uint64_t CALENDAR = 0x0f;
static const uint64_t JOURNAL = 0x10;
static const uint64_t NOTES = 0x11;
static const uint64_t TASKS = 0x12;
static const uint64_t CONTACTS = 0x13;
static const uint64_t QUICKCONTACTS = 0x14;
static const uint64_t IMCONTACTLIST = 0x15;
static const uint64_t GALCONTACTS = 0x16;
static const uint64_t JUNK = 0x17;
static const uint64_t LOCAL_FREEBUSY = 0x18;
static const uint64_t SYNC_ISSUES = 0x19;
static const uint64_t CONFLICTS = 0x1a;
static const uint64_t LOCAL_FAILURES = 0x1b;
static const uint64_t SERVER_FAILURES = 0x1c;
static const uint64_t CONVERSATION_ACTION_SETTINGS = 0x1d;
static const uint64_t CUSTOM = 0x1e;
}

namespace Permission
{
static const uint32_t NONE = 0x00000000;
static const uint32_t READANY = 0x00000001;
static const uint32_t CREATE = 0x00000002;
static const uint32_t SENDAS = 0x00000004; /* self defined */
static const uint32_t EDITOWNED = 0x00000008;
static const uint32_t DELETEOWNED = 0x00000010;
static const uint32_t EDITANY = 0x00000020;
static const uint32_t DELETEANY = 0x00000040;
static const uint32_t CREATESUBFOLDER = 0x00000080;
static const uint32_t FOLDEROWNER = 0x00000100;
static const uint32_t FOLDERCONTACT = 0x00000200;
static const uint32_t FOLDERVISIBLE = 0x00000400;
static const uint32_t FREEBUSYSIMPLE = 0x00000800;
static const uint32_t FREEBUSYDETAILED = 0x00001000;
static const uint32_t STOREOWNER = 0x00002000;
}

namespace FolderType
{
static const uint32_t ROOT = 0x0;
static const uint32_t GENERIC = 0x1;
static const uint32_t SEARCH = 0x2;
}

namespace FuzzyLevel
{
static const uint32_t FULLSTRING = 0x0;
static const uint32_t SUBSTRING = 0x1;
static const uint32_t PREFIX = 0x2;
static const uint32_t PREFIX_ON_ANY_WORD = 1<<4;
static const uint32_t PHRASE_MATCH = 1<<5;
static const uint32_t IGNORECASE = 1<<16;
static const uint32_t IGNORENONSPACE = 1<<17;
static const uint32_t LOOSE = 1<<18;
}

namespace TableFlags
{
static const uint8_t ASSOCIATED = 0x2;
static const uint8_t DEPTH = 0x4;
static const uint8_t DEFERREDERRORS = 0x8;
static const uint8_t NONOTIFICATIONS = 0x10;
static const uint8_t SOFTDELETES = 0x20;
static const uint8_t USEUNICODE = 0x40;
static const uint8_t SUPPRESSNOTIFICATIONS = 0x80;
static const uint8_t CONVERSATIONMEMBERS = 0x80;
}

namespace PropvalType
{
static const uint16_t UNSPECIFIED = 0x0000;
static const uint16_t SHORT = 0x0002;
static const uint16_t LONG = 0x0003;
static const uint16_t FLOAT = 0x0004;
static const uint16_t DOUBLE = 0x0005;
static const uint16_t CURRENCY = 0x0006;
static const uint16_t FLOATINGTIME = 0x0007;
static const uint16_t ERROR = 0x000a;
static const uint16_t BYTE = 0x000b;
static const uint16_t OBJECT = 0x000d;
static const uint16_t LONGLONG = 0x0014;
static const uint16_t STRING = 0x001e;
static const uint16_t WSTRING = 0x001f;
static const uint16_t FILETIME = 0x0040;
static const uint16_t GUID = 0x0048;
static const uint16_t SVREID = 0x00fb;
static const uint16_t RESTRICTION = 0x00fd;
static const uint16_t RULE = 0x00fe;
static const uint16_t BINARY = 0x0102;
static const uint16_t SHORT_ARRAY = 0x1002;
static const uint16_t LONG_ARRAY = 0x1003;
static const uint16_t FLOAT_ARRAY = 0x1004;
static const uint16_t DOUBLE_ARRAY = 0x1005;
static const uint16_t CURRENCY_ARRAY = 0x1006;
static const uint16_t FLOATINGTIME_ARRAY = 0x1007;
static const uint16_t LONGLONG_ARRAY = 0x1014;
static const uint16_t STRING_ARRAY = 0x101e;
static const uint16_t WSTRING_ARRAY = 0x101f;
static const uint16_t GUID_ARRAY = 0x1048;
static const uint16_t BINARY_ARRAY = 0x1102;

constexpr uint16_t tagType(uint32_t tag)
{return tag & 0xFFFF;}

constexpr bool isArray(uint16_t type)
{return type == BINARY || type & 0x1000;}
}

namespace PropTag
{
static const uint32_t ABPROVIDERID = 0x36150102;
static const uint32_t ACCESS = 0x0FF40003;
static const uint32_t ACCESSCONTROLLISTDATA = 0x3FE00102;
static const uint32_t ACCESSLEVEL = 0x0FF70003;
static const uint32_t ACCOUNT = 0x3A00001F;
static const uint32_t ACCOUNT_STRING8 = 0x3A00001E;
static const uint32_t ADDITIONALRENENTRYIDS = 0x36D81102;
static const uint32_t ADDITIONALRENENTRYIDSEX = 0x36D90102;
static const uint32_t ADDRESSBOOKAUTHORIZEDSENDERS = 0x8CD8000D;
static const uint32_t ADDRESSBOOKCONTAINERID = 0xFFFD0003;
static const uint32_t ADDRESSBOOKDELIVERYCONTENTLENGTH = 0x806A0003;
static const uint32_t ADDRESSBOOKDISPLAYNAMEPRINTABLE = 0x39FF001F;
static const uint32_t ADDRESSBOOKDISPLAYNAMEPRINTABLE_STRING8 = 0x39FF001E;
static const uint32_t ADDRESSBOOKDISPLAYTYPEEXTENDED = 0x8C930003;
static const uint32_t ADDRESSBOOKDISTRIBUTIONLISTEXTERNALMEMBERCOUNT = 0x8CE30003;
static const uint32_t ADDRESSBOOKDISTRIBUTIONLISTMEMBERCOUNT = 0x8CE20003;
static const uint32_t ADDRESSBOOKDISTRIBUTIONLISTMEMBERSUBMITACCEPTED = 0x8073000D;
static const uint32_t ADDRESSBOOKDISTRIBUTIONLISTMEMBERSUBMITREJECTED = 0x8CDA000D;
static const uint32_t ADDRESSBOOKDISTRIBUTIONLISTREJECTMESSAGESFROMDLMEMBERS = 0x8CDB000D;
static const uint32_t ADDRESSBOOKENTRYID = 0x663B0102;
static const uint32_t ADDRESSBOOKEXTENSIONATTRIBUTE1 = 0x802D001F;
static const uint32_t ADDRESSBOOKEXTENSIONATTRIBUTE10 = 0x8036001F;
static const uint32_t ADDRESSBOOKEXTENSIONATTRIBUTE10_STRING8 = 0x8036001E;
static const uint32_t ADDRESSBOOKEXTENSIONATTRIBUTE11 = 0x8C57001F;
static const uint32_t ADDRESSBOOKEXTENSIONATTRIBUTE11_STRING8 = 0x8C57001E;
static const uint32_t ADDRESSBOOKEXTENSIONATTRIBUTE12 = 0x8C58001F;
static const uint32_t ADDRESSBOOKEXTENSIONATTRIBUTE12_STRING8 = 0x8C58001E;
static const uint32_t ADDRESSBOOKEXTENSIONATTRIBUTE13 = 0x8C59001F;
static const uint32_t ADDRESSBOOKEXTENSIONATTRIBUTE13_STRING8 = 0x8C59001E;
static const uint32_t ADDRESSBOOKEXTENSIONATTRIBUTE14 = 0x8C60001F;
static const uint32_t ADDRESSBOOKEXTENSIONATTRIBUTE14_STRING8 = 0x8C60001E;
static const uint32_t ADDRESSBOOKEXTENSIONATTRIBUTE15 = 0x8C61001F;
static const uint32_t ADDRESSBOOKEXTENSIONATTRIBUTE15_STRING8 = 0x8C61001E;
static const uint32_t ADDRESSBOOKEXTENSIONATTRIBUTE1_STRING8 = 0x802D001E;
static const uint32_t ADDRESSBOOKEXTENSIONATTRIBUTE2 = 0x802E001F;
static const uint32_t ADDRESSBOOKEXTENSIONATTRIBUTE2_STRING8 = 0x802E001E;
static const uint32_t ADDRESSBOOKEXTENSIONATTRIBUTE3 = 0x802F001F;
static const uint32_t ADDRESSBOOKEXTENSIONATTRIBUTE3_STRING8 = 0x802F001E;
static const uint32_t ADDRESSBOOKEXTENSIONATTRIBUTE4 = 0x8030001F;
static const uint32_t ADDRESSBOOKEXTENSIONATTRIBUTE4_STRING8 = 0x8030001E;
static const uint32_t ADDRESSBOOKEXTENSIONATTRIBUTE5 = 0x8031001F;
static const uint32_t ADDRESSBOOKEXTENSIONATTRIBUTE5_STRING8 = 0x8031001E;
static const uint32_t ADDRESSBOOKEXTENSIONATTRIBUTE6 = 0x8032001F;
static const uint32_t ADDRESSBOOKEXTENSIONATTRIBUTE6_STRING8 = 0x8032001E;
static const uint32_t ADDRESSBOOKEXTENSIONATTRIBUTE7 = 0x8033001F;
static const uint32_t ADDRESSBOOKEXTENSIONATTRIBUTE7_STRING8 = 0x8033001E;
static const uint32_t ADDRESSBOOKEXTENSIONATTRIBUTE8 = 0x8034001F;
static const uint32_t ADDRESSBOOKEXTENSIONATTRIBUTE8_STRING8 = 0x8034001E;
static const uint32_t ADDRESSBOOKEXTENSIONATTRIBUTE9 = 0x8035001F;
static const uint32_t ADDRESSBOOKEXTENSIONATTRIBUTE9_STRING8 = 0x8035001E;
static const uint32_t ADDRESSBOOKFOLDERPATHNAME = 0x8004001F;
static const uint32_t ADDRESSBOOKFOLDERPATHNAME_STRING8 = 0x8004001E;
static const uint32_t ADDRESSBOOKHIERARCHICALCHILDDEPARTMENTS = 0x8C9A000D;
static const uint32_t ADDRESSBOOKHIERARCHICALDEPARTMENTMEMBERS = 0x8C97000D;
static const uint32_t ADDRESSBOOKHIERARCHICALISHIERARCHICALGROUP = 0x8CDD000B;
static const uint32_t ADDRESSBOOKHIERARCHICALPARENTDEPARTMENT = 0x8C99000D;
static const uint32_t ADDRESSBOOKHIERARCHICALROOTDEPARTMENT = 0x8C98001E;
static const uint32_t ADDRESSBOOKHIERARCHICALSHOWINDEPARTMENTS = 0x8C94000D;
static const uint32_t ADDRESSBOOKHOMEMESSAGEDATABASE = 0x8006001F;
static const uint32_t ADDRESSBOOKHOMEMESSAGEDATABASE_STRING8 = 0x8006001E;
static const uint32_t ADDRESSBOOKISMASTER = 0xFFFB000B;
static const uint32_t ADDRESSBOOKISMEMBEROFDISTRIBUTIONLIST = 0x8008001E;
static const uint32_t ADDRESSBOOKMANAGEDISTRIBUTIONLIST = 0x6704000D;
static const uint32_t ADDRESSBOOKMANAGER = 0x8005000D;
static const uint32_t ADDRESSBOOKMANAGERDISTINGUISHEDNAME = 0x8005001F;
static const uint32_t ADDRESSBOOKMEMBER = 0x8009000D;
static const uint32_t ADDRESSBOOKMESSAGEID = 0x674F0014;
static const uint32_t ADDRESSBOOKMODERATIONENABLED = 0x8CB5000B;
static const uint32_t ADDRESSBOOKNETWORKADDRESS = 0x8170101F;
static const uint32_t ADDRESSBOOKNETWORKADDRESS_STRING8 = 0x8170101E;
static const uint32_t ADDRESSBOOKOBJECTDISTINGUISHEDNAME = 0x803C001F;
static const uint32_t ADDRESSBOOKOBJECTDISTINGUISHEDNAME_STRING8 = 0x803C001E;
static const uint32_t ADDRESSBOOKOBJECTGUID = 0x8C6D0102;
static const uint32_t ADDRESSBOOKORGANIZATIONALUNITROOTDISTINGUISHEDNAME = 0x8CA8001F;
static const uint32_t ADDRESSBOOKORGANIZATIONALUNITROOTDISTINGUISHEDNAME_STRING8 = 0x8CA8001E;
static const uint32_t ADDRESSBOOKOWNER = 0x800C000D;
static const uint32_t ADDRESSBOOKOWNERBACKLINK = 0x8024000D;
static const uint32_t ADDRESSBOOKPARENTENTRYID = 0xFFFC0102;
static const uint32_t ADDRESSBOOKPHONETICCOMPANYNAME = 0x8C91001F;
static const uint32_t ADDRESSBOOKPHONETICCOMPANYNAME_STRING8 = 0x8C91001E;
static const uint32_t ADDRESSBOOKPHONETICDEPARTMENTNAME = 0x8C90001F;
static const uint32_t ADDRESSBOOKPHONETICDEPARTMENTNAME_STRING8 = 0x8C90001E;
static const uint32_t ADDRESSBOOKPHONETICDISPLAYNAME = 0x8C92001F;
static const uint32_t ADDRESSBOOKPHONETICDISPLAYNAME_STRING8 = 0x8C92001E;
static const uint32_t ADDRESSBOOKPHONETICGIVENNAME = 0x8C8E001F;
static const uint32_t ADDRESSBOOKPHONETICGIVENNAME_STRING8 = 0x8C8E001E;
static const uint32_t ADDRESSBOOKPHONETICSURNAME = 0x8C8F001F;
static const uint32_t ADDRESSBOOKPHONETICSURNAME_STRING8 = 0x8C8F001E;
static const uint32_t ADDRESSBOOKPROXYADDRESSES = 0x800F101F;
static const uint32_t ADDRESSBOOKPROXYADDRESSES_STRING8 = 0x800F101E;
static const uint32_t ADDRESSBOOKPUBLICDELEGATES = 0x8015000D;
static const uint32_t ADDRESSBOOKREPORTS = 0x800E000D;
static const uint32_t ADDRESSBOOKROOMCAPACITY = 0x08070003;
static const uint32_t ADDRESSBOOKROOMCONTAINERS = 0x8C96101F;
static const uint32_t ADDRESSBOOKROOMDESCRIPTION = 0x0809001F;
static const uint32_t ADDRESSBOOKROOMDESCRIPTION_STRING8 = 0x0809001E;
static const uint32_t ADDRESSBOOKSENDERHINTTRANSLATIONS = 0x8CAC101F;
static const uint32_t ADDRESSBOOKSENIORITYINDEX = 0x8CA00003;
static const uint32_t ADDRESSBOOKTARGETADDRESS = 0x8011001F;
static const uint32_t ADDRESSBOOKTARGETADDRESS_STRING8 = 0x8011001E;
static const uint32_t ADDRESSBOOKUNAUTHORIZEDSENDERS = 0x8CD9000D;
static const uint32_t ADDRESSBOOKX509CERTIFICATE = 0x8C6A1102;
static const uint32_t ADDRESSTYPE = 0x3002001F;
static const uint32_t ADDRESSTYPE_STRING8 = 0x3002001E;
static const uint32_t ALTERNATERECIPIENTALLOWED = 0x0002000B;
static const uint32_t ANR = 0x360C001F;
static const uint32_t ANR_STRING8 = 0x360C001E;
static const uint32_t ARCHIVEDATE = 0x301F0040;
static const uint32_t ARCHIVEPERIOD = 0x301E0003;
static const uint32_t ARCHIVETAG = 0x30180102;
static const uint32_t ASSISTANT = 0x3A30001F;
static const uint32_t ASSISTANTTELEPHONENUMBER = 0x3A2E001F;
static const uint32_t ASSISTANTTELEPHONENUMBER_STRING8 = 0x3A2E001E;
static const uint32_t ASSISTANT_STRING8 = 0x3A30001E;
static const uint32_t ASSOCIATED = 0x67AA000B;
static const uint32_t ATTACHADDITIONALINFORMATION = 0x370F0102;
static const uint32_t ATTACHCONTENTBASE = 0x3711001F;
static const uint32_t ATTACHCONTENTBASE_STRING8 = 0x3711001E;
static const uint32_t ATTACHCONTENTID = 0x3712001F;
static const uint32_t ATTACHCONTENTID_STRING8 = 0x3712001E;
static const uint32_t ATTACHCONTENTLOCATION = 0x3713001F;
static const uint32_t ATTACHCONTENTLOCATION_STRING8 = 0x3713001E;
static const uint32_t ATTACHDATABINARY = 0x37010102;
static const uint32_t ATTACHDATAOBJECT = 0x3701000D;
static const uint32_t ATTACHENCODING = 0x37020102;
static const uint32_t ATTACHEXTENSION = 0x3703001F;
static const uint32_t ATTACHEXTENSION_STRING8 = 0x3703001E;
static const uint32_t ATTACHFILENAME = 0x3704001F;
static const uint32_t ATTACHFILENAME_STRING8 = 0x3704001E;
static const uint32_t ATTACHFLAGS = 0x37140003;
static const uint32_t ATTACHLONGFILENAME = 0x3707001F;
static const uint32_t ATTACHLONGFILENAME_STRING8 = 0x3707001E;
static const uint32_t ATTACHLONGPATHNAME = 0x370D001F;
static const uint32_t ATTACHLONGPATHNAME_STRING8 = 0x370D001E;
static const uint32_t ATTACHMETHOD = 0x37050003;
static const uint32_t ATTACHMIMETAG = 0x370E001F;
static const uint32_t ATTACHMIMETAG_STRING8 = 0x370E001E;
static const uint32_t ATTACHNUMBER = 0x0E210003;
static const uint32_t ATTACHPATHNAME = 0x3708001F;
static const uint32_t ATTACHPATHNAME_STRING8 = 0x3708001E;
static const uint32_t ATTACHPAYLOADCLASS = 0x371A001F;
static const uint32_t ATTACHPAYLOADCLASS_STRING8 = 0x371A001E;
static const uint32_t ATTACHPAYLOADPROVIDERGUIDSTRING = 0x3719001F;
static const uint32_t ATTACHPAYLOADPROVIDERGUIDSTRING_STRING8 = 0x3719001E;
static const uint32_t ATTACHRENDERING = 0x37090102;
static const uint32_t ATTACHSIZE = 0x0E200003;
static const uint32_t ATTACHTAG = 0x370A0102;
static const uint32_t ATTACHTRANSPORTNAME = 0x370C001F;
static const uint32_t ATTACHTRANSPORTNAME_STRING8 = 0x370C001E;
static const uint32_t ATTACHMENTCONTACTPHOTO = 0x7FFF000B;
static const uint32_t ATTACHMENTFLAGS = 0x7FFD0003;
static const uint32_t ATTACHMENTHIDDEN = 0x7FFE000B;
static const uint32_t ATTACHMENTLINKID = 0x7FFA0003;
static const uint32_t ATTRIBUTEHIDDEN = 0x10F4000B;
static const uint32_t ATTRIBUTESYSTEM = 0x10F5000B;
static const uint32_t ATTRIBUTEREADONLY = 0x10F6000B;
static const uint32_t AUTOFORWARDCOMMENT = 0x0004001F;
static const uint32_t AUTOFORWARDCOMMENT_STRING8 = 0x0004001E;
static const uint32_t AUTOFORWARDED = 0x0005000B;
static const uint32_t AUTORESPONSESUPPRESS = 0x3FDF0003;
static const uint32_t BIRTHDAY = 0x3A420040;
static const uint32_t BLOCKSTATUS = 0x10960003;
static const uint32_t BODY = 0x1000001F;
static const uint32_t BODYCONTENTID = 0x1015001F;
static const uint32_t BODYCONTENTID_STRING8 = 0x1015001E;
static const uint32_t BODYCONTENTLOCATION = 0x1014001F;
static const uint32_t BODYCONTENTLOCATION_STRING8 = 0x1014001E;
static const uint32_t BODYHTML = 0x1013001F;
static const uint32_t BODYHTML_STRING8 = 0x1013001E;
static const uint32_t BODY_STRING8 = 0x1000001E;
static const uint32_t BUSINESS2TELEPHONENUMBER = 0x3A1B001F;
static const uint32_t BUSINESS2TELEPHONENUMBER_STRING8 = 0x3A1B001E;
static const uint32_t BUSINESS2TELEPHONENUMBERS = 0x3A1B101F;
static const uint32_t BUSINESSFAXNUMBER = 0x3A24001F;
static const uint32_t BUSINESSFAXNUMBER_STRING8 = 0x3A24001E;
static const uint32_t BUSINESSHOMEPAGE = 0x3A51001F;
static const uint32_t BUSINESSHOMEPAGE_STRING8 = 0x3A51001E;
static const uint32_t BUSINESSTELEPHONENUMBER = 0x3A08001F;
static const uint32_t BUSINESSTELEPHONENUMBER_STRING8 = 0x3A08001E;
static const uint32_t CALLID = 0x6806001F;
static const uint32_t CALLID_STRING8 = 0x6806001E;
static const uint32_t CALLBACKTELEPHONENUMBER = 0x3A02001F;
static const uint32_t CALLBACKTELEPHONENUMBER_STRING8 = 0x3A02001E;
static const uint32_t CARTELEPHONENUMBER = 0x3A1E001F;
static const uint32_t CARTELEPHONENUMBER_STRING8 = 0x3A1E001E;
static const uint32_t CDORECURRENCEID = 0x10C50040;
static const uint32_t CHANGEKEY = 0x65E20102;
static const uint32_t CHANGENUMBER = 0x67A40014;
static const uint32_t CHILDRENSNAMES = 0x3A58101F;
static const uint32_t CLIENTACTIONS = 0x66450102;
static const uint32_t CLIENTSUBMITTIME = 0x00390040;
static const uint32_t PROVIDERSUBMITTIME = 0x00480040;
static const uint32_t CODEPAGEID = 0x66C30003;
static const uint32_t COMMENT = 0x3004001F;
static const uint32_t COMMENT_STRING8 = 0x3004001E;
static const uint32_t COMPANYMAINTELEPHONENUMBER = 0x3A57001F;
static const uint32_t COMPANYMAINTELEPHONENUMBER_STRING8 = 0x3A57001E;
static const uint32_t COMPANYNAME = 0x3A16001F;
static const uint32_t COMPANYNAME_STRING8 = 0x3A16001E;
static const uint32_t COMPUTERNETWORKNAME = 0x3A49001F;
static const uint32_t COMPUTERNETWORKNAME_STRING8 = 0x3A49001E;
static const uint32_t CONFLICTENTRYID = 0x3FF00102;
static const uint32_t CONTAINERCLASS = 0x3613001F;
static const uint32_t CONTAINERCLASS_STRING8 = 0x3613001E;
static const uint32_t CONTAINERCONTENTS = 0x360F000D;
static const uint32_t CONTAINERFLAGS = 0x36000003;
static const uint32_t CONTAINERHIERARCHY = 0x360E000D;
static const uint32_t CONTENTCOUNT = 0x36020003;
static const uint32_t CONTENTFILTERSPAMCONFIDENCELEVEL = 0x40760003;
static const uint32_t CONTENTUNREADCOUNT = 0x36030003;
static const uint32_t CONVERSATIONID = 0x30130102;
static const uint32_t CONVERSATIONINDEX = 0x00710102;
static const uint32_t CONVERSATIONINDEXTRACKING = 0x3016000B;
static const uint32_t CONVERSATIONTOPIC = 0x0070001F;
static const uint32_t CONVERSATIONTOPIC_STRING8 = 0x0070001E;
static const uint32_t COUNTRY = 0x3A26001F;
static const uint32_t COUNTRY_STRING8 = 0x3A26001E;
static const uint32_t CREATIONTIME = 0x30070040;
static const uint32_t CREATORENTRYID = 0x3FF90102;
static const uint32_t CREATORNAME = 0x3FF8001F;
static const uint32_t CREATORNAME_STRING8 = 0x3FF8001E;
static const uint32_t CUSTOMERID = 0x3A4A001F;
static const uint32_t CUSTOMERID_STRING8 = 0x3A4A001E;
static const uint32_t DAMBACKPATCHED = 0x6647000B;
static const uint32_t DAMORIGINALENTRYID = 0x66460102;
static const uint32_t DEFAULTPOSTMESSAGECLASS = 0x36E5001F;
static const uint32_t DEFAULTPOSTMESSAGECLASS_STRING8 = 0x36E5001E;
static const uint32_t DEFERREDACTIONMESSAGEORIGINALENTRYID = 0x674100FB;
static const uint32_t RULEFOLDERFID = 0x67420014;
static const uint32_t DEFERREDDELIVERYTIME = 0x000F0040;
static const uint32_t DEFERREDSENDNUMBER = 0x3FEB0003;
static const uint32_t DEFERREDSENDTIME = 0x3FEF0040;
static const uint32_t DEFERREDSENDUNITS = 0x3FEC0003;
static const uint32_t DELEGATEFLAGS = 0x686B1003;
static const uint32_t DELEGATEDBYRULE = 0x3FE3000B;
static const uint32_t DELETEAFTERSUBMIT = 0x0E01000B;
static const uint32_t SENTMAILENTRYID = 0x0E0A0102;
static const uint32_t DEFAULTSTORE = 0x3400000B;
static const uint32_t DELETEDCOUNTTOTAL = 0x670B0003;
static const uint32_t DELETEDFOLDERTOTAL = 0x66410003;
static const uint32_t DELETEDON = 0x668F0040;
static const uint32_t DELIVERTIME = 0x00100040;
static const uint32_t DEPARTMENTNAME = 0x3A18001F;
static const uint32_t DEPARTMENTNAME_STRING8 = 0x3A18001E;
static const uint32_t DEPTH = 0x30050003;
static const uint32_t DISPLAYBCC = 0x0E02001F;
static const uint32_t DISPLAYBCC_STRING8 = 0x0E02001E;
static const uint32_t DISPLAYCC = 0x0E03001F;
static const uint32_t DISPLAYCC_STRING8 = 0x0E03001E;
static const uint32_t DISPLAYNAME = 0x3001001F;
static const uint32_t DISPLAYNAMEPREFIX = 0x3A45001F;
static const uint32_t DISPLAYNAMEPREFIX_STRING8 = 0x3A45001E;
static const uint32_t DISPLAYNAME_STRING8 = 0x3001001E;
static const uint32_t DISPLAYTO = 0x0E04001F;
static const uint32_t DISPLAYTO_STRING8 = 0x0E04001E;
static const uint32_t DISPLAYTYPE = 0x39000003;
static const uint32_t DISPLAYTYPEEX = 0x39050003;
static const uint32_t EMAILADDRESS = 0x3003001F;
static const uint32_t EMAILADDRESS_STRING8 = 0x3003001E;
static const uint32_t ENDDATE = 0x00610040;
static const uint32_t ENTRYID = 0x0FFF0102;
static const uint32_t EXCEPTIONENDTIME = 0x7FFC0040;
static const uint32_t EXCEPTIONREPLACETIME = 0x7FF90040;
static const uint32_t EXCEPTIONSTARTTIME = 0x7FFB0040;
static const uint32_t EXCHANGENTSECURITYDESCRIPTOR = 0x0E840102;
static const uint32_t EXPIRYNUMBER = 0x3FED0003;
static const uint32_t EXPIRYTIME = 0x00150040;
static const uint32_t EXPIRYUNITS = 0x3FEE0003;
static const uint32_t EXTENDEDFOLDERFLAGS = 0x36DA0102;
static const uint32_t EXTENDEDRULEMESSAGEACTIONS = 0x0E990102;
static const uint32_t EXTENDEDRULEMESSAGECONDITION = 0x0E9A0102;
static const uint32_t EXTENDEDRULESIZELIMIT = 0x0E9B0003;
static const uint32_t FAXNUMBEROFPAGES = 0x68040003;
static const uint32_t FLAGCOMPLETETIME = 0x10910040;
static const uint32_t FLAGSTATUS = 0x10900003;
static const uint32_t FLATURLNAME = 0x670E001F;
static const uint32_t FLATURLNAME_STRING8 = 0x670E001E;
static const uint32_t FOLDERASSOCIATEDCONTENTS = 0x3610000D;
static const uint32_t FOLDERID = 0x67480014;
static const uint32_t FOLDERTYPE = 0x36010003;
static const uint32_t FOLLOWUPICON = 0x10950003;
static const uint32_t FREEBUSYCOUNTMONTHS = 0x68690003;
static const uint32_t FREEBUSYENTRYIDS = 0x36E41102;
static const uint32_t FREEBUSYMESSAGEEMAILADDRESS = 0x6849001F;
static const uint32_t FREEBUSYMESSAGEEMAILADDRESS_STRING8 = 0x6849001E;
static const uint32_t FREEBUSYPUBLISHEND = 0x68480003;
static const uint32_t FREEBUSYPUBLISHSTART = 0x68470003;
static const uint32_t FREEBUSYRANGETIMESTAMP = 0x68680040;
static const uint32_t FTPSITE = 0x3A4C001F;
static const uint32_t FTPSITE_STRING8 = 0x3A4C001E;
static const uint32_t GATEWAYNEEDSTOREFRESH = 0x6846000B;
static const uint32_t GENDER = 0x3A4D0002;
static const uint32_t GENERATION = 0x3A05001F;
static const uint32_t GENERATION_STRING8 = 0x3A05001E;
static const uint32_t GIVENNAME = 0x3A06001F;
static const uint32_t GIVENNAME_STRING8 = 0x3A06001E;
static const uint32_t GOVERNMENTIDNUMBER = 0x3A07001F;
static const uint32_t GOVERNMENTIDNUMBER_STRING8 = 0x3A07001E;
static const uint32_t HASATTACHMENTS = 0x0E1B000B;
static const uint32_t HASDEFERREDACTIONMESSAGES = 0x3FEA000B;
static const uint32_t HASNAMEDPROPERTIES = 0x664A000B;
static const uint32_t HASRULES = 0x663A000B;
static const uint32_t HIERARCHYCHANGENUMBER = 0x663E0003;
static const uint32_t HOBBIES = 0x3A43001F;
static const uint32_t HOBBIES_STRING8 = 0x3A43001E;
static const uint32_t HOME2TELEPHONENUMBER = 0x3A2F001F;
static const uint32_t HOME2TELEPHONENUMBER_STRING8 = 0x3A2F001E;
static const uint32_t HOME2TELEPHONENUMBERS = 0x3A2F101F;
static const uint32_t HOMEADDRESSCITY = 0x3A59001F;
static const uint32_t HOMEADDRESSCITY_STRING8 = 0x3A59001E;
static const uint32_t HOMEADDRESSCOUNTRY = 0x3A5A001F;
static const uint32_t HOMEADDRESSCOUNTRY_STRING8 = 0x3A5A001E;
static const uint32_t HOMEADDRESSPOSTOFFICEBOX = 0x3A5E001F;
static const uint32_t HOMEADDRESSPOSTOFFICEBOX_STRING8 = 0x3A5E001E;
static const uint32_t HOMEADDRESSPOSTALCODE = 0x3A5B001F;
static const uint32_t HOMEADDRESSPOSTALCODE_STRING8 = 0x3A5B001E;
static const uint32_t HOMEADDRESSSTATEORPROVINCE = 0x3A5C001F;
static const uint32_t HOMEADDRESSSTATEORPROVINCE_STRING8 = 0x3A5C001E;
static const uint32_t HOMEADDRESSSTREET = 0x3A5D001F;
static const uint32_t HOMEADDRESSSTREET_STRING8 = 0x3A5D001E;
static const uint32_t HOMEFAXNUMBER = 0x3A25001F;
static const uint32_t HOMEFAXNUMBER_STRING8 = 0x3A25001E;
static const uint32_t HOMETELEPHONENUMBER = 0x3A09001F;
static const uint32_t HOMETELEPHONENUMBER_STRING8 = 0x3A09001E;
static const uint32_t HTML = 0x10130102;
static const uint32_t ICALENDARENDTIME = 0x10C40040;
static const uint32_t ICALENDARREMINDERNEXTTIME = 0x10CA0040;
static const uint32_t ICALENDARSTARTTIME = 0x10C30040;
static const uint32_t ICONINDEX = 0x10800003;
static const uint32_t IMPORTANCE = 0x00170003;
static const uint32_t INCONFLICT = 0x666C000B;
static const uint32_t INREPLYTOID = 0x1042001F;
static const uint32_t INREPLYTOID_STRING8 = 0x1042001E;
static const uint32_t INITIALDETAILSPANE = 0x3F080003;
static const uint32_t INITIALS = 0x3A0A001F;
static const uint32_t INITIALS_STRING8 = 0x3A0A001E;
static const uint32_t INSTID = 0x674D0014;
static const uint32_t INSTANCEKEY = 0x0FF60102;
static const uint32_t INSTANCESVREID = 0x0FF600FB;
static const uint32_t INSTANCENUM = 0x674E0003;
static const uint32_t INTERNETCODEPAGE = 0x3FDE0003;
static const uint32_t INTERNETMAILOVERRIDEFORMAT = 0x59020003;
static const uint32_t INTERNETMESSAGEID = 0x1035001F;
static const uint32_t INTERNETMESSAGEID_STRING8 = 0x1035001E;
static const uint32_t INTERNETREFERENCES = 0x1039001F;
static const uint32_t INTERNETREFERENCES_STRING8 = 0x1039001E;
static const uint32_t IPMAPPOINTMENTENTRYID = 0x36D00102;
static const uint32_t IPMCONTACTENTRYID = 0x36D10102;
static const uint32_t IPMDRAFTSENTRYID = 0x36D70102;
static const uint32_t IPMJOURNALENTRYID = 0x36D20102;
static const uint32_t IPMNOTEENTRYID = 0x36D30102;
static const uint32_t IPMTASKENTRYID = 0x36D40102;
static const uint32_t ISDNNUMBER = 0x3A2D001F;
static const uint32_t ISDNNUMBER_STRING8 = 0x3A2D001E;
static const uint32_t JUNKADDRECIPIENTSTOSAFESENDERSLIST = 0x61030003;
static const uint32_t JUNKINCLUDECONTACTS = 0x61000003;
static const uint32_t JUNKPERMANENTLYDELETE = 0x61020003;
static const uint32_t JUNKPHISHINGENABLELINKS = 0x6107000B;
static const uint32_t JUNKTHRESHOLD = 0x61010003;
static const uint32_t KEYWORD = 0x3A0B001F;
static const uint32_t KEYWORD_STRING8 = 0x3A0B001E;
static const uint32_t LANGUAGE = 0x3A0C001F;
static const uint32_t LANGUAGE_STRING8 = 0x3A0C001E;
static const uint32_t LASTMODIFICATIONTIME = 0x30080040;
static const uint32_t LASTMODIFIERENTRYID = 0x3FFB0102;
static const uint32_t LASTMODIFIERNAME = 0x3FFA001F;
static const uint32_t LASTMODIFIERNAME_STRING8 = 0x3FFA001E;
static const uint32_t LASTVERBEXECUTED = 0x10810003;
static const uint32_t LASTVERBEXECUTIONTIME = 0x10820040;
static const uint32_t LISTHELP = 0x1043001F;
static const uint32_t LISTHELP_STRING8 = 0x1043001E;
static const uint32_t LISTSUBSCRIBE = 0x1044001F;
static const uint32_t LISTSUBSCRIBE_STRING8 = 0x1044001E;
static const uint32_t LISTUNSUBSCRIBE = 0x1045001F;
static const uint32_t LISTUNSUBSCRIBE_STRING8 = 0x1045001E;
static const uint32_t LOCALCOMMITTIME = 0x67090040;
static const uint32_t LOCALCOMMITTIMEMAX = 0x670A0040;
static const uint32_t LOCALEID = 0x66A10003;
static const uint32_t LOCALITY = 0x3A27001F;
static const uint32_t LOCALITY_STRING8 = 0x3A27001E;
static const uint32_t LOCATION = 0x3A0D001F;
static const uint32_t LOCATION_STRING8 = 0x3A0D001E;
static const uint32_t MAILBOXOWNERENTRYID = 0x661B0102;
static const uint32_t MAILBOXOWNERNAME = 0x661C001F;
static const uint32_t MAILBOXOWNERNAME_STRING8 = 0x661C001E;
static const uint32_t MANAGERNAME = 0x3A4E001F;
static const uint32_t MANAGERNAME_STRING8 = 0x3A4E001E;
static const uint32_t MAPPINGSIGNATURE = 0x0FF80102;
static const uint32_t MAXIMUMSUBMITMESSAGESIZE = 0x666D0003;
static const uint32_t MEMBERID = 0x66710014;
static const uint32_t MEMBERNAME = 0x6672001F;
static const uint32_t MEMBERNAME_STRING8 = 0x6672001E;
static const uint32_t MEMBERRIGHTS = 0x66730003;
static const uint32_t MESSAGEATTACHMENTS = 0x0E13000D;
static const uint32_t MESSAGECCME = 0x0058000B;
static const uint32_t MESSAGECLASS = 0x001A001F;
static const uint32_t MESSAGECLASS_STRING8 = 0x001A001E;
static const uint32_t MESSAGECODEPAGE = 0x3FFD0003;
static const uint32_t MESSAGEDELIVERYTIME = 0x0E060040;
static const uint32_t MESSAGEEDITORFORMAT = 0x59090003;
static const uint32_t MESSAGEFLAGS = 0x0E070003;
static const uint32_t ITEMTEMPORARYFLAGS = 0x10970003;
static const uint32_t MESSAGEHANDLINGSYSTEMCOMMONNAME = 0x3A0F001F;
static const uint32_t MESSAGEHANDLINGSYSTEMCOMMONNAME_STRING8 = 0x3A0F001E;
static const uint32_t MESSAGELOCALEID = 0x3FF10003;
static const uint32_t MESSAGERECIPIENTME = 0x0059000B;
static const uint32_t MESSAGERECIPIENTS = 0x0E12000D;
static const uint32_t MESSAGESIZE = 0x0E080003;
static const uint32_t NORMALMESSAGESIZE = 0x66B30003;
static const uint32_t NORMALMESSAGESIZEEXTENDED = 0x66B30014;
static const uint32_t ASSOCMESSAGESIZE = 0x66B40003;
static const uint32_t ASSOCMESSAGESIZEEXTENDED = 0x66B40014;
static const uint32_t MESSAGESIZEEXTENDED = 0x0E080014;
static const uint32_t MESSAGESTATUS = 0x0E170003;
static const uint32_t MESSAGESUBMISSIONID = 0x00470102;
static const uint32_t MESSAGETOME = 0x0057000B;
static const uint32_t MID = 0x674A0014;
static const uint32_t MIDDLENAME = 0x3A44001F;
static const uint32_t MIDDLENAME_STRING8 = 0x3A44001E;
static const uint32_t MIMESKELETON = 0x64F00102;
static const uint32_t MOBILETELEPHONENUMBER = 0x3A1C001F;
static const uint32_t MOBILETELEPHONENUMBER_STRING8 = 0x3A1C001E;
static const uint32_t NATIVEBODY = 0x10160003;
static const uint32_t NEXTSENDACCT = 0x0E29001F;
static const uint32_t NEXTSENDACCT_STRING8 = 0x0E29001E;
static const uint32_t NICKNAME = 0x3A4F001F;
static const uint32_t NICKNAME_STRING8 = 0x3A4F001E;
static const uint32_t NONDELIVERYREPORTDIAGCODE = 0x0C050003;
static const uint32_t NONDELIVERYREPORTREASONCODE = 0x0C040003;
static const uint32_t NONDELIVERYREPORTSTATUSCODE = 0x0C200003;
static const uint32_t NORMALIZEDSUBJECT = 0x0E1D001F;
static const uint32_t NORMALIZEDSUBJECT_STRING8 = 0x0E1D001E;
static const uint32_t OBJECTTYPE = 0x0FFE0003;
static const uint32_t OFFICELOCATION = 0x3A19001F;
static const uint32_t OFFICELOCATION_STRING8 = 0x3A19001E;
static const uint32_t OFFLINEADDRESSBOOKCONTAINERGUID = 0x6802001E;
static const uint32_t OFFLINEADDRESSBOOKDISTINGUISHEDNAME = 0x6804001E;
static const uint32_t OFFLINEADDRESSBOOKMESSAGECLASS = 0x68030003;
static const uint32_t OFFLINEADDRESSBOOKNAME = 0x6800001F;
static const uint32_t OFFLINEADDRESSBOOKNAME_STRING8 = 0x6800001E;
static const uint32_t OFFLINEADDRESSBOOKSEQUENCE = 0x68010003;
static const uint32_t OFFLINEADDRESSBOOKTRUNCATEDPROPERTIES = 0x68051003;
static const uint32_t ORDINALMOST = 0x36E20003;
static const uint32_t ORGANIZATIONALIDNUMBER = 0x3A10001F;
static const uint32_t ORGANIZATIONALIDNUMBER_STRING8 = 0x3A10001E;
static const uint32_t ORIGINALAUTHORENTRYID = 0x004C0102;
static const uint32_t ORIGINALAUTHORNAME = 0x004D001F;
static const uint32_t ORIGINALAUTHORNAME_STRING8 = 0x004D001E;
static const uint32_t ORIGINALDELIVERYTIME = 0x00550040;
static const uint32_t ORIGINALDISPLAYBCC = 0x0072001F;
static const uint32_t ORIGINALDISPLAYBCC_STRING8 = 0x0072001E;
static const uint32_t ORIGINALDISPLAYCC = 0x0073001F;
static const uint32_t ORIGINALDISPLAYCC_STRING8 = 0x0073001E;
static const uint32_t ORIGINALDISPLAYTO = 0x0074001F;
static const uint32_t ORIGINALDISPLAYTO_STRING8 = 0x0074001E;
static const uint32_t ORIGINALENTRYID = 0x3A120102;
static const uint32_t ORIGINALMESSAGECLASS = 0x004B001F;
static const uint32_t ORIGINALMESSAGECLASS_STRING8 = 0x004B001E;
static const uint32_t ORIGINALMESSAGEID = 0x1046001F;
static const uint32_t ORIGINALMESSAGEID_STRING8 = 0x1046001E;
static const uint32_t ORIGINALSENDERADDRESSTYPE = 0x0066001F;
static const uint32_t ORIGINALSENDERADDRESSTYPE_STRING8 = 0x0066001E;
static const uint32_t ORIGINALSENDEREMAILADDRESS = 0x0067001F;
static const uint32_t ORIGINALSENDEREMAILADDRESS_STRING8 = 0x0067001E;
static const uint32_t ORIGINALSENDERENTRYID = 0x005B0102;
static const uint32_t ORIGINALSENDERNAME = 0x005A001F;
static const uint32_t ORIGINALSENDERNAME_STRING8 = 0x005A001E;
static const uint32_t ORIGINALSENDERSEARCHKEY = 0x005C0102;
static const uint32_t ORIGINALSENSITIVITY = 0x002E0003;
static const uint32_t ORIGINALSENTREPRESENTINGADDRESSTYPE = 0x0068001F;
static const uint32_t ORIGINALSENTREPRESENTINGADDRESSTYPE_STRING8 = 0x0068001E;
static const uint32_t ORIGINALSENTREPRESENTINGEMAILADDRESS = 0x0069001F;
static const uint32_t ORIGINALSENTREPRESENTINGEMAILADDRESS_STRING8 = 0x0069001E;
static const uint32_t ORIGINALSENTREPRESENTINGENTRYID = 0x005E0102;
static const uint32_t ORIGINALSENTREPRESENTINGNAME = 0x005D001F;
static const uint32_t ORIGINALSENTREPRESENTINGNAME_STRING8 = 0x005D001E;
static const uint32_t ORIGINALSENTREPRESENTINGSEARCHKEY = 0x005F0102;
static const uint32_t ORIGINALSUBJECT = 0x0049001F;
static const uint32_t ORIGINALSUBJECT_STRING8 = 0x0049001E;
static const uint32_t ORIGINALSUBMITTIME = 0x004E0040;
static const uint32_t ORIGINATORDELIVERYREPORTREQUESTED = 0x0023000B;
static const uint32_t ORIGINATORNONDELIVERYREPORTREQUESTED = 0x0C08000B;
static const uint32_t OSCSYNCENABLED = 0x7C24000B;
static const uint32_t OTHERADDRESSCITY = 0x3A5F001F;
static const uint32_t OTHERADDRESSCITY_STRING8 = 0x3A5F001E;
static const uint32_t OTHERADDRESSCOUNTRY = 0x3A60001F;
static const uint32_t OTHERADDRESSCOUNTRY_STRING8 = 0x3A60001E;
static const uint32_t OTHERADDRESSPOSTOFFICEBOX = 0x3A64001F;
static const uint32_t OTHERADDRESSPOSTOFFICEBOX_STRING8 = 0x3A64001E;
static const uint32_t OTHERADDRESSPOSTALCODE = 0x3A61001F;
static const uint32_t OTHERADDRESSPOSTALCODE_STRING8 = 0x3A61001E;
static const uint32_t OTHERADDRESSSTATEORPROVINCE = 0x3A62001F;
static const uint32_t OTHERADDRESSSTATEORPROVINCE_STRING8 = 0x3A62001E;
static const uint32_t OTHERADDRESSSTREET = 0x3A63001F;
static const uint32_t OTHERADDRESSSTREET_STRING8 = 0x3A63001E;
static const uint32_t OTHERTELEPHONENUMBER = 0x3A1F001F;
static const uint32_t OTHERTELEPHONENUMBER_STRING8 = 0x3A1F001E;
static const uint32_t OUTOFOFFICESTATE = 0x661D000B;
static const uint32_t OWNERAPPOINTMENTID = 0x00620003;
static const uint32_t PAGERTELEPHONENUMBER = 0x3A21001F;
static const uint32_t PAGERTELEPHONENUMBER_STRING8 = 0x3A21001E;
static const uint32_t PARENTENTRYID = 0x0E090102;
static const uint32_t PARENTSVREID = 0x0E0900FB;
static const uint32_t PARENTFOLDERID = 0x67490014;
static const uint32_t PARENTKEY = 0x00250102;
static const uint32_t PARENTSOURCEKEY = 0x65E10102;
static const uint32_t PERSONALHOMEPAGE = 0x3A50001F;
static const uint32_t PERSONALHOMEPAGE_STRING8 = 0x3A50001E;
static const uint32_t POLICYTAG = 0x30190102;
static const uint32_t POSTOFFICEBOX = 0x3A2B001F;
static const uint32_t POSTOFFICEBOX_STRING8 = 0x3A2B001E;
static const uint32_t POSTALADDRESS = 0x3A15001F;
static const uint32_t POSTALADDRESS_STRING8 = 0x3A15001E;
static const uint32_t POSTALCODE = 0x3A2A001F;
static const uint32_t POSTALCODE_STRING8 = 0x3A2A001E;
static const uint32_t PREDECESSORCHANGELIST = 0x65E30102;
static const uint32_t PRIMARYFAXNUMBER = 0x3A23001F;
static const uint32_t PRIMARYFAXNUMBER_STRING8 = 0x3A23001E;
static const uint32_t PRIMARYSENDACCOUNT = 0x0E28001F;
static const uint32_t PRIMARYSENDACCOUNT_STRING8 = 0x0E28001E;
static const uint32_t PRIMARYTELEPHONENUMBER = 0x3A1A001F;
static const uint32_t PRIMARYTELEPHONENUMBER_STRING8 = 0x3A1A001E;
static const uint32_t PRIORITY = 0x00260003;
static const uint32_t PROCESSED = 0x7D01000B;
static const uint32_t PROFESSION = 0x3A46001F;
static const uint32_t PROFESSION_STRING8 = 0x3A46001E;
static const uint32_t PROHIBITRECEIVEQUOTA = 0x666A0003;
static const uint32_t PROHIBITSENDQUOTA = 0x666E0003;
static const uint32_t PROVIDERDISPLAY = 0x3006001F;
static const uint32_t PROVIDERDISPLAY_STRING8 = 0x3006001E;
static const uint32_t PROVIDERUID = 0x300C0102;
static const uint32_t PURPORTEDSENDERDOMAIN = 0x4083001F;
static const uint32_t PURPORTEDSENDERDOMAIN_STRING8 = 0x4083001E;
static const uint32_t RADIOTELEPHONENUMBER = 0x3A1D001F;
static const uint32_t RADIOTELEPHONENUMBER_STRING8 = 0x3A1D001E;
static const uint32_t READ = 0x0E69000B;
static const uint32_t READRECEIPTADDRESSTYPE = 0x4029001F;
static const uint32_t READRECEIPTADDRESSTYPE_STRING8 = 0x4029001E;
static const uint32_t READRECEIPTEMAILADDRESS = 0x402A001F;
static const uint32_t READRECEIPTEMAILADDRESS_STRING8 = 0x402A001E;
static const uint32_t READRECEIPTENTRYID = 0x00460102;
static const uint32_t READRECEIPTNAME = 0x402B001F;
static const uint32_t READRECEIPTNAME_STRING8 = 0x402B001E;
static const uint32_t READRECEIPTREQUESTED = 0x0029000B;
static const uint32_t READRECEIPTSEARCHKEY = 0x00530102;
static const uint32_t READRECEIPTSMTPADDRESS = 0x5D05001F;
static const uint32_t READRECEIPTSMTPADDRESS_STRING8 = 0x5D05001E;
static const uint32_t RECEIPTTIME = 0x002A0040;
static const uint32_t RECEIVEDBYADDRESSTYPE = 0x0075001F;
static const uint32_t RECEIVEDBYADDRESSTYPE_STRING8 = 0x0075001E;
static const uint32_t RECEIVEDBYEMAILADDRESS = 0x0076001F;
static const uint32_t RECEIVEDBYEMAILADDRESS_STRING8 = 0x0076001E;
static const uint32_t RECEIVEDBYENTRYID = 0x003F0102;
static const uint32_t RECEIVEDBYNAME = 0x0040001F;
static const uint32_t RECEIVEDBYNAME_STRING8 = 0x0040001E;
static const uint32_t RECEIVEDBYSEARCHKEY = 0x00510102;
static const uint32_t RECEIVEDBYSMTPADDRESS = 0x5D07001F;
static const uint32_t RECEIVEDBYSMTPADDRESS_STRING8 = 0x5D07001E;
static const uint32_t RECEIVEDREPRESENTINGADDRESSTYPE = 0x0077001F;
static const uint32_t RECEIVEDREPRESENTINGADDRESSTYPE_STRING8 = 0x0077001E;
static const uint32_t RECEIVEDREPRESENTINGEMAILADDRESS = 0x0078001F;
static const uint32_t RECEIVEDREPRESENTINGEMAILADDRESS_STRING8 = 0x0078001E;
static const uint32_t RECEIVEDREPRESENTINGENTRYID = 0x00430102;
static const uint32_t RECEIVEDREPRESENTINGNAME = 0x0044001F;
static const uint32_t RECEIVEDREPRESENTINGNAME_STRING8 = 0x0044001E;
static const uint32_t RECEIVEDREPRESENTINGSEARCHKEY = 0x00520102;
static const uint32_t RECEIVEDREPRESENTINGSMTPADDRESS = 0x5D08001F;
static const uint32_t RECEIVEDREPRESENTINGSMTPADDRESS_STRING8 = 0x5D08001E;
static const uint32_t RECIPIENTDISPLAYNAME = 0x5FF6001F;
static const uint32_t RECIPIENTDISPLAYNAME_STRING8 = 0x5FF6001E;
static const uint32_t RECIPIENTENTRYID = 0x5FF70102;
static const uint32_t RECIPIENTFLAGS = 0x5FFD0003;
static const uint32_t RECIPIENTORDER = 0x5FDF0003;
static const uint32_t RECIPIENTPROPOSED = 0x5FE1000B;
static const uint32_t RECIPIENTPROPOSEDENDTIME = 0x5FE40040;
static const uint32_t RECIPIENTPROPOSEDSTARTTIME = 0x5FE30040;
static const uint32_t RECIPIENTREASSIGNMENTPROHIBITED = 0x002B000B;
static const uint32_t RECIPIENTTRACKSTATUS = 0x5FFF0003;
static const uint32_t RECIPIENTTRACKSTATUSTIME = 0x5FFB0040;
static const uint32_t RECIPIENTTYPE = 0x0C150003;
static const uint32_t RECORDKEY = 0x0FF90102;
static const uint32_t REFERREDBYNAME = 0x3A47001F;
static const uint32_t REFERREDBYNAME_STRING8 = 0x3A47001E;
static const uint32_t REMINDERSONLINEENTRYID = 0x36D50102;
static const uint32_t REMOTEMESSAGETRANSFERAGENT = 0x0C21001F;
static const uint32_t REMOTEMESSAGETRANSFERAGENT_STRING8 = 0x0C21001E;
static const uint32_t RENDERINGPOSITION = 0x370B0003;
static const uint32_t REPLYRECIPIENTENTRIES = 0x004F0102;
static const uint32_t REPLYRECIPIENTNAMES = 0x0050001F;
static const uint32_t REPLYRECIPIENTNAMES_STRING8 = 0x0050001E;
static const uint32_t REPLYREQUESTED = 0x0C17000B;
static const uint32_t REPLYTEMPLATEID = 0x65C20102;
static const uint32_t REPLYTIME = 0x00300040;
static const uint32_t REPORTDISPOSITION = 0x0080001F;
static const uint32_t REPORTDISPOSITIONMODE = 0x0081001F;
static const uint32_t REPORTDISPOSITIONMODE_STRING8 = 0x0081001E;
static const uint32_t REPORTDISPOSITION_STRING8 = 0x0080001E;
static const uint32_t REPORTENTRYID = 0x00450102;
static const uint32_t REPORTNAME = 0x003A001F;
static const uint32_t REPORTNAME_STRING8 = 0x003A001E;
static const uint32_t REPORTSEARCHKEY = 0x00540102;
static const uint32_t REPORTTAG = 0x00310102;
static const uint32_t REPORTTEXT = 0x1001001F;
static const uint32_t REPORTTEXT_STRING8 = 0x1001001E;
static const uint32_t REPORTTIME = 0x00320040;
static const uint32_t REPORTINGMESSAGETRANSFERAGENT = 0x6820001F;
static const uint32_t REPORTINGMESSAGETRANSFERAGENT_STRING8 = 0x6820001E;
static const uint32_t RESOLVEMETHOD = 0x3FE70003;
static const uint32_t RESOURCEFLAGS = 0x30090003;
static const uint32_t RESOURCETYPE = 0x3E030003;
static const uint32_t RESPONSEREQUESTED = 0x0063000B;
static const uint32_t RESPONSIBILITY = 0x0E0F000B;
static const uint32_t RETENTIONDATE = 0x301C0040;
static const uint32_t RETENTIONFLAGS = 0x301D0003;
static const uint32_t RETENTIONPERIOD = 0x301A0003;
static const uint32_t RIGHTS = 0x66390003;
static const uint32_t ROAMINGDATATYPES = 0x7C060003;
static const uint32_t ROAMINGDICTIONARY = 0x7C070102;
static const uint32_t ROAMINGXMLSTREAM = 0x7C080102;
static const uint32_t ROWTYPE = 0x0FF50003;
static const uint32_t ROWID = 0x30000003;
static const uint32_t RTFCOMPRESSED = 0x10090102;
static const uint32_t RTFINSYNC = 0x0E1F000B;
static const uint32_t RULEACTIONNUMBER = 0x66500003;
static const uint32_t RULEACTIONTYPE = 0x66490003;
static const uint32_t RULEACTIONS = 0x668000FE;
static const uint32_t RULECONDITION = 0x667900FD;
static const uint32_t RULEERROR = 0x66480003;
static const uint32_t RULEFOLDERENTRYID = 0x66510102;
static const uint32_t RULEID = 0x66740014;
static const uint32_t RULEIDS = 0x66750102;
static const uint32_t RULELEVEL = 0x66830003;
static const uint32_t RULEMESSAGELEVEL = 0x65ED0003;
static const uint32_t RULEMESSAGENAME = 0x65EC001F;
static const uint32_t RULEMESSAGENAME_STRING8 = 0x65EC001E;
static const uint32_t RULEMESSAGEPROVIDER = 0x65EB001F;
static const uint32_t RULEMESSAGEPROVIDERDATA = 0x65EE0102;
static const uint32_t RULEMESSAGEPROVIDER_STRING8 = 0x65EB001E;
static const uint32_t RULEMESSAGESEQUENCE = 0x65F30003;
static const uint32_t RULEMESSAGESTATE = 0x65E90003;
static const uint32_t RULEMESSAGEUSERFLAGS = 0x65EA0003;
static const uint32_t RULENAME = 0x6682001F;
static const uint32_t RULENAME_STRING8 = 0x6682001E;
static const uint32_t RULEPROVIDER = 0x6681001F;
static const uint32_t RULEPROVIDERDATA = 0x66840102;
static const uint32_t RULEPROVIDER_STRING8 = 0x6681001E;
static const uint32_t RULESEQUENCE = 0x66760003;
static const uint32_t RULESTATE = 0x66770003;
static const uint32_t RULEUSERFLAGS = 0x66780003;
static const uint32_t RWRULESSTREAM = 0x68020102;
static const uint32_t SCHEDULEINFOAPPOINTMENTTOMBSTONE = 0x686A0102;
static const uint32_t SCHEDULEINFOAUTOACCEPTAPPOINTMENTS = 0x686D000B;
static const uint32_t SCHEDULEINFODELEGATEENTRYIDS = 0x68451102;
static const uint32_t SCHEDULEINFODELEGATENAMES = 0x6844101F;
static const uint32_t SCHEDULEINFODELEGATENAMESW = 0x684A101F;
static const uint32_t SCHEDULEINFODELEGATORWANTSCOPY = 0x6842000B;
static const uint32_t SCHEDULEINFODELEGATORWANTSINFO = 0x684B000B;
static const uint32_t SCHEDULEINFODISALLOWOVERLAPPINGAPPTS = 0x686F000B;
static const uint32_t SCHEDULEINFODISALLOWRECURRINGAPPTS = 0x686E000B;
static const uint32_t SCHEDULEINFODONTMAILDELEGATES = 0x6843000B;
static const uint32_t SCHEDULEINFOFREEBUSY = 0x686C0102;
static const uint32_t SCHEDULEINFOFREEBUSYAWAY = 0x68561102;
static const uint32_t SCHEDULEINFOFREEBUSYBUSY = 0x68541102;
static const uint32_t SCHEDULEINFOFREEBUSYMERGED = 0x68501102;
static const uint32_t SCHEDULEINFOFREEBUSYTENTATIVE = 0x68521102;
static const uint32_t SCHEDULEINFOMONTHSAWAY = 0x68551003;
static const uint32_t SCHEDULEINFOMONTHSBUSY = 0x68531003;
static const uint32_t SCHEDULEINFOMONTHSMERGED = 0x684F1003;
static const uint32_t SCHEDULEINFOMONTHSTENTATIVE = 0x68511003;
static const uint32_t SCHEDULEINFORESOURCETYPE = 0x68410003;
static const uint32_t SCHEDULEPLUSFREEBUSYENTRYID = 0x66220102;
static const uint32_t SCRIPTDATA = 0x00040102;
static const uint32_t SEARCHFOLDERDEFINITION = 0x68450102;
static const uint32_t SEARCHFOLDEREXPIRATION = 0x683A0003;
static const uint32_t SEARCHFOLDERID = 0x68420102;
static const uint32_t SEARCHFOLDERLASTUSED = 0x68340003;
static const uint32_t SEARCHFOLDERRECREATEINFO = 0x68440102;
static const uint32_t SEARCHFOLDERSTORAGETYPE = 0x68460003;
static const uint32_t SEARCHKEY = 0x300B0102;
static const uint32_t SECURITYDESCRIPTORASXML = 0x0E6A001F;
static const uint32_t SECURITYDESCRIPTORASXML_STRING8 = 0x0E6A001E;
static const uint32_t SELECTABLE = 0x3609000B;
static const uint32_t SENDINTERNETENCODING = 0x3A710003;
static const uint32_t SENDRICHINFO = 0x3A40000B;
static const uint32_t SENDERADDRESSTYPE = 0x0C1E001F;
static const uint32_t SENDERADDRESSTYPE_STRING8 = 0x0C1E001E;
static const uint32_t SENDEREMAILADDRESS = 0x0C1F001F;
static const uint32_t SENDEREMAILADDRESS_STRING8 = 0x0C1F001E;
static const uint32_t SENDERENTRYID = 0x0C190102;
static const uint32_t SENDERIDSTATUS = 0x40790003;
static const uint32_t SENDERNAME = 0x0C1A001F;
static const uint32_t SENDERNAME_STRING8 = 0x0C1A001E;
static const uint32_t SENDERSEARCHKEY = 0x0C1D0102;
static const uint32_t SENDERSMTPADDRESS = 0x5D01001F;
static const uint32_t SENDERSMTPADDRESS_STRING8 = 0x5D01001E;
static const uint32_t SENDERTELEPHONENUMBER = 0x6802001F;
static const uint32_t SENDERTELEPHONENUMBER_STRING8 = 0x6802001E;
static const uint32_t SENSITIVITY = 0x00360003;
static const uint32_t SENTMAILSVREID = 0x674000FB;
static const uint32_t SENTREPRESENTINGADDRESSTYPE = 0x0064001F;
static const uint32_t SENTREPRESENTINGADDRESSTYPE_STRING8 = 0x0064001E;
static const uint32_t SENTREPRESENTINGEMAILADDRESS = 0x0065001F;
static const uint32_t SENTREPRESENTINGEMAILADDRESS_STRING8 = 0x0065001E;
static const uint32_t SENTREPRESENTINGENTRYID = 0x00410102;
static const uint32_t SENTREPRESENTINGFLAGS = 0x401A0003;
static const uint32_t SENTREPRESENTINGNAME = 0x0042001F;
static const uint32_t SENTREPRESENTINGNAME_STRING8 = 0x0042001E;
static const uint32_t SENTREPRESENTINGSEARCHKEY = 0x003B0102;
static const uint32_t SENTREPRESENTINGSMTPADDRESS = 0x5D02001F;
static const uint32_t SENTREPRESENTINGSMTPADDRESS_STRING8 = 0x5D02001E;
static const uint32_t SMTPADDRESS = 0x39FE001F;
static const uint32_t SMTPADDRESS_STRING8 = 0x39FE001E;
static const uint32_t SORTLOCALEID = 0x67050003;
static const uint32_t SOURCEKEY = 0x65E00102;
static const uint32_t SPOKENNAME = 0x8CC20102;
static const uint32_t SPOUSENAME = 0x3A48001F;
static const uint32_t SPOUSENAME_STRING8 = 0x3A48001E;
static const uint32_t STARTDATE = 0x00600040;
static const uint32_t STARTDATEETC = 0x301B0102;
static const uint32_t STATEORPROVINCE = 0x3A28001F;
static const uint32_t STATEORPROVINCE_STRING8 = 0x3A28001E;
static const uint32_t STOREENTRYID = 0x0FFB0102;
static const uint32_t STOREPROVIDER = 0x34140102;
static const uint32_t STORERECORDKEY = 0x0FFA0102;
static const uint32_t STORESTATE = 0x340E0003;
static const uint32_t STORESUPPORTMASK = 0x340D0003;
static const uint32_t STREETADDRESS = 0x3A29001F;
static const uint32_t STREETADDRESS_STRING8 = 0x3A29001E;
static const uint32_t SUBFOLDERS = 0x360A000B;
static const uint32_t SUBJECT = 0x0037001F;
static const uint32_t SUBJECTPREFIX = 0x003D001F;
static const uint32_t SUBJECTPREFIX_STRING8 = 0x003D001E;
static const uint32_t SUBJECT_STRING8 = 0x0037001E;
static const uint32_t SUPPLEMENTARYINFO = 0x0C1B001F;
static const uint32_t SUPPLEMENTARYINFO_STRING8 = 0x0C1B001E;
static const uint32_t SURNAME = 0x3A11001F;
static const uint32_t SURNAME_STRING8 = 0x3A11001E;
static const uint32_t SWAPPEDTODODATA = 0x0E2D0102;
static const uint32_t SWAPPEDTODOSTORE = 0x0E2C0102;
static const uint32_t TARGETENTRYID = 0x30100102;
static const uint32_t TELECOMMUNICATIONSDEVICEFORDEAFTELEPHONENUMBER = 0x3A4B001F;
static const uint32_t TELECOMMUNICATIONSDEVICEFORDEAFTELEPHONENUMBER_STRING8 = 0x3A4B001E;
static const uint32_t TELEXNUMBER = 0x3A2C001F;
static const uint32_t TELEXNUMBER_STRING8 = 0x3A2C001E;
static const uint32_t TEMPLATEDATA = 0x00010102;
static const uint32_t TEMPLATEID = 0x39020102;
static const uint32_t TEXTATTACHMENTCHARSET = 0x371B001F;
static const uint32_t TEXTATTACHMENTCHARSET_STRING8 = 0x371B001E;
static const uint32_t THUMBNAILPHOTO = 0x8C9E0102;
static const uint32_t TITLE = 0x3A17001F;
static const uint32_t TITLE_STRING8 = 0x3A17001E;
static const uint32_t TNEFCORRELATIONKEY = 0x007F0102;
static const uint32_t TODOITEMFLAGS = 0x0E2B0003;
static const uint32_t TRANSMITTABLEDISPLAYNAME = 0x3A20001F;
static const uint32_t TRANSMITTABLEDISPLAYNAME_STRING8 = 0x3A20001E;
static const uint32_t TRANSPORTMESSAGEHEADERS = 0x007D001F;
static const uint32_t TRANSPORTMESSAGEHEADERS_STRING8 = 0x007D001E;
static const uint32_t TRUSTSENDER = 0x0E790003;
static const uint32_t USERCERTIFICATE = 0x3A220102;
static const uint32_t USERENTRYID = 0x66190102;
static const uint32_t USERX509CERTIFICATE = 0x3A701102;
static const uint32_t VIEWDESCRIPTORBINARY = 0x70010102;
static const uint32_t VIEWDESCRIPTORNAME = 0x7006001F;
static const uint32_t VIEWDESCRIPTORNAME_STRING8 = 0x7006001E;
static const uint32_t VIEWDESCRIPTORSTRINGS = 0x7002001F;
static const uint32_t VIEWDESCRIPTORSTRINGS_STRING8 = 0x7002001E;
static const uint32_t VIEWDESCRIPTORVERSION = 0x70070003;
static const uint32_t VOICEMESSAGEATTACHMENTORDER = 0x6805001F;
static const uint32_t VOICEMESSAGEATTACHMENTORDER_STRING8 = 0x6805001E;
static const uint32_t VOICEMESSAGESENDERNAME = 0x6803001F;
static const uint32_t VOICEMESSAGESENDERNAME_STRING8 = 0x6803001E;
static const uint32_t VOICEMESSAGEDURATION = 0x68010003;
static const uint32_t WEDDINGANNIVERSARY = 0x3A410040;
static const uint32_t WLINKADDRESSBOOKEID = 0x68540102;
static const uint32_t WLINKADDRESSBOOKSTOREEID = 0x68910102;
static const uint32_t WLINKCALENDARCOLOR = 0x68530003;
static const uint32_t WLINKCLIENTID = 0x68900102;
static const uint32_t WLINKENTRYID = 0x684C0102;
static const uint32_t WLINKFLAGS = 0x684A0003;
static const uint32_t WLINKFOLDERTYPE = 0x684F0102;
static const uint32_t WLINKGROUPCLSID = 0x68500102;
static const uint32_t WLINKGROUPHEADERID = 0x68420048;
static const uint32_t WLINKGROUPNAME = 0x6851001F;
static const uint32_t WLINKORDINAL = 0x684B0102;
static const uint32_t WLINKROGROUPTYPE = 0x68920003;
static const uint32_t WLINKRECORDKEY = 0x684D0102;
static const uint32_t WLINKSECTION = 0x68520003;
static const uint32_t WLINKSTOREENTRYID = 0x684E0102;
static const uint32_t WLINKTYPE = 0x68490003;
static const uint32_t ASSOCIATEDCONTENTCOUNT = 0x36170003;
static const uint32_t FOLDERCHILDCOUNT = 0x66380003;
static const uint32_t IPMPUBLICFOLDERSENTRYID = 0x66310102;
static const uint32_t CONVERSATIONKEY = 0x000B0102;
static const uint32_t CONTACTEMAILADDRESSES = 0x3A56101F;
static const uint32_t GENERATEEXCHANGEVIEWS = 0x36E9000B;
static const uint32_t LATESTDELIVERYTIME = 0x00190040;
static const uint32_t MAILPERMISSION = 0x3A0E000B;
static const uint32_t FOLDERFLAGS = 0x66A80003;
static const uint32_t HIERREV = 0x40820040;
static const uint32_t SETGIVEN = 0x40170003;
static const uint32_t CNSETSEEN = 0x67960102;
static const uint32_t CNSETSEENFAI = 0x67da0102;
static const uint32_t CNSETREAD = 0x67d20102;
static const uint32_t SETDELETED = 0x67e50102;
static const uint32_t SETNOLONGERINSCOPE = 0x40210102;
static const uint32_t SETEXPIRED = 0x67930102;
static const uint32_t SETREAD = 0x402d0102;
static const uint32_t SETUNREAD = 0x402e0102;
static const uint32_t NONRECEIPTNOTIFICATIONREQUESTED = 0x0C06000B;
static const uint32_t RESERVED = 0xFFFFFFFF;
static const uint32_t COMMONVIEWSENTRYID = 0x35E60102;
static const uint32_t DELETEDASSOCMESSAGESIZE = 0x669D0003;
static const uint32_t DELETEDASSOCMESSAGESIZEEXTENDED = 0x669D0014;
static const uint32_t DELETEDASSOCMSGCOUNT = 0x66430003;
static const uint32_t DELETEDMESSAGESIZE =	0x669B0003;
static const uint32_t DELETEDMESSAGESIZEEXTENDED =	0x669B0014;
static const uint32_t DELETEDMSGCOUNT = 0x66400003;
static const uint32_t DELETEDNORMALMESSAGESIZE = 0x669C0003;
static const uint32_t DELETEDNORMALMESSAGESIZEEXTENDED = 0x669C0014;
static const uint32_t FINDERENTRYID = 0x35E70102;
static const uint32_t INTERNETARTICLENUMBER = 0x0E230003;
static const uint32_t MIDSTRING = 0x0E23001F;
static const uint32_t ARTICLENUMBERNEXT = 0x67510003;
static const uint32_t IPMDAFENTRYID = 0x661F0102;
static const uint32_t IPMFAVORITESENTRYID = 0x66300102;
static const uint32_t IPMOUTBOXENTRYID = 0x35E20102;
static const uint32_t IPMSENTMAILENTRYID = 0x35E40102;
static const uint32_t IPMSUBTREEENTRYID = 0x35E00102;
static const uint32_t IPMWASTEBASKETENTRYID = 0x35E30102;
static const uint32_t SCHEDULEFOLDERENTRYID = 0x661E0102;
static const uint32_t NONIPMSUBTREEENTRYID = 0x66200102;
static const uint32_t STORAGEQUOTALIMIT = 0x3FF50003;
static const uint32_t STOREOFFLINE = 0x6632000B;
static const uint32_t VALIDFOLDERMASK = 0x35DF0003;
static const uint32_t VIEWSENTRYID = 0x35E50102;
static const uint32_t EFORMSREGISTRYENTRYID = 0x66210102;
static const uint32_t OFFLINEADDRBOOKENTRYID = 0x66230102;
static const uint32_t HIERARCHYSERVER = 0x6633001E;
static const uint32_t REPLICASERVER = 0x6644001E;
static const uint32_t FOLDERPATHNAME = 0x66B5001F;
static const uint32_t ASSOCMSGATTACHCOUNT = 0x66AE0003;
static const uint32_t NORMALMSGATTACHCOUNT = 0x66AD0003;
static const uint32_t TESTLINESPEED = 0x662B0102;
static const uint32_t PARENTDISPLAY = 0x0E05001F;
static const uint32_t PARENTDISPLAY_STRING8 = 0x0E05001E;
static const uint32_t CREATORSID = 0x0E580102;
}

}
