from .circuits import Circuits, CircuitTerminations
from .dcim import (
    DeviceTypes,
    Devices,
    Interfaces,
    PowerOutlets,
    PowerPorts,
    ConsolePorts,
    ConsoleServerPorts,
    RackReservations,
    VirtualChassis,
    FrontPorts,
    RearPorts,
    Racks,
    Termination,
    Cables,
)
from .ipam import (
    IpAddresses,
    Prefixes,
    Aggregates,
    Vlans,
    VlanGroups,
)
from .virtualization import VirtualMachines
from .wireless import WirelessLans


CONTENT_TYPE_MAPPER = {
    "circuits.circuit": Circuits,
    "circuits.circuittermination": CircuitTerminations,
    "dcim.cable": Cables,
    "dcim.cablepath": None,
    "dcim.cabletermination": Termination,
    "dcim.consoleport": ConsolePorts,
    "dcim.consoleporttemplate": None,
    "dcim.consoleserverport": ConsoleServerPorts,
    "dcim.consoleserverporttemplate": None,
    "dcim.device": Devices,
    "dcim.devicebay": None,
    "dcim.devicebaytemplate": None,
    "dcim.devicerole": None,
    "dcim.devicetype": DeviceTypes,
    "dcim.frontport": FrontPorts,
    "dcim.frontporttemplate": None,
    "dcim.interface": Interfaces,
    "dcim.interfacetemplate": None,
    "dcim.inventoryitem": None,
    "dcim.inventoryitemrole": None,
    "dcim.inventoryitemtemplate": None,
    "dcim.location": None,
    "dcim.manufacturer": None,
    "dcim.module": None,
    "dcim.modulebay": None,
    "dcim.modulebaytemplate": None,
    "dcim.moduletype": None,
    "dcim.platform": None,
    "dcim.powerfeed": None,
    "dcim.poweroutlet": PowerOutlets,
    "dcim.poweroutlettemplate": None,
    "dcim.powerpanel": None,
    "dcim.powerport": PowerPorts,
    "dcim.powerporttemplate": None,
    "dcim.rack": Racks,
    "dcim.rackreservation": RackReservations,
    "dcim.rackrole": None,
    "dcim.rearport": RearPorts,
    "dcim.rearporttemplate": None,
    "dcim.region": None,
    "dcim.site": None,
    "dcim.sitegroup": None,
    "dcim.virtualchassis": VirtualChassis,
    "extras.configcontext": None,
    "extras.configrevision": None,
    "extras.customfield": None,
    "extras.customlink": None,
    "extras.exporttemplate": None,
    "extras.imageattachment": None,
    "extras.jobresult": None,
    "extras.journalentry": None,
    "extras.objectchange": None,
    "extras.report": None,
    "extras.script": None,
    "extras.tag": None,
    "extras.taggeditem": None,
    "extras.webhook": None,
    "ipam.aggregate": Aggregates,
    "ipam.ASN": None,
    "ipam.FHRPgroup": None,
    "ipam.FHRPgroupassignment": None,
    "ipam.IPaddress": IpAddresses,
    "ipam.IPrange": None,
    "ipam.L2VPN": None,
    "ipam.L2VPNtermination": None,
    "ipam.prefix": Prefixes,
    "ipam.RIR": None,
    "ipam.role": None,
    "ipam.routetarget": None,
    "ipam.service": None,
    "ipam.servicetemplate": None,
    "ipam.VLAN": Vlans,
    "ipam.VLANgroup": VlanGroups,
    "ipam.VRF": None,
    "tenancy.contact": None,
    "tenancy.contactassignment": None,
    "tenancy.contactgroup": None,
    "tenancy.contactrole": None,
    "tenancy.tenant": None,
    "tenancy.tenantgroup": None,
    "virtualization.cluster": None,
    "virtualization.clustergroup": None,
    "virtualization.clustertype": None,
    "virtualization.interface": None,
    "virtualization.virtualmachine": VirtualMachines,
    "wireless.WirelessLAN": WirelessLans,
    "wireless.WirelessLANGroup": None,
    "wireless.wirelesslink": None,
}
