/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.cas.conf;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.properties.GuacamoleProperty;

public abstract class PrivateKeyGuacamoleProperty
implements GuacamoleProperty<PrivateKey> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PrivateKey parseValue(String value) throws GuacamoleServerException {
        if (value == null) return null;
        if (value.isEmpty()) {
            return null;
        }
        FileInputStream keyStreamIn = null;
        try {
            try {
                int readBytes;
                File keyFile = new File(value);
                keyStreamIn = new FileInputStream(keyFile);
                ByteArrayOutputStream keyStreamOut = new ByteArrayOutputStream();
                byte[] keyBuffer = new byte[1024];
                while ((readBytes = keyStreamIn.read(keyBuffer)) != -1) {
                    keyStreamOut.write(keyBuffer, 0, readBytes);
                }
                byte[] keyBytes = keyStreamOut.toByteArray();
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
                PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
                return privateKey;
            }
            catch (FileNotFoundException e) {
                throw new GuacamoleServerException("Could not find the specified key file.", (Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new GuacamoleServerException("RSA algorithm is not available.", (Throwable)e);
            }
            catch (InvalidKeySpecException e) {
                throw new GuacamoleServerException("Key is not in expected PKCS8 encoding.", (Throwable)e);
            }
            finally {
                if (keyStreamIn != null) {
                    keyStreamIn.close();
                }
            }
        }
        catch (IOException e) {
            throw new GuacamoleServerException("Could not read in the specified key file.", (Throwable)e);
        }
    }
}

