"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSearchFilters = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _filters = require("./filters");

var _filter_group = require("../filter_group");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

var EuiSearchFilters = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(EuiSearchFilters, _Component);

  var _super = _createSuper(EuiSearchFilters);

  function EuiSearchFilters() {
    (0, _classCallCheck2.default)(this, EuiSearchFilters);
    return _super.apply(this, arguments);
  }

  (0, _createClass2.default)(EuiSearchFilters, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          _this$props$filters = _this$props.filters,
          filters = _this$props$filters === void 0 ? [] : _this$props$filters,
          query = _this$props.query,
          onChange = _this$props.onChange;
      var items = [];
      filters.forEach(function (filterConfig, index) {
        if (filterConfig.available && !filterConfig.available()) {
          return;
        }

        var key = "filter_".concat(index);
        var control = (0, _filters.createFilter)(index, filterConfig, query, onChange);
        items.push( /*#__PURE__*/_react.default.createElement(_react.Fragment, {
          key: key
        }, control));
      });
      return /*#__PURE__*/_react.default.createElement(_filter_group.EuiFilterGroup, null, items);
    }
  }]);
  return EuiSearchFilters;
}(_react.Component);

exports.EuiSearchFilters = EuiSearchFilters;
(0, _defineProperty2.default)(EuiSearchFilters, "defaultProps", {
  filters: []
});
EuiSearchFilters.propTypes = {
  query: _propTypes.default.any.isRequired,
  onChange: _propTypes.default.func.isRequired,
  filters: _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.shape({
    type: _propTypes.default.oneOf(["is"]).isRequired,
    field: _propTypes.default.string.isRequired,
    name: _propTypes.default.string.isRequired,
    negatedName: _propTypes.default.string,
    available: _propTypes.default.func
  }).isRequired, _propTypes.default.shape({
    type: _propTypes.default.oneOf(["field_value_selection"]).isRequired,
    field: _propTypes.default.string,
    name: _propTypes.default.string.isRequired,

    /**
       * See #FieldValueOptionType
       */
    options: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.shape({
      field: _propTypes.default.string,
      value: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired, _propTypes.default.bool.isRequired, _propTypes.default.shape({
        type: _propTypes.default.oneOf(["date"]).isRequired,
        raw: _propTypes.default.any.isRequired,
        granularity: _propTypes.default.oneOfType([_propTypes.default.shape({
          es: _propTypes.default.oneOf(["d", "w", "M", "y"]).isRequired,
          js: _propTypes.default.oneOf(["day", "week", "month", "year"]).isRequired,
          isSame: _propTypes.default.func.isRequired,
          start: _propTypes.default.func.isRequired,
          startOfNext: _propTypes.default.func.isRequired,
          iso8601: _propTypes.default.func.isRequired
        }).isRequired, _propTypes.default.oneOf([undefined])]).isRequired,
        text: _propTypes.default.string.isRequired,
        resolve: _propTypes.default.func.isRequired
      }).isRequired]).isRequired,
      name: _propTypes.default.string,
      view: _propTypes.default.node
    }).isRequired).isRequired, _propTypes.default.func.isRequired]).isRequired,
    filterWith: _propTypes.default.oneOfType([_propTypes.default.oneOf(["prefix", "includes"]), _propTypes.default.func.isRequired]),
    cache: _propTypes.default.number,
    multiSelect: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.oneOf(["and", "or"])]),
    loadingMessage: _propTypes.default.string,
    noOptionsMessage: _propTypes.default.string,
    searchThreshold: _propTypes.default.number,
    available: _propTypes.default.func,
    autoClose: _propTypes.default.bool,
    operator: _propTypes.default.oneOf(["eq", "exact", "gt", "gte", "lt", "lte"])
  }).isRequired, _propTypes.default.shape({
    type: _propTypes.default.oneOf(["field_value_toggle"]).isRequired,
    field: _propTypes.default.string.isRequired,
    value: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired, _propTypes.default.bool.isRequired, _propTypes.default.shape({
      type: _propTypes.default.oneOf(["date"]).isRequired,
      raw: _propTypes.default.any.isRequired,
      granularity: _propTypes.default.oneOfType([_propTypes.default.shape({
        es: _propTypes.default.oneOf(["d", "w", "M", "y"]).isRequired,
        js: _propTypes.default.oneOf(["day", "week", "month", "year"]).isRequired,
        isSame: _propTypes.default.func.isRequired,
        start: _propTypes.default.func.isRequired,
        startOfNext: _propTypes.default.func.isRequired,
        iso8601: _propTypes.default.func.isRequired
      }).isRequired, _propTypes.default.oneOf([undefined])]).isRequired,
      text: _propTypes.default.string.isRequired,
      resolve: _propTypes.default.func.isRequired
    }).isRequired]).isRequired,
    name: _propTypes.default.string.isRequired,
    negatedName: _propTypes.default.string,
    available: _propTypes.default.func,
    operator: _propTypes.default.oneOf(["eq", "exact", "gt", "gte", "lt", "lte"])
  }).isRequired, _propTypes.default.shape({
    type: _propTypes.default.oneOf(["field_value_toggle_group"]).isRequired,
    field: _propTypes.default.string.isRequired,

    /**
       * See #FieldValueToggleGroupFilterItemType
       */
    items: _propTypes.default.arrayOf(_propTypes.default.shape({
      value: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired, _propTypes.default.bool.isRequired]).isRequired,
      name: _propTypes.default.string.isRequired,
      negatedName: _propTypes.default.string,
      operator: _propTypes.default.oneOf(["eq", "exact", "gt", "gte", "lt", "lte"])
    }).isRequired).isRequired,
    available: _propTypes.default.func
  }).isRequired]).isRequired).isRequired
};