"use strict";
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.loggerMock = void 0;
const createLoggerMock = (context = []) => {
    const mockLog = {
        context,
        debug: jest.fn(),
        error: jest.fn(),
        fatal: jest.fn(),
        info: jest.fn(),
        log: jest.fn(),
        trace: jest.fn(),
        warn: jest.fn(),
        get: jest.fn(),
    };
    mockLog.get.mockImplementation((...ctx) => ({
        ctx,
        ...mockLog,
    }));
    return mockLog;
};
const clearLoggerMock = (logger) => {
    logger.debug.mockClear();
    logger.info.mockClear();
    logger.warn.mockClear();
    logger.error.mockClear();
    logger.trace.mockClear();
    logger.fatal.mockClear();
    logger.log.mockClear();
};
const collectLoggerMock = (logger) => {
    return {
        debug: logger.debug.mock.calls,
        error: logger.error.mock.calls,
        fatal: logger.fatal.mock.calls,
        info: logger.info.mock.calls,
        log: logger.log.mock.calls,
        trace: logger.trace.mock.calls,
        warn: logger.warn.mock.calls,
    };
};
exports.loggerMock = {
    create: createLoggerMock,
    clear: clearLoggerMock,
    collect: collectLoggerMock,
};
