"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _constants = require("../utils/constants");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } /*
                                                                                                                                                                                                                   * Copyright OpenSearch Contributors
                                                                                                                                                                                                                   * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                   */

class FindingsService {
  constructor(osDriver) {
    _defineProperty(this, "osDriver", void 0);

    _defineProperty(this, "getFindings", async (context, request, response) => {
      try {
        const {
          detectorType,
          detectorId,
          sortOrder,
          size
        } = request.query;
        const defaultParams = {
          sortOrder,
          size
        };
        let params;

        if (detectorId) {
          params = { ...defaultParams,
            detectorId
          };
        } else if (detectorType) {
          params = { ...defaultParams,
            detectorType
          };
        } else {
          throw Error(`Invalid request params: detectorId or detectorType must be specified`);
        }

        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const getFindingsResponse = await callWithRequest(_constants.CLIENT_DETECTOR_METHODS.GET_FINDINGS, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getFindingsResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - FindingsService - getFindings:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    this.osDriver = osDriver;
  }
  /**
   * Calls backend GET Findings API.
   */


}

exports.default = FindingsService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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