"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityPlugin = void 0;

var _operators = require("rxjs/operators");

var _routes = require("./routes");

var _opensearch_security_configuration_plugin = _interopRequireDefault(require("./backend/opensearch_security_configuration_plugin"));

var _opensearch_security_plugin = _interopRequireDefault(require("./backend/opensearch_security_plugin"));

var _security_cookie = require("./session/security_cookie");

var _opensearch_security_client = require("./backend/opensearch_security_client");

var _tenant_index = require("./multitenancy/tenant_index");

var _auth_handler_factory = require("./auth/auth_handler_factory");

var _routes2 = require("./multitenancy/routes");

var _auth_type_routes = require("./routes/auth_type_routes");

var _core = require("../../../src/core/server/saved_objects/migrations/core");

var _saved_objects_wrapper = require("./saved_objects/saved_objects_wrapper");

var _tenant_resolver = require("./multitenancy/tenant_resolver");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } /*
                                                                                                                                                                                                                   *   Copyright OpenSearch Contributors
                                                                                                                                                                                                                   *
                                                                                                                                                                                                                   *   Licensed under the Apache License, Version 2.0 (the "License").
                                                                                                                                                                                                                   *   You may not use this file except in compliance with the License.
                                                                                                                                                                                                                   *   A copy of the License is located at
                                                                                                                                                                                                                   *
                                                                                                                                                                                                                   *       http://www.apache.org/licenses/LICENSE-2.0
                                                                                                                                                                                                                   *
                                                                                                                                                                                                                   *   or in the "license" file accompanying this file. This file is distributed
                                                                                                                                                                                                                   *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
                                                                                                                                                                                                                   *   express or implied. See the License for the specific language governing
                                                                                                                                                                                                                   *   permissions and limitations under the License.
                                                                                                                                                                                                                   */

class SecurityPlugin {
  // FIXME: keep an reference of admin client so that it can be used in start(), better to figureout a
  //        decent way to get adminClient in start. (maybe using getStartServices() from setup?)
  // @ts-ignore: property not initialzied in constructor
  constructor(initializerContext) {
    this.initializerContext = initializerContext;

    _defineProperty(this, "logger", void 0);

    _defineProperty(this, "securityClient", void 0);

    _defineProperty(this, "savedObjectClientWrapper", void 0);

    this.logger = initializerContext.logger.get();
    this.savedObjectClientWrapper = new _saved_objects_wrapper.SecuritySavedObjectsClientWrapper();
  }

  async setup(core) {
    var _config$multitenancy, _config$multitenancy2;

    this.logger.debug('opendistro_security: Setup');
    const config$ = this.initializerContext.config.create();
    const config = await config$.pipe((0, _operators.first)()).toPromise();
    const router = core.http.createRouter();
    const esClient = core.opensearch.legacy.createClient('opendistro_security', {
      plugins: [_opensearch_security_configuration_plugin.default, _opensearch_security_plugin.default]
    });
    this.securityClient = new _opensearch_security_client.SecurityClient(esClient);
    const securitySessionStorageFactory = await core.http.createCookieSessionStorageFactory((0, _security_cookie.getSecurityCookieOptions)(config)); // put logger into route handler context, so that we don't need to pass througth parameters

    core.http.registerRouteHandlerContext('security_plugin', (context, request) => {
      return {
        logger: this.logger,
        esClient
      };
    }); // setup auth

    const auth = await (0, _auth_handler_factory.getAuthenticationHandler)(config.auth.type, router, config, core, esClient, securitySessionStorageFactory, this.logger);
    core.http.registerAuth(auth.authHandler);
    /* Here we check if multitenancy is enabled to ensure if it is, we insert the tenant info (security_tenant) into the resolved, short URL so the page can correctly load with the right tenant information [Fix for issue 1203](https://github.com/opensearch-project/security-dashboards-plugin/issues/1203 */

    if ((_config$multitenancy = config.multitenancy) !== null && _config$multitenancy !== void 0 && _config$multitenancy.enabled) {
      core.http.registerOnPreResponse((request, preResponse, toolkit) => {
        (0, _tenant_resolver.addTenantParameterToResolvedShortLink)(request);
        return toolkit.next();
      });
    } // Register server side APIs


    (0, _routes.defineRoutes)(router);
    (0, _auth_type_routes.defineAuthTypeRoutes)(router, config); // set up multi-tenent routes

    if ((_config$multitenancy2 = config.multitenancy) !== null && _config$multitenancy2 !== void 0 && _config$multitenancy2.enabled) {
      (0, _routes2.setupMultitenantRoutes)(router, securitySessionStorageFactory, this.securityClient);
    }

    if (config.multitenancy.enabled && config.multitenancy.enable_aggregation_view) {
      core.savedObjects.addClientWrapper(2, 'security-saved-object-client-wrapper', this.savedObjectClientWrapper.wrapperFactory);
    }

    return {
      config$,
      securityConfigClient: esClient
    };
  } // TODO: add more logs


  async start(core) {
    var _config$multitenancy3;

    this.logger.debug('opendistro_security: Started');
    const config$ = this.initializerContext.config.create();
    const config = await config$.pipe((0, _operators.first)()).toPromise();
    this.savedObjectClientWrapper.httpStart = core.http;
    this.savedObjectClientWrapper.config = config;

    if ((_config$multitenancy3 = config.multitenancy) !== null && _config$multitenancy3 !== void 0 && _config$multitenancy3.enabled) {
      const globalConfig$ = this.initializerContext.config.legacy.globalConfig$;
      const globalConfig = await globalConfig$.pipe((0, _operators.first)()).toPromise();
      const opensearchDashboardsIndex = globalConfig.opensearchDashboards.index;
      const typeRegistry = core.savedObjects.getTypeRegistry();
      const esClient = core.opensearch.client.asInternalUser;
      const migrationClient = (0, _core.createMigrationOpenSearchClient)(esClient, this.logger);
      (0, _tenant_index.setupIndexTemplate)(esClient, opensearchDashboardsIndex, typeRegistry, this.logger);
      const serializer = core.savedObjects.createSerializer();
      const opensearchDashboardsVersion = this.initializerContext.env.packageInfo.version;
      (0, _tenant_index.migrateTenantIndices)(opensearchDashboardsVersion, migrationClient, this.securityClient, typeRegistry, serializer, this.logger);
    }

    return {
      http: core.http,
      es: core.opensearch.legacy
    };
  }

  stop() {}

}

exports.SecurityPlugin = SecurityPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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