/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.exceptions.AXmlDecodingException;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.RawXmlEncounteredException;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.decoder.AXmlResourceParser;
import brut.androlib.res.decoder.ResStreamDecoder;
import brut.androlib.res.util.ExtXmlSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.wrapper.XmlPullParserWrapper;
import org.xmlpull.v1.wrapper.XmlPullWrapperFactory;
import org.xmlpull.v1.wrapper.classic.StaticXmlSerializerWrapper;

public class XmlPullStreamDecoder
implements ResStreamDecoder {
    private final AXmlResourceParser mParser;
    private final ExtXmlSerializer mSerial;

    public XmlPullStreamDecoder(AXmlResourceParser parser, ExtXmlSerializer serializer) {
        this.mParser = parser;
        this.mSerial = serializer;
    }

    @Override
    public void decode(InputStream in, OutputStream out) throws AndrolibException {
        try {
            XmlPullWrapperFactory factory = XmlPullWrapperFactory.newInstance();
            XmlPullParserWrapper par = factory.newPullParserWrapper(this.mParser);
            final ResTable resTable = this.mParser.getResTable();
            StaticXmlSerializerWrapper ser = new StaticXmlSerializerWrapper(this.mSerial, factory){
                boolean hideSdkInfo;
                boolean hidePackageInfo;
                {
                    super(arg0, arg1);
                    this.hideSdkInfo = false;
                    this.hidePackageInfo = false;
                }

                @Override
                public void event(XmlPullParser pp) throws XmlPullParserException, IOException {
                    int type = pp.getEventType();
                    if (type == 2) {
                        if ("manifest".equalsIgnoreCase(pp.getName())) {
                            try {
                                this.hidePackageInfo = this.parseManifest(pp);
                            }
                            catch (AndrolibException androlibException) {}
                        } else if ("uses-sdk".equalsIgnoreCase(pp.getName())) {
                            try {
                                this.hideSdkInfo = this.parseAttr(pp);
                                if (this.hideSdkInfo) {
                                    return;
                                }
                            }
                            catch (AndrolibException androlibException) {}
                        }
                    } else {
                        if (this.hideSdkInfo && type == 3 && "uses-sdk".equalsIgnoreCase(pp.getName())) {
                            return;
                        }
                        if (this.hidePackageInfo && type == 3 && "manifest".equalsIgnoreCase(pp.getName())) {
                            super.event(pp);
                            return;
                        }
                    }
                    super.event(pp);
                }

                private boolean parseManifest(XmlPullParser pp) throws AndrolibException {
                    for (int i = 0; i < pp.getAttributeCount(); ++i) {
                        String attr_name = pp.getAttributeName(i);
                        if (attr_name.equalsIgnoreCase("package")) {
                            resTable.setPackageRenamed(pp.getAttributeValue(i));
                            continue;
                        }
                        if (attr_name.equalsIgnoreCase("versionCode")) {
                            resTable.setVersionCode(pp.getAttributeValue(i));
                            continue;
                        }
                        if (!attr_name.equalsIgnoreCase("versionName")) continue;
                        resTable.setVersionName(pp.getAttributeValue(i));
                    }
                    return true;
                }

                private boolean parseAttr(XmlPullParser pp) throws AndrolibException {
                    for (int i = 0; i < pp.getAttributeCount(); ++i) {
                        String a_ns = "http://schemas.android.com/apk/res/android";
                        String ns = pp.getAttributeNamespace(i);
                        if ("http://schemas.android.com/apk/res/android".equalsIgnoreCase(ns)) {
                            String name = pp.getAttributeName(i);
                            String value = pp.getAttributeValue(i);
                            if (name == null || value == null) continue;
                            if (name.equalsIgnoreCase("minSdkVersion") || name.equalsIgnoreCase("targetSdkVersion") || name.equalsIgnoreCase("maxSdkVersion") || name.equalsIgnoreCase("compileSdkVersion")) {
                                resTable.addSdkInfo(name, value);
                                continue;
                            }
                            resTable.clearSdkInfo();
                            return false;
                        }
                        resTable.clearSdkInfo();
                        if (i < pp.getAttributeCount()) continue;
                        return false;
                    }
                    return !resTable.getAnalysisMode();
                }
            };
            par.setInput(in, null);
            ser.setOutput(out, null);
            while (par.nextToken() != 1) {
                ser.event(par);
            }
            ser.flush();
        }
        catch (XmlPullParserException ex) {
            throw new AXmlDecodingException("Could not decode XML", ex);
        }
        catch (IOException ex) {
            throw new RawXmlEncounteredException("Could not decode XML", ex);
        }
    }

    public void decodeManifest(InputStream in, OutputStream out) throws AndrolibException {
        this.decode(in, out);
    }
}

