/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sqlobject;

import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.object.annotation.NonBound;
import ca.sqlpower.object.annotation.Transient;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLSchema;
import ca.sqlpower.sqlobject.SQLTable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class SQLCatalog
extends SQLObject {
    private static Logger logger = Logger.getLogger(SQLCatalog.class);
    public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.unmodifiableList(new ArrayList<Class>(Arrays.asList(SQLSchema.class, SQLTable.class)));
    private List<SQLSchema> schemas = new ArrayList<SQLSchema>();
    private List<SQLTable> tables = new ArrayList<SQLTable>();
    protected String nativeTerm;

    static List<SQLCatalog> fetchCatalogs(DatabaseMetaData dbmd) throws SQLObjectException {
        ResultSet rs = null;
        try {
            ArrayList<SQLCatalog> catalogs = new ArrayList<SQLCatalog>();
            rs = dbmd.getCatalogs();
            while (rs.next()) {
                String catName = rs.getString(1);
                if (catName == null) continue;
                SQLCatalog cat = new SQLCatalog(null, catName);
                cat.setNativeTerm(dbmd.getCatalogTerm());
                logger.debug((Object)("Set catalog term to " + cat.getNativeTerm()));
                catalogs.add(cat);
            }
            ArrayList<SQLCatalog> arrayList = catalogs;
            return arrayList;
        }
        catch (SQLException ex) {
            throw new SQLObjectException("Failed to get catalog names from source database", ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                throw new SQLObjectException("Couldn't close result set. Squishing this exception:", e);
            }
        }
    }

    public SQLCatalog() {
        this(null, null, false);
    }

    @Constructor
    public SQLCatalog(@ConstructorParameter(propertyName="parent") SQLDatabase parent, @ConstructorParameter(propertyName="name") String name) {
        this(parent, name, false);
    }

    public SQLCatalog(SQLDatabase parent, String name, boolean startPopulated) {
        this.setParent(parent);
        this.setName(name);
        this.nativeTerm = "catalog";
        this.populated = startPopulated;
    }

    @Override
    public void updateToMatch(SQLObject source) throws SQLObjectException {
        SQLCatalog c = (SQLCatalog)source;
        this.setName(c.getName());
        this.setNativeTerm(c.getNativeTerm());
        this.setPhysicalName(c.getPhysicalName());
    }

    protected SQLTable getTableByName(String tableName) throws SQLObjectException {
        this.populate();
        for (SQLObject sQLObject : this.getChildren()) {
            SQLTable table;
            if (!(sQLObject instanceof SQLTable ? (table = (SQLTable)sQLObject).getName().equalsIgnoreCase(tableName) : sQLObject instanceof SQLSchema && (table = ((SQLSchema)sQLObject).findTableByName(tableName)) != null)) continue;
            return table;
        }
        return null;
    }

    public SQLSchema findSchemaByName(String schemaName) throws SQLObjectException {
        this.populate();
        if (!this.isSchemaContainer()) {
            return null;
        }
        for (SQLSchema schema : this.schemas) {
            if (!schema.getName().equalsIgnoreCase(schemaName)) continue;
            return schema;
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getShortDisplayName();
    }

    @Override
    @Transient
    @Accessor
    public String getShortDisplayName() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void populateImpl() throws SQLObjectException {
        if (this.populated) {
            return;
        }
        logger.debug((Object)"SQLCatalog: populate starting");
        SQLDatabase sQLDatabase = this.getParent();
        synchronized (sQLDatabase) {
            List<SQLTable> fetchedTables;
            List<SQLSchema> fetchedSchemas;
            Connection con = null;
            try {
                con = this.getParent().getConnection();
                DatabaseMetaData dbmd = con.getMetaData();
                fetchedSchemas = SQLSchema.fetchSchemas(dbmd, this.getName());
                fetchedTables = fetchedSchemas.isEmpty() ? SQLTable.fetchTablesForTableContainer(dbmd, this.getName(), null) : null;
            }
            catch (SQLException e) {
                throw new SQLObjectException("catalog.populate.fail", e);
            }
            finally {
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException e) {
                    throw new SQLObjectException("Couldn't close connection", e);
                }
            }
            this.runInForeground(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SQLCatalog sQLCatalog = SQLCatalog.this;
                    synchronized (sQLCatalog) {
                        if (SQLCatalog.this.populated) {
                            return;
                        }
                        if (!fetchedSchemas.isEmpty()) {
                            SQLCatalog.populateCatalogWithList(SQLCatalog.this, fetchedSchemas);
                        } else if (!fetchedTables.isEmpty()) {
                            SQLCatalog.populateCatalogWithList(SQLCatalog.this, fetchedTables);
                        }
                    }
                }
            });
        }
        logger.debug((Object)"SQLCatalog: populate finished");
    }

    static void populateCatalogWithList(SQLCatalog catalog, List<? extends SQLObject> children) {
        try {
            Class childType;
            int index;
            if (children.isEmpty()) {
                return;
            }
            if (children.get(0) instanceof SQLSchema) {
                index = catalog.schemas.size();
                childType = SQLSchema.class;
                for (SQLObject sQLObject : children) {
                    catalog.schemas.add((SQLSchema)sQLObject);
                    sQLObject.setParent(catalog);
                }
            } else if (children.get(0) instanceof SQLTable) {
                index = catalog.tables.size();
                childType = SQLTable.class;
                for (SQLObject sQLObject : children) {
                    catalog.tables.add((SQLTable)sQLObject);
                    sQLObject.setParent(catalog);
                }
            } else {
                throw new IllegalArgumentException("Catalog " + catalog + " cannot have children " + "of type " + children.get(0).getClass());
            }
            catalog.populated = true;
            catalog.begin("Populating Catalog " + catalog);
            for (SQLObject sQLObject : children) {
                catalog.fireChildAdded(childType, sQLObject, index);
                ++index;
            }
            catalog.firePropertyChange("populated", false, true);
            catalog.commit();
        }
        catch (Exception e) {
            catalog.rollback(e.getMessage());
            if (children.get(0) instanceof SQLSchema) {
                for (SQLObject sQLObject : children) {
                    catalog.schemas.remove((SQLSchema)sQLObject);
                }
            } else if (children.get(0) instanceof SQLTable) {
                for (SQLObject sQLObject : children) {
                    catalog.tables.remove((SQLTable)sQLObject);
                }
            }
            catalog.populated = false;
            throw new RuntimeException(e);
        }
    }

    @Override
    @Accessor
    public SQLDatabase getParent() {
        return (SQLDatabase)super.getParent();
    }

    @Mutator
    public void setParent(SQLDatabase parent) {
        super.setParent(parent);
    }

    @Accessor
    public String getNativeTerm() {
        return this.nativeTerm;
    }

    @Mutator
    public void setNativeTerm(String argNativeTerm) {
        if (argNativeTerm != null) {
            argNativeTerm = argNativeTerm.toLowerCase();
        }
        String oldValue = this.nativeTerm;
        this.nativeTerm = argNativeTerm;
        this.firePropertyChange("nativeTerm", oldValue, this.nativeTerm);
    }

    @NonBound
    public boolean isSchemaContainer() throws SQLObjectException {
        if (this.getParent() != null) {
            this.populate();
        }
        if (this.getChildrenWithoutPopulating().isEmpty()) {
            return true;
        }
        return !this.schemas.isEmpty();
    }

    @Override
    protected void addChildImpl(SPObject child, int index) {
        if (child instanceof SQLSchema) {
            this.addSchema((SQLSchema)child, index);
        } else if (child instanceof SQLTable) {
            this.addTable((SQLTable)child, index);
        } else {
            throw new IllegalArgumentException("The child " + child.getName() + " of type " + child.getClass() + " is not a valid child type of " + this.getClass() + ".");
        }
    }

    public void addSchema(SQLSchema schema) {
        this.addSchema(schema, this.schemas.size());
    }

    public void addSchema(SQLSchema schema, int index) {
        this.schemas.add(index, schema);
        schema.setParent(this);
        this.fireChildAdded(SQLSchema.class, schema, index);
    }

    public void addTable(SQLTable table) {
        this.addTable(table, this.tables.size());
    }

    public void addTable(SQLTable table, int index) {
        this.tables.add(index, table);
        table.setParent(this);
        this.fireChildAdded(SQLTable.class, table, index);
    }

    @Override
    public List<? extends SQLObject> getChildrenWithoutPopulating() {
        ArrayList<SQLObject> children = new ArrayList<SQLObject>();
        children.addAll(this.schemas);
        children.addAll(this.tables);
        return Collections.unmodifiableList(children);
    }

    @Override
    protected boolean removeChildImpl(SPObject child) {
        if (child instanceof SQLSchema) {
            return this.removeSchema((SQLSchema)child);
        }
        if (child instanceof SQLTable) {
            return this.removeTable((SQLTable)child);
        }
        return false;
    }

    public boolean removeSchema(SQLSchema schema) {
        int index = this.schemas.indexOf(schema);
        if (index != -1) {
            this.schemas.remove(index);
            this.fireChildRemoved(SQLSchema.class, schema, index);
            schema.setParent(null);
            return true;
        }
        return false;
    }

    public boolean removeTable(SQLTable table) {
        table.removeNotify();
        int index = this.tables.indexOf(table);
        if (index != -1) {
            this.tables.remove(index);
            this.fireChildRemoved(SQLTable.class, table, index);
            table.setParent(null);
            return true;
        }
        return false;
    }

    @Override
    public List<? extends SPObject> getDependencies() {
        return Collections.emptyList();
    }

    @Override
    public void removeDependency(SPObject dependency) {
        for (SQLObject sQLObject : this.getChildren()) {
            sQLObject.removeDependency(dependency);
        }
    }

    @Override
    public List<Class<? extends SPObject>> getAllowedChildTypes() {
        return allowedChildTypes;
    }
}

