/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import com.amazonaws.services.ec2.model.ClassicLinkInstance;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeClassicLinkInstances
extends BaseCmd {
    public DescribeClassicLinkInstances(String[] args) {
        super("ec2dcli", "ec2-describe-classic-link-instances");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    protected String getOptionString() {
        return "[INSTANCE [INSTANCE [...]]]";
    }

    private Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)"Add a filter criterion for the result-set.");
        options.addOption(OptionBuilder.create((String)"F"));
        return options;
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Describes one or more of your ClassicLink instances. This command only returns information about EC2-Classic instances linked to a VPC through ClassicLink; information about other instances is not included in the results.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("filter");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        RequestResultPair rsp;
        String[] instanceIds = this.getNonOptions();
        String nextToken = null;
        ArrayList<ClassicLinkInstance> classicLinkInstances = new ArrayList<ClassicLinkInstance>();
        do {
            rsp = jec2.describeClassicLinkInstances(instanceIds, this.getFilters(true), nextToken);
            classicLinkInstances.addAll((Collection)rsp.getResponse());
        } while ((nextToken = rsp.getNextToken()) != null && !nextToken.isEmpty());
        out.outputClassicLinkInstances(System.out, classicLinkInstances);
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    @Override
    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    protected void validateParameters() {
    }

    public static void main(String[] args) {
        new DescribeClassicLinkInstances(args).invoke();
    }
}

