/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Arrays;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.XPathComparable;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.ContextFreeAtomicValue;
import net.sf.saxon.value.Whitespace;

public class HexBinaryValue
extends AtomicValue
implements AtomicMatchKey,
XPathComparable,
ContextFreeAtomicValue {
    private final byte[] binaryValue;

    public HexBinaryValue(UnicodeString in) throws XPathException {
        UnicodeString s = Whitespace.trim(in);
        int len32 = s.length32();
        if ((len32 & 1) != 0) {
            XPathException err = new XPathException("A hexBinary value must contain an even number of characters");
            err.setErrorCode("FORG0001");
            throw err;
        }
        this.binaryValue = new byte[len32 / 2];
        for (int i = 0; i < this.binaryValue.length; ++i) {
            this.binaryValue[i] = (byte)((this.fromHex(s.codePointAt(2 * i)) << 4) + this.fromHex(s.codePointAt(2 * i + 1)));
        }
        this.typeLabel = BuiltInAtomicType.HEX_BINARY;
    }

    public HexBinaryValue(byte[] value) {
        this.binaryValue = value;
        this.typeLabel = BuiltInAtomicType.HEX_BINARY;
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        HexBinaryValue v = new HexBinaryValue(this.binaryValue);
        v.typeLabel = typeLabel;
        return v;
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.HEX_BINARY;
    }

    public byte[] getBinaryValue() {
        return this.binaryValue;
    }

    private int fromHex(int c) throws XPathException {
        int d;
        int n = d = c < 255 ? "0123456789ABCDEFabcdef".indexOf((char)c) : -1;
        if (d > 15) {
            d -= 6;
        }
        if (d < 0) {
            XPathException err = new XPathException("Invalid hexadecimal digit '" + c + "'");
            err.setErrorCode("FORG0001");
            throw err;
        }
        return d;
    }

    @Override
    public UnicodeString getPrimitiveStringValue() {
        String digits = "0123456789ABCDEF";
        UnicodeBuilder sb = new UnicodeBuilder(this.binaryValue.length * 2);
        for (byte aBinaryValue : this.binaryValue) {
            sb.append(digits.charAt(aBinaryValue >> 4 & 0xF));
            sb.append(digits.charAt(aBinaryValue & 0xF));
        }
        return sb.toUnicodeString();
    }

    public int getLengthInOctets() {
        return this.binaryValue.length;
    }

    @Override
    public AtomicMatchKey getXPathMatchKey(StringCollator collator, int implicitTimezone) {
        return this;
    }

    @Override
    public XPathComparable getXPathComparable(StringCollator collator, int implicitTimezone) {
        return this;
    }

    @Override
    public XPathComparable getXPathComparable() {
        return this;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof HexBinaryValue && Arrays.equals(this.binaryValue, ((HexBinaryValue)other).binaryValue);
    }

    @Override
    public int hashCode() {
        return Base64BinaryValue.byteArrayHashCode(this.binaryValue);
    }

    @Override
    public int compareTo(XPathComparable o) {
        if (o instanceof HexBinaryValue) {
            byte[] other = ((HexBinaryValue)o).binaryValue;
            int len0 = this.binaryValue.length;
            int len1 = other.length;
            int shorter = Math.min(len0, len1);
            for (int i = 0; i < shorter; ++i) {
                int a = this.binaryValue[i] & 0xFF;
                int b = other[i] & 0xFF;
                if (a == b) continue;
                return a < b ? -1 : 1;
            }
            return Integer.signum(len0 - len1);
        }
        throw new ClassCastException("Cannot compare xs:hexBinary to " + o.toString());
    }
}

