package MyServer::HelloWorld::HelloWorldSoap;
use strict;
use warnings;
use Class::Std::Fast::Storable;
use Scalar::Util qw(blessed);
use base qw(SOAP::WSDL::Client::Base);

# only load if it hasn't been loaded before
require MyTypemaps::HelloWorld
    if not MyTypemaps::HelloWorld->can('get_class');

my %transport_class_of :ATTR(:name<transport_class> :default<SOAP::WSDL::Server::CGI>);
my %transport_of :ATTR(:name<transport> :default<()>);
my %dispatch_to :ATTR(:name<dispatch_to>);

my $action_map_ref = {
    'urn:HelloWorld#sayHello' => 'sayHello',
};

sub START {
    my ($self, $ident, $arg_ref) = @_;
    eval "require $transport_class_of{ $ident }"
        or die "Cannot load transport class $transport_class_of{ $ident }: $@";
    $transport_of{ $ident } = $transport_class_of{ $ident }->new({
        action_map_ref => $action_map_ref,
        class_resolver => 'MyTypemaps::HelloWorld',
        dispatch_to => $dispatch_to{ $ident },
    });
}

sub handle {
    $transport_of{ ${ $_[0] } }->handle(@_[1..$#_]);
}

1;



__END__

=pod

=head1 NAME

MyInterfaces::HelloWorld::HelloWorldSoap - SOAP Server Class for the HelloWorld Web Service

=head1 SYNOPSIS

 use MyServer::HelloWorld::HelloWorldSoap;
 my $server = MyServer::HelloWorld::HelloWorldSoap->new({
    dispatch_to => 'My::Handler::Class',
    transport_class => 'SOAP::WSDL::Server::CGI',   # optional, default
 });
 $server->handle();


=head1 DESCRIPTION

SOAP Server handler for the HelloWorld web service
located at http://localhost:81/soap-wsdl-test/helloworld.pl.

=head1 SERVICE HelloWorld



=head2 Port HelloWorldSoap



=head1 METHODS

=head2 General methods

=head3 new

Constructor.

The C<dispatch_to> argument is mandatory. It must be a class or object
implementing the SOAP Service methods listed below.

=head2 SOAP Service methods

Your dispatch_to class has to implement the following methods:

The examples below serve as copy-and-paste prototypes to use in your
class.

=head3 sayHello



 sub sayHello(
    my ($self, $body, $header) = @_;
    # body is a ??? object - sorry, POD not implemented yet
    # header is a ??? object - sorry, POD not implemented yet

    # do something with body and header...

    return  MyElements::sayHelloResponse->new(  {
    sayHelloResult =>  $some_value, # string
  },
 );

 }



=head1 AUTHOR

Generated by SOAP::WSDL on Sun Dec  2 01:20:36 2007

=pod