/*	$OpenBSD: ar5212var.h,v 1.16 2022/01/09 05:42:38 jsg Exp $	*/

/*
 * Copyright (c) 2004, 2005, 2006, 2007 Reyk Floeter <reyk@openbsd.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * Specific definitions for the Atheros AR5001 Wireless LAN chipset
 * (AR5212/AR5311).
 */

#ifndef _AR5K_AR5212_VAR_H
#define _AR5K_AR5212_VAR_H

#include <dev/ic/ar5xxx.h>

/*
 * Define a "magic" code for the AR5212 (the HAL layer wants it)
 */

#define AR5K_AR5212_MAGIC		0x0000145c /* 5212 */
#define AR5K_AR5212_TX_NUM_QUEUES	10

#if BYTE_ORDER == BIG_ENDIAN
#define AR5K_AR5212_INIT_CFG	(					\
	AR5K_AR5212_CFG_SWTD | AR5K_AR5212_CFG_SWRD			\
)
#else
#define AR5K_AR5212_INIT_CFG	0x00000000
#endif

/*
 * Internal RX/TX descriptor structures
 * (rX: reserved fields possibly used by future versions of the ar5k chipset)
 */

struct ar5k_ar5212_rx_desc {
	/*
	 * RX control word 0
	 */
	u_int32_t	rx_control_0;

#define AR5K_AR5212_DESC_RX_CTL0			0x00000000

	/*
	 * RX control word 1
	 */
	u_int32_t	rx_control_1;

#define AR5K_AR5212_DESC_RX_CTL1_BUF_LEN		0x00000fff
#define AR5K_AR5212_DESC_RX_CTL1_INTREQ			0x00002000
} __packed;

struct ar5k_ar5212_rx_status {
	/*
	 * RX status word 0
	 */
	u_int32_t	rx_status_0;

#define AR5K_AR5212_DESC_RX_STATUS0_DATA_LEN		0x00000fff
#define AR5K_AR5212_DESC_RX_STATUS0_MORE		0x00001000
#define AR5K_AR5212_DESC_RX_STATUS0_DECOMP_CRC_ERROR	0x00002000
#define AR5K_AR5212_DESC_RX_STATUS0_RECEIVE_RATE	0x000f8000
#define AR5K_AR5212_DESC_RX_STATUS0_RECEIVE_RATE_S	15
#define AR5K_AR5212_DESC_RX_STATUS0_RECEIVE_SIGNAL	0x0ff00000
#define AR5K_AR5212_DESC_RX_STATUS0_RECEIVE_SIGNAL_S	20
#define AR5K_AR5212_DESC_RX_STATUS0_RECEIVE_ANTENNA	0xf0000000
#define AR5K_AR5212_DESC_RX_STATUS0_RECEIVE_ANTENNA_S	28

	/*
	 * RX status word 1
	 */
	u_int32_t	rx_status_1;

#define AR5K_AR5212_DESC_RX_STATUS1_DONE		0x00000001
#define AR5K_AR5212_DESC_RX_STATUS1_FRAME_RECEIVE_OK	0x00000002
#define AR5K_AR5212_DESC_RX_STATUS1_CRC_ERROR		0x00000004
#define AR5K_AR5212_DESC_RX_STATUS1_DECRYPT_CRC_ERROR	0x00000008
#define AR5K_AR5212_DESC_RX_STATUS1_PHY_ERROR		0x00000010
#define AR5K_AR5212_DESC_RX_STATUS1_MIC_ERROR		0x00000020
#define AR5K_AR5212_DESC_RX_STATUS1_KEY_INDEX_VALID	0x00000100
#define AR5K_AR5212_DESC_RX_STATUS1_KEY_INDEX		0x0000fe00
#define AR5K_AR5212_DESC_RX_STATUS1_KEY_INDEX_S		9
#define AR5K_AR5212_DESC_RX_STATUS1_RECEIVE_TIMESTAMP	0x7fff0000
#define AR5K_AR5212_DESC_RX_STATUS1_RECEIVE_TIMESTAMP_S	16
#define AR5K_AR5212_DESC_RX_STATUS1_KEY_CACHE_MISS	0x80000000
} __packed;

struct ar5k_ar5212_rx_error {
	/*
	 * RX error word 0
	 */
	u_int32_t	rx_error_0;

#define AR5K_AR5212_DESC_RX_ERROR0			0x00000000

	/*
	 * RX error word 1
	 */
	u_int32_t	rx_error_1;

#define AR5K_AR5212_DESC_RX_ERROR1_PHY_ERROR_CODE	0x0000ff00
#define AR5K_AR5212_DESC_RX_ERROR1_PHY_ERROR_CODE_S	8
} __packed;

#define AR5K_AR5212_DESC_RX_PHY_ERROR_NONE		0x00
#define AR5K_AR5212_DESC_RX_PHY_ERROR_TIMING		0x20
#define AR5K_AR5212_DESC_RX_PHY_ERROR_PARITY		0x40
#define AR5K_AR5212_DESC_RX_PHY_ERROR_RATE		0x60
#define AR5K_AR5212_DESC_RX_PHY_ERROR_LENGTH		0x80
#define AR5K_AR5212_DESC_RX_PHY_ERROR_64QAM		0xa0
#define AR5K_AR5212_DESC_RX_PHY_ERROR_SERVICE		0xc0
#define AR5K_AR5212_DESC_RX_PHY_ERROR_TRANSMITOVR	0xe0

struct ar5k_ar5212_tx_desc {
	/*
	 * TX control word 0
	 */
	u_int32_t	tx_control_0;

#define AR5K_AR5212_DESC_TX_CTL0_FRAME_LEN		0x00000fff
#define AR5K_AR5212_DESC_TX_CTL0_XMIT_POWER		0x003f0000
#define AR5K_AR5212_DESC_TX_CTL0_XMIT_POWER_S		16
#define AR5K_AR5212_DESC_TX_CTL0_RTSENA			0x00400000
#define AR5K_AR5212_DESC_TX_CTL0_VEOL			0x00800000
#define AR5K_AR5212_DESC_TX_CTL0_CLRDMASK		0x01000000
#define AR5K_AR5212_DESC_TX_CTL0_ANT_MODE_XMIT		0x1e000000
#define AR5K_AR5212_DESC_TX_CTL0_ANT_MODE_XMIT_S	25
#define AR5K_AR5212_DESC_TX_CTL0_INTREQ			0x20000000
#define AR5K_AR5212_DESC_TX_CTL0_ENCRYPT_KEY_VALID	0x40000000
#define AR5K_AR5212_DESC_TX_CTL0_CTSENA			0x80000000

	/*
	 * TX control word 1
	 */
	u_int32_t	tx_control_1;

#define AR5K_AR5212_DESC_TX_CTL1_BUF_LEN		0x00000fff
#define AR5K_AR5212_DESC_TX_CTL1_MORE			0x00001000
#define AR5K_AR5212_DESC_TX_CTL1_ENCRYPT_KEY_INDEX	0x000fe000
#define AR5K_AR5212_DESC_TX_CTL1_ENCRYPT_KEY_INDEX_S	13
#define AR5K_AR5212_DESC_TX_CTL1_FRAME_TYPE		0x00f00000
#define AR5K_AR5212_DESC_TX_CTL1_FRAME_TYPE_S		20
#define AR5K_AR5212_DESC_TX_CTL1_NOACK			0x01000000
#define AR5K_AR5212_DESC_TX_CTL1_COMP_PROC		0x06000000
#define AR5K_AR5212_DESC_TX_CTL1_COMP_PROC_S		25
#define AR5K_AR5212_DESC_TX_CTL1_COMP_IV_LEN		0x18000000
#define AR5K_AR5212_DESC_TX_CTL1_COMP_IV_LEN_S		27
#define AR5K_AR5212_DESC_TX_CTL1_COMP_ICV_LEN		0x60000000
#define AR5K_AR5212_DESC_TX_CTL1_COMP_ICV_LEN_S		29

	/*
	 * TX control word 2
	 */
	u_int32_t	tx_control_2;

#define AR5K_AR5212_DESC_TX_CTL2_RTS_DURATION		0x00007fff
#define AR5K_AR5212_DESC_TX_CTL2_DURATION_UPDATE_ENABLE	0x00008000
#define AR5K_AR5212_DESC_TX_CTL2_XMIT_TRIES0		0x000f0000
#define AR5K_AR5212_DESC_TX_CTL2_XMIT_TRIES0_S		16
#define AR5K_AR5212_DESC_TX_CTL2_XMIT_TRIES1		0x00f00000
#define AR5K_AR5212_DESC_TX_CTL2_XMIT_TRIES1_S		20
#define AR5K_AR5212_DESC_TX_CTL2_XMIT_TRIES2		0x0f000000
#define AR5K_AR5212_DESC_TX_CTL2_XMIT_TRIES2_S		24
#define AR5K_AR5212_DESC_TX_CTL2_XMIT_TRIES3		0xf0000000
#define AR5K_AR5212_DESC_TX_CTL2_XMIT_TRIES3_S		28

	/*
	 * TX control word 3
	 */
	u_int32_t	tx_control_3;

#define AR5K_AR5212_DESC_TX_CTL3_XMIT_RATE0		0x0000001f
#define AR5K_AR5212_DESC_TX_CTL3_XMIT_RATE1		0x000003e0
#define AR5K_AR5212_DESC_TX_CTL3_XMIT_RATE1_S		5
#define AR5K_AR5212_DESC_TX_CTL3_XMIT_RATE2		0x00007c00
#define AR5K_AR5212_DESC_TX_CTL3_XMIT_RATE2_S		10
#define AR5K_AR5212_DESC_TX_CTL3_XMIT_RATE3		0x000f8000
#define AR5K_AR5212_DESC_TX_CTL3_XMIT_RATE3_S		15
#define AR5K_AR5212_DESC_TX_CTL3_RTS_CTS_RATE		0x01f00000
#define AR5K_AR5212_DESC_TX_CTL3_RTS_CTS_RATE_S		20
} __packed;

struct ar5k_ar5212_tx_status {
	/*
	 * TX status word 0
	 */
	u_int32_t	tx_status_0;

#define AR5K_AR5212_DESC_TX_STATUS0_FRAME_XMIT_OK	0x00000001
#define AR5K_AR5212_DESC_TX_STATUS0_EXCESSIVE_RETRIES	0x00000002
#define AR5K_AR5212_DESC_TX_STATUS0_FIFO_UNDERRUN	0x00000004
#define AR5K_AR5212_DESC_TX_STATUS0_FILTERED		0x00000008
#define AR5K_AR5212_DESC_TX_STATUS0_RTS_FAIL_COUNT	0x000000f0
#define AR5K_AR5212_DESC_TX_STATUS0_RTS_FAIL_COUNT_S	4
#define AR5K_AR5212_DESC_TX_STATUS0_DATA_FAIL_COUNT	0x00000f00
#define AR5K_AR5212_DESC_TX_STATUS0_DATA_FAIL_COUNT_S	8
#define AR5K_AR5212_DESC_TX_STATUS0_VIRT_COLL_COUNT	0x0000f000
#define AR5K_AR5212_DESC_TX_STATUS0_VIRT_COLL_COUNT_S	12
#define AR5K_AR5212_DESC_TX_STATUS0_SEND_TIMESTAMP	0xffff0000
#define AR5K_AR5212_DESC_TX_STATUS0_SEND_TIMESTAMP_S	16

	/*
	 * TX status word 1
	 */
	u_int32_t	tx_status_1;

#define AR5K_AR5212_DESC_TX_STATUS1_DONE		0x00000001
#define AR5K_AR5212_DESC_TX_STATUS1_SEQ_NUM		0x00001ffe
#define AR5K_AR5212_DESC_TX_STATUS1_SEQ_NUM_S		1
#define AR5K_AR5212_DESC_TX_STATUS1_ACK_SIG_STRENGTH	0x001fe000
#define AR5K_AR5212_DESC_TX_STATUS1_ACK_SIG_STRENGTH_S	13
#define AR5K_AR5212_DESC_TX_STATUS1_FINAL_TS_INDEX	0x00600000
#define AR5K_AR5212_DESC_TX_STATUS1_FINAL_TS_INDEX_S	21
#define AR5K_AR5212_DESC_TX_STATUS1_COMP_SUCCESS	0x00800000
#define AR5K_AR5212_DESC_TX_STATUS1_XMIT_ANTENNA	0x01000000
} __packed;

/*
 * Public function prototypes
 */
extern ar5k_attach_t ar5k_ar5212_attach;

/*
 * Initial register values which have to be loaded into the
 * card at boot time and after each reset.
 */

#define AR5K_AR5212_INI	{		\
	{ 0x000c,	0x00000000 },	\
	{ 0x0034,	0x00000005 },	\
	{ 0x0040,	0x00000000 },	\
	{ 0x0044,	0x00000008 },	\
	{ 0x0048,	0x00000008 },	\
	{ 0x004c,	0x00000010 },	\
	{ 0x0050,	0x00000000 },	\
	{ 0x0054,	0x0000001f },	\
	{ 0x0800,	0x00000000 },	\
	{ 0x0804,	0x00000000 },	\
	{ 0x0808,	0x00000000 },	\
	{ 0x080c,	0x00000000 },	\
	{ 0x0810,	0x00000000 },	\
	{ 0x0814,	0x00000000 },	\
	{ 0x0818,	0x00000000 },	\
	{ 0x081c,	0x00000000 },	\
	{ 0x0820,	0x00000000 },	\
	{ 0x0824,	0x00000000 },	\
	{ 0x1230,	0x00000000 },	\
	{ 0x1270,	0x00000000 },	\
	{ 0x1038,	0x00000000 },	\
	{ 0x1078,	0x00000000 },	\
	{ 0x10b8,	0x00000000 },	\
	{ 0x10f8,	0x00000000 },	\
	{ 0x1138,	0x00000000 },	\
	{ 0x1178,	0x00000000 },	\
	{ 0x11b8,	0x00000000 },	\
	{ 0x11f8,	0x00000000 },	\
	{ 0x1238,	0x00000000 },	\
	{ 0x1278,	0x00000000 },	\
	{ 0x12b8,	0x00000000 },	\
	{ 0x12f8,	0x00000000 },	\
	{ 0x1338,	0x00000000 },	\
	{ 0x1378,	0x00000000 },	\
	{ 0x13b8,	0x00000000 },	\
	{ 0x13f8,	0x00000000 },	\
	{ 0x1438,	0x00000000 },	\
	{ 0x1478,	0x00000000 },	\
	{ 0x14b8,	0x00000000 },	\
	{ 0x14f8,	0x00000000 },	\
	{ 0x1538,	0x00000000 },	\
	{ 0x1578,	0x00000000 },	\
	{ 0x15b8,	0x00000000 },	\
	{ 0x15f8,	0x00000000 },	\
	{ 0x1638,	0x00000000 },	\
	{ 0x1678,	0x00000000 },	\
	{ 0x16b8,	0x00000000 },	\
	{ 0x16f8,	0x00000000 },	\
	{ 0x1738,	0x00000000 },	\
	{ 0x1778,	0x00000000 },	\
	{ 0x17b8,	0x00000000 },	\
	{ 0x17f8,	0x00000000 },	\
	{ 0x103c,	0x00000000 },	\
	{ 0x107c,	0x00000000 },	\
	{ 0x10bc,	0x00000000 },	\
	{ 0x10fc,	0x00000000 },	\
	{ 0x113c,	0x00000000 },	\
	{ 0x117c,	0x00000000 },	\
	{ 0x11bc,	0x00000000 },	\
	{ 0x11fc,	0x00000000 },	\
	{ 0x123c,	0x00000000 },	\
	{ 0x127c,	0x00000000 },	\
	{ 0x12bc,	0x00000000 },	\
	{ 0x12fc,	0x00000000 },	\
	{ 0x133c,	0x00000000 },	\
	{ 0x137c,	0x00000000 },	\
	{ 0x13bc,	0x00000000 },	\
	{ 0x13fc,	0x00000000 },	\
	{ 0x143c,	0x00000000 },	\
	{ 0x147c,	0x00000000 },	\
	{ 0x143c,	0x00000000 },	\
	{ 0x147c,	0x00000000 },	\
	{ 0x8004,	0x00000000 },	\
	{ 0x8008,	0x00000000 },	\
	{ 0x800c,	0x00000000 },	\
	{ 0x8020,	0x00000000 },	\
	{ 0x8024,	0x00000000 },	\
	{ 0x8028,	0x00000030 },	\
	{ 0x802c,	0x0007ffff },	\
	{ 0x8030,	0x01ffffff },	\
	{ 0x8034,	0x00000031 },	\
	{ 0x8038,	0x00000000 },	\
	{ 0x803c,	0x00000000 },	\
	{ 0x8048,	0x00000000 },	\
	{ 0x8054,	0x00000000 },	\
	{ 0x8058,	0x00000000 },	\
	{ 0x8080,	0x00000000 },	\
	{ 0x805c,	0x000fc78f },	\
	{ 0x8084,	0x00000000 },	\
	{ 0x8088,	0x00000000 },	\
	{ 0x808c,	0x00000000 },	\
	{ 0x8090,	0x00000000 },	\
	{ 0x8094,	0x00000000 },	\
	{ 0x8098,	0x00000000 },	\
	{ 0x80c0,	0x2a82301a },	\
	{ 0x80c4,	0x05dc01e0 },	\
	{ 0x80c8,	0x1f402710 },	\
	{ 0x80cc,	0x01f40000 },	\
	{ 0x80d0,	0x00001e1c },	\
	{ 0x80d4,	0x0002aaaa },	\
	{ 0x80d8,	0x02005555 },	\
	{ 0x80dc,	0x00000000 },	\
	{ 0x80e0,	0xffffffff },	\
	{ 0x80e4,	0x0000ffff },	\
	{ 0x80e8,	0x00000000 },	\
	{ 0x80ec,	0x00000000 },	\
	{ 0x80f0,	0x00000000 },	\
	{ 0x80f4,	0x00000000 },	\
	{ 0x80f8,	0x00000000 },	\
	{ 0x80fc,	0x00000088 },	\
	{ 0x8700,	0x00000000 },	\
	{ 0x8704,	0x0000008c },	\
	{ 0x8708,	0x000000e4 },	\
	{ 0x870c,	0x000002d5 },	\
	{ 0x8710,	0x00000000 },	\
	{ 0x8714,	0x00000000 },	\
	{ 0x8718,	0x000000a0 },	\
	{ 0x871c,	0x000001c9 },	\
	{ 0x8720,	0x0000002c },	\
	{ 0x8724,	0x0000002c },	\
	{ 0x8728,	0x00000030 },	\
	{ 0x872c,	0x0000003c },	\
	{ 0x8730,	0x0000002c },	\
	{ 0x8734,	0x0000002c },	\
	{ 0x8738,	0x00000030 },	\
	{ 0x873c,	0x0000003c },	\
	{ 0x8740,	0x00000000 },	\
	{ 0x8744,	0x00000000 },	\
	{ 0x8748,	0x00000000 },	\
	{ 0x874c,	0x00000000 },	\
	{ 0x8750,	0x00000000 },	\
	{ 0x8754,	0x00000000 },	\
	{ 0x8758,	0x00000000 },	\
	{ 0x875c,	0x00000000 },	\
	{ 0x8760,	0x000000d5 },	\
	{ 0x8764,	0x000000df },	\
	{ 0x8768,	0x00000102 },	\
	{ 0x876c,	0x0000013a },	\
	{ 0x8770,	0x00000075 },	\
	{ 0x8774,	0x0000007f },	\
	{ 0x8778,	0x000000a2 },	\
	{ 0x877c,	0x00000000 },	\
	{ 0x8100,	0x00010002 },	\
	{ 0x8104,	0x00000001 },	\
	{ 0x8108,	0x000000c0 },	\
	{ 0x810c,	0x00000000 },	\
	{ 0x8110,	0x00000168 },	\
	{ 0x8114,	0x00000000 },	\
	{ 0x87c0,	0x03020100 },	\
	{ 0x87c4,	0x07060504 },	\
	{ 0x87c8,	0x0b0a0908 },	\
	{ 0x87cc,	0x0f0e0d0c },	\
	{ 0x87d0,	0x13121110 },	\
	{ 0x87d4,	0x17161514 },	\
	{ 0x87d8,	0x1b1a1918 },	\
	{ 0x87dc,	0x1f1e1d1c },	\
	{ 0x87e0,	0x03020100 },	\
	{ 0x87e4,	0x07060504 },	\
	{ 0x87e8,	0x0b0a0908 },	\
	{ 0x87ec,	0x0f0e0d0c },	\
	{ 0x87f0,	0x13121110 },	\
	{ 0x87f4,	0x17161514 },	\
	{ 0x87f8,	0x1b1a1918 },	\
	{ 0x87fc,	0x1f1e1d1c },	\
	{ 0x980c,	0xad848e19 },	\
	{ 0x9810,	0x7d28e000 },	\
	{ 0x9814,	0x9c0a9f6b },	\
	{ 0x981c,	0x00000000 },	\
	{ 0x9840,	0x206a017a },	\
	{ 0x9854,	0x00000859 },	\
	{ 0x9900,	0x00000000 },	\
	{ 0x9904,	0x00000000 },	\
	{ 0x9908,	0x00000000 },	\
	{ 0x990c,	0x00800000 },	\
	{ 0x9910,	0x00000001 },	\
	{ 0x991c,	0x00000c80 },	\
	{ 0x9920,	0x05100000 },	\
	{ 0x9928,	0x00000001 },	\
	{ 0x992c,	0x00000004 },	\
	{ 0x9934,	0x1e1f2022 },	\
	{ 0x9938,	0x0a0b0c0d },	\
	{ 0x993c,	0x0000003f },	\
	{ 0x9948,	0x9280b212 },	\
	{ 0x9954,	0x5d50e188 },	\
	{ 0x995c,	0x004b6a8e },	\
	{ 0x9968,	0x000003ce },	\
	{ 0x9970,	0x192fb515 },	\
	{ 0x9978,	0x00000001 },	\
	{ 0x997c,	0x00000000 },	\
	{ 0xa210,	0x00806333 },	\
	{ 0xa214,	0x00106c10 },	\
	{ 0xa218,	0x009c4060 },	\
	{ 0xa21c,	0x1483800a },	\
	{ 0xa220,	0x01831061 },	\
	{ 0xa224,	0x00000400 },	\
	{ 0xa22c,	0x00000000 },	\
	{ 0xa234,	0x20202020 },	\
	{ 0x9938,	0x20202020 },	\
	{ 0xa240,	0x38490a20 },	\
	{ 0xa244,	0x00007bb6 },	\
	{ 0xa248,	0x0fff3ffc },	\
}

#define AR5K_AR5212_MODE	{		\
	{ 0xa200,\
	    { 0x00000008, 0x00000008, 0x0000000b, 0x0000000e, 0x0000000e } },\
	{ 0x9800,\
	    { 0x00000007, 0x00000007, 0x00000007, 0x00000007, 0x00000007 } },\
	{ 0x1040,\
	    { 0x002ffc0f, 0x002ffc0f, 0x002ffc1f, 0x002ffc0f, 0x002ffc0f } },\
	{ 0x1044,\
	    { 0x002ffc0f, 0x002ffc0f, 0x002ffc1f, 0x002ffc0f, 0x002ffc0f } },\
	{ 0x1048,\
	    { 0x002ffc0f, 0x002ffc0f, 0x002ffc1f, 0x002ffc0f, 0x002ffc0f } },\
	{ 0x104c,\
	    { 0x002ffc0f, 0x002ffc0f, 0x002ffc1f, 0x002ffc0f, 0x002ffc0f } },\
	{ 0x1050,\
	    { 0x002ffc0f, 0x002ffc0f, 0x002ffc1f, 0x002ffc0f, 0x002ffc0f } },\
	{ 0x1054,\
	    { 0x002ffc0f, 0x002ffc0f, 0x002ffc1f, 0x002ffc0f, 0x002ffc0f } },\
	{ 0x1058,\
	    { 0x002ffc0f, 0x002ffc0f, 0x002ffc1f, 0x002ffc0f, 0x002ffc0f } },\
	{ 0x105c,\
	    { 0x002ffc0f, 0x002ffc0f, 0x002ffc1f, 0x002ffc0f, 0x002ffc0f } },\
	{ 0x1060,\
	    { 0x002ffc0f, 0x002ffc0f, 0x002ffc1f, 0x002ffc0f, 0x002ffc0f } },\
	{ 0x1064,\
	    { 0x002ffc0f, 0x002ffc0f, 0x002ffc1f, 0x002ffc0f, 0x002ffc0f } },\
	{ 0x1030,\
	    { 0x00000230, 0x000001e0, 0x000000b0, 0x00000160, 0x000001e0 } },\
	{ 0x1070,\
	    { 0x00000168, 0x000001e0, 0x000001b8, 0x0000018c, 0x000001e0 } },\
	{ 0x10b0,\
	    { 0x00000e60, 0x00001180, 0x00001f1c, 0x00003e38, 0x00001180 } },\
	{ 0x10f0,\
	    { 0x0000a0e0, 0x00014068, 0x00005880, 0x0000b0e0, 0x00014068 } },\
	{ 0x8014,\
	    { 0x03e803e8, 0x06e006e0, 0x04200420, 0x08400840, 0x06e006e0 } },\
	{ 0x9804,\
	    { 0x00000000, 0x00000003, 0x00000000, 0x00000000, 0x00000003 } },\
	{ 0x9820,\
	    { 0x02020200, 0x02020200, 0x02010200, 0x02020200, 0x02020200 } },\
	{ 0x9824,\
	    { 0x00000e0e, 0x00000e0e, 0x00000707, 0x00000e0e, 0x00000e0e } },\
	{ 0x9844,\
	    { 0x1372161c, 0x13721c25, 0x13721722, 0x137216a2, 0x13721c25 } },\
	{ 0x9860,\
	    { 0x00009d10, 0x00009d10, 0x00009d18, 0x00009d18, 0x00009d18 } },\
	{ 0x9864,\
	    { 0x0001ce00, 0x0001ce00, 0x0001ce00, 0x0001ce00, 0x0001ce00 } },\
	{ 0x9868,\
	    { 0x409a4190, 0x409a4190, 0x409a4190, 0x409a4190, 0x409a4190 } },\
	{ 0x9918,\
	    { 0x000001b8, 0x000001b8, 0x00000084, 0x00000108, 0x000001b8 } },\
	{ 0x9924,\
	    { 0x10058a05, 0x10058a05, 0x10058a05, 0x10058a05, 0x10058a05 } },\
	{ 0xa230,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000108, 0x00000000 } },\
}

#define AR5K_AR5212_AR5111_MODE	{		\
	{ 0xa200,\
	    { 0x00000000, 0x00000000, 0x00000003, 0x00000006, 0x00000006 } },\
	{ 0x0030,\
	    { 0x00008015, 0x00008015, 0x00008015, 0x00008015, 0x00008015 } },\
	{ 0x801c,\
	    { 0x128d8fa7, 0x09880fcf, 0x04e00f95, 0x12e00fab, 0x09880fcf } },\
	{ 0x9828,\
	    { 0x0a020001, 0x0a020001, 0x05010100, 0x0a020001, 0x0a020001 } },\
	{ 0x9834,\
	    { 0x00000e0e, 0x00000e0e, 0x00000e0e, 0x00000e0e, 0x00000e0e } },\
	{ 0x9838,\
	    { 0x00000007, 0x00000007, 0x0000000b, 0x0000000b, 0x0000000b } },\
	{ 0x9848,\
	    { 0x0018da5a, 0x0018da5a, 0x0018ca69, 0x0018ca69, 0x0018ca69 } },\
	{ 0x9850,\
	    { 0x0de8b4e0, 0x0de8b4e0, 0x0de8b4e0, 0x0de8b4e0, 0x0de8b4e0 } },\
	{ 0x9858,\
	    { 0x7e800d2e, 0x7e800d2e, 0x7ee84d2e, 0x7ee84d2e, 0x7e800d2e } },\
	{ 0x985c,\
	    { 0x3137665e, 0x3137665e, 0x3137665e, 0x3137665e, 0x3137615e } },\
	{ 0x986c,\
	    { 0x050cb081, 0x050cb081, 0x050cb081, 0x050cb080, 0x050cb080 } },\
	{ 0x9914,\
	    { 0x00002710, 0x00002710, 0x0000157c, 0x00002af8, 0x00002710 } },\
	{ 0x9944,\
	    { 0xf7b81020, 0xf7b81020, 0xf7b80d20, 0xf7b81020, 0xf7b81020 } },\
	{ 0xa20c,\
	    { 0x642c416a, 0x642c416a, 0x6440416a, 0x6440416a, 0x6440416a } },\
	{ 0xa21c,\
	    { 0x1883800a, 0x1883800a, 0x1873800a, 0x1883800a, 0x1883800a } },\
	{ 0x1230,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x9808,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x982c,\
	    { 0x00022ffe, 0x00022ffe, 0x00022ffe, 0x00022ffe, 0x00022ffe } },\
	{ 0x983c,\
	    { 0x00020100, 0x00020100, 0x00020100, 0x00020100, 0x00020100 } },\
	{ 0x984c,\
	    { 0x1284613c, 0x1284613c, 0x1284613c, 0x1284613c, 0x1284613c } },\
	{ 0x9930,\
	    { 0x00004883, 0x00004883, 0x00004883, 0x00004883, 0x00004883 } },\
	{ 0x9940,\
	    { 0x00000004, 0x00000004, 0x00000004, 0x00000004, 0x00000004 } },\
	{ 0x9958,\
	    { 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff } },\
	{ 0x9974,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x99f8,\
	    { 0x00000018, 0x00000018, 0x00000018, 0x00000018, 0x00000018 } },\
	{ 0xa204,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0xa208,\
	    { 0xd03e6788, 0xd03e6788, 0xd03e6788, 0xd03e6788, 0xd03e6788 } },\
	{ 0xa23c,\
	    { 0x13c889af, 0x13c889af, 0x13c889af, 0x13c889af, 0x13c889af } },\
}

#define AR5K_AR5212_AR5112_MODE	{		\
	{ 0x0030,\
	    { 0x00008015, 0x00008015, 0x00008015, 0x00008015, 0x00008015 } },\
	{ 0x801c,\
	    { 0x128d93a7, 0x098813cf, 0x04e01395, 0x12e013ab, 0x098813cf } },\
	{ 0x9828,\
	    { 0x0a020001, 0x0a020001, 0x05020100, 0x0a020001, 0x0a020001 } },\
	{ 0x9834,\
	    { 0x00000e0e, 0x00000e0e, 0x00000e0e, 0x00000e0e, 0x00000e0e } },\
	{ 0x9838,\
	    { 0x00000007, 0x00000007, 0x0000000b, 0x0000000b, 0x0000000b } },\
	{ 0x9848,\
	    { 0x0018da6d, 0x0018da6d, 0x0018ca75, 0x0018ca75, 0x0018ca75 } },\
	{ 0x9850,\
	    { 0x0de8b4e0, 0x0de8b4e0, 0x0de8b4e0, 0x0de8b4e0, 0x0de8b4e0 } },\
	{ 0x9858,\
	    { 0x7e800d2e, 0x7e800d2e, 0x7ee80d2e, 0x7ee80d2e, 0x7ee80d2e } },\
	{ 0x985c,\
	    { 0x3137665e, 0x3137665e, 0x3137665e, 0x3137665e, 0x3137665e } },\
	{ 0x986c,\
	    { 0x050cb081, 0x050cb081, 0x050cb081, 0x050cb081, 0x050cb081 } },\
	{ 0x9914,\
	    { 0x000007d0, 0x000007d0, 0x0000044c, 0x00000898, 0x000007d0 } },\
	{ 0x9944,\
	    { 0xf7b81020, 0xf7b81020, 0xf7b80d10, 0xf7b81010, 0xf7b81010 } },\
	{ 0xa204,\
	    { 0x00000000, 0x00000000, 0x00000008, 0x00000008, 0x00000008 } },\
	{ 0xa208,\
	    { 0xd6be6788, 0xd6be6788, 0xd03e6788, 0xd03e6788, 0xd03e6788 } },\
	{ 0xa20c,\
	    { 0x642c0140, 0x642c0140, 0x6442c160, 0x6442c160, 0x6442c160 } },\
	{ 0xa21c,\
	    { 0x1883800a, 0x1883800a, 0x1873800a, 0x1883800a, 0x1883800a } },\
	{ 0x1230,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x9808,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x982c,\
	    { 0x00022ffe, 0x00022ffe, 0x00022ffe, 0x00022ffe, 0x00022ffe } },\
	{ 0x983c,\
	    { 0x00020100, 0x00020100, 0x00020100, 0x00020100, 0x00020100 } },\
	{ 0x984c,\
	    { 0x1284613c, 0x1284613c, 0x1284613c, 0x1284613c, 0x1284613c } },\
	{ 0x9930,\
	    { 0x00004882, 0x00004882, 0x00004882, 0x00004882, 0x00004882 } },\
	{ 0x9940,\
	    { 0x00000004, 0x00000004, 0x00000004, 0x00000004, 0x00000004 } },\
	{ 0x9958,\
	    { 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff } },\
	{ 0x9974,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0xa228,\
	    { 0x000001b5, 0x000001b5, 0x000001b5, 0x000001b5, 0x000001b5 } },\
	{ 0xa23c,\
	    { 0x13c889af, 0x13c889af, 0x13c889af, 0x13c889af, 0x13c889af } },\
}

#define AR5K_AR5413_MODE	{		\
	{ 0x0030,\
	    { 0x00000015, 0x00000015, 0x00000015, 0x00000015, 0x00000015 } },\
	{ 0x801c,\
	    { 0x128d93a7, 0x098813cf, 0x04e01395, 0x12e013ab, 0x098813cf } },\
	{ 0x9828,\
	    { 0x0a020001, 0x0a020001, 0x05020100, 0x0a020001, 0x0a020001 } },\
	{ 0x9834,\
	    { 0x00000e0e, 0x00000e0e, 0x00000e0e, 0x00000e0e, 0x00000e0e } },\
	{ 0x9838,\
	    { 0x00000007, 0x00000007, 0x0000000b, 0x0000000b, 0x0000000b } },\
	{ 0x9848,\
	    { 0x0018fa61, 0x0018fa61, 0x001a1a63, 0x001a1a63, 0x001a1a63 } },\
	{ 0x9850,\
	    { 0x0c98b4e0, 0x0c98b4e0, 0x0c98b0da, 0x0c98b0da, 0x0c98b0da } },\
	{ 0x9858,\
	    { 0x7ec80d2e, 0x7ec80d2e, 0x7ec80d2e, 0x7ec80d2e, 0x7ec80d2e } },\
	{ 0x985c,\
	    { 0x3139605e, 0x3139605e, 0x3139605e, 0x3139605e, 0x3139605e } },\
	{ 0x986c,\
	    { 0x050cb081, 0x050cb081, 0x050cb081, 0x050cb081, 0x050cb081 } },\
	{ 0x9914,\
	    { 0x000007d0, 0x000007d0, 0x0000044c, 0x00000898, 0x000007d0 } },\
	{ 0x9944,\
	    { 0xf7b81000, 0xf7b81000, 0xf7b80d00, 0xf7b81000, 0xf7b81000 } },\
	{ 0xa204,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0xa208,\
	    { 0xd6be6788, 0xd6be6788, 0xd03e6788, 0xd03e6788, 0xd03e6788 } },\
	{ 0xa20c,\
	    { 0x002ec1e0, 0x002ec1e0, 0x002ac120, 0x002ac120, 0x002ac120 } },\
	{ 0xa21c,\
	    { 0x1883800a, 0x1883800a, 0x1863800a, 0x1883800a, 0x1883800a } },\
	{ 0xa300,\
	    { 0x18010000, 0x18010000, 0x18010000, 0x18010000, 0x18010000 } },\
	{ 0xa304,\
	    { 0x30032602, 0x30032602, 0x30032602, 0x30032602, 0x30032602 } },\
	{ 0xa308,\
	    { 0x48073e06, 0x48073e06, 0x48073e06, 0x48073e06, 0x48073e06 } },\
	{ 0xa30c,\
	    { 0x560b4c0a, 0x560b4c0a, 0x560b4c0a, 0x560b4c0a, 0x560b4c0a } },\
	{ 0xa310,\
	    { 0x641a600f, 0x641a600f, 0x641a600f, 0x641a600f, 0x641a600f } },\
	{ 0xa314,\
	    { 0x784f6e1b, 0x784f6e1b, 0x784f6e1b, 0x784f6e1b, 0x784f6e1b } },\
	{ 0xa318,\
	    { 0x868f7c5a, 0x868f7c5a, 0x868f7c5a, 0x868f7c5a, 0x868f7c5a } },\
	{ 0xa31c,\
	    { 0x90cf865b, 0x90cf865b, 0x8ecf865b, 0x8ecf865b, 0x8ecf865b } },\
	{ 0xa320,\
	    { 0x9d4f970f, 0x9d4f970f, 0x9b4f970f, 0x9b4f970f, 0x9b4f970f } },\
	{ 0xa324,\
	    { 0xa7cfa38f, 0xa7cfa38f, 0xa3cf9f8f, 0xa3cf9f8f, 0xa3cf9f8f } },\
	{ 0xa328,\
	    { 0xb55faf1f, 0xb55faf1f, 0xb35faf1f, 0xb35faf1f, 0xb35faf1f } },\
	{ 0xa32c,\
	    { 0xbddfb99f, 0xbddfb99f, 0xbbdfb99f, 0xbbdfb99f, 0xbbdfb99f } },\
	{ 0xa330,\
	    { 0xcb7fc53f, 0xcb7fc53f, 0xcb7fc73f, 0xcb7fc73f, 0xcb7fc73f } },\
	{ 0xa334,\
	    { 0xd5ffd1bf, 0xd5ffd1bf, 0xd3ffd1bf, 0xd3ffd1bf, 0xd3ffd1bf } },\
	{ 0x1230,\
	    { 0x000003e0, 0x000003e0, 0x000003e0, 0x000003e0, 0x000003e0 } },\
	{ 0x4068,\
	    { 0x00000010, 0x00000010, 0x00000010, 0x00000010, 0x00000010 } },\
	{ 0x8060,\
	    { 0x0000000f, 0x0000000f, 0x0000000f, 0x0000000f, 0x0000000f } },\
	{ 0x809c,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x80a0,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x8118,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x811c,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x8120,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x8124,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x8128,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x812c,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x8130,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x8134,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x8138,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x813c,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x8140,\
	    { 0x800003f9, 0x800003f9, 0x800003f9, 0x800003f9, 0x800003f9 } },\
	{ 0x8144,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x9808,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x982c,\
	    { 0x0000a000, 0x0000a000, 0x0000a000, 0x0000a000, 0x0000a000 } },\
	{ 0x983c,\
	    { 0x00200400, 0x00200400, 0x00200400, 0x00200400, 0x00200400 } },\
	{ 0x984c,\
	    { 0x1284233c, 0x1284233c, 0x1284233c, 0x1284233c, 0x1284233c } },\
	{ 0x9870,\
	    { 0x0000001f, 0x0000001f, 0x0000001f, 0x0000001f, 0x0000001f } },\
	{ 0x9874,\
	    { 0x00000080, 0x00000080, 0x00000080, 0x00000080, 0x00000080 } },\
	{ 0x9878,\
	    { 0x0000000e, 0x0000000e, 0x0000000e, 0x0000000e, 0x0000000e } },\
	{ 0x9958,\
	    { 0x00081fff, 0x00081fff, 0x00081fff, 0x00081fff, 0x00081fff } },\
	{ 0x9980,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x9984,\
	    { 0x02800000, 0x02800000, 0x02800000, 0x02800000, 0x02800000 } },\
	{ 0x99a0,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x99e0,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x99e4,\
	    { 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa } },\
	{ 0x99e8,\
	    { 0x3c466478, 0x3c466478, 0x3c466478, 0x3c466478, 0x3c466478 } },\
	{ 0x99ec,\
	    { 0x000000aa, 0x000000aa, 0x000000aa, 0x000000aa, 0x000000aa } },\
	{ 0x99f0,\
	    { 0x0000000c, 0x0000000c, 0x0000000c, 0x0000000c, 0x0000000c } },\
	{ 0x99f4,\
	    { 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff, 0x000000ff } },\
	{ 0x99f8,\
	    { 0x00000014, 0x00000014, 0x00000014, 0x00000014, 0x00000014 } },\
	{ 0xa228,\
	    { 0x000009b5, 0x000009b5, 0x000009b5, 0x000009b5, 0x000009b5 } },\
	{ 0xa23c,\
	    { 0x93c889af, 0x93c889af, 0x93c889af, 0x93c889af, 0x93c889af } },\
	{ 0xa24c,\
	    { 0x00000001, 0x00000001, 0x00000001, 0x00000001, 0x00000001 } },\
	{ 0xa250,\
	    { 0x0000a000, 0x0000a000, 0x0000a000, 0x0000a000, 0x0000a000 } },\
	{ 0xa254,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0xa258,\
	    { 0x0cc75380, 0x0cc75380, 0x0cc75380, 0x0cc75380, 0x0cc75380 } },\
	{ 0xa25c,\
	    { 0x0f0f0f01, 0x0f0f0f01, 0x0f0f0f01, 0x0f0f0f01, 0x0f0f0f01 } },\
	{ 0xa260,\
	    { 0x5f690f01, 0x5f690f01, 0x5f690f01, 0x5f690f01, 0x5f690f01 } },\
	{ 0xa264,\
	    { 0x00418a11, 0x00418a11, 0x00418a11, 0x00418a11, 0x00418a11 } },\
	{ 0xa268,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0xa26c,\
	    { 0x0c30c16a, 0x0c30c16a, 0x0c30c16a, 0x0c30c16a, 0x0c30c16a } },\
	{ 0xa270,\
	    { 0x00820820, 0x00820820, 0x00820820, 0x00820820, 0x00820820 } },\
	{ 0xa274,\
	    { 0x081b7caa, 0x081b7caa, 0x081b7caa, 0x081b7caa, 0x081b7caa } },\
	{ 0xa278,\
	    { 0x1ce739ce, 0x1ce739ce, 0x1ce739ce, 0x1ce739ce, 0x1ce739ce } },\
	{ 0xa27c,\
	    { 0x051701ce, 0x051701ce, 0x051701ce, 0x051701ce, 0x051701ce } },\
	{ 0xa338,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0xa33c,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0xa340,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0xa344,\
	    { 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0xa348,\
	    { 0x3fffffff, 0x3fffffff, 0x3fffffff, 0x3fffffff, 0x3fffffff } },\
	{ 0xa34c,\
	    { 0x3fffffff, 0x3fffffff, 0x3fffffff, 0x3fffffff, 0x3fffffff } },\
	{ 0xa350,\
	    { 0x3fffffff, 0x3fffffff, 0x3fffffff, 0x3fffffff, 0x3fffffff } },\
	{ 0xa354,\
	    { 0x0003ffff, 0x0003ffff, 0x0003ffff, 0x0003ffff, 0x0003ffff } },\
	{ 0xa358,\
	    { 0x79a8aa1f, 0x79a8aa1f, 0x79a8aa1f, 0x79a8aa1f, 0x79a8aa1f } },\
	{ 0xa35c,\
	    { 0x066c420f, 0x066c420f, 0x066c420f, 0x066c420f, 0x066c420f } },\
	{ 0xa360,\
	    { 0x0f282207, 0x0f282207, 0x0f282207, 0x0f282207, 0x0f282207 } },\
	{ 0xa364,\
	    { 0x17601685, 0x17601685, 0x17601685, 0x17601685, 0x17601685 } },\
	{ 0xa368,\
	    { 0x1f801104, 0x1f801104, 0x1f801104, 0x1f801104, 0x1f801104 } },\
	{ 0xa36c,\
	    { 0x37a00c03, 0x37a00c03, 0x37a00c03, 0x37a00c03, 0x37a00c03 } },\
	{ 0xa370,\
	    { 0x3fc40883, 0x3fc40883, 0x3fc40883, 0x3fc40883, 0x3fc40883 } },\
	{ 0xa374,\
	    { 0x57c00803, 0x57c00803, 0x57c00803, 0x57c00803, 0x57c00803 } },\
	{ 0xa378,\
	    { 0x5fd80682, 0x5fd80682, 0x5fd80682, 0x5fd80682, 0x5fd80682 } },\
	{ 0xa37c,\
	    { 0x7fe00482, 0x7fe00482, 0x7fe00482, 0x7fe00482, 0x7fe00482 } },\
	{ 0xa380,\
	    { 0x7f3c7bba, 0x7f3c7bba, 0x7f3c7bba, 0x7f3c7bba, 0x7f3c7bba } },\
	{ 0xa384,\
	    { 0xf3307ff0, 0xf3307ff0, 0xf3307ff0, 0xf3307ff0, 0xf3307ff0 } },\
}

#define AR5K_AR2413_MODE	{		\
	{ 0x0030, { 0, 0, 0x00000015, 0x00000015, 0x00000015 } },\
	{ 0x801c, { 0, 0, 0x04e01395, 0x12e013ab, 0x098813cf } },\
	{ 0x9828, { 0, 0, 0x05020000, 0x0a020001, 0x0a020001 } },\
	{ 0x9834, { 0, 0, 0x00000e00, 0x00000e00, 0x00000e00 } },\
	{ 0x9838, { 0, 0, 0x0000000a, 0x0000000a, 0x0000000a } },\
	{ 0x9848, { 0, 0, 0x001a6a64, 0x001a6a64, 0x001a6a64 } },\
	{ 0x9850, { 0, 0, 0x0de8b0da, 0x0c98b0da, 0x0c98b0da } },\
	{ 0x9858, { 0, 0, 0x7ee80d2e, 0x7ec80d2e, 0x7ec80d2e } },\
	{ 0x985c, { 0, 0, 0x3137665e, 0x3139605e, 0x3139605e } },\
	{ 0x986c, { 0, 0, 0x050cb081, 0x050cb081, 0x050cb081 } },\
	{ 0x9914, { 0, 0, 0x0000044c, 0x00000898, 0x000007d0 } },\
	{ 0x9944, { 0, 0, 0xf7b80d00, 0xf7b81000, 0xf7b81000 } },\
	{ 0xa204, { 0, 0, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0xa208, { 0, 0, 0xd03e6788, 0xd03e6788, 0xd03e6788 } },\
	{ 0xa20c, { 0, 0, 0x0042c140, 0x0042c140, 0x0042c140 } },\
	{ 0xa21c, { 0, 0, 0x1863800a, 0x1883800a, 0x1883800a } },\
	{ 0x1230, { 0, 0, 0x000003e0, 0x000003e0, 0x000003e0 } },\
	{ 0x8060, { 0, 0, 0x0000000f, 0x0000000f, 0x0000000f } },\
	{ 0x8118, { 0, 0, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x811c, { 0, 0, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x8120, { 0, 0, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x8124, { 0, 0, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x8128, { 0, 0, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x812c, { 0, 0, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x8130, { 0, 0, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x8134, { 0, 0, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x8138, { 0, 0, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x813c, { 0, 0, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x8140, { 0, 0, 0x800000a8, 0x800000a8, 0x800000a8 } },\
	{ 0x8144, { 0, 0, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x9808, { 0, 0, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x982c, { 0, 0, 0x0000a000, 0x0000a000, 0x0000a000 } },\
	{ 0x983c, { 0, 0, 0x00200400, 0x00200400, 0x00200400 } },\
	{ 0x984c, { 0, 0, 0x1284233c, 0x1284233c, 0x1284233c } },\
	{ 0x9870, { 0, 0, 0x0000001f, 0x0000001f, 0x0000001f } },\
	{ 0x9874, { 0, 0, 0x00000080, 0x00000080, 0x00000080 } },\
	{ 0x9878, { 0, 0, 0x0000000e, 0x0000000e, 0x0000000e } },\
	{ 0x9958, { 0, 0, 0x000000ff, 0x000000ff, 0x000000ff } },\
	{ 0x9980, { 0, 0, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x9984, { 0, 0, 0x02800000, 0x02800000, 0x02800000 } },\
	{ 0x99a0, { 0, 0, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x99e0, { 0, 0, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0x99e4, { 0, 0, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa } },\
	{ 0x99e8, { 0, 0, 0x3c466478, 0x3c466478, 0x3c466478 } },\
	{ 0x99ec, { 0, 0, 0x000000aa, 0x000000aa, 0x000000aa } },\
	{ 0x99f0, { 0, 0, 0x0000000c, 0x0000000c, 0x0000000c } },\
	{ 0x99f4, { 0, 0, 0x000000ff, 0x000000ff, 0x000000ff } },\
	{ 0x99f8, { 0, 0, 0x00000014, 0x00000014, 0x00000014 } },\
	{ 0xa228, { 0, 0, 0x000009b5, 0x000009b5, 0x000009b5 } },\
	{ 0xa23c, { 0, 0, 0x93c889af, 0x93c889af, 0x93c889af } },\
	{ 0xa24c, { 0, 0, 0x00000001, 0x00000001, 0x00000001 } },\
	{ 0xa250, { 0, 0, 0x0000a000, 0x0000a000, 0x0000a000 } },\
	{ 0xa254, { 0, 0, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0xa258, { 0, 0, 0x0cc75380, 0x0cc75380, 0x0cc75380 } },\
	{ 0xa25c, { 0, 0, 0x0f0f0f01, 0x0f0f0f01, 0x0f0f0f01 } },\
	{ 0xa260, { 0, 0, 0x5f690f01, 0x5f690f01, 0x5f690f01 } },\
	{ 0xa264, { 0, 0, 0x00418a11, 0x00418a11, 0x00418a11 } },\
	{ 0xa268, { 0, 0, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0xa26c, { 0, 0, 0x0c30c16a, 0x0c30c16a, 0x0c30c16a } },\
	{ 0xa270, { 0, 0, 0x00820820, 0x00820820, 0x00820820 } },\
	{ 0xa274, { 0, 0, 0x001b7caa, 0x001b7caa, 0x001b7caa } },\
	{ 0xa278, { 0, 0, 0x1ce739ce, 0x1ce739ce, 0x1ce739ce } },\
	{ 0xa27c, { 0, 0, 0x051701ce, 0x051701ce, 0x051701ce } },\
	{ 0xa300, { 0, 0, 0x18010000, 0x18010000, 0x18010000 } },\
	{ 0xa304, { 0, 0, 0x30032602, 0x30032602, 0x30032602 } },\
	{ 0xa308, { 0, 0, 0x48073e06, 0x48073e06, 0x48073e06 } },\
	{ 0xa30c, { 0, 0, 0x560b4c0a, 0x560b4c0a, 0x560b4c0a } },\
	{ 0xa310, { 0, 0, 0x641a600f, 0x641a600f, 0x641a600f } },\
	{ 0xa314, { 0, 0, 0x784f6e1b, 0x784f6e1b, 0x784f6e1b } },\
	{ 0xa318, { 0, 0, 0x868f7c5a, 0x868f7c5a, 0x868f7c5a } },\
	{ 0xa31c, { 0, 0, 0x8ecf865b, 0x8ecf865b, 0x8ecf865b } },\
	{ 0xa320, { 0, 0, 0x9d4f970f, 0x9d4f970f, 0x9d4f970f } },\
	{ 0xa324, { 0, 0, 0xa5cfa18f, 0xa5cfa18f, 0xa5cfa18f } },\
	{ 0xa328, { 0, 0, 0xb55faf1f, 0xb55faf1f, 0xb55faf1f } },\
	{ 0xa32c, { 0, 0, 0xbddfb99f, 0xbddfb99f, 0xbddfb99f } },\
	{ 0xa330, { 0, 0, 0xcd7fc73f, 0xcd7fc73f, 0xcd7fc73f } },\
	{ 0xa334, { 0, 0, 0xd5ffd1bf, 0xd5ffd1bf, 0xd5ffd1bf } },\
	{ 0xa338, { 0, 0, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0xa33c, { 0, 0, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0xa340, { 0, 0, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0xa344, { 0, 0, 0x00000000, 0x00000000, 0x00000000 } },\
	{ 0xa348, { 0, 0, 0x3fffffff, 0x3fffffff, 0x3fffffff } },\
	{ 0xa34c, { 0, 0, 0x3fffffff, 0x3fffffff, 0x3fffffff } },\
	{ 0xa350, { 0, 0, 0x3fffffff, 0x3fffffff, 0x3fffffff } },\
	{ 0xa354, { 0, 0, 0x0003ffff, 0x0003ffff, 0x0003ffff } },\
	{ 0xa358, { 0, 0, 0x79a8aa1f, 0x79a8aa1f, 0x79a8aa1f } },\
	{ 0xa35c, { 0, 0, 0x066c420f, 0x066c420f, 0x066c420f } },\
	{ 0xa360, { 0, 0, 0x0f282207, 0x0f282207, 0x0f282207 } },\
	{ 0xa364, { 0, 0, 0x17601685, 0x17601685, 0x17601685 } },\
	{ 0xa368, { 0, 0, 0x1f801104, 0x1f801104, 0x1f801104 } },\
	{ 0xa36c, { 0, 0, 0x37a00c03, 0x37a00c03, 0x37a00c03 } },\
	{ 0xa370, { 0, 0, 0x3fc40883, 0x3fc40883, 0x3fc40883 } },\
	{ 0xa374, { 0, 0, 0x57c00803, 0x57c00803, 0x57c00803 } },\
	{ 0xa378, { 0, 0, 0x5fd80682, 0x5fd80682, 0x5fd80682 } },\
	{ 0xa37c, { 0, 0, 0x7fe00482, 0x7fe00482, 0x7fe00482 } },\
	{ 0xa380, { 0, 0, 0x7f3c7bba, 0x7f3c7bba, 0x7f3c7bba } },\
	{ 0xa384, { 0, 0, 0xf3307ff0, 0xf3307ff0, 0xf3307ff0 } },\
}

#define AR5K_AR2425_MODE	{		\
	{ 0x0030, { 0, 0, 0, 0x00000015, 0x00000015 } },\
	{ 0x801c, { 0, 0, 0, 0x12e013ab, 0x098813cf } },\
	{ 0x9804, { 0, 0, 0, 0x00000000, 0x00000003 } },\
	{ 0x9828, { 0, 0, 0, 0x0a020001, 0x0a020001 } },\
	{ 0x9834, { 0, 0, 0, 0x00000e0e, 0x00000e0e } },\
	{ 0x9838, { 0, 0, 0, 0x0000000b, 0x0000000b } },\
	{ 0x9844, { 0, 0, 0, 0x13721422, 0x13721422 } },\
	{ 0x9848, { 0, 0, 0, 0x00199a65, 0x00199a65 } },\
	{ 0x9850, { 0, 0, 0, 0x0c98b0da, 0x0c98b0da } },\
	{ 0x9858, { 0, 0, 0, 0x7ec80d2e, 0x7ec80d2e } },\
	{ 0x985c, { 0, 0, 0, 0x3139605e, 0x3139605e } },\
	{ 0x986c, { 0, 0, 0, 0x050cb081, 0x050cb081 } },\
	{ 0x9914, { 0, 0, 0, 0x00000898, 0x000007d0 } },\
	{ 0x9944, { 0, 0, 0, 0xf7b81000, 0xf7b81000 } },\
	{ 0xa204, { 0, 0, 0, 0x00000000, 0x00000000 } },\
	{ 0xa208, { 0, 0, 0, 0xd03e6788, 0xd03e6788 } },\
	{ 0xa20c, { 0, 0, 0, 0x0052c140, 0x0052c140 } },\
	{ 0xa21c, { 0, 0, 0, 0x1883800a, 0x1883800a } },\
	{ 0xa324, { 0, 0, 0, 0xa7cfa7cf, 0xa7cfa7cf } },\
	{ 0xa328, { 0, 0, 0, 0xa7cfa7cf, 0xa7cfa7cf } },\
	{ 0xa32c, { 0, 0, 0, 0xa7cfa7cf, 0xa7cfa7cf } },\
	{ 0xa330, { 0, 0, 0, 0xa7cfa7cf, 0xa7cfa7cf } },\
	{ 0xa334, { 0, 0, 0, 0xa7cfa7cf, 0xa7cfa7cf } },\
	{ 0x1230, { 0, 0, 0, 0x000003e0, 0x000003e0 } },\
	{ 0x8060, { 0, 0, 0, 0x0000000f, 0x0000000f } },\
	{ 0x809c, { 0, 0, 0, 0x00000000, 0x00000000 } },\
	{ 0x80a0, { 0, 0, 0, 0x00000000, 0x00000000 } },\
	{ 0x8118, { 0, 0, 0, 0x00000000, 0x00000000 } },\
	{ 0x811c, { 0, 0, 0, 0x00000000, 0x00000000 } },\
	{ 0x8120, { 0, 0, 0, 0x00000000, 0x00000000 } },\
	{ 0x8124, { 0, 0, 0, 0x00000000, 0x00000000 } },\
	{ 0x8128, { 0, 0, 0, 0x00000000, 0x00000000 } },\
	{ 0x812c, { 0, 0, 0, 0x00000000, 0x00000000 } },\
	{ 0x8130, { 0, 0, 0, 0x00000000, 0x00000000 } },\
	{ 0x8134, { 0, 0, 0, 0x00000000, 0x00000000 } },\
	{ 0x8138, { 0, 0, 0, 0x00000000, 0x00000000 } },\
	{ 0x813c, { 0, 0, 0, 0x00000000, 0x00000000 } },\
	{ 0x8140, { 0, 0, 0, 0x800003f9, 0x800003f9 } },\
	{ 0x8144, { 0, 0, 0, 0x00000000, 0x00000000 } },\
	{ 0x9808, { 0, 0, 0, 0x00000000, 0x00000000 } },\
	{ 0x982c, { 0, 0, 0, 0x0000a000, 0x0000a000 } },\
	{ 0x983c, { 0, 0, 0, 0x00200400, 0x00200400 } },\
	{ 0x984c, { 0, 0, 0, 0x1284233c, 0x1284233c } },\
	{ 0x9870, { 0, 0, 0, 0x0000001f, 0x0000001f } },\
	{ 0x9874, { 0, 0, 0, 0x00000080, 0x00000080 } },\
	{ 0x9878, { 0, 0, 0, 0x0000000e, 0x0000000e } },\
	{ 0x9958, { 0, 0, 0, 0x00081fff, 0x00081fff } },\
	{ 0x9980, { 0, 0, 0, 0x00000000, 0x00000000 } },\
	{ 0x9984, { 0, 0, 0, 0x02800000, 0x02800000 } },\
	{ 0x99a0, { 0, 0, 0, 0x00000000, 0x00000000 } },\
	{ 0x99dc, { 0, 0, 0, 0xfebadbe8, 0xfebadbe8 } },\
	{ 0x99e0, { 0, 0, 0, 0x00000000, 0x00000000 } },\
	{ 0x99e4, { 0, 0, 0, 0xaaaaaaaa, 0xaaaaaaaa } },\
	{ 0x99e8, { 0, 0, 0, 0x3c466478, 0x3c466478 } },\
	{ 0x99ec, { 0, 0, 0, 0x000000aa, 0x000000aa } },\
	{ 0x99f0, { 0, 0, 0, 0x0000000c, 0x0000000c } },\
	{ 0x99f4, { 0, 0, 0, 0x000000ff, 0x000000ff } },\
	{ 0x99f8, { 0, 0, 0, 0x00000014, 0x00000014 } },\
	{ 0xa228, { 0, 0, 0, 0x000009b5, 0x000009b5 } },\
	{ 0xa234, { 0, 0, 0, 0x20202020, 0x20202020 } },\
	{ 0xa238, { 0, 0, 0, 0x20202020, 0x20202020 } },\
	{ 0xa23c, { 0, 0, 0, 0x93c889af, 0x93c889af } },\
	{ 0xa24c, { 0, 0, 0, 0x00000001, 0x00000001 } },\
	{ 0xa250, { 0, 0, 0, 0x0000a000, 0x0000a000 } },\
	{ 0xa254, { 0, 0, 0, 0x00000000, 0x00000000 } },\
	{ 0xa258, { 0, 0, 0, 0x0cc75380, 0x0cc75380 } },\
	{ 0xa25c, { 0, 0, 0, 0x0f0f0f01, 0x0f0f0f01 } },\
	{ 0xa260, { 0, 0, 0, 0x5f690f01, 0x5f690f01 } },\
	{ 0xa264, { 0, 0, 0, 0x00418a11, 0x00418a11 } },\
	{ 0xa268, { 0, 0, 0, 0x00000000, 0x00000000 } },\
	{ 0xa26c, { 0, 0, 0, 0x0c30c166, 0x0c30c166 } },\
	{ 0xa270, { 0, 0, 0, 0x00820820, 0x00820820 } },\
	{ 0xa274, { 0, 0, 0, 0x081a3caa, 0x081a3caa } },\
	{ 0xa278, { 0, 0, 0, 0x1ce739ce, 0x1ce739ce } },\
	{ 0xa27c, { 0, 0, 0, 0x051701ce, 0x051701ce } },\
	{ 0xa300, { 0, 0, 0, 0x16010000, 0x16010000 } },\
	{ 0xa304, { 0, 0, 0, 0x2c032402, 0x2c032402 } },\
	{ 0xa308, { 0, 0, 0, 0x48433e42, 0x48433e42 } },\
	{ 0xa30c, { 0, 0, 0, 0x5a0f500b, 0x5a0f500b } },\
	{ 0xa310, { 0, 0, 0, 0x6c4b624a, 0x6c4b624a } },\
	{ 0xa314, { 0, 0, 0, 0x7e8b748a, 0x7e8b748a } },\
	{ 0xa318, { 0, 0, 0, 0x96cf8ccb, 0x96cf8ccb } },\
	{ 0xa31c, { 0, 0, 0, 0xa34f9d0f, 0xa34f9d0f } },\
	{ 0xa320, { 0, 0, 0, 0xa7cfa58f, 0xa7cfa58f } },\
	{ 0xa348, { 0, 0, 0, 0x3fffffff, 0x3fffffff } },\
	{ 0xa34c, { 0, 0, 0, 0x3fffffff, 0x3fffffff } },\
	{ 0xa350, { 0, 0, 0, 0x3fffffff, 0x3fffffff } },\
	{ 0xa354, { 0, 0, 0, 0x0003ffff, 0x0003ffff } },\
	{ 0xa358, { 0, 0, 0, 0x79a8aa1f, 0x79a8aa1f } },\
	{ 0xa35c, { 0, 0, 0, 0x066c420f, 0x066c420f } },\
	{ 0xa360, { 0, 0, 0, 0x0f282207, 0x0f282207 } },\
	{ 0xa364, { 0, 0, 0, 0x17601685, 0x17601685 } },\
	{ 0xa368, { 0, 0, 0, 0x1f801104, 0x1f801104 } },\
	{ 0xa36c, { 0, 0, 0, 0x37a00c03, 0x37a00c03 } },\
	{ 0xa370, { 0, 0, 0, 0x3fc40883, 0x3fc40883 } },\
	{ 0xa374, { 0, 0, 0, 0x57c00803, 0x57c00803 } },\
	{ 0xa378, { 0, 0, 0, 0x5fd80682, 0x5fd80682 } },\
	{ 0xa37c, { 0, 0, 0, 0x7fe00482, 0x7fe00482 } },\
	{ 0xa380, { 0, 0, 0, 0x7f3c7bba, 0x7f3c7bba } },\
	{ 0xa384, { 0, 0, 0, 0xf3307ff0, 0xf3307ff0 } },\
}

#define AR5K_AR5111_INI_BBGAIN	{	\
	{ 0x9b00,	0x00000000 },	\
	{ 0x9b04,	0x00000020 },	\
	{ 0x9b08,	0x00000010 },	\
	{ 0x9b0c,	0x00000030 },	\
	{ 0x9b10,	0x00000008 },	\
	{ 0x9b14,	0x00000028 },	\
	{ 0x9b18,	0x00000004 },	\
	{ 0x9b1c,	0x00000024 },	\
	{ 0x9b20,	0x00000014 },	\
	{ 0x9b24,	0x00000034 },	\
	{ 0x9b28,	0x0000000c },	\
	{ 0x9b2c,	0x0000002c },	\
	{ 0x9b30,	0x00000002 },	\
	{ 0x9b34,	0x00000022 },	\
	{ 0x9b38,	0x00000012 },	\
	{ 0x9b3c,	0x00000032 },	\
	{ 0x9b40,	0x0000000a },	\
	{ 0x9b44,	0x0000002a },	\
	{ 0x9b48,	0x00000006 },	\
	{ 0x9b4c,	0x00000026 },	\
	{ 0x9b50,	0x00000016 },	\
	{ 0x9b54,	0x00000036 },	\
	{ 0x9b58,	0x0000000e },	\
	{ 0x9b5c,	0x0000002e },	\
	{ 0x9b60,	0x00000001 },	\
	{ 0x9b64,	0x00000021 },	\
	{ 0x9b68,	0x00000011 },	\
	{ 0x9b6c,	0x00000031 },	\
	{ 0x9b70,	0x00000009 },	\
	{ 0x9b74,	0x00000029 },	\
	{ 0x9b78,	0x00000005 },	\
	{ 0x9b7c,	0x00000025 },	\
	{ 0x9b80,	0x00000015 },	\
	{ 0x9b84,	0x00000035 },	\
	{ 0x9b88,	0x0000000d },	\
	{ 0x9b8c,	0x0000002d },	\
	{ 0x9b90,	0x00000003 },	\
	{ 0x9b94,	0x00000023 },	\
	{ 0x9b98,	0x00000013 },	\
	{ 0x9b9c,	0x00000033 },	\
	{ 0x9ba0,	0x0000000b },	\
	{ 0x9ba4,	0x0000002b },	\
	{ 0x9ba8,	0x0000002b },	\
	{ 0x9bac,	0x0000002b },	\
	{ 0x9bb0,	0x0000002b },	\
	{ 0x9bb4,	0x0000002b },	\
	{ 0x9bb8,	0x0000002b },	\
	{ 0x9bbc,	0x0000002b },	\
	{ 0x9bc0,	0x0000002b },	\
	{ 0x9bc4,	0x0000002b },	\
	{ 0x9bc8,	0x0000002b },	\
	{ 0x9bcc,	0x0000002b },	\
	{ 0x9bd0,	0x0000002b },	\
	{ 0x9bd4,	0x0000002b },	\
	{ 0x9bd8,	0x0000002b },	\
	{ 0x9bdc,	0x0000002b },	\
	{ 0x9be0,	0x0000002b },	\
	{ 0x9be4,	0x0000002b },	\
	{ 0x9be8,	0x0000002b },	\
	{ 0x9bec,	0x0000002b },	\
	{ 0x9bf0,	0x0000002b },	\
	{ 0x9bf4,	0x0000002b },	\
	{ 0x9bf8,	0x00000002 },	\
	{ 0x9bfc,	0x00000016 },	\
}

#define AR5K_AR5112_INI_BBGAIN	{	\
	{ 0x9b00,	0x00000000 },	\
	{ 0x9b04,	0x00000001 },	\
	{ 0x9b08,	0x00000002 },	\
	{ 0x9b0c,	0x00000003 },	\
	{ 0x9b10,	0x00000004 },	\
	{ 0x9b14,	0x00000005 },	\
	{ 0x9b18,	0x00000008 },	\
	{ 0x9b1c,	0x00000009 },	\
	{ 0x9b20,	0x0000000a },	\
	{ 0x9b24,	0x0000000b },	\
	{ 0x9b28,	0x0000000c },	\
	{ 0x9b2c,	0x0000000d },	\
	{ 0x9b30,	0x00000010 },	\
	{ 0x9b34,	0x00000011 },	\
	{ 0x9b38,	0x00000012 },	\
	{ 0x9b3c,	0x00000013 },	\
	{ 0x9b40,	0x00000014 },	\
	{ 0x9b44,	0x00000015 },	\
	{ 0x9b48,	0x00000018 },	\
	{ 0x9b4c,	0x00000019 },	\
	{ 0x9b50,	0x0000001a },	\
	{ 0x9b54,	0x0000001b },	\
	{ 0x9b58,	0x0000001c },	\
	{ 0x9b5c,	0x0000001d },	\
	{ 0x9b60,	0x00000020 },	\
	{ 0x9b64,	0x00000021 },	\
	{ 0x9b68,	0x00000022 },	\
	{ 0x9b6c,	0x00000023 },	\
	{ 0x9b70,	0x00000024 },	\
	{ 0x9b74,	0x00000025 },	\
	{ 0x9b78,	0x00000028 },	\
	{ 0x9b7c,	0x00000029 },	\
	{ 0x9b80,	0x0000002a },	\
	{ 0x9b84,	0x0000002b },	\
	{ 0x9b88,	0x0000002c },	\
	{ 0x9b8c,	0x0000002d },	\
	{ 0x9b90,	0x00000030 },	\
	{ 0x9b94,	0x00000031 },	\
	{ 0x9b98,	0x00000032 },	\
	{ 0x9b9c,	0x00000033 },	\
	{ 0x9ba0,	0x00000034 },	\
	{ 0x9ba4,	0x00000035 },	\
	{ 0x9ba8,	0x00000035 },	\
	{ 0x9bac,	0x00000035 },	\
	{ 0x9bb0,	0x00000035 },	\
	{ 0x9bb4,	0x00000035 },	\
	{ 0x9bb8,	0x00000035 },	\
	{ 0x9bbc,	0x00000035 },	\
	{ 0x9bc0,	0x00000035 },	\
	{ 0x9bc4,	0x00000035 },	\
	{ 0x9bc8,	0x00000035 },	\
	{ 0x9bcc,	0x00000035 },	\
	{ 0x9bd0,	0x00000035 },	\
	{ 0x9bd4,	0x00000035 },	\
	{ 0x9bd8,	0x00000035 },	\
	{ 0x9bdc,	0x00000035 },	\
	{ 0x9be0,	0x00000035 },	\
	{ 0x9be4,	0x00000035 },	\
	{ 0x9be8,	0x00000035 },	\
	{ 0x9bec,	0x00000035 },	\
	{ 0x9bf0,	0x00000035 },	\
	{ 0x9bf4,	0x00000035 },	\
	{ 0x9bf8,	0x00000010 },	\
	{ 0x9bfc,	0x0000001a },	\
}

#define AR5K_AR5212_PCIE	{	\
	{ 0x4080,	0x9248fc00 },	\
	{ 0x4080,	0x24924924 },	\
	{ 0x4080,	0x28000039 },	\
	{ 0x4080,	0x53160824 },	\
	{ 0x4080,	0xe5980579 },	\
	{ 0x4080,	0x001defff },	\
	{ 0x4080,	0x1aaabe40 },	\
	{ 0x4080,	0xbe105554 },	\
	{ 0x4080,	0x000e3007 },	\
	{ 0x4084,	0x00000000 }	\
}

#endif /* _AR5K_AR5212_VAR_H */
